# ====================================================

brX = 50    #  Горизонтальные бордюры для графика
brY = 40    #  Вертикальные бордюры для графика

def FuncStat (RqCnv, RqFuncTab) :
#  Формат RqFuncTab = [[x0,y0], ... [xN,yN]]   
#  Формат return    = [[minX,maxX,SclX,grW],[minY,maxY,SclY,grY]]
   lstX, lstY, FStat = [], [], [[0,0,0,0],[0,0,0,0]]
   FStat[0][3] = int(RqCnv['width'])  - 2 * brX
   FStat[1][3] = int(RqCnv['height']) - 2 * brY
   for i in range(len(RqFuncTab)) :
      lstX.append(RqFuncTab[i][0])
      lstY.append(RqFuncTab[i][1])    
   FStat[0][0] = min(lstX)
   FStat[0][1] = max(lstX)
   FStat[1][0] = min(lstY)
   FStat[1][1] = max(lstY)
   try    : FStat[0][2] = FStat[0][3]/(FStat[0][1]-FStat[0][0])
   except : FStat[0][2] = 0
   try    : FStat[1][2] = FStat[1][3]/(FStat[1][1]-FStat[1][0])
   except : FStat[1][2] = 0
   return FStat

# --------------------------------------
#  Получить аргумент в масштабе графика
def XtoPix(RqFStat, X) :
    return brX + RqFStat[0][2] * (X - RqFStat[0][0])
# --------------------------------------
#  Получить значение в масштабе графика
def YtoPix(RqFStat, Y) :
    return brY + RqFStat[1][3] - RqFStat[1][2] * (Y - RqFStat[1][0])
# --------------------------------------
titenum = 10
def Axes(RqCnv, RqFStat, RqFuncTab) :
    # Опорные точки осей
    xb = XtoPix(RqFStat,RqFStat[0][0])
    xe = XtoPix(RqFStat,RqFStat[0][1])
    yb = YtoPix(RqFStat,RqFStat[1][0])
    ye = YtoPix(RqFStat,RqFStat[1][1])
    # Прорисовать оси X и Y
    RqCnv.create_line(xb, yb, xe + 0.7 * brX, yb, width=1, arrow='last')  # Ось X
    RqCnv.create_line(xb, yb, xb, ye - 0.7 * brY, width=1, arrow='last')  # Ось Y
    if (RqFStat[1][0] < 0) and (RqFStat[1][1] > 0) :
       y0 = YtoPix(RqFStat, 0)
       RqCnv.create_line(xb, y0, xe, y0, width=1, dash=(3,3))             # Ось нуля
    # Прорисовать подписи на оси X       
    xp, xpStep = xb, (xe-xb)/(titenum -1)
    xr, xrStep = RqFStat[0][0], (RqFStat[0][1]- RqFStat[0][0])/(titenum -1)
    i = 0
    while i < titenum :
      RqCnv.create_line(xp, yb, xp, yb - 5, width=2)
      RqCnv.create_text(xp, yb + 12, text='%3.1f'% (xr))
      xp+=xpStep
      xr+=xrStep
      i+=1
    # Прорисовать подписи на оси Y
    yp, ypStep = yb, (ye-yb)/(titenum -1)
    yr, yrStep = RqFStat[1][0], (RqFStat[1][1]- RqFStat[1][0])/(titenum -1)
    i = 0
    while i < titenum :
      RqCnv.create_line(xb, yp, xb + 5, yp, width=2)
      RqCnv.create_text(20, yp, text='%5.2f'% (yr))
      yp+=ypStep
      yr+=yrStep
      i+=1
    
def CnvShowFunc(RqCnv, RqFuncTab, RqTitle) :
   FStat = FuncStat(RqCnv, RqFuncTab)
   lstP = []
   for i in range(len(RqFuncTab)) :
      PixX = XtoPix(FStat, RqFuncTab[i][0])
      PixY = YtoPix(FStat, RqFuncTab[i][1])
      lstP.append(PixX)
      lstP.append(PixY)   
   RqCnv.create_line(lstP, fill='blue')
   Axes(RqCnv, FStat, RqFuncTab)
   RqCnv.create_text(2 * brX, 12, text=RqTitle, anchor='w')
   return lstP
       
def CnvSize(RqCnv, RqWidth, RqHeight) :
    if RqWidth < 400 : RqCnv['width'] = 400
    else : RqCnv['width']  =  RqWidth  
    if RqHeight < 200 : RqCnv['height'] = 200
    else : RqCnv['height'] =  RqHeight  

def CnvClean (RqCnv, RqColor) :
    RqCnv['bg']=RqColor
    RqCnv.delete('all')

# ====================================================
