#!/usr/bin/python3
from tkinter import *
from tkinter import ttk
 
root = Tk()
root.title("События мышки для эластичного рисования")
root.geometry("460x440")

# Глобальные переменные
id     = None          # Объект id
shape  = None          # Фигура
# Стартовые координаты фигуры
startX = 0
startY = 0

# Выбор и начало рисования фигуры
def onStart(event):
    global id, shape, startX, startY
    # Выбор фигуры
    shape = canvas.create_oval
    # Фиксация начальных координат фигуры
    startX = event.x
    startY = event.y
    # Фигура еще не создана
    id = None

# Эластичное преобразование фигуры
def onElastic(event):
    global id, shape, startX, startY
    # Удалить фигуру, если она существует
    if id : canvas.delete(id)
    # Создать и нарисовать фигуру с новыми габаритами
    id = shape(startX, startY, event.x, event.y)

# Перемещение последней фигуры
def onMove(event):
    global id, startX, startY
    if id :
       # если фигура существует выполнить ее смещение 
       diffX, diffY = (event.x - startX), (event.y - startY)
       canvas.move(id, diffX, diffY)
       # Сохранить стартовые координаты фигуры
       startX = event.x
       startY = event.y

# Удаление всех фигур (очистка canvas)       
def onClear(event):
    canvas.delete('all')
 
canvas = Canvas(width=400, height=400, bg='light cyan')
canvas.pack()
canvas.bind('<ButtonPress-1>', onStart)      # Начало фигуры
canvas.bind('<B1-Motion>',     onElastic)    # Эластичная перерисовка
canvas.bind('<Double-1>',      onClear)      # Удаление всех фигур
canvas.bind('<ButtonPress-3>', onMove)       # Перемещение последнй фигуры

canvas.create_text(150, 20, text='ЭЛАСТИЧНОЕ РИСОВАНИЕ ФИГУР')
canvas.create_text(150, 40, text='Рисуем фигуры удержанием левой кнопки мышки')
canvas.create_text(150, 60, text='Перемещаем фигуру кликом правой кнопки мышки')
canvas.create_text(150, 80, text='Очистка окна двойным кликом')
 
root.mainloop()
