#!/usr/bin/python3
from tkinter import *
from tkinter import ttk
from Tools.GraphXY import CnvSize, CnvClean, CnvShowFunc
from math    import *  #pow

root=Tk()
root.geometry ('640x560')
root.title('Визуализация графиков степенного ряда')


Frm1=ttk.Frame(root, padding=10, relief=SUNKEN, width=640,  height=280)
Frm1.pack(side='top', fill='x',  expand='no')

IniAn  = ['-3.5', '1', '2', '-2', '0.4', '-0.08', '0.04', '0.01']
AnTAB  = []
XbeTAB = []

# Конструктор создания надписей и таблиц   
def entCreate(entNum) :
    LabAn=Label(Frm1, text='Коэффициенты степенного ряда', relief=FLAT)
    LabAn.grid(row=0, column=0, columnspan=entNum, sticky=EW)
    for ind in range(entNum):
       lab = Label(Frm1, width= 10, text='a' + str(ind))
       lab.grid(row=1, column=ind, sticky=EW)
       ent = Entry(Frm1, width= 10)    
       ent.grid(row=2, column=ind, sticky=EW)
       ent.insert(0,IniAn[ind])
       AnTAB.append(ent)
    labXb = Label(Frm1, width= 10, text='Xb')
    labXb.grid(row=3, column=0, sticky=EW)
    labXe = Label(Frm1, width= 10, text='Xe')
    labXe.grid(row=3, column=1, sticky=EW)   
    entXb = Entry(Frm1, width= 10)
    entXb.grid(row=4, column=0, sticky=EW)
    entXb.insert(0,'-1.5')
    XbeTAB.append(entXb)
    entXe = Entry(Frm1, width= 10)
    entXe.grid(row=4, column=1, sticky=EW)
    entXe.insert(0,'1.5')
    XbeTAB.append(entXe)
    btnRun = Button(Frm1, text="Run", width= 10, command = (lambda : CreatePolinom()))
    btnRun.grid(row=4, column=2, sticky=EW)

# Создадим надписи и таблицу Entry 
entCreate(len(IniAn))

Frm2=ttk.Frame(root, padding=10, relief=SUNKEN, width=640,  height=400)
Frm2.pack(side='left', fill='y', expand='no')

cnv2 = Canvas(Frm2, width=600, height=380)
cnv2.pack()

ErrCode = 0
def GetData(RqEnt) :
    global ErrCode
    wstr = RqEnt.get()    
    try :
      RqEnt['bg'] = 'white'      
      return float(wstr)
    except :
      ErrCode+=1  
      RqEnt['bg'] = 'bisque'
      return 0

# Вычислить по коэффициентам an степенной многочлен в точке x
def ppoly(an, x) :
   s = 0
   for n in range(0, len(an)) : s+=an[n]*pow(x, n)
   return s

def CreatePolinom() :
   global ErrCode
   ErrCode = 0
   An      = []
   for ind in range(len(IniAn)):
      An.append(GetData(AnTAB[ind]))   
   Xb = GetData(XbeTAB[0])
   Xe = GetData(XbeTAB[1])   
   lstXY = []
   x = Xb
   while (x <= Xe ) :
       y = ppoly(An, x)
       # Упаковка в формат FuncTab
       lst   = []
       lst.append(x)
       lst.append(y)
       lstXY.append(lst)
       x = x + (Xe - Xb)/50
   CnvClean(cnv2, 'gray90')
   if ErrCode == 0 :
      CnvShowFunc(cnv2, lstXY, 'График степенного ряда')
   else :
      cnv2.create_text(150, 20, text='Ошибки в полях отмеченных цветом', anchor='w') 
   del(lstXY)

CnvSize(cnv2,600,400)
CnvClean(cnv2, 'gray90')

root.mainloop ()
