#!/usr/bin/python3
from tkinter import *
from tkinter import ttk
from tkinter.scrolledtext import ScrolledText

root=Tk()
root.geometry('700x660')
root.title('Чувствительные области на Canvas (метод .tag_bind)')

# ------------------------------------------------
# Подготовим два фрейма
# ------------------------------------------------
frameT=ttk.Frame(root, padding=[10, 10], relief=SUNKEN, width=700, height=80)
frameB=ttk.Frame(root, padding=[10, 10], relief=SUNKEN, width=700, height=520)

frameT.pack(side='top', fill='none', expand='no')
frameB.pack(side='top', fill='none', expand='no')

# ------------------------------------------------
# Разметка и обслуживание чувствительных областей
# ------------------------------------------------
CnvT = Canvas(frameT, bg='gray89', width=680, height=60)
CnvT.pack()

def area_func(event):
    id = CnvT.find_closest(event.x, event.y,  halo=None, start=None)[0]
    TextB.insert('1.0', '\n')
    TextB.insert('1.0', 'Coords = ' + str(CnvT.coords(id)) + '\n')
    TextB.insert('1.0', 'Tags = ' + str(CnvT.gettags(id)) + '\n')
    TextB.insert('1.0', 'Id = ' + str(id) + '\n')

xstep, xb, yb = 70, 10, 10
for indx in range(9) :
   id = CnvT.create_rectangle([xb,10], [xb+xstep, yb+40], fill='light cyan')
   CnvT.addtag_withtag('AreaRectangle', id)
   CnvT.tag_bind(id,'<Button-1>', area_func)
   id = CnvT.create_text(xb + 6, yb + 8, text='Area ' + str(indx), fill='blue', anchor='w')
   CnvT.addtag_withtag('AreaTitle', id)
   CnvT.tag_bind(id,'<Button-1>', area_func)
   xb+=xstep
   
# ------------------------------------------------
# Краткая справка плюс репортер обработчика area_func
# ------------------------------------------------
strB1 = '''
         Чувствительные области на Canvas (метод .tag_bind)

 Tkinter позволяет  с помощью метода .tag_bind на объектах Canvas задать
 события и соответствующие им обработчики событий. Если обработчик событий
 является общим для всех объектов, то в нем возникает задача идентификации
 соответствующего объекта. Эта задача обычно решается методом на Canvas:
 сanvas.find_closest(event.x, event.y,  halo=None, start=None)[0]
 Подробно о методах работы с тегами можно посмотреть на страницах:

    https://tkdocs.com/shipman/canvas-tags.html
    https://tkdocs.com/shipman/tag-or-id.html
    https://tkdocs.com/shipman/canvas-methods.html
  
 Кликните мышкой на подпись области или на прямоугольник области.
'''
TextB = ScrolledText(frameB, width=80, height=32, wrap=WORD)
TextB.pack(expand='no', fill="none")
TextB.insert('1.0', strB1 + '\n')
    
# ------------------------------------------------
mainloop( )

