#!/usr/bin/python3
from tkinter import *
from tkinter import ttk

root=Tk()
root.geometry('700x540')
root.title('Работа с виртуальными событиями')

# Подготовим три фрейма 
frameT=ttk.Frame(root, padding=[8, 10], relief=SUNKEN)
frameM=ttk.Frame(root, padding=[8, 10],relief=SUNKEN)

# Определим порядок фреймов на root
frameT.pack(side='top',    fill='x',    expand='no')
frameM.pack(side='top',    fill='both', expand='yes')


# 
frameT1=ttk.Frame(frameT, padding=[10, 12], relief=SUNKEN)
frameT1.pack(side='left',  fill='x',  expand='no')

wstr1 = '''  LabTest, к которой подключено,   
  созданное нами, виртуальное
  событие <<custom-event>>, а
  также обработчик ShowEvent. '''

LabTest=Label(frameT1 ,text=wstr1, justify='left', bg='light cyan', relief=SUNKEN)
LabTest.pack(side='left')

def ShowEvent(event):
    labMsg['text'] = str(event)
    print(event.num, event.x, event.y)
    
    
LabTest.event_add('<<custom-event>>', '<Button-1>', '<Button-2>', '<Button-3>')
LabTest.bind('<<custom-event>>', ShowEvent)

# 
frameT2=ttk.Frame(frameT, padding=[8, 10], relief=SUNKEN)
frameT2.pack(side='left',    fill='x',    expand='yes')
#

labe2T=Label(frameT2 ,text='Строка из объекта Event', relief=FLAT)
labe2T.pack(side='top', fill='x', expand='no')
# 
labMsg=Label(frameT2 ,text='', relief=SUNKEN)
labMsg.pack(side='top', fill='x', expand='no')
#
def DelEvent(ind) :
    if ind == 1 : LabTest.event_delete('<<custom-event>>', '<Button-3>')
    if ind == 2 : LabTest.event_delete('<<custom-event>>', '<Button-2>')
    if ind == 3 : LabTest.unbind('<<custom-event>>')
    labMsg['text'] =''
    
But1T = Button(frameT2, text='Отключить <Button-3>', command=(lambda: DelEvent(1)))
But1T.pack(side="left")
But2T = Button(frameT2, text='Отключить <Button-2>', command=(lambda: DelEvent(2)))
But2T.pack(side="left")
But3T = Button(frameT2, text='Отключить обработчик', command=(lambda: DelEvent(3)))
But3T.pack(side="left")

labelM=Label(frameM ,text='Краткая, пошаговая инструкция')
labelM.pack(side='top', fill='x', expand='no')

textM = Text(frameM, height=16, width=60)
textM.pack(side='left', fill="both", expand='yes')
wstr = '''
 1. В этом примере создается и привязывается к  LabTest виртуальное событие
 <<custom-event>>, которое объединяет прослушивание трех кнопок мышки:
 LabTest.event_add('<<custom-event>>','<Button-1>','<Button-2>','<Button-3>')

 2. Также к LabTest подключается обработчик событий ShowEvent(event) с помощью
 инструкции: LabTest.bind('<<custom-event>>', ShowEvent) 

 3. Обработчик событий имеет обязательный параметр event, который позволяет
 получить некоторую информацию о параметрах события:
 
 def ShowEvent(event):
    labMsg['text'] = str(event)
    print(event.num, event.x, event.y)

 4. Также можно исключить из <<custom-event>> отдельное событие, например
 LabTest.event_delete('<<custom-event>>', '<Button-3>') исключается реакция на
 третью кнопку мышки.

 5. У метода .bind существует ему противоположный метод .unbind, отключающий
 от события или виртуального события соответствующий обработчик. В данном
 примере это реализуется так: LabTest.unbind('<<custom-event>>')
'''
textM.insert(END,wstr)


# ------------------------------------------------
root.mainloop ()
