import tkinter as tk
from tkinter import ttk

def button_pressed(event):
    print('Handler1: Button-1 pressed.')

def return_pressed(event):
    print('Handler2: Return key pressed.')

def log(event):
    print('Handler13: ',event)

root = tk.Tk()
root.geometry("480x380")

wstr = '''
   Расширенный синтаксис для widget.bind:
   
   widget.bind(event, handler1, add=None)
   widget.bind(event, handler2, add="+")
   
   В этом примере показано, как использовать метод
   bind()для регистрации нескольких обработчиков
   одного и того же события:

   btn1 = ttk.Button(root, text=' Press Return or Button-1 ')
   btn1.bind('<Button-1>', button_pressed)
   btn1.bind('<Return>', return_pressed)
   btn1.bind('<Return>', log, add='+')
   btn1.pack(side="top")
 
   Когда вы перемещаете фокус на кнопку и нажимаете клавишу Return,
   Tkinter автоматически вызывает функции return_pressed и log.
   Реакцию смотрите на консоли.
'''
lbl = ttk.Label(root, text=wstr).pack(side="top")
btn1 = ttk.Button(root, text=' Press Return or Button-1 ')
btn1.bind('<Button-1>', button_pressed)
btn1.bind('<Return>', return_pressed)
btn1.bind('<Return>', log, add='+')
btn1.pack(side="top")

btn2 = ttk.Button(root, text=' None ')
btn2.focus()
btn2.pack(side="top")
root.mainloop()

