#!/usr/bin/python3
import platform
from tkinter import *
from tkinter import ttk
from tkinter.scrolledtext import ScrolledText
import time
import datetime as dt

print(' OS   : ', platform.system(), platform.release())
print(' Ver. : ', platform.version())

root=Tk()
root.geometry('760x780')
root.title('Примеры работы с программными и програмно-аппаратными событиями')

# ------------------------------------------------
# Подготовим три фрейма первого уровня
# ------------------------------------------------
frameT=ttk.Frame(root, padding=[8, 10], relief=SUNKEN, width=740, height=240)
frameM=ttk.Frame(root, padding=[8, 10], relief=SUNKEN, width=740, height=240)
frameB=ttk.Frame(root, padding=[6, 10], relief=SUNKEN, width=740)

frameT.pack(side='top', fill='none', expand='no')
frameM.pack(side='top', fill='none', expand='no')
frameB.pack(side='top', fill='y',    expand='yes')

# ------------------------------------------------
# Подготовим фреймы второго уровня
# ------------------------------------------------
# Внутри frameT
frameTL=ttk.Frame(frameT, padding=[8, 12], relief=SUNKEN, width=320, height=240)
frameTR=ttk.Frame(frameT, padding=[8, 10], relief=SUNKEN, width=320, height=240)
frameTL.pack(side='left', fill='none', expand='no')
frameTR.pack(side='left', fill='none', expand='no')
# Внутри frameM
frameML=ttk.Frame(frameM, padding=[8,  12], relief=SUNKEN, width=320, height=230)
frameMR=ttk.Frame(frameM, padding=[8,  10], relief=SUNKEN, width=320, height=230)
frameML.pack(side='left', fill='none', expand='no')
frameMR.pack(side='left', fill='none', expand='no')

# ------------------------------------------------
# Комментарий
# ------------------------------------------------
strCmnt = '''
 Представлено четыре примера работы с программными и програмно-аппаратными
 событиями. Примеры  иллюстрируют работу с событиями из списка, который
 формирует Tkinter, прослушивая события операционной системы. В свою очередь
 различные виджеты могут использовать собственные выборки событий из такого
 списка. О том, что разрешает использовать конкретный виджет можно выяснить
 выполнив HelpEvent.py или две инструкции:
        import tkinter
        help(tkinter.Event)
 В примерах 1 и 3 связывание конкретного события осуществляется методом bind
 на виджете.
 В примерах 2 и 4 связывание событий с обработчиком выполняется либо атрибутом
 command в тех виджетах, для которых такой атрибут предусмотрен (пример 2),
 либо используется специальное связывание, предоставляемое импортированным
 модулем (пример 4)
 Все написаные примеры независимы друг от друга и могут использоваться как
 самостоятельные шаблоны.
'''
TextB = Text(frameB,  wrap=WORD)
TextB.pack(side='top', fill='y', expand='yes')
TextB.insert('1.0', strCmnt)

# ------------------------------------------------
# Пример 1 (кнопки на мышке)
# ------------------------------------------------
strTL1 = '''
 ПРИМЕР 1.
 К надписи ( LabTL1 ) подключены методом ( .bind )
 четыре обычных оброботчика событий: <Motion>,
 <Button-1>, <Button-2>, а также  <Button-3>.

 Наведите курсор на надпись и нажмите одну
 из кнопок на мышке.
'''
def TLmsg1(event):
    LabTLmsg1['text']='X: ' + str(event.x) + '; Y: ' + str(event.y)
    
def TLmsg2(event):
    LabTLmsg2['text']='Номер нажатой кнопки: ' + str(event.num)
    
LabTL1 = Label(frameTL, text=strTL1, width=43, bg='light cyan', justify ='left', relief=SUNKEN)
LabTL1.pack(side='top')
LabTLmsg1 = Label(frameTL, text=' ', width=43, relief=SUNKEN)
LabTLmsg1.pack(side='top')
LabTLmsg2 = Label(frameTL, text=' ', width=43, relief=SUNKEN)
LabTLmsg2.pack(side='top')
LabTL1.bind('<Motion>',   TLmsg1)
LabTL1.bind('<Button-1>', TLmsg2)
LabTL1.bind('<Button-2>', TLmsg2)
LabTL1.bind('<Button-3>', TLmsg2)

# ------------------------------------------------
# Пример 2 (подсветка надписи и отключение кнопки)
# ------------------------------------------------
strTL1 = '''
 ПРИМЕР 2.
 К надписи ( LabTR1 ) подключены методом ( .bind )
 четыре обычных оброботчика событий: <Enter>,
 <Leave>, <Button-1>, а также  <Button-3>.

 Наведите курсор на надпись и нажмите одну
 из кнопок на мышке.
'''
def TRmsg1(event):
    LabTR1['bg']='light cyan'
    
def TRmsg2(event):
    LabTR1['bg']='gray90'

def TRmsg3(event):
    LabTRmsg2['text']='Номер нажатой кнопки: ' + str(event.num)

def TRoff(indx):
    LabTRmsg2['text']=''
    if indx==1 : LabTR1.unbind('<Enter>')
    if indx==2 : LabTR1.unbind('<Button-3>')
    
LabTR1 = Label(frameTR, text=strTL1, width=43, bg='gray90', justify ='left', relief=SUNKEN)
LabTR1.pack(side='top')
LabTRmsg2 = Label(frameTR, text=' ', width=43, relief=SUNKEN)
LabTRmsg2.pack(side='top')
ButTR1 =  Button(frameTR, text='Отключить Enter', width=20, command =(lambda : TRoff(1)))
ButTR1.pack(side='left')
ButTR2 =  Button(frameTR, text='Отключить Button-3', width=20, command =(lambda : TRoff(2)))
ButTR2.pack(side='left')
LabTR1.bind('<Enter>',    TRmsg1)
LabTR1.bind('<Leave>',    TRmsg2)
LabTR1.bind('<Button-1>', TRmsg3)
LabTR1.bind('<Button-3>', TRmsg3)

# ------------------------------------------------
# Пример 3 (отработка событий клавиатуры)
# ------------------------------------------------
strML1 = '''
 ПРИМЕР 3.
 Для начала нажмите кнопку
   "Подключить KeyPress"
 чтобы подключить к окну (root)
 обработчик события: <Keys>.
 
 Далее нажимайте любые клавиши
 на клавиатуре.
'''
def MyOnBind() :
    wstr = str(platform.system())
    # Контроль платформы
    if wstr.upper() != 'WINDOWS':
       wstr = 'Enabled Windows only'+ '\n'
       TextML.insert(1.0, wstr)
       print(wstr)
       return 
    root.bind_all('<KeyPress>', keys)
    wstr = "root.bind_all('KeyPress>', keys)"  + '\n'
    TextML.insert(1.0, wstr)
    btn2ML.focus()
    print(wstr)

def MyOffBind() :
    root.unbind_all('<KeyPress>')
    wstr = "root.unbind_all('<KeyPress>')"  + '\n'
    TextML.insert(1.0, wstr)
    btn1ML.focus()
    print(wstr)

# Глобальный индикатор - нажата клавиша из списка SCA_List
SCA_txt = ''

# Особенность функции show_key(event)
# Функция не определяет была ли отпущена клавиша из списка SCA_List в момент
# нажатия обычной клавиши. В любом случае алгоритм распознает комбинированное
# нажатие
def keys(event):
    global SCA_txt   
    # Модификаторы стандартных клавиш (сами по себе не должны вызывать реакции)
    SCA_List = ['Shift_L', 'Shift_R', 'Control_L', 'Control_R', 'Alt_L', 'Alt_R']
    # Проверка - если нажата клавиша из списка SCA_List
    for SCA in SCA_List:
        if event.keysym.upper() == SCA.upper():
           SCA_txt = event.keysym           
           return
    # Для остальных клавиш          
    if  SCA_txt != '' :
        msgLab ='Комбинация клавиш: ' + SCA_txt
        if event.keysym != '??':
           # Английские символы 
           msgLab = msgLab + '+' + event.keysym
        else:
           # Символы кирилицы 
           msgLab = msgLab + '+' +  chr(event.keycode)
        SCA_txt = ''
    elif event.char==event.keysym:
        # Английские символы 
        msgLab ='Клавиша символа: ' + event.char
    elif (len(event.char)==1) and (event.keysym=='??') :
        # Символы кирилицы
        msgLab = 'Клавиша символа: ' + event.char
    elif len(event.char)==1:
        msgLab ='Клавиша пунктуации: ' + event.keysym + '; ' + event.char
    else:
        msgLab ='Специальная клавиша: ' + event.keysym
    # Отчет     
    TextML.insert('1.0', msgLab + '\n')   
    print(event, 'len(event.char)=', len(event.char), '; event.state=',  event.state)
    return
  
TextML = ScrolledText(frameML, height=10, width=30,  wrap=WORD)
TextML.pack(side='top', fill='x', expand='no')
TextML.insert('1.0', strML1 + '\n')
btn1ML = Button(frameML, text='Подключить KeyPress', width=20, command = lambda : MyOnBind())
btn1ML.pack(side='left', expand='no')
btn1ML.focus()
btn2ML = Button(frameML, text='Отключить KeyPress',  width=20, command = lambda : MyOffBind())
btn2ML.pack(side='left', expand='no')

# ------------------------------------------------
# Пример 4 (отработка событий таймера)
# ------------------------------------------------

def cycle() :
    cnvML.delete('all')
    cnvML.create_text(30,30, text='ПРИМЕР 4. Работа с событиями таймера',  font=('Tahoma',9), fill='Black', anchor='w')
    date = dt.datetime.now()
    cnvML.create_text(30,60, text=f"{date:%A, %B %d, %Y}", font=('Tahoma',16), fill='Gray50', anchor='w')
    wstr = str(time.strftime('%H:%M:%S'))
    cnvML.create_text(60,100, text=wstr, font=('Tahoma',30), fill='Gray50', anchor='w')
    # Рекурсивный вызов с обновлением установки таймера
    cnvML.after(500, cycle)                  
                      
cnvML = Canvas(frameMR, width=300, height=190, bg='light cyan')
cnvML.pack()
cnvML.after(500, cycle)



# ------------------------------------------------
root.mainloop ()
