#!/usr/bin/python3
import platform
from tkinter import *
from tkinter import ttk

print(' OS   : ', platform.system(), platform.release())
print(' Ver. : ', platform.version())


root=Tk()
winW = 800  # Ширина окна
winH = 200  # Высота окна
root.geometry(str(winW)+'x'+str(winH))
root.title('Работа с клавиатурой. Событие <Key> ')
root.resizable(width=False, height=False)

# ------------------------------------------------
# Отступы внутри всех фреймов
# ------------------------------------------------
pdX = 8     # Отступы внутри фрейма по X
pdY = 6     # Отступы внутри фрейма по Y

# ------------------------------------------------
# Подготовим три фрейма первого уровня
# ------------------------------------------------
frameT=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=winW, height=winH)
frameT.pack(side='top', fill='none', expand='no')
# Запрет изменения размеров фреймов встроенными виджетами
frameT.pack_propagate(0)


# ------------------------------------------------
# Подготовим фреймы второго уровня
# ------------------------------------------------
winW = winW - 2 * pdX  # Ширина уменьшилась за счет уже использованых отступов
winH = winH - 4 * pdY  # Высота уменьшилась за счет уже использованых отступов

# Внутри frameT
frameTL=ttk.Frame(frameT, padding=[pdX, pdY], relief=SUNKEN, width=2* winW//4, height=winH)
frameTR=ttk.Frame(frameT, padding=[pdX, pdY], relief=SUNKEN, width=2* winW//4, height=winH)
frameTL.pack(side='left', fill='none', expand='no')
frameTR.pack(side='left', fill='none', expand='no')
# Запрет изменения размеров фреймов встроенными виджетами
frameTL.pack_propagate(0)
frameTR.pack_propagate(0)

# ------------------------------------------------
# Сегмент для прикладной части
# ------------------------------------------------
stdfont  = 'Calibri 11'   # Фонт для Python  3, Windows 10
#stdfont = 'Calibri 8'    # Фонт для Pydroid 3, Android 11

# ------------------------------------------------
# ПРИМЕР: Подключения/Отключения bind
# ------------------------------------------------
def onBind() :
    wstr = str(platform.system())
    # Контроль платформы
    if wstr.upper() != 'WINDOWS':
       wstr = 'Enabled Windows only'+ '\n'
       TextTR.insert(1.0, wstr)
       print(wstr)
       return 
    root.bind_all('<KeyPress>', show_key)
    wstr = " root.bind_all('KeyPress>', show_key)"  + '\n'
    TextTR.insert(1.0, wstr)
    print(wstr)

def offBind() :
    root.unbind_all('<KeyPress>')
    wstr = " root.unbind_all('<KeyPress>')"  + '\n'
    TextTR.insert(1.0, wstr)
    print(wstr)

# ------------------------------------------------
# Пример работы со всеми клавишами
# ------------------------------------------------
# Глобальный индикатор - нажата клавиша из списка SCA_List
SCA_txt = ''

# Особенность функции show_key(event)
# Функция не определяет была ли отпущена клавиша из списка SCA_List в момент
# нажатия обычной клавиши. В любом случае алгоритм распознает комбинированное
# нажатие
def show_key(event):
    global SCA_txt   
    # Модификаторы стандартных клавиш (сами по себе не должны вызывать реакции)
    SCA_List = ['Shift_L', 'Shift_R', 'Control_L', 'Control_R', 'Alt_L', 'Alt_R']
    # Проверка - если нажата клавиша из списка SCA_List
    for SCA in SCA_List:
        if event.keysym.upper() == SCA.upper():
           SCA_txt = event.keysym           
           return
    # Для остальных клавиш          
    msg1 = 'event.keycode (en) = ' + str(event.keycode) + '\n'
    msg2 = 'event.char  = '   + event.char + '\n'
    msg3 = 'event.keysym = '  + event.keysym + '\n'
    if  SCA_txt != '' :
        msgLab ='Комбинация клавиш: ' + SCA_txt
        if event.keysym != '??':
           # Английские символы 
           msgLab = msgLab + '+' + event.keysym
           msgTxt = msgLab + '\n' + msg1 + msg3
        else:
           # Символы кирилицы 
           msgLab = msgLab + '+' +  chr(event.keycode)
           msgTxt = msgLab + '\n' + msg1
        SCA_txt = ''
    elif event.char==event.keysym:
        # Английские символы 
        msgLab ='Клавиша символа: ' + event.char
        msgTxt = msgLab + '\n' + msg1 + msg2 + msg3
    elif (len(event.char)==1) and (event.keysym=='??') :
        # Символы кирилицы
        msgLab = 'Клавиша символа: '
        msgTxt = msgLab + '\n' + msg1 + msg2
    elif len(event.char)==1:
        msgLab ='Клавиша пунктуации: ' + event.keysym + '; ' + event.char
        msgTxt = msgLab + '\n' + msg1 + msg2 + msg3
    else:
        msgLab ='Специальная клавиша: ' + event.keysym
        msgTxt = msgLab + '\n' + msg1 + msg3
    # Отчет     
    LabTL.config(text='\n' +msgTxt)
    TextTR.insert('1.0', msgTxt + '\n')    
    print(event, 'len(event.char)=', len(event.char), '; event.state=',  event.state)
    return

but1 = Button(frameTL, text='bind_all', font = stdfont, command = lambda : onBind())
but1.pack(side='top', fill='x', expand='no')
but2 = Button(frameTL, text='unbind_all', font = stdfont, command = lambda : offBind())
but2.pack(side='top', fill='x', expand='no')
LabTL= Label(frameTL, text='', font=('bold'))
LabTL.pack(side='top', fill='x', expand='no')

# ---------------------------
# ПРИМЕР: Подготовим TextHelp
# ---------------------------
TextTR= Text(frameTR, font = stdfont)
TextTR.pack(side='top', fill='both',  expand='yes')

wstr = '''
  Для работы с клавиатурой подключите (bind_all)
  обработчик события <KeyPress> и нажимайте любые
  клавиши ... Обработчик также можно включать
  и отключать (unbind_all)  
'''
TextTR.insert(END, wstr)


# ------------------------------------------------
# Цикл ожидания событий
# ------------------------------------------------
root.mainloop ()
