#!/usr/bin/python3
from tkinter import *
from tkinter import ttk
from tkinter.scrolledtext import ScrolledText

# Обработчик виртуального события. Обязательный параметр event  
def vr(event) :
    print('Вкладка изменилась')
    indx = int(nb.index('current'))
    print('Индекс  вкладки: ' + str(indx))
    print('Надпись вкладки: ' + nb.tab(indx)['text'])

root = Tk()
root.title("Вкладки и события ttk.Notebook")

nb = ttk.Notebook(root)
page1 = ttk.Frame(nb)
page2 = ttk.Frame(nb)

text1 = ScrolledText(page1)
text1.pack(expand=1, fill="both")

text2 = ScrolledText(page2)
text2.pack(expand=1, fill="both")

nb.add(page1, text=' PAGE 1 ')
nb.add(page2, text=' PAGE 2 ')
nb.pack(expand=1, fill="both")

# В виджете Notebook встроено виртуальное событие '<<NotebookTabChanged>>'   
# В bind для виртуальных событий обработчик указывается только именем
nb.bind('<<NotebookTabChanged>>', vr)


print(nb.event_info())        # Список событий
nb.select(1)                  # Пкреключение вкладок по индексу вкладки 
print(nb.index('end'))        # Общее число вкладок  
print(nb.index('current'))    # Индекс текущей вкладки
print(nb.tab(0))              # Параметры атрибутов вкладки с индексом 0 
print(nb.tab(0)['text'])      # Надпись вкладки с индексом 0
print(nb.tab(1)['text'])      # Надпись вкладки с индексом 1 


root.mainloop()


