#!/usr/bin/python3
'''
 Шаблон для размещения виджетов (в том числе и эластичных)
 в трех горизонтальных фреймах. Управление эластичностью
 виджетов выполняется в упаковке параметрами fill и expand.
'''
from tkinter import *
from tkinter import ttk

# ------------------------------------------------
# Имитатор отображения прогресса
def onStart(pb) :
    pb.start(100)   # Параметр: время задержки шага прогресса в мсек 
def onStop(pb) :    
    pb.stop()
# ------------------------------------------------
root=Tk()
root.geometry('500x440')
root.title('Sample 3-horizontal frames')

w = root.winfo_screenwidth()    # ширина экрана
h = root.winfo_screenheight()   # высота экрана

# Подготовим три фрейма 
frameT=ttk.Frame(root, padding=[8, 10], relief=SUNKEN)
frameM=ttk.Frame(root, padding=[8, 10],relief=SUNKEN)
frameB=ttk.Frame(root, padding=[8, 10],relief=SUNKEN)
# Определим порядок фреймов на root
frameT.pack(side='top',    fill='x',    expand='no')
frameM.pack(side='top',    fill='both', expand='yes')
frameB.pack(side='bottom', fill='x',    expand='no')
# Подготовим виджеты,  свяжем их с фреймами,
# определим вид эластичности
labelT=Label(frameT ,text='Screen rezolution ')
labelT.pack(side='left')

labe2T=Label(frameT ,text=' width :' + str(w) + ' ', relief=SUNKEN)
labe2T.pack(side='left')

labe3T=Label(frameT ,text=' height :' + str(h) + ' ', relief=SUNKEN)
labe3T.pack(side='left')

labelM=Label(frameM ,text='Text title')
labelM.pack(side='top', fill='x', expand='no')

textM = Text(frameM, height=16, width=60)
textM.pack(side='left', fill="both", expand='yes')
wstr = '''
 Шаблон для размещения виджетов (в том числе и эластичных)
 в трех горизонтальных фреймах. Управление эластичностью
 виджетов выполняется в упаковке параметрами fill и expand.
'''
textM.insert(END,wstr)

labelD=Label(frameB, text='Progressbar title')
labelD.pack(side='top', fill='x', expand='yes')

ButStart = Button(frameB, text='Start Progress', command=(lambda: onStart(pbD)))
ButStart.pack(side="left")
ButStop  = Button(frameB, text='Stop  Progress', command=(lambda: onStop(pbD)))
ButStop.pack(side="left")

pbD = ttk.Progressbar (frameB, length=400)
pbD.pack(side="bottom", fill="x", expand='yes')

# ------------------------------------------------
root.mainloop ()
