#!/usr/bin/python3
from tkinter import *
from tkinter import ttk
from tkinter.scrolledtext import ScrolledText
from Tools.LibSamples import *

root=Tk()
winW = 800  # Ширина окна
winH = 600  # Высота окна
root.geometry(str(winW)+'x'+str(winH))
root.title('Методы структуры данных типа tuple')
root.resizable(width=False, height=False)

# ------------------------------------------------
# Отступы внутри всех фреймов
# ------------------------------------------------
pdX = 8     # Отступы внутри фрейма по X
pdY = 6     # Отступы внутри фрейма по Y

# ------------------------------------------------
# Подготовим три фрейма первого уровня
# ------------------------------------------------
frameT=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=winW, height= 3 * winH//12)
frameM=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=winW, height= 5 * winH//12)
frameB=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=winW, height= 4 * winH//12)
frameT.pack(side='top', fill='none', expand='no')
frameM.pack(side='top', fill='none', expand='no')
frameB.pack(side='top', fill='none', expand='no')
# Запрет изменения размеров фреймов встроенными виджетами
frameT.pack_propagate(0)
frameM.pack_propagate(0)
frameB.pack_propagate(0)

# ------------------------------------------------
# Подготовим фреймы второго уровня
# ------------------------------------------------
winWp2 = winW - 2 * pdX  # Ширина уменьшилась за счет уже использованых отступов
winHp6 = winH - 6 * pdY  # Высота уменьшилась за счет уже использованых отступов

# Внутри frameT
frameT1=ttk.Frame(frameT, padding=[pdX, pdY], relief=SUNKEN, width=winWp2//4, height= 3 * winHp6//12)
frameT2=ttk.Frame(frameT, padding=[pdX, pdY], relief=SUNKEN, width=winWp2//4, height= 3 * winHp6//12)
frameT3=ttk.Frame(frameT, padding=[pdX, pdY], relief=SUNKEN, width=winWp2//2, height= 3 * winHp6//12)

frameT1.pack(side='left', fill='none', expand='no')
frameT2.pack(side='left', fill='none', expand='no')
frameT3.pack(side='left', fill='none', expand='no')

# Запрет изменения размеров фреймов встроенными виджетами
frameT1.pack_propagate(0)
frameT2.pack_propagate(0)
frameT3.pack_propagate(0)


# ------------------------------------------------
# Сегмент для прикладной части
# ------------------------------------------------
stdfont  = 'Calibri 11'   # Фонт для Python  3, Windows 10
#stdfont = 'Calibri 8'    # Фонт для Pydroid 3, Android 11
# ---------------------------
# ПРИМЕР: Подготовим TextCode
# ---------------------------
TextCode= ScrolledText(frameM, font = stdfont, padx = 10, pady = 8, wrap = WORD)
TextCode.pack(side='top', fill='both',  expand='yes')

wstr = '''
 tuple (кортеж) - это набор индексируемых объектов-констант
 1. Примеры методов и функций для структуры данных типа tuple:
   .index();  # Только для одноуровневых кортежей
   .count();  # Только для одноуровневых кортежей
    len();      # Для одноуровневых и многоуровневых кортежей
    min();     # Только для одноуровневых цифровых кортежей
    max();     # Только для одноуровневых цифровых кортежей
    copy();    # https://docs.python.org/3.10/library/copy.html
 2. Примеры работы с кортежами (регулярными и нерегулярными по типу элементов)
 3. В этом окне будет отображаться исходный текст, а в окне ниже результат
    его выполнения
'''
TextCode.insert(END, wstr)

# ---------------------------
#  Подготовим TextResult
# ---------------------------
TextResult = ScrolledText(frameB, font = stdfont, padx = 10, pady = 8, wrap = WORD)
TextResult.pack(side='top', fill='both',  expand='yes')

# ---------------------------
# Подготовим кнопки
# ---------------------------
but1 = Button(frameT1, text='Конструктор кортежа', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample01(x,y))
but1.pack(side='top', fill='x', expand='no')
but2 = Button(frameT1, text='Адресация элементов', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample02(x,y))
but2.pack(side='top', fill='x', expand='no')
but3 = Button(frameT1, text=' len()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample03(x,y))
but3.pack(side='top', fill='x', expand='no')
but4 = Button(frameT1, text='min();  max()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample04(x,y))
but4.pack(side='top', fill='x', expand='no')
#
but5 = Button(frameT2, text=' .index()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample05(x,y))
but5.pack(side='top', fill='x', expand='no')
but6 = Button(frameT2, text=' .count()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample06(x,y))
but6.pack(side='top', fill='x', expand='no')
but7 = Button(frameT2, text=' copy()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample07(x,y))
but7.pack(side='top', fill='x', expand='no')
# but8 = Button(frameT2, text='Reserv', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample08(x,y))
# but8.pack(side='top', fill='x', expand='no')
#
msg9 = '''
 1. Элементы кортежа имеют определенный порядок,
 и этот порядок НЕ изменится после создания кортежа;
 2. Мы НЕ можем изменять, добавлять или удалять
 элементы после того, как кортеж был создан;
 3. Поскольку кортежи индексируются, они могут иметь
 элементы с одинаковым значением. 
'''
Lab9 = Label(frameT3, text=msg9, font = stdfont, justify = 'left')
Lab9.pack(side='top', fill='x', expand='no')

# ------------------------------------------------
# Цикл ожидания событий
# ------------------------------------------------
root.mainloop ()
