unit Common1;

interface

uses
  Windows, SysUtils, MMSystem;

// ==========================================================================
//    
// ==========================================================================
// --------------------------------------------------------------------------
//      (. unit SensorGroup01)
// (   !)
const REC1MaxIndx = 11;

//       
// ( !)
type TREC1 = packed record
     Id    : string[8];
     Arr   : array[0..REC1MaxIndx] of extended;
end;

// 08.02.2019 
//     
type TNStrREC1 = packed record
     Id    : array[0..255] of char;
end;

// =========================================================================
//       
// =========================================================================
//      ( 1 msec)
//    unit MMSystem.pas
type TTimeStampsMM = record
  MMErr  : word;             //      
  BTime  : LongInt;          //    msec
  ETime  : LongInt;          //    msec
end;
// -------------------------------------------------------------------------

//    
function StartMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;

//       
function StopMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;

// ==========================================================================
//  
// ==========================================================================
// --------------------------------------------------------------------------
//   
var ApplicationDirectory : string;

// ==========================================================================
//      
// ==========================================================================
// 05.06.2018
var  REC1 : TREC1;   //    'REC1'

// 08.02.2019
//    
var  NStrREC1 : TNStrREC1;

// ==========================================================================
implementation
// ==========================================================================

// =========================================================================
//       
// =========================================================================
// 02.01.2017
//    
function StartMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   Result := '';
   try
       RqStamp.BTime := timeGetTime;
       RqStamp.MMErr := 0;
   except
       RqStamp.MMErr := 1;          //   
       Result := '.';
   end;
end;
// -------------------------------------------------------------------------
// 02.01.2017
//       
function StopMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   if RqStamp.MMErr = 0
   then begin
      with RqStamp
      do begin
          try
            ETime := timeGetTime;
            if (ETime - BTime) >= 0
            then Result := IntToStr(ETime - BTime);
          except
            MMErr := 1;
            Result := '.';
          end;
      end;
   end;
end;

// ==========================================================================
// 
// ==========================================================================
end.
