unit UserApp01Main;
// ====================================================================
(*
                         
               

         
        ()  .
    ,       
     .   
            Ecxel,
          
    .    ()  
       .
   // -----------------------------------------------------
    2.01. ()  , , , , 2018.
                () Source code  ..
     03.01.2018
*)
// ====================================================================

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, Buttons, Menus, MMSystem,
  //  
  Common1,  ImgLoadSave01, DTF03, RingScope01,
  LineScope01, Oscillograph02, SpectrScopes02;

// =========================================================================
//       (DTF)
//   .
// ( !)
// =========================================================================
type TSpectrData = record
    Sensor_Inx    : integer;           //    
    Sensor_Title  : string;            //  
    Signal_MaxPnt : integer;           //     
    Signal_ArrIdx : integer;           //    
    Signal_ArrY   : array of extended; //   
    Spectr_Arr    : TArrSpectr;        //   
end;

// =========================================================================
//   
// ( !)
// =========================================================================
type
  TUserApp01Form = class(TForm)
    Panel1: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    StaticText3: TStaticText;
    StaticText4: TStaticText;
    Label1: TLabel;
    PageControl1: TPageControl;
    TabSopes: TTabSheet;
    TabSpectr: TTabSheet;
    PanelSpectr: TPanel;
    Label3: TLabel;
    PrBarExtracts: TProgressBar;
    rdgrpOscilograph: TRadioGroup;
    Image1: TImage;
    PanelOS2: TPanel;
    PanelOsc02CTRL: TPanel;
    Label7: TLabel;
    edYMax: TEdit;
    edY1Alarm: TEdit;
    edY2Alarm: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    spbuttAplyAmp: TSpeedButton;
    spbuttOptimalScale: TSpeedButton;
    spbuttClearHistory: TSpeedButton;
    cbboxSelectSensor: TComboBox;
    PopupMenuLR: TPopupMenu;
    menuHidenShow: TMenuItem;
    menuStyle: TMenuItem;
    menuTranparent: TMenuItem;
    StTxtDFTTime: TStaticText;
    Label2: TLabel;
    StTxtFullTime: TStaticText;
    Label12: TLabel;
    stxtGrmNum: TStaticText;
    stxtGrmFreq: TStaticText;
    Label11: TLabel;
    Label13: TLabel;
    // ----------------------------------
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure rdgrpOscilographClick(Sender: TObject);
    procedure spbuttAplyAmpClick(Sender: TObject);
    procedure cbboxSelectSensorClick(Sender: TObject);
    procedure spbuttClearHistoryClick(Sender: TObject);
    procedure spbuttOptimalScaleClick(Sender: TObject);
    procedure menuHidenShowClick(Sender: TObject);
    procedure menuStyleClick(Sender: TObject);
    procedure menuTranparentClick(Sender: TObject);
    // ----------------------------------
  private
    function ClickIndByImgXY(X,Y : integer): integer;
    function ImgPointToFormPoint(X,Y : integer) : TPoint;
    // ----------------------------------
    //  
    procedure SelectSensor(Indx : integer);
    //     
    procedure SetLineScopeParam (RqScope   : TLineScope; ScopeIndx : integer);
    //     
    procedure SetRingScopeParam (RqScope   : TRingScope; ScopeIndx : integer);
    //     
    procedure SetSignalOscParam (RqOsc : TOscillograph; ScopeIndx : integer);
    //       
    procedure SetGrmlOscParam (RqOsc     : TOscillograph;
                               ScopeIndx : integer;
                               GrmIndx   : integer);
    // ----------------------------------
    //   "   "
    procedure  SpectrLoad(Sender : TObject; ArrGrm : TArrSpectr);
    //   "   Free"
    procedure SpecrtDestroy(Sender : TObject);
    //   "  "
    procedure ShowSelectGrm(Sender: TObject;
                            Num : integer; ArrGrm : TArrSpectr);
    //                                   
    procedure AddSignalPoint(RqVal : extended;
                         var RqSpectrData : TSpectrData);
    //         
    procedure ShowSpectrScope(var RqSpectrData : TSpectrData);
    // ----------------------------------
  public
    // ----------------------------------
    //      
    procedure ShowSensors();
  end;

var
  UserApp01Form: TUserApp01Form;

// =========================================================================
// =========================================================================
implementation
{$R *.dfm}
// =========================================================================
// =========================================================================
// 03.01.2018
//    (False)
//  (True)  ,  
//    
const HidenSpectrTab = True;

// =========================================================================
//       
//      
// =========================================================================
//       
// (   !)
const ImgFileName = '\PICTUREs\destroyer01.jpg';

// -------------------------------------------------------------------------
//     
// (   !)
//(       )
const ArrIndMax = 7;

// -------------------------------------------------------------------------
// 03.01.2018
//      
//   FormCreate  MaxSignal_MaxPnt
// (   !)
const MaxGrmNum = 100;

//         
// ( !)
const MaxSignal_MaxPnt = 4 * MaxGrmNum + 1;
// -------------------------------------------------------------------------
// 03.01.2018
//        
// ( !)
type TDescScope = array[0..ArrIndMax] of record
     SType   : char;       //   L- R-
     // --------------------
     Title   : string;     //  
     Meas    : string;     //   
     // --------------------
     Min     : extended;   //    (. )
     Max     : extended;   //     (. )
     ZoneY   : extended;   //     
     ZoneR   : extended;   //     
     FltMax  : byte;       //     
     Grm1P   : extended;   //     (msec)
                           //    (-1  0)
     // --------------------
     Xb, YB  : integer;    //     
     Compact : boolean;    //    ( L-)
end;

// -------------------------------------------------------------------------
// 03.01.2018
//    
//         
//    SensorGroup01
// (   !)
const DescScope : TDescScope =
(
  ( SType : 'L';
    Title:' 0';
                   Meas:'.';
                   Min:-10;  Max:10;
                   ZoneY : 6; ZoneR : 8;
                   FltMax: 0;
                   Grm1P : 20; // msec
                   // -----------
                   Xb:285; YB:26;
                   Compact:True),
  ( SType : 'L';
    Title:' 1';
                   Meas:'.';
                   Min:-100; Max:100;
                   ZoneY : 60; ZoneR : 80;
                   FltMax: 0;
                   Grm1P : 10; // msec
                   // -----------
                   Xb:310; YB:84;
                   Compact:True),
  ( SType : 'L';
    Title:' 2';
                   Meas:'.';
                   Min:-150; Max:150;
                   ZoneY : 70; ZoneR : 90;
                   FltMax: 0;
                   Grm1P : 20; // msec
                   // -----------
                   Xb:346; YB:142;
                   Compact:True),
  ( SType : 'L';
    Title:' 3';
                   Meas:'.';
                   Min:-150; Max:150;
                   ZoneY : 70; ZoneR : 90;
                   FltMax: 0;
                   Grm1P : 20; // msec
                   // -----------
                   Xb:574; YB:243;
                   Compact:True),
  ( SType : 'L';
    Title:' 4';
                   Meas:'.';
                   Min:-100; Max:100;
                   ZoneY : 60; ZoneR : 80;
                   FltMax: 0;
                   Grm1P : 20; // msec
                   // -----------
                   Xb:613; YB:299;
                   Compact:True),
  ( SType : 'L';
    Title:' 5';
                   Meas:'.';
                   Min:-10;  Max:10;
                   ZoneY : 6; ZoneR : 8;
                   FltMax: 0;
                   Grm1P : 10; // msec
                   // -----------
                   Xb:635; YB:361;
                   Compact:True),
  ( SType : 'R';
    Title:'';
                   Meas:'m/cek';
                   Min:0;  Max:900;
                   ZoneY : 300; ZoneR : 600;
                   FltMax: 0;
                   Grm1P : -1; //   
                   // -----------
                   Xb:50; YB:350;
                   Compact:True),
  ( SType : 'R';
    Title:'';
                   Meas:'m';
                   Min:0;  Max:20000;
                   ZoneY : 15000; ZoneR : 18000;
                   FltMax: 0;
                   Grm1P : -1; // //   
                   // -----------
                   Xb:50; YB:200;
                   Compact:True)
);

// -------------------------------------------------------------------------
//    
//    
// (     !)
const Osc01XB = 510;
      Osc01YB = 115;

// -------------------------------------------------------------------------
//    
// (     !)
const Osc01Width  = 300;                   // 
      Osc01Heigth = 200;                   // 

// =========================================================================
// =========================================================================
//          !!!
//    ,   ,
//    
// =========================================================================
// =========================================================================

// =========================================================================
//        
// =========================================================================
//    
type TScopeArrLR = record
     SType   : char;         //   L- R-
     LScope  : TLineScope;   // Nil    
     RScope  : TRingScope;   // Nil    
end;

//   
var SelectInd : integer;

//      
var ModifyInd : integer;

//      
var ScopeArrLR : array[0..ArrIndMax] of TScopeArrLR;

//      
var  Osc01Rect : TRect;

//  - 
var Osc01     : TOscillograph;

//  -  /  
var ImgLoadSave1 : TLoadSaveImage;   //     Image

// =========================================================================
//        
// =========================================================================
//    DTF   
var SpectrData    : TSpectrData;

//     (DTF)
var DTF03         : TDTF03;

//  
var SpectrScope   : TSpectrScope;

//  -   
var Osc02         : TOscillograph;

//   
var Spectr_Inx    : integer;

//    
var Spectr_MaxAmp : extended;

// =========================================================================
//      (03.01.2018)
// =========================================================================
//     
var FullStamps  :  TTimeStampsMM;

//    
var DFTStamps   :  TTimeStampsMM;


// =========================================================================
//      
// =========================================================================
// -------------------------------------------------------------------------
//     
procedure TUserApp01Form.SetLineScopeParam (RqScope   : TLineScope;
                                            ScopeIndx : integer);
begin
  if not Assigned(RqScope) then Exit;
  if not((ScopeIndx >= Low(DescScope)) and (ScopeIndx <= High(DescScope)))
  then Exit;
  with RqScope
  do begin
    Title := DescScope[ScopeIndx].Title;       //  
    Measure := DescScope[ScopeIndx].Meas;      //  
    Min := DescScope[ScopeIndx].Min;           //  
    Max := DescScope[ScopeIndx].Max;           //  
    Value := Min + (Max - Min) / 2;            //  
    YZone := DescScope[ScopeIndx].ZoneY;       //    
    RZone := DescScope[ScopeIndx].ZoneR;       //    
    XBeg := DescScope[ScopeIndx].Xb;           // X -   
    YBeg := DescScope[ScopeIndx].Yb;           // Y -   
    FiltrMax := DescScope[ScopeIndx].FltMax;   //    
    GLen := 180;                               //   
    Transparent := False;                      //  
    Compact := DescScope[ScopeIndx].Compact;   //  
  end;
end;
// -------------------------------------------------------------------------
//     
procedure TUserApp01Form.SetRingScopeParam (RqScope   : TRingScope;
                                            ScopeIndx : integer);
begin
  if not Assigned(RqScope) then Exit;
  if not((ScopeIndx >= Low(DescScope)) and (ScopeIndx <= High(DescScope)))
  then Exit;
  with RqScope
  do begin
    Title := DescScope[ScopeIndx].Title;       //  
    Measure := DescScope[ScopeIndx].Meas;      //  
    Max := DescScope[ScopeIndx].Max;           //  
    Value := 0;                                //  
    YZone := DescScope[ScopeIndx].ZoneY;       //    
    RZone := DescScope[ScopeIndx].ZoneR;       //    
    FiltrMax := DescScope[ScopeIndx].FltMax;   //    
    Transparent := True;                       // 
  end;
end;
// -------------------------------------------------------------------------
//     
procedure TUserApp01Form.SetSignalOscParam (RqOsc     : TOscillograph;
                                      ScopeIndx : integer);
begin
    if not Assigned(RqOsc) then Exit;
    if not((ScopeIndx >= Low(DescScope)) and (ScopeIndx <= High(DescScope)))
    then Exit;
    //   
    RqOsc.Title := DescScope[ScopeIndx].Title;
    RqOsc.YMes  := DescScope[ScopeIndx].Meas;
    //   
    if Abs(DescScope[ScopeIndx].Max) >= Abs(DescScope[ScopeIndx].Min)
    then RqOsc.YMax := Abs(DescScope[ScopeIndx].Max)
    else RqOsc.YMax := Abs(DescScope[ScopeIndx].Min);
    //      
    RqOsc.Y1Alarm := DescScope[ScopeIndx].ZoneY;
    RqOsc.Y2Alarm := DescScope[ScopeIndx].ZoneR;
    //     110   YMax
    RqOsc.YMax := RqOsc.YMax * 1.1;
    //  
    RqOsc.Clear;
end;
// -------------------------------------------------------------------------
// 03.01.2018
//        
procedure TUserApp01Form.SetGrmlOscParam (RqOsc     : TOscillograph;
                                          ScopeIndx : integer;
                                          GrmIndx   : integer);
begin
    if not Assigned(RqOsc) then Exit;
    if not((ScopeIndx >= Low(DescScope)) and (ScopeIndx <= High(DescScope)))
    then Exit;
    if DescScope[SelectInd].Grm1P > 0
    then begin
       //        
       RqOsc.Title := DescScope[ScopeIndx].Title
                   + ' //      : '
                   + IntToStr(GrmIndx);
       RqOsc.YMes  := DescScope[ScopeIndx].Meas;
       //   
       if Abs(DescScope[ScopeIndx].Max) >= Abs(DescScope[ScopeIndx].Min)
       then RqOsc.YMax := Abs(DescScope[ScopeIndx].Max)
       else RqOsc.YMax := Abs(DescScope[ScopeIndx].Min);
       //      
       RqOsc.Y1Alarm := DescScope[ScopeIndx].ZoneY;
       RqOsc.Y2Alarm := DescScope[ScopeIndx].ZoneR;
       edYMax.Text := FloatToStr(RqOsc.YMax);
       edY1Alarm.Text := FloatToStr(RqOsc.Y1Alarm);  //  
       edY2Alarm.Text := FloatToStr(RqOsc.Y2Alarm);  //  
       //     110   YMax
       RqOsc.YMax := RqOsc.YMax * 1.1;
       //   - 
       TabSpectr.TabVisible := True;
    end
    else begin
        //   
        StTxtDFTTime.Caption := '';
        RqOsc.Title := '';
        RqOsc.YMes  := '';
        RqOsc.YMax := 1.1;
        edYMax.Text := '';
        edY1Alarm.Text := '';
        edY2Alarm.Text := '';
        stxtGrmNum.Caption := '';
        stxtGrmFreq.Caption := '';
        //   - 
        if HidenSpectrTab
        then TabSpectr.TabVisible := False;
    end;
    //  
    RqOsc.Clear;
end;
// =========================================================================
//   /  
// =========================================================================
// -------------------------------------------------------------------------
// 03.01.2018
procedure TUserApp01Form.FormCreate(Sender: TObject);
var Ind : integer;
begin
    // -------------------------------
    //    
    ImgLoadSave1 := TLoadSaveImage.Create(nil,nil);
    ImgLoadSave1.LoadImgFromFile(ApplicationDirectory + ImgFileName,
                                 Image1);
    // -------------------------------
    //    
    cbboxSelectSensor.Clear;
    for Ind := Low(ScopeArrLR) to High(ScopeArrLR)
    do begin
      //    
      cbboxSelectSensor.Items.Add(DescScope[Ind].Title);
      if DescScope[Ind].SType = 'L'
      then begin
         //      Image1
         ScopeArrLR[Ind].LScope := TLineScope.Create(Image1);
         ScopeArrLR[Ind].SType  := 'L';
         ScopeArrLR[Ind].RScope := nil;
         //    
         SetLineScopeParam (ScopeArrLR[Ind].LScope, Ind);
         //   
         ScopeArrLR[Ind].LScope.Visible := True;
      end;
      if DescScope[Ind].SType = 'R'
      then begin
         ScopeArrLR[Ind].RScope := TRingScope.Create(Image1,
                           DescScope[Ind].Xb,
                           DescScope[Ind].YB,
                           110);
         ScopeArrLR[Ind].SType  := 'R';
         ScopeArrLR[Ind].LScope := nil;
         SetRingScopeParam (ScopeArrLR[Ind].RScope, Ind);
      end;
    end;
    //    
    SelectInd := 0;
    //    
    cbboxSelectSensor.ItemIndex := SelectInd;
    //     
    Osc01Rect := Rect(Osc01XB, Osc01YB,
                      Osc01XB + Osc01Width, Osc01YB + Osc01Heigth);
   // ---------------------------------------------
   //     
   // ---------------------------------------------
   with SpectrData
   do begin
      //      
      Sensor_Inx := SelectInd;
      Sensor_Title := DescScope[Sensor_Inx].Title;
      Signal_ArrIdx := -1;
      Signal_MaxPnt := MaxSignal_MaxPnt;
      SetLength(Signal_ArrY, Signal_MaxPnt);
      //       
      PrBarExtracts.Min := 0;
      PrBarExtracts.Max := Signal_MaxPnt;
      PrBarExtracts.Position := PrBarExtracts.Min;
   end;
   //     
   DTF03 := TDTF03.Create;
   //   SpectrScope -  
   if not Assigned(SpectrScope)
   then begin
     SpectrScope := TSpectrScope.Create(PanelSpectr);
     //      
     SpectrScope.DialogLoadSpectrOnOff(False);
     // --------------------
     //    "   "
     //        
     SpectrScope.OnSpectrLoad := SpectrLoad;
     // --------------------
     //    "   Free"
     //       
     SpectrScope.OnSpecrtDestroy := SpecrtDestroy;
     // --------------------
     //    "  "
     //        
     SpectrScope.OnGrmSelect  := ShowSelectGrm;
  end;
  //      
  if not Assigned(Osc02)
  then begin
       Osc02 := TOscillograph.Create(PanelOS2,
                                     Rect(4,4, PanelOS2.Width  - 8,
                                               PanelOS2.Height - 8 ));
       //        
       SetGrmlOscParam (Osc02, SelectInd, 0);
   end;
end;
// -------------------------------------------------------------------------
//      
procedure TUserApp01Form.FormDestroy(Sender: TObject);
var Ind : integer;
begin
  // ---------------------------------------------
  //   
  for Ind := Low(ScopeArrLR) to High(ScopeArrLR)
  do begin
     if Assigned(ScopeArrLR[Ind].LScope)
     then ScopeArrLR[Ind].LScope.Free;
     if Assigned(ScopeArrLR[Ind].RScope)
     then ScopeArrLR[Ind].RScope.Free;
  end;
  //   
  if Assigned(Osc01)
  then begin
     Osc01.Free;
     Osc01 := nil;
  end;
  //   /  
  if Assigned(ImgLoadSave1) then ImgLoadSave1.Free;
  // ---------------------------------------------
  //     
  if Assigned(DTF03)
  then begin
     DTF03.Free;
     DTF03 := nil;
  end;
  //   
  if Assigned(SpectrScope)
   then begin
      SpectrScope.Free;
      SpectrScope := nil;
   end;
   //    
   if Assigned(Osc02)
   then begin
      Osc02.Free;
      Osc02 := nil;
   end;
end;
// =========================================================================
//     
// =========================================================================
// / 
procedure TUserApp01Form.menuHidenShowClick(Sender: TObject);
begin
  if ModifyInd < 0 then Exit;
  if Assigned(ScopeArrLR[ModifyInd].LScope)
  then begin
     with ScopeArrLR[ModifyInd].LScope
     do Visible := not Visible;
     Exit;
  end;
  if Assigned(ScopeArrLR[ModifyInd].RScope)
  then begin
     with ScopeArrLR[ModifyInd].RScope
     do Visible := not Visible;
  end;
end;
// -------------------------------------------------------------------------
//   
procedure TUserApp01Form.menuStyleClick(Sender: TObject);
begin
  if ModifyInd < 0 then Exit;
  if Assigned(ScopeArrLR[ModifyInd].LScope)
  then begin
     with ScopeArrLR[ModifyInd].LScope
     do Compact := not Compact;
    Exit;
  end;
  if Assigned(ScopeArrLR[ModifyInd].RScope)
  then begin
     case ScopeArrLR[ModifyInd].RScope.RingStyle of
       rsARC : ScopeArrLR[ModifyInd].RScope.RingStyle := rsPIE;
       rsPIE : ScopeArrLR[ModifyInd].RScope.RingStyle := rsARC;
     end;
   end;
end;
// -------------------------------------------------------------------------
//  
procedure TUserApp01Form.menuTranparentClick(Sender: TObject);
begin
  if ModifyInd < 0 then Exit;
  if Assigned(ScopeArrLR[ModifyInd].LScope)
  then begin
     with ScopeArrLR[ModifyInd].LScope
     do Transparent := not Transparent;
     Exit;
  end;
  if Assigned(ScopeArrLR[ModifyInd].RScope)
  then begin
     with ScopeArrLR[ModifyInd].RScope
     do Transparent := not Transparent;
  end;
end;

// -------------------------------------------------------------------------
// 03.01.2018
//  
procedure TUserApp01Form.SelectSensor(Indx : integer);
begin
   if  (Indx >= Low(ScopeArrLR)) and (Indx <= High(ScopeArrLR))
   then begin
      SelectInd := Indx;
      cbboxSelectSensor.ItemIndex := SelectInd;
      // ---------------------
      //       
      SetSignalOscParam (Osc01, SelectInd);
      // ---------------------
      PrBarExtracts.Position := 0;
      if Assigned(SpectrScope)
      then begin
        //  
        SpectrData.Sensor_Inx := SelectInd;
        SpectrData.Signal_ArrIdx := -1;
        SpectrData.Sensor_Title := DescScope[SelectInd].Title;
        SpectrScope.ClearShow();
        if Assigned(Osc02)
        then //        
             SetGrmlOscParam (Osc02, SelectInd, Spectr_Inx);
      end;
   end;
end;
// -------------------------------------------------------------------------
//    RqX,RqY  RqRect
function IsXYInRect(const RqRect : TRect; RqX, RqY : integer): boolean;
begin
  Result := (RqX >= RqRect.Left) and (RqX <= RqRect.Right) and
            (RqY >= RqRect.Top)  and (RqY <= RqRect.Bottom);
end;
// -------------------------------------------------------------------------
//    Img    
function TUserApp01Form.ImgPointToFormPoint(X,Y : integer): TPoint;
begin
    Result.X := X + PageControl1.Left + TabSopes.Left + Image1.Left;
    Result.Y := Y + PageControl1.Top  + TabSopes.Top  + Image1.Top;
end;
// -------------------------------------------------------------------------
//       Img
function TUserApp01Form.ClickIndByImgXY(X,Y : integer): integer;
var Ind : integer;
begin
   Result := -1;
   for Ind := Low(ScopeArrLR) to High(ScopeArrLR)
   do begin
      if Assigned(ScopeArrLR[Ind].LScope)
      then begin
          if IsXYInRect(ScopeArrLR[Ind].LScope.ScopeRect, X, Y)
          then begin
             Result :=Ind;
             Exit;
          end;
      end;
      if Assigned(ScopeArrLR[Ind].RScope)
        then begin
          if IsXYInRect(ScopeArrLR[Ind].RScope.ScopeRect, X, Y)
          then begin
             Result :=Ind;
             Exit;
          end;
      end;
   end;
end;
// -------------------------------------------------------------------------
//      Image
procedure TUserApp01Form.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var Ind    : integer;
    wPoint : TPoint;
begin
  // --------------------
  //  MouseDown
  StaticText3.Caption := ' ' + IntToStr(X);
  StaticText4.Caption := ' ' + IntToStr(Y);
  // --------------------
  //  PopupMenu
  PopupMenuLR.AutoPopup := False;
  if (Button = mbRight)
  then begin
      ModifyInd := ClickIndByImgXY(X,Y);
      if ModifyInd >= 0
      then begin
         //   
         if Assigned(ScopeArrLR[ModifyInd].LScope)
         then begin
            if IsXYInRect(ScopeArrLR[ModifyInd].LScope.ScopeRect, X, Y)
            then begin
               PopupMenuLR.AutoPopup := True;
               Exit;
            end;
         end;
         if Assigned(ScopeArrLR[ModifyInd].RScope)
         then begin
            if IsXYInRect(ScopeArrLR[ModifyInd].RScope.ScopeRect, X, Y)
            then begin
               PopupMenuLR.AutoPopup := True;
               Exit;
            end;
         end;
      end;
  end;
  // --------------------
  //  
  if (Shift * [ssAlt] = []) and (Button = mbLeft)
  then begin
     for Ind := Low(ScopeArrLR) to High(ScopeArrLR)
     do begin
        if Assigned(ScopeArrLR[Ind].LScope)
        then begin
          if IsXYInRect(ScopeArrLR[Ind].LScope.ScopeRect, X, Y)
          then begin
             SelectSensor(Ind);
             Exit;
          end;
        end;
        if Assigned(ScopeArrLR[Ind].RScope)
        then begin
          if IsXYInRect(ScopeArrLR[Ind].RScope.ScopeRect, X, Y)
          then begin
             SelectSensor(Ind);
             Exit;
          end;
        end;
     end;
  end;
  // --------------------
  //     
  if (Shift * [ssAlt] <> [])  and (Button = mbLeft) and Assigned(Osc01)
  then begin
      //   
      Osc01.Free;
      wPoint := ImgPointToFormPoint(X,Y);
      //    
      Osc01Rect := Rect( wPoint.X, wPoint.Y,
                         wPoint.X + Osc01Width,
                         wPoint.Y  + Osc01Heigth
                        );
      //      
      Osc01 := TOscillograph.Create(UserApp01Form, Osc01Rect);
      //       
      SetSignalOscParam (Osc01, SelectInd);
  end;
end;
// -------------------------------------------------------------------------
//    ComboBox
procedure TUserApp01Form.cbboxSelectSensorClick(Sender: TObject);
begin
   if cbboxSelectSensor.ItemIndex <> SelectInd
   then SelectSensor(cbboxSelectSensor.ItemIndex);
end;
// -------------------------------------------------------------------------
// /  
procedure TUserApp01Form.rdgrpOscilographClick(Sender: TObject);
const XB = 530;
      YB = 160;
begin
   case rdgrpOscilograph.ItemIndex of
   0 : begin
          //       
          Osc01 := TOscillograph.Create(UserApp01Form, Osc01Rect);
          //        
          SetSignalOscParam (Osc01, SelectInd);
       end;
   1 : begin
          if Assigned(Osc01)
          then begin
             Osc01.Free;
             Osc01 := nil;
          end;
       end;
   end;
end;

// =========================================================================
//  /       
// =========================================================================
// 03.01.2018
//      
procedure TUserApp01Form.ShowSensors();
var Ind : integer;
begin
   // ----------------------------
   //    
   StTxtFullTime.Caption := StartMMTimeStamp (FullStamps);
   // ----------------------------
   //   
   for Ind := Low(ScopeArrLR) to High(ScopeArrLR)
   do begin
      if Assigned(ScopeArrLR[Ind].LScope)
      then begin
        ScopeArrLR[Ind].LScope.Value := REC1.Arr[Ind];
      end;
      if Assigned(ScopeArrLR[Ind].RScope)
      then begin
        ScopeArrLR[Ind].RScope.Value := REC1.Arr[Ind];
      end;
   end;
   // ----------------------------
   //     
   if Assigned(Osc01)
   then begin
     Osc01.AddNewData(REC1.Arr[SelectInd]);
     Osc01.ShowBeam;
   end;
   // ----------------------------
   //   
   if DescScope[SelectInd].Grm1P > 0
   then begin
      // ----------------------------
      //        
      //      
      AddSignalPoint(REC1.Arr[SelectInd], SpectrData);
   end;
   // ----------------------------
   //       
   StTxtFullTime.Caption := StopMMTimeStamp (FullStamps);
   // ----------------------------
end;

// ====================================================================
//     TSpectrScope  
// ====================================================================
// --------------------------------------------------------------------
//   "   "
procedure  TUserApp01Form.SpectrLoad(Sender : TObject; ArrGrm : TArrSpectr);
begin
//     
end;
// --------------------------------------------------------------------
//   "   Free"
procedure TUserApp01Form.SpecrtDestroy(Sender : TObject);
begin
//     
end;
// --------------------------------------------------------------------
// 03.01.2018
//   "  "
procedure TUserApp01Form.ShowSelectGrm (Sender: TObject;
                                Num : integer; ArrGrm : TArrSpectr);
var wFreq : extended;
begin
   if Spectr_Inx <> Num
   then begin
      Spectr_Inx := Num;
      if Assigned(Osc02)
      then begin
        //        
       SetGrmlOscParam (Osc02, SelectInd, Spectr_Inx);
       end;
       //     
       stxtGrmFreq.Caption := '';
       stxtGrmNum.Caption := IntToStr(Num);
       if DescScope[SelectInd].Grm1P > 0
       then begin
         try
            //   ( msec)   (Hz)
            wFreq := (1/DescScope[SelectInd].Grm1P) * 1000 *  Num;
            stxtGrmFreq.Caption := FloatToStr(wFreq) + ' Hz';
         except
            stxtGrmFreq.Caption := '';
         end;
       end;
   end;
end;
// --------------------------------------------------------------------
// 03.01.2018
//          
procedure TUserApp01Form.AddSignalPoint(RqVal : extended;
                                    var RqSpectrData : TSpectrData);
begin
  with SpectrData
  do begin
    Inc(Signal_ArrIdx);
    if Signal_ArrIdx > High(Signal_ArrY)
    then begin
       if Assigned(DTF03)
       then begin
          // ----------------------------
          //    
          StTxtDFTTime.Caption := StartMMTimeStamp (DFTStamps);
          // ----------------------------
          //  
          DTF03.CodMet := 0;             //   
          DTF03.RqDegree := False;       //    
          DTF03.XB := 0;                 //    
          if DescScope[SelectInd].Grm1P > 0
          then DTF03.XE := DescScope[SelectInd].Grm1P
          else DTF03.XE := 1;            //     ( msec)
          DTF03.RunDTF03(Signal_ArrY);   //   
          // ----------------------------
          //       
          StTxtDFTTime.Caption := StopMMTimeStamp (DFTStamps);
          // ----------------------------
          //  
          if Assigned (SpectrScope)
          then begin
              ShowSpectrScope(RqSpectrData);
              SpectrScope.SelectNum := Spectr_Inx;
              if Assigned(Osc02)
              then begin
                  Osc02.AddNewData(DTF03.Cn[Spectr_Inx]);
                  Osc02.ShowBeam;
              end;
          end;
       end;
       Signal_ArrIdx := -1;               //  
    end
    else begin
      //     
      Signal_ArrY[Signal_ArrIdx] := RqVal;
    end;
    //   
    PrBarExtracts.Position := Signal_ArrIdx;
  end; // with
end;
// --------------------------------------------------------------------
//         
procedure TUserApp01Form.ShowSpectrScope(var RqSpectrData : TSpectrData);
var Ind : integer;
begin
   //  
   if not Assigned(DTF03) then Exit;
   if not Assigned(SpectrScope) then Exit;
   //       
   if DTF03.MaxIndGgm < 0 then Exit;
   Spectr_MaxAmp := 0;
   SetLength(RqSpectrData.Spectr_Arr, DTF03.MaxIndGgm + 1);
   for Ind := 0 to DTF03.MaxIndGgm
   do begin
      //    SpectrScope
      RqSpectrData.Spectr_Arr[Ind].Amp := DTF03.Cn[Ind];
      RqSpectrData.Spectr_Arr[Ind].Phs := DTF03.Pn[Ind];
   end;
   //      
   SpectrScope.ArrSpectr := RqSpectrData.Spectr_Arr;
   //    
   SpectrScope.Show;
end;
// --------------------------------------------------------------------
//       
procedure TUserApp01Form.spbuttAplyAmpClick(Sender: TObject);
var wExt : extended;
begin
  if Assigned(Osc02)
  then begin
      if TryStrToFloat(edYMax.Text,wExt)
      then begin
         Osc02.YMax  := wExt;
         Osc02.GridY := wExt/5;
      end;
      if TryStrToFloat(edY1Alarm.Text,wExt)
      then Osc02.Y1Alarm := wExt;
      if TryStrToFloat(edY2Alarm.Text,wExt)
      then Osc02.Y2Alarm := wExt;
      Osc02.ShowBeam();
   end;
end;
// --------------------------------------------------------------------
//         Y
function YFormatString(RqVal : extended): string;
begin
   Result := '%5.5f';
   if (RqVal > 10000)
   then begin Result := '%5.0f'; Exit; end;
   if (RqVal >= 1000)
   then begin Result := '%5.1f'; Exit; end;
   if (RqVal >= 100)
   then begin Result := '%5.2f'; Exit; end;
   if (RqVal >= 10)
   then begin Result := '%5.3f'; Exit; end;
   if (RqVal >= 1)
   then begin Result := '%5.4f'; Exit; end;
   if (RqVal >= 0.1)
   then begin Result := '%5.5f'; Exit; end;
end;
// --------------------------------------------------------------------
//   Y -     
procedure TUserApp01Form.spbuttOptimalScaleClick(Sender: TObject);
const Eps = 1e-6;
var   wExt    : extended;
      wFrmStr : string;
begin
   if not Assigned(Osc02) then Exit;
   if not Assigned(DTF03) then Exit;
   //     
   wExt := DTF03.MaxAmpGrm;
   if wExt > Eps
   then begin
      Osc02.YMax  := wExt;
      Osc02.GridY := wExt/5;
      try
        Osc02.Y1Alarm := wExt * DescScope[SelectInd].ZoneY
                              / DescScope[SelectInd].Max;
        Osc02.Y2Alarm := wExt * DescScope[SelectInd].ZoneR
                              / DescScope[SelectInd].Max;
      except
        Osc02.Y1Alarm := wExt;
        Osc02.Y2Alarm := wExt;
      end;
      wFrmStr := YFormatString(wExt);
      edYMax.Text := Format(wFrmStr, [wExt]);
      wFrmStr := YFormatString(Osc02.Y1Alarm);
      edY1Alarm.Text := Format(wFrmStr, [Osc02.Y1Alarm]);  //  
      wFrmStr := YFormatString(Osc02.Y2Alarm);
      edY2Alarm.Text := Format(wFrmStr, [Osc02.Y2Alarm]);  //  
      Osc02.YMax  := wExt * 1.1;
      Osc02.ShowBeam();
   end;
end;
// --------------------------------------------------------------------
//    
procedure TUserApp01Form.spbuttClearHistoryClick(Sender: TObject);
begin
  if Assigned(Osc02) then Osc02.Clear;
end;
// =========================================================================
//  
// =========================================================================

end.
