unit RingScope01;
// ====================================================================
(*
        
      .   
          
   TImage.
   // -----------------------------------------------------
   //     :
   //    Title          
   //    Measure        
   //    Max            
   //     :
   //    Value          
   //    YZone            
   //    RZone            
   //    FiltrMax         
   //    Transparent    
   // -----------------------------------------------------
   //   :
   // XBeg   X -   Image
   // YBeg   Y -   Image
   // Size        
   Scope := TLineScope.Create(Image1, XBeg, YBeg, Size);
   // -----------------------------------------------------
   //     :
   if Assigned(Scope)
   then Scope.Value := ........;    //  
   // :  FiltrMax  = 0,    
   //             .  FiltrMax >= 2,   
   //                 (FiltrMax)   
   //              .
   // -----------------------------------------------------
    1.01. ()  , , , , 2017.
                () Source code  ..
     29.12.2017
*)
// ====================================================================

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls,
  Math;

// =========================================================================
//   TRingScope
// =========================================================================
//   -   
type TOnOutRangeR = procedure(Sender : TObject; Value : extended) of object;

// rsARC -    , rsPIE -  
type TRingStyle = (rsARC, rsPIE);

type TRingScope = class(Tobject)
private
    // ------------
    fImg           : TImage;       //  Image
    // ------------
    fXBeg          : integer;      // X -    Image
    fYBeg          : integer;      // Y -    Image
    fScSize        : integer;      //    
    fScopeW        : integer;      //   
    fScopeH        : integer;      //   
    // ------------
    fScopeRect     : TRect;        //    
    fBmpSave       : TBitMap;      // BitMap   
    // ------------
    fX0            : integer;      // X-   
    fY0            : integer;      // Y-   
    fBMP           : TBitMap;      // BitMap   
    // ------------
    fRadiusOUT     : integer;      //   
    fRadiusMarks   : integer;      //   
    fRadiusARC     : integer;      //  ARC 
    fRadiusPIE     : integer;      //  PIE 
    fRadiusIN      : integer;      //   
    // ------------
    fTitle         : string;       //  
    fMeasure       : string;       //  
    fMax           : extended;     //   
    fYZone    : extended;     //    
    fRZone       : extended;     //    
    // ------------
    //    fFiltrMax > 0
    fFiltrMax      : integer;      //    
    fFiltrNum      : integer;      //     
    fFiltrVal      : extended;     //    
    // ------------
    fValue         : extended;     //  
    fOnOutRange    : TOnOutRangeR; //  -   
    // ------------
    fRingStyle     : TRingStyle;   //   
    fTransparent   : boolean;      //  
    fVisible       : boolean;      //  
    // ------------
    fclValue       : Tcolor;       //   
    fclGzone       : Tcolor;       //    
    fclYzone       : Tcolor;       //    
    fclRzone       : Tcolor;       //    

    // ---------------
    //    
    procedure SaveBkGround();
    //    
    procedure RestoreBkGround();
    //        RqValue  RqColor
    procedure BmpZoneShow(RqValue : extended; RqColor : TColor);
    //      
    procedure BmpRingClear();
    //     
    procedure BmpShowMarks();
    //   
    procedure BmpShowRing(RqValue : extended);
    //   
    procedure ShowScope();
    // ---------------
    //  
    procedure SetVisible(RqVisible : boolean);
    //    
    procedure SetStyle(RqStyle : TRingStyle);
    //   
    procedure SetTransparent(RqTransparent : boolean);
    // ---------------
    //   
    procedure SetTitle(RqTitle : string);
    //     
    procedure SetMeasure(RqMeasure : string);
    //    
    procedure SetMax(RqMax : extended);
    //     
    procedure SetZoneYellow(RqZoneYellow : extended);
    //     
    procedure SetZoneRed(RqZoneRed : extended);
    //   
    procedure SetValue(RqValue : extended);

public
    constructor Create(
          RqImg : TImage;   //    Image
          RqXB, RqYB, RqScSize : integer);
    procedure Free();
    // ---------------
    //     fImg
    property SopeArea : TRect read fScopeRect;
    //  
    property Visible : boolean read fVisible write SetVisible;
    //   
    property RingStyle : TRingStyle read fRingStyle write SetStyle;
    //   
    property Transparent : boolean read fTransparent write SetTransparent;
    // ---------------
    //    fImg
    property ScopeRect : TRect  read fScopeRect;
    //  
    property Title : string read fTitle   write SetTitle;
    //    
    property Measure : string read fMeasure write SetMeasure;
    //    
    property Max   : extended read fMax   write SetMax;
    //    
    property YZone : extended read fYZone write SetZoneYellow;
    //    
    property RZone : extended read fRZone write SetZoneRed;
    //  -   
    property OnOutRange : TOnOutRangeR read fOnOutRange write fOnOutRange;
    //     
    property FiltrMax : integer read fFiltrMax write fFiltrMax;
    //  
    property Value : extended read fValue write SetValue;
    // ---------------
    //   
    property clValue : Tcolor read fclValue write fclValue;
    //    
    property clGzone : Tcolor read fclGzone write fclGzone;
    //    
    property clYzone : Tcolor read fclYzone write fclYzone;
    //    
    property clRzone : Tcolor read fclRzone write fclRzone;
end;

// =========================================================================
// =========================================================================

implementation

// =========================================================================
//  TRingScope.  
// =========================================================================
const RingMinSize = 110;  //    
      RingUse     = 80;   //     
      RingWidth   = 20;   //     
// ================================================================
//    TRingScope.  / 
// ================================================================
// ----------------------------------------------------------------
constructor TRingScope.Create(
            RqImg : TImage;   //    Image
            RqXB, RqYB, RqScSize : integer);
begin
   inherited Create;
   // ----------------------------------------------
   //   Image
   fImg      := RqImg;
   fXBeg     := RqXB;
   fYBeg     := RqYB;
   if RqScSize >= RingMinSize
   then fScSize := RqScSize
   else fScSize := RingMinSize;
   fScopeW   := fScSize;
   fScopeH   := fScSize;
   fScopeRect := Rect(fXBeg, fYBeg, fXBeg + fScSize, fYBeg + fScSize);
   fBmpSave := TBitMap.Create;
   fBmpSave.PixelFormat := pf24bit;
   fBmpSave.Width  := fScSize;
   fBmpSave.Height := fScSize;
   //    
   SaveBkGround();
   // ----------------------------------------------
   fX0  := fScSize div 2;
   fY0  := fScSize div 2;
   // ----------------------------------------------
   //  BitMap   
   fBMP := TBitMap.Create;
   fBmp.PixelFormat := pf24bit;
   fBmp.Width  := fScSize;
   fBmp.Height := fScSize;
   // ----------------------------------------------
   //     
   fRadiusOUT   := (fScSize div 2);
   fRadiusMarks := fRadiusOUT - (RingWidth div 3);
   fRadiusARC   := fRadiusOUT - 2 * (RingWidth div 3);
   fRadiusIN    := fRadiusOUT -RingWidth;
   fRadiusPIE   := fRadiusIN;
   // ----------------------------------------------
   fRingStyle   := rsARC;           //  
   fTransparent := True;            //  
   // ----------------------------------------------
   fTitle      := '';       //  
   fMeasure    := './.';       //  
   fValue      := 0;
   fMax        := 1000;
   fRZone    := 0.8 * fMax;       //    
   fYZone := 0.6 * fMax;       //    

   // ----------------------------------------------
   fclValue := clGreen;             //   
   fclGzone := RGB(180,255,180);    //    
   fclYzone := RGB(255,255,180);    //    
   fclRzone := RGB(255,180,180);    //    
   // ----------------------------------------------
   fVisible := False;
   //  
   SetVisible(True);
end;
// ----------------------------------------------------------------
procedure TRingScope.Free();
begin
    // ---------------
    //  
    SetVisible(False);
    // ---------------
    fBMP.Free;
    fBmpSave.Free;
    // ---------------
    inherited Free;
end;
// ================================================================
//   TRingScope.   .
// ================================================================
// ----------------------------------------------------------------
//    
procedure TRingScope.SaveBkGround();
var wRect : TRect;
begin
   if not Assigned(fBmpSave) then Exit;
   //  Rect 
   wRect := Rect(0,0, fBmpSave.Width, fBmpSave.Height);
   //  
   fBmpSave.Canvas.CopyRect(wRect, fImg.Canvas, fScopeRect);
end;
// ----------------------------------------------------------------
//    
procedure TRingScope.RestoreBkGround();
var wRect : TRect;
begin
   if not Assigned(fBmpSave) then Exit;
   //  Rect 
   wRect := Rect(0,0, fBmpSave.Width, fBmpSave.Height);
   //  
   fImg.Canvas.CopyRect(fScopeRect, fBmpSave.Canvas, wRect);
end;
// ----------------------------------------------------------------
//  
procedure TRingScope.SetVisible(RqVisible : boolean);
begin
    if not Assigned(fBMP) then Exit;
    // ----------------------
    //  
    if (RqVisible = True) and (fVisible = False)
    then begin
       //    
       SaveBkGround();
       fVisible := True;
       //   
       ShowScope();
    end;
    // ----------------------
    //  
    if (RqVisible = False) and (fVisible = True)
    then begin
       //    
       RestoreBkGround();
       fVisible := False;
    end;
end;
// ----------------------------------------------------------------
//        RqValue  RqColor
procedure TRingScope.BmpZoneShow(RqValue : extended; RqColor : TColor);
const TwoPi  = 2 * Pi;            // 2Pi
      RScale = 2 - RingUse/100;   //    
var   wRadius    : integer;       //    
      wAngle2    : extended;      //  
      wSin, wCos : extended;      //  
      wPn1, wPn2 : Tpoint;        //    
begin
     if RqValue = 0 then Exit;
     //    
     wRadius := fRadiusOUT - (RingWidth div 2);
     //     
     wPn1.X := wRadius;
     wPn1.Y := 0;
     //     
     wAngle2 := TwoPi * RqValue / (RScale * fMax);
     SinCos(wAngle2, wSin, wCos);
     wPn2.X := Round(wRadius * wCos);
     wPn2.Y := Round(wRadius * wSin);
     // 
     with fBMP.Canvas
     do begin
        Pen.Width   := RingWidth;
        Pen.Color   := RqColor;
        Brush.Color := Pen.Color;
        Brush.Style := bsClear;
        // 
        Arc   (fX0 - wRadius, fY0 - wRadius,
               fX0 + wRadius, fY0 + wRadius,
               fX0 + wPn1.X, fY0 - wPn1.Y,
               fX0 + wPn2.X, fY0 - wPn2.Y);
     end;
end;
// ----------------------------------------------------------------
//      
procedure TRingScope.BmpRingClear();
begin
    with fBMP.Canvas
    do begin
       //   
       if fRingStyle = rsARC
       then begin
          //     
          if fRZone > 0
          then begin
              //    
              BmpZoneShow(fMax, fclRzone);
              if (fYZone > 0) and (fRZone > fYZone)
              then begin
                 //   
                 BmpZoneShow(fRZone, fclYzone);
                 //    
                 BmpZoneShow(fYZone, fclGzone);
              end
              //   
             else BmpZoneShow(fRZone, fclGzone);
          end
          //   
          else BmpZoneShow(fMax, fclGzone);
       end;
       //   
       if fRingStyle = rsPIE
       then begin
          BmpZoneShow(fMax, RGB(200,255,255));
       end;

       //      
       Pen.Width   := 1;
       Pen.Color   := clBlack;
       Brush.Color := clWhite;
       if fTransparent
       then Brush.Style := bsClear
       else Brush.Style := bsSolid;
       Ellipse(RingWidth,
               RingWidth,
               fScSize - RingWidth,
               fScSize - RingWidth);
    end;
end;
// ----------------------------------------------------------------
//     
procedure TRingScope.BmpShowMarks();
const GdRd   = Pi/180;
      RScale = 2 - RingUse/100;   //    
var   wStep      : extended;      //     
      wValue     : extended;      //     
      Ind        : integer;       //  
      wAngle     : extended;      //    
      wSin, wCos : extended;      //   
      wPn1       : Tpoint;        //    
begin
    with fBMP.Canvas
    do begin
       Pen.Width := 1;
       Pen.Color := clBlack;
       Font.Color := clBlack;
       Pen.Width := 1;
       Brush.Style := bsSolid;
    end;
    wStep := (RScale * fMax) / 360;
    wValue := 0;
    //  
    Ind    := 0;
    repeat
       wAngle := Ind * GdRd;
       SinCos(wAngle, wSin, wCos);
       wPn1.X := Round((fRadiusMarks) * wCos);
       wPn1.Y := Round((fRadiusMarks) * wSin);
       with fBMP.Canvas
       do begin
          if (Ind mod 10) = 0
          then begin
              Pen.Width := 2;
              //  
              Rectangle(fX0 + wPn1.X - 1, fY0 - (wPn1.Y - 1),
                        fX0 + wPn1.X + 1, fY0 - (wPn1.Y + 1));
          end;
       end;
       Ind := Ind + 1;
       wValue := wValue + wStep;
    until ((Ind >= 360) or (wValue > fMax));
end;
// ----------------------------------------------------------------
//   
procedure TRingScope.BmpShowRing(RqValue : extended);
const TwoPi  = 2 * Pi;            // 2Pi
      RScale = 2 - RingUse/100;   //    
var   wAngle1    : extended;
      wAngle2    : extended;
      wRadius    : integer;
      wColor     : TColor;
      wSin, wCos : extended;
      wPn1, wPn2 : Tpoint;
begin

     //   
     if fValue > 0
     then begin
        wAngle1 := 0;
        wAngle2 := TwoPi * fValue / (RScale * fMax);
        //     
        SinCos(wAngle1, wSin, wCos);
        wPn1.X := Round(fRadiusARC * wCos);
        wPn1.Y := Round(fRadiusARC * wSin);
        //     
        SinCos(wAngle2, wSin, wCos);
        wPn2.X := Round(fRadiusARC * wCos);
        wPn2.Y := Round(fRadiusARC * wSin);
        with fBMP.Canvas
        do begin
           //   
           if fRingStyle = rsARC
           then begin
              Pen.Width   := 3;
              Pen.Color   := fclValue;
              wRadius  := fRadiusARC;
              Brush.Style := bsClear;
              //    
              Arc   (fX0 - wRadius, fY0 - wRadius,
                     fX0 + wRadius, fY0 + wRadius,
                     fX0 + wPn1.X, fY0 - wPn1.Y,
                    fX0 + wPn2.X, fY0 - wPn2.Y);
           end;
           //   
           if fRingStyle = rsPIE
           then begin
              //     
              wColor := fclGzone;
              if RqValue >= fYZone then wColor := fclYzone;
              if RqValue >= fRZone    then wColor := fclRzone;
              //  
              Pen.Width   := 1;
              Pen.Color   := fclValue;
              wRadius  := fRadiusPIE;
              Brush.Color := wColor;
              Brush.Style := bsSolid;
              //    
              Pie   (fX0 - wRadius, fY0 - wRadius,
                     fX0 + wRadius, fY0 + wRadius,
                     fX0 + wPn1.X, fY0 - wPn1.Y,
                     fX0 + wPn2.X, fY0 - wPn2.Y);
              //    
              Pen.Width   := 2;
              Pen.Color   := clBlue;
              MoveTo (fX0, fY0);
              LineTo (fX0 + wPn2.X, fY0 - wPn2.Y);
           end;
        end;
     end;

     with fBMP.Canvas
     do begin
        Brush.Style := bsClear;
        //     
        Font.Color  := clBlack;
        Font.Style  := [];
        TextOut(fX0 - 24, fY0 - 20, fTitle);      //  
        Font.Style  := [fsBold];
        TextOut(fX0 - 24, fY0 - 5,  FloatToStr(fValue));
        TextOut(fX0 - 24, fY0 + 8,  fMeasure);    //  
        Font.Style  := [];

        //   
       Pen.Width   := 1;
       Pen.Color   := clBlack;
       Brush.Style := bsClear;
       //  
       Ellipse(0, 0, fScSize, fScSize);
       //  
       Ellipse(RingWidth,
               RingWidth,
               fScSize - RingWidth,
               fScSize - RingWidth);
     end;
end;
// ----------------------------------------------------------------
//   
procedure TRingScope.ShowScope();
var wRect : TRect;
begin
    if (not Assigned(fBmpSave)) or (not Assigned(fBmp)) then Exit;
    //     
    fBmp.Assign(fBmpSave);
    //     
    BmpRingClear();
    //     
    BmpShowMarks();
    //   
    BmpShowRing(fValue);
    if fVisible
    then begin
      //  Rect 
     wRect := Rect(0,0, fBMP.Width, fBMP.Height);
     //     fImg
     fImg.Canvas.CopyRect(fScopeRect, fBmp.Canvas, wRect);
    end;
end;
// ================================================================
//   TRingScope.  PROPERTY  .
// ================================================================
// ----------------------------------------------------------------
//    
procedure TRingScope.SetTitle(RqTitle : string);
begin
   if Length(RqTitle) > 8
   then fTitle := copy(RqTitle, 1, 8)
   else fTitle := RqTitle;
   ShowScope();
end;
// ----------------------------------------------------------------
//     
procedure TRingScope.SetMeasure(RqMeasure : string);
begin
   if Length(RqMeasure) > 8
   then fMeasure := copy(RqMeasure, 1, 8)
   else fMeasure := RqMeasure;
   ShowScope();
end;
// ----------------------------------------------------------------
//    
procedure TRingScope.SetStyle(RqStyle : TRingStyle);
begin
   fRingStyle := RqStyle;
   ShowScope();
end;
// ----------------------------------------------------------------
//   
procedure TRingScope.SetTransparent(RqTransparent : boolean);
begin
  fTransparent := RqTransparent;
  ShowScope();
end;
// ----------------------------------------------------------------
//    
procedure TRingScope.SetValue(RqValue : extended);
begin
  if (RqValue >= 0) and (RqValue <= fMax)
  then  begin
     if fFiltrMax > 1
     then begin
        //   
        //    fFiltrMax
        fFiltrVal := fFiltrVal + RqValue;    //  
        fFiltrNum := fFiltrNum + 1;          //  
        if fFiltrNum >= fFiltrMax
        then begin
           fValue := fFiltrVal / fFiltrMax;  //   
           fFiltrNum := 0;                   //   
           fFiltrVal := 0;                   //  
           if fVisible then ShowScope();     //  
        end;
     end
     else begin
        //    
        fValue := RqValue;                   //  
        if fVisible then ShowScope();        //  
     end;
  end;
  if Assigned(fOnOutRange)
  then begin
     if (RqValue >= fMax) or (RqValue < 0) or
        ((fYZone > 0) and (RqValue >= fYZone)) or
        ((fRZone    > 0) and (RqValue >= fRZone))
     then fOnOutRange(Self, RqValue);
  end;
end;
// ----------------------------------------------------------------
//     
procedure TRingScope.SetMax(RqMax : extended);
begin
   if (RqMax > 0)
   then  begin
      fMax := RqMax;
      ShowScope();
   end;
end;
// ----------------------------------------------------------------
//      
procedure TRingScope.SetZoneYellow(RqZoneYellow : extended);
begin
   if (RqZoneYellow > 0) and (RqZoneYellow < fMax)
   then  begin
      fYZone := RqZoneYellow;
      ShowScope();
   end;
end;
// ----------------------------------------------------------------
//      
procedure TRingScope.SetZoneRed(RqZoneRed : extended);
begin
   if (RqZoneRed > 0) and (RqZoneRed < fMax)
   then  begin
      fRZone := RqZoneRed;
      ShowScope();
   end;
end;

// ================================================================
//   TRingScope. 
// ================================================================

end.
