unit LineScope01;
// ====================================================================
(*
        
      .   
          
   TImage.
   // -----------------------------------------------------
   //     :
   //    XBeg          X -   Image
   //    YBeg          Y -   Image
   //    Title          
   //    Measure        
   //    Min            
   //    Max            
   //     :
   //    Value          
   //    YZone            
   //    RZone            
   //    FiltrMax         
   //    GLen              
   //    Transparent   
   //    Compact        
   // -----------------------------------------------------
   //   :
   Scope := TLineScope.Create(Image1);
   // -----------------------------------------------------
   //     :
   if Assigned(Scope)
   then Scope.Value := ........;    //  
   // :  FiltrMax  = 0,    
   //             .  FiltrMax >= 2,   
   //                 (FiltrMax)   
   //              .
   // -----------------------------------------------------
    1.01. ()  , , , , 2017.
                () Source code  ..
     29.12.2017
*)
// ====================================================================

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, ExtCtrls, StdCtrls;

type TLineScope = class(TObject)
private
  // ------------------------
  fImg         : TImage;    //  Image
  // ------------------------
  //   
  fXBeg        : integer;   // X -  
  fYBeg        : integer;   // Y -  
  fScopeRect   : TRect;     //   
  fBmpSave     : TBitMap;   //    
  fBmp         : TBitMap;   //   
  // ------------------------
  fCompact     : boolean;   //  
  fTransparent : boolean;   //     
  // ------------------------
  //    
  fCGW         : integer;   //   
  fCGH         : integer;   //   
  // ------------------------
  //    
  fIRect       : TRect;     //   
  fVRect       : TRect;     //   
  fGRect       : TRect;     //   
  fTRect       : TRect;     //   
  fFRect       : TRect;     //   
  fTitle       : string;    //  
  // ------------------------
  //    fFiltrMax > 0
  fFiltrMax    : integer;   //    
  fFiltrNum    : integer;   //     
  fFiltrVal    : extended;  //    
  // ------------------------
  //   
  fMeasure     : string;    //  
  fMin         : extended;  //   
  fMax         : extended;  //   
  fScale       : extended;  // 
  fYZone       : extended;  //    
  fRZone       : extended;  //    
  fValue       : extended;  //  
  //  
  fVisible     : boolean;   //  
  // ------------------------
  //     
  procedure CalcSRect();
  // ------------------------
  //     fImg
  procedure SetXBeg(XBeg : integer);
  procedure SetYBeg(YBeg : integer);
  procedure SetTitle (Title : string);
  // ------------------------
  //    
  procedure CalcScale();
  //      
  function  GetGW(Value : extended) : integer;
  // ------------------------
  //     fImg
  procedure RestoreBkGround();
  procedure SaveBkGround();
  function  TestBkGround() : boolean;
  procedure SetVisible(Visible : boolean);
  procedure SetCompact(Compact : boolean);
  procedure SetTransparent(Transparent : boolean);
  // ------------------------
  //   
  procedure SetMeasure(Measure : string);
  procedure SetMin   (Min  : extended);
  procedure SetMax   (Max  : extended);
  procedure SetCGW   (GLen : integer);
  // ------------------------
  //      
  procedure SetYZone (YZone : extended);
  procedure SetRZone (RZone : extended);
  // ------------------------
  //     
  procedure SetValue (Value : extended);
  // ------------------------
  //  
  procedure DrawScope();

public
  // ------------------------
  //  / 
  constructor  Create(RqImage : TImage);
  procedure Free();
  // ------------------------
  //    fImg
  property ScopeRect : TRect  read fScopeRect;
  // ------------------------
  //  
  property Visible : boolean read fVisible write SetVisible;
  property Compact : boolean read fCompact write SetCompact;
  property Transparent : boolean read fTransparent write SetTransparent;

  property XBeg  : integer  read fXBeg  write SetXBeg;
  property YBeg  : integer  read fYBeg  write SetYBeg;
  property Title : string   read fTitle write SetTitle;
  // ------------------------
  //     
  property Measure : string read fMeasure write SetMeasure;
  property Min  : extended read fMin write SetMin;
  property Max  : extended read fMax write SetMax;
  property GLen : integer  read fCGW write SetCGW;
  // ------------------------
  //     
  property FiltrMax : integer read fFiltrMax write fFiltrMax;
  //      (  )
  property Value : extended read fValue write SetValue;
  // ------------------------
  //    
  property YZone : extended read fYZone write SetYZone;
  property RZone : extended read fRZone write SetRZone;
  // ------------------------

end;

implementation

// -------------------------------------------------------------------------
const cWIcon  = 14;
      cHIcon  = 14;
      cWBound = 4;
      cHBound = 4;
      cTxtPic = ' 123,123 ';
      cOutPic = '%6.3f';
// -------------------------------------------------------------------------
constructor TLineScope.Create(RqImage : TImage);
begin
   inherited Create;
   // -------------------------------
   //  fImg
   fImg   := RqImage;
   if not Assigned(fImg.Picture) then fImg.Picture := TPicture.Create;
   with fImg.Picture.Bitmap
   do begin
      if Width  <> fImg.Width   then Width  := fImg.Width;
      if Height <> fImg.Height  then Height := fImg.Height;
      if PixelFormat <> pf24bit then PixelFormat := pf24bit;
   end;
   // -------------------------------
   //   
   fXBeg    := 0;
   fYBeg    := 0;
   //  
   fTitle   := 'K ';
   fCGW     := 100;       //   
   fCGH     := 8;         //   
   fCompact     := False;
   fTransparent := False;
   // -------------------------------
   //   
   fBmpSave := TBitMap.Create;
   fBmpSave.PixelFormat := pf24bit;
   //   
   fBmp  := TBitMap.Create;
   fBmp.PixelFormat := pf24bit;
   // 
   CalcSRect();
   SaveBkGround();        //    
   // -------------------------------

   // -------------------------------
   //     
   fFiltrMax    := 0;     //    
   fFiltrNum    := 0;     //     
   fFiltrVal    := 0;     //    
   // -------------------------------
   //  
   fMeasure := ' . ';
   fMin   := 20;
   fMax   := 80;
   fValue := fMin;
   CalcScale();
end;

// -------------------------------------------------------------------------
procedure TLineScope.Free();
begin
   if Assigned(fBmpSave)
   then begin
       RestoreBkGround();
       fBmpSave.Free();
   end;
   if Assigned(fBmp)
   then begin
       fBmp.Free();
   end;
   inherited Free();
end;
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
//     
procedure TLineScope.CalcSRect();
var wH, wW : integer;
begin
  with fImg
  do begin
     //   
     fIRect.Top    := cHBound;
     fIRect.Left   := cWBound;
     fIRect.Bottom := fIRect.Top  + cHIcon;
     fIRect.Right  := fIRect.Left + cWIcon;
     //  
     wW := fIRect.Right  + cWBound;
     //   
     fVRect.Top    := fIRect.Top;
     fVRect.Left   := wW + cWBound;
     fVRect.Bottom := fVRect.Top  + Canvas.TextHeight('0');
     fVRect.Right  := fVRect.Left
                   + Canvas.TextWidth(cTxtPic + ' ' + fMeasure + ' ');
     //   
     if fVRect.Bottom > fIRect.Bottom
     then wH := fVRect.Bottom + cHBound
     else wH := fIRect.Bottom + cHBound;
     wW := fVRect.Right  + cWBound;
     //  
     if not fCompact
     then begin
       //   
       fGRect.Top    := wH;
       fGRect.Left   := cWBound;
       fGRect.Bottom := fGRect.Top  + fCGH;
       fGRect.Right  := fGRect.Left + fCGW;
       //   
       if fGRect.Right  + cWBound > wW
       then wW := fGRect.Right + cHBound;
       wH := fGRect.Bottom + cHBound;
       if fTitle <> ''
       then begin
         //   
         fTRect.Top    := wH;
         fTRect.Left   := cWBound;
         fTRect.Bottom := fTRect.Top  + Canvas.TextHeight('0');
         fTRect.Right  := fTRect.Left + Canvas.TextWidth(' ' + fTitle + ' ');
         //   
         if fTRect.Right  + cWBound > wW
         then wW := fTRect.Right + cHBound;
         wH := fTRect.Bottom + cHBound;
       end;
     end;
     //     ( fBmp)
     fFRect := Rect(0, 0, wW, wH);
     //     ( fImg)
     fScopeRect.Top    := fYBeg;
     fScopeRect.Left   := fXBeg;
     fScopeRect.Bottom := fYBeg + wH;
     fScopeRect.Right  := fXBeg + wW;
  end;
end;
// -------------------------------------------------------------------------
//   fScopeRect  fBmpSave
function  TLineScope.TestBkGround() : boolean;
begin
   Result := False;
   if Assigned(fBmpSave)
   then begin
      if fBmpSave.Height <> (fScopeRect.Bottom - fScopeRect.Top) + 1 then Exit;
      if fBmpSave.Width  <> (fScopeRect.Right - fScopeRect.Left) + 1 then Exit;
      Result := True;
   end;
end;
// -------------------------------------------------------------------------
//    
procedure TLineScope.RestoreBkGround();
var wRect : TRect;
begin
   if TestBkGround() and fVisible
   then begin
      //  Rect 
      wRect := Rect(0,0, fBmpSave.Width, fBmpSave.Height);
      //     fImg
      fImg.Canvas.CopyRect(fScopeRect, fBmpSave.Canvas,wRect);
   end;
end;
// -------------------------------------------------------------------------
//    
procedure TLineScope.SaveBkGround();
var wRect : TRect;
begin
   if (not Assigned(fImg)) or (not Assigned(fBmpSave)) then Exit;
   //    
   fBmpSave.Height := fScopeRect.Bottom - fScopeRect.Top + 1;
   fBmpSave.Width  := fScopeRect.Right - fScopeRect.Left + 1;
   //  Rect 
   wRect := Rect(0,0, fBmpSave.Width, fBmpSave.Height);
   //  
   fBmpSave.Canvas.CopyRect(wRect, fImg.Canvas, fScopeRect);
   //    
   fBmp.Height := fBmpSave.Height;
   fBmp.Width  := fBmpSave.Width;
end;
// -------------------------------------------------------------------------
//   
procedure TLineScope.SetVisible(Visible : boolean);
begin
  if Visible
  then begin
      if TestBkGround() and (not fVisible)
      then begin
         //    fImg
         fVisible := Visible;
         DrawScope();
      end;
  end
  else begin
      if TestBkGround() and fVisible
      then begin
          //    fImg
          RestoreBkGround();
          fVisible := Visible;
       end;
  end;
end;
// -------------------------------------------------------------------------
//       
procedure TLineScope.SetCompact(Compact : boolean);
begin
   if fVisible then RestoreBkGround();
   fCompact := Compact;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//       
procedure TLineScope.SetTransparent(Transparent : boolean);
begin
   if fVisible then RestoreBkGround();
   fTransparent := Transparent;
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//    
procedure TLineScope.SetMeasure(Measure : string);
begin
   if fVisible then RestoreBkGround();
   fMeasure := Measure;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
//  XBeg    fImg
procedure TLineScope.SetXBeg(XBeg : integer);
begin
   if fVisible then RestoreBkGround();
   if (XBeg < 0) or (XBeg > fImg.Width) then Exit;
   fXBeg := XBeg;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//  YBeg    fImg
procedure TLineScope.SetYBeg(YBeg : integer);
begin
   if fVisible then RestoreBkGround();
   if (YBeg < 0) or (YBeg > fImg.Height) then Exit;
   fYBeg := YBeg;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//   
procedure TLineScope.SetTitle (Title : string);
begin
   if fVisible then RestoreBkGround();
   fTitle := Title;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//     
procedure TLineScope.CalcScale();
begin
  fScale := 0;
  if fMax <= fMin then Exit;
  fScale := fCGW / (fMax - fMin);
end;
// -------------------------------------------------------------------------
//        
function TLineScope.GetGW(Value : extended) : integer;
begin
   Result := 0;
   if fScale > 0
   then begin
      if Value > fMax
      then begin
         Result := Round(fScale * Abs(fMax - fMin));
         Exit;
      end;
      if Value < fMin
      then begin
         Result := 0;
         Exit;
      end;
      Result := Round(fScale * Abs(Value - fMin));
   end;
end;
// -------------------------------------------------------------------------
//    
procedure TLineScope.SetMin(Min : extended);
begin
   if Min >= fMax then Exit;
   fMin := Min;
   fYZone := 0;
   fRZone := 0;
   CalcScale();
end;
// -------------------------------------------------------------------------
//    
procedure TLineScope.SetMax(Max : extended);
begin
   if Max <= fMin then Exit;
   fMax := Max;
   fYZone := 0;
   fRZone := 0;
   CalcScale();
end;
// -------------------------------------------------------------------------
//     
procedure TLineScope.SetCGW(GLen : integer);
begin
   if fVisible then RestoreBkGround();
   if GLen < cWIcon then fCGW := cWIcon;
   fCGW := GLen;
   CalcSRect();
   CalcScale();
   SaveBkGround();
   if fVisible then DrawScope();
end;

// -------------------------------------------------------------------------
//      
procedure TLineScope.SetYZone (YZone : extended);
begin
   fYZone := 0;
   if (YZone >= fMin) and (YZone <= fMax)
   then fYZone := YZone
   else ShowMessage('       ');
end;
// -------------------------------------------------------------------------
//     
procedure TLineScope.SetRZone (RZone : extended);
begin
   fRZone := 0;
   if fYZone <> 0
   then begin
     if (RZone > fYZone) and (RZone <= fMax)
     then fRZone := RZone
     else ShowMessage('       ');
   end
   else ShowMessage('       ');
end;
// -------------------------------------------------------------------------
//      
procedure TLineScope.SetValue (Value : extended);
begin
   if fFiltrMax > 1
   then begin
      //   
      //    fFiltrMax
      fFiltrVal := fFiltrVal + Value;      //  
      fFiltrNum := fFiltrNum + 1;          //  
      if fFiltrNum >= fFiltrMax
      then begin
         fValue := fFiltrVal / fFiltrMax;  //   
         fFiltrNum := 0;                   //   
         fFiltrVal := 0;                   //  
         if fVisible then DrawScope();     //  
      end;
   end
   else begin
      //    
      fValue := Value;                     //  
      if fVisible then DrawScope();        //  
   end;
end;
// -------------------------------------------------------------------------
//   
procedure TLineScope.DrawScope();
const clTransp = clTeal;
var wRect   : TRect;
    CFields : TColor;
    CValue  : TColor;
begin
   if not fVisible then Exit;
   //     
   CFields := RGB(200,220,240);
   if fValue < 0
   then begin
      CValue := RGB(180,180,255);
      if Abs(fValue) > fYZone then CValue := RGB(100,100,255);
      if Abs(fValue) > fRZone then CValue := RGB(0,0,255);
   end
   else begin
      CValue  := clLime;
      if fValue > fYZone then CValue := clYellow;
      if fValue > fRZone then CValue := clRed;
   end;
   //  
   with fBmp.Canvas
   do begin
      // -----------------------------
      if fTransparent
      then begin
         //   fBmp   fBmpSave
         fBmp.Assign(fBmpSave);
      end
      else begin
         //      
         Pen.Color := clWhite;
         Brush.Color := CFields;
         Brush.Style := bsSolid;
         Rectangle(fFRect);
         //   
         Pen.Color := clBlack;
         MoveTo(fFRect.Left,    fFRect.Bottom-1);
         LineTo(fFRect.Right-1, fFRect.Bottom-1);
         MoveTo(fFRect.Right-1, fFRect.Top);
         LineTo(fFRect.Right-1, fFRect.Bottom);
      end;
      // -----------------------------
      //  
      Brush.Color := CValue;
      Brush.Style := bsSolid;
      Ellipse(fIRect);
      // -----------------------------
      //  
      Brush.Style := bsClear;
      TextOut(fVRect.Left, fVRect.Top,
               ' ' + Format(cOutPic, [fValue])
             + ' ' + fMeasure + ' ' );
      // -----------------------------
      if not fCompact
      then begin
        // ---------------------------
        //   
        Brush.Color := CFields;
        Brush.Style := bsSolid;
        Rectangle(fGRect);
        // ---------------------------
        //   
        Brush.Style := bsSolid;
        Brush.Color := CValue;
        Rectangle(fGRect.Left, fGRect.Top,
                  fGRect.Left + Abs(GetGW(fValue)),
                  fGRect.Bottom);
         // ---------------------------
         //  
         if fTitle <> ''
         then begin
            Brush.Color := CFields;
            Brush.Style := bsClear;
            TextOut(fTRect.Left, fTRect.Top, ' ' + fTitle + ' ');
         end;
      end;
   end;
   //  Rect 
   wRect := Rect(0,0, fBmp.Width, fBmp.Height);
   //     fImg
   fImg.Canvas.CopyRect(fScopeRect, fBmp.Canvas,wRect);
end;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

end.
