unit AppDispatch1;

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls,
  //  
  Common1, UserApp01Main;

// ==========================================================================
//      
// ==========================================================================
// ( !)
type TRequest = record
  RqCmd   : string;      //   
  RqPrm   : string;      //    
  Replay  : string;      //    
  //      GET
  Buffer  : pointer;     //    nil
  BufSize : integer;     //    
end;

// --------------------------------------------------------------------------
//      
function SetRequest(RqCmdInd  : integer; var RqRequest : TRequest) : boolean;

function UnPackReplay(var RqReplay : string; RqReport : TMemo) : boolean;

// ==========================================================================
// --------------------------------------------------------------------------
implementation
// --------------------------------------------------------------------------
// ==========================================================================
// 08.02.2019
const cFieldSep   = ';';        //      
// --------------------------------------------------------------------------
// 08.02.2019
//      
//  1
//   Cmd = 'field1;field2;field3'
//   Result = 'field1', Cmd = 'field2;field3'
//  2
//   Cmd = 'field3'
//   Result = 'field3', Cmd = ''
function CutNextCmdField(var Cmd : string) : string;
var wPos : integer;
    wStr : string;
begin
   wStr   := Trim(Cmd);
   Result := wStr;
   wPos   := pos(cFieldSep, wStr);
   if wPos > 0
   then begin
        Result := copy(wStr, 1, wPos - 1);
        if (Length(wStr) > wPos)
        then Cmd := copy(wStr, wPos + 1, Length(wStr))
   end
   else Cmd := '';
end;


// =========================================================================
//       , 
//     .    
//       .
// =========================================================================
// -------------------------------------------------------------------------
// 08.01.2018
// (    !)
//      
function SetRequest(RqCmdInd : integer; var RqRequest : TRequest) : boolean;
begin
  Result := False;
  //      
  FillChar(RqRequest, SizeOf(RqRequest), #0);
  //      
  with RqRequest do
  begin
     case RqCmdInd of
     0 : begin
           // ---------------------
           // ------ NEW ----------
           RqCmd   := 'GET';
           RqPrm   := 'REC1';
           // ---------------------
           // ------ NEW ----------
           Buffer  := Addr(NStrREC1);
           BufSize := SizeOF(NStrREC1);
           // ------- NEW ---------
           // ---------------------
           Result  := True;
         end;
     end;
  end;
end;

// -------------------------------------------------------------------------
//          
procedure ToRealStr(var RqStr : string);
var Ind : integer;
begin
    for Ind := 1 to Length(RqStr)
             do if (RqStr[Ind] = '.') or (RqStr[Ind] = ',')
                then if (RqStr[Ind] <> DecimalSeparator)
                     then RqStr[Ind] := DecimalSeparator;
end;

// =========================================================================
//           
//      .
//   (TMemo)      ( ).
// =========================================================================
function UnPackReplay(var RqReplay : string; RqReport : TMemo) : boolean;
var wRep   : string;    //  RqReplay
    wField : string;    //    
    Ind    : integer;
begin
    Result := False;
    wRep := RqReplay;
    //     Id
    wField := CutNextCmdField(wRep);
    if (UpperCase(wField) = 'REC1')
    then begin
       //  REC1
       FillChar(REC1, SizeOf(REC1), #0);
       REC1.Id := wField;
       RqReport.Lines.Add(wField);
       Ind := 0;
       repeat
           //      
           wField := CutNextCmdField(wRep);
           if wField <> ''
           then begin
             //        
             ToRealStr(wField);
             //       
             try
                REC1.Arr[Ind] := StrToFloat(wField);
                RqReport.Lines.Add(wField);
             except end;
             Ind := Ind + 1;
           end;
       until (Ind > High(REC1.Arr)) or (wField = '');
       // -------------------------
       //     ,
       //    
       //    .
       UserApp01Form.ShowSensors;
    end;
end;


// =========================================================================
//  
// =========================================================================

end.
