#!/usr/bin/python3
# -*- coding: utf-8 -*-
import socket
import threading
import time
import sys
import os

# =======================================================================
#  ГЛОБАЛЬНЫЕ КОНСТАНТЫ
# =======================================================================
cBufLen   = 2048;        # Байтовая длина буфера обмена информацмей
# --------------------------------------
# Поля команд и квитанций
cFldSep   = ';';         #  Разделитель полей в командах и квитанциях
cRepYES   = 'YES';       #  Код позитивной квитанции от сервера
cRepNOT   = 'NOT';       #  Код негативной квитанции от сервера
cCmdEND   = 'END';       #  Код команды отключения клиента

# Индексы полей в строке авторизации
cPswIndx  = 0;           #  Индекс password-поля в запросе клиента
cLogIndx  = 1;           #  Индекс login-поля в запросе клиента

# Индексы полей в строке обмена данными
cCmdIndx  = 0;           #  Индекс командного поля в запросе клиента

# --------------------------------------
# Запрос отладочной печати
Debug = True             # Отладочный вывод на консоль операторами print
DeepDebug = True         # Деталный отладочный вывод на консоль операторами print
# --------------------------------------
# Параметры тайм-аута
MAX_TIME_OUT = 60.0      # Максимальное время ожидания на операциях чтения (сек.)       
ONE_TIMEOUT  = 1.0       # Время одной попытки при операции чтения (сек.)

# =======================================================================
#  ГЛОБАЛЬНЫЕ ПЕРЕМЕННЫЕ
# =======================================================================
# Переменные для хранения информации о соединениях
SrvSocked = None         # Основной Socked сервера
Password  = ""           # Пароль для подключения клиентов
Activate  = False        # Флаг - сервер активирован
connections = []         # Список подключенных агентов клиента на сервере
total_connections = 0    # Число  подключенных агентов клиента на сервере

# =======================================================================
#  АГЕНТ КЛИЕНТА НА СЕРВЕРЕ
# =======================================================================
# --------------------------------------
# Класс потока для агента клиента, каждый новый экземпляр создается для
# каждого подключенного клиента и имеет свой сокет и адрес
class Client(threading.Thread):
    def __init__(self, socket, address, psw, id, name, signal):
        threading.Thread.__init__(self)
        self.socket = socket
        self.address = address   # IP -адрес клиента
        self.psw = psw           # Пароль
        self.id = id             # Цифровой идентификатор пользователя
        self.name = name         # Имя пользователя
        self.rqexit = False      # Запрос на немедленное завершение 
        self.signal = signal     # Выполняется цикл клиента
        self.rcount = 0          # Счетчик попыток чтения клиекта
        self.codend = 0          # Код завершения последней операции
        self._stop_event = threading.Event()
    
    # --------------------------------------    
    # Проверить запрос на остановку и ликвидацию текущего агента клиента 
    def stopped(self):
        return self._stop_event.is_set()
    # --------------------------------------
    # Получить строку идентификации клиента
    def __GetIdClient(self):
        if self.name != '' :
           return "client " +  self.name + " " + str(self.address)
        else:
           return "client " + str(self.address)
    # --------------------------------------
    # 18.o9.2019
    # Выполнить чтение данных текущего клиента
    # Num - Заказанное число попыток чтения
    # return - Список строк прочитанного или пусто
    def __ReadLnFromClient(self, Num):        
        # ------
        # Проверим запрос на немедленное завершение
        if self.rqexit :           
           return []
        # ------
        self.codend = 0                       # Оптимистический прогноз попыток
        self.rcount = 0                       # Счетчик попыток чтение 
        self.socket.settimeout(ONE_TIMEOUT)   # Длительность тайм-аута
        # ----------------------
        while self.signal: 
           # Выполним попытку чтения  
           data =[]
           # ------
           try:
              data = self.socket.recv(cBufLen)
              self.codend = 0                 # Данные успешно прочитаны    
              break
           except :
              if not self.socket.timeout :
                 self.codend = 2              # Аварийное завершение socket.recv
                 return []                    # Далее нет смысла в повторах чтения
              else :
                 self.codend = 1              # Выход по тайм-ауту
           # ------  
           self.rcount += 1                   # Счетчик попыток чтение
           # Проверим результат очередной попытки
           if (self.codend > 0) and (self.rcount > Num) :
              # Число неудачных попыток исчерпано 
              return []                               
        # ---------------------- 
        if DeepDebug: print("Server receive data : ", data)
        # ------ 
        # Проверим запрос на немедленное завершение
        if self.rqexit :  
           return []
        # ------
        if (self.codend == 0) :
            # Успешное завершение чтения 
           txt = str(data.decode("utf-8"))     # Перекодируем прочитанное в строку utf-8
           txt = txt.rstrip('\r\n')            # Удалим символы конец строки и перевод каретки
           # Вернем список строк прочитанного
           return txt.split(cFldSep)           # Разделим строку сепараторами на отдельные части 
        else :
           return []
    # --------------------------------------       
    # Выполнить запись данных для текущего клиента
    def __SendToClient(self, data):
        try:
           self.socket.sendall(data)
           if DeepDebug: print("Server send :", data)
           return True                          # Успешное завершение записи
        except : return False                   # Аварийное завершение операции
    # --------------------------------------       
    # Выполнить запись данных для текущего клиента
    def __WriteLnToClient(self, txt):
        try:
           line = txt + '\r\n'
           self.socket.sendall(line.encode("utf-8"))
           if DeepDebug: print("Server send :", txt)
           return True                           # Успешное завершение записи
        except : return False                    # Аварийное завершение операции
    # --------------------------------------
    # Остановка и ликвидация текущего агента клиента и его сокета       
    def __RemoveClient(self, msg):
        msg = self.__GetIdClient() + msg
        self.__WriteLnToClient(cCmdEND)
        self.rqexit = True                       # Запрос на немедленное завершение
        self.signal = False                      # Сигнал завершения основного цикла агента клиента
        self._stop_event.set()                   # Запрос на завершение нити агента клиента
        self.socket.shutdown(0)                  # Запрос на подготовку завершения socket агента 
        self.socket.close()                      # Завершение socket агента 
        connections.remove(self)                 # Удаление агента из списка активных агентов клиента
        # Очет
        print(msg)
    # --------------------------------------
    # Прочитать указанную строку запроса клиента
    def GetRequestStr(self, data, indx): 
       if data == [] : return ''
       if (indx >= 0) and (indx < len(data)) :
          txt =  str(data[indx])
          if DeepDebug: print("GetRequestStr : ", txt)
          return txt.rstrip('\r\n') 
       else : return ''       
    # --------------------------------------
    # Основной цикл агента клиента по взаимодействию с клиентом.
    # Если чтение или запись клиенту выполнить не удается, выполняется
    # остановка и ликвидация текущего агента клиента и его сокета
    # self._stop_event.is_set() может использовать для контроля
    # запроса на завершения нити клиента
    def run(self):                                     
        self._stop_event.clear()
        while self.signal :    
            # ----------------------
            # Чтение запроса клиента 
            data = self.__ReadLnFromClient(60)
            # ----------------------
            # Проверим запрос на немедленное завершение
            if self.rqexit :                       
               # Выполним disconnect клиента 
               msg = " client force disconnect!"
               self.__RemoveClient(msg) 
               return []
            # Проверим аварийное завершение socket.recv
            if self.codend == 2 :
               # Выполним disconnect клиента 
               msg = ' socket receive I/O error'
               self.__RemoveClient(msg)
               return []
            # Проверим превышение тайм-аута
            if self.codend == 1 : 
               # Выполним disconnect клиента 
               msg = " long inactive disconnect!"
               self.__RemoveClient(msg)
               return []
            # ----------------------
            # Проверка кодов завершения операции чтения
            if (self.codend == 0) and (not self.rqexit) :
               # ----------------------
               # Все хорошо. Проверим запрос на завершение сеанса
               if self.GetRequestStr(data, 0) == 'END' :
                  msg = " logged out"
                  self.__RemoveClient(msg)
                  break           
               # ===========================
               # Заглушка обработки запроса
               # ===========================


               # ===========================
               # Реплика сервера
               txt = self.GetRequestStr(data, 0)
               if self.__WriteLnToClient(txt) :
                  msg = "Server send to " + self.__GetIdClient() + " : " + txt                              
                  print(msg)
               else :
                  self._stop_event.set()
            else :
               break
               
# =======================================================================
#  Основные функции сервера
# =======================================================================
# Принудительно отключить всех клиентов               
def DisConnectAll():    
    if Debug : print("DisConnectAll")
    if len(connections) <= 0 :
        if Debug : print(" Clients :", connections)
        return
    # Ликвидировать активных агентов
    while connections != [] :
       CL = connections[0]
       CL.rqexit = True                              # Запрос на немедленное завершение
       CL.signal = False
       CL._stop_event.set()
       time.sleep(2*ONE_TIMEOUT)
    if Debug : print(" Clients : ", connections)

    
#    for ind in range(0,len(connections)) :     
#       CL =  connections[ind]
       # CL.stop()
#       txt = " ID : " + str(CL.address) + " : Request for disconnect"
#       if Debug : print(txt)       
#    time.sleep(4 * ONE_TIMEOUT)       
#    if Debug : print(" Clients : ", connections)
# -------------------------------------- 
# Прочитать в список строки авторизации клиента
def GetAuthorization(RqSock) :
    СodeEnd = 3
    try :
       data = []
       RqSock.settimeout(ONE_TIMEOUT)
       data = RqSock.recv(cBufLen)
       СodeEnd = 0
    except :
       return [] 
    RqSock.settimeout(None)
    if СodeEnd == 0 :
       if DeepDebug: print("Server receive authorization data: ", data)
       txt = data.decode("utf-8")
       txt = txt.rstrip('\r\n')
       lst = txt.split(cFldSep)
       if len(lst) < 2 : return []
       else : return lst
# -------------------------------------- 
# Ждем новых подключений
def newConnections(RqSocket):
    global Activate, Password, total_connections
    # print("connect Request")
    if not Activate : return
    while  Activate :
        try : 
           # Попытка подключить клиента  
           sock, address = RqSocket.accept()
           if DeepDebug : print("connect accept")
           # Авторизация клиента
           lst = GetAuthorization(sock)
           ClientPsw  = ''
           ClientName = ''
           OkFlag = False
           if len(lst) > 0 :
              ClientName  = lst[cLogIndx] 
              ClientPsw   = lst[cPswIndx]
              if Password == ClientPsw:
                 OkFlag = True 
           if DeepDebug:
              print("Server identify client name as: ", ClientName) 
              print("Server identify client password as: ", ClientPsw)
           if OkFlag :
              # Позитивная квитанция 
              sock.sendall(str.encode(cRepYES + '\r\n'))
           else:
              # Негативная квитанция
              txt = "Client " + ClientName + str(address) + " : Disabled"  
              sock.sendall(str.encode(cRepNOT + '\r\n'))
              sock.close()
              print(txt)
        except :
           OkFlag = False
        # Создание агента клиента на сервере   
        if OkFlag:           
           try :
              connections.append(Client(sock, address, ClientPsw, total_connections, ClientName, True))
              connections[len(connections) - 1].start()
              total_connections += 1
              # Отчет
              txt = "Client " + ClientName  + str(address) + " New connection"
           except :
              txt = "Client " + ClientName  + str(address) + " Disabled" 
           print(txt)
# --------------------------------------                     
# Активировать сервер    
def ActivateServer():
    global SrvSocked, Password, Activate
    Activate = False
    try :
       # Прочитать значения host, port, Password
       host = input("Default Host : 127.0.0.1 or >>> ")
       port = input("Default Port : 9099 or >>> ")
       Password = input("Default PSW  : psw or >>> ")
       if host == '' : host = "127.0.0.1"
       if port == '' : port = '9099'
       if Password == '' : Password = 'psw'
       # Создать новый socket для сервера       
       SrvSocked = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
       SrvSocked.bind((host, int(port)))
       SrvSocked.listen(5)
       # Успешная активация
       Activate = True
       # Вывод отчета
       print(" SERVER ACTIVATED")
    except :
       print(" REEOR Activation! Verify (HOST, PORT), Cloce All Active Python Server.") 
    if Debug : print(SrvSocked)
# --------------------------------------
# ДеАктивировать сервер    
def DeactivateServer() :
    global SrvSocked, Activate 
    if not SrvSocked : return 0
    # Отключить всех клиентов
    DisConnectAll()
    # Деактивировать сервер
    try :
       SrvSocked.close()
       Activate = False
       print(" SERVER DEACTIVATED")
    except :
       if Debug : print(SrvSocked)
       print(" ERROR SERVER DeActivation") 
    time.sleep(2 * ONE_TIMEOUT)
    if Debug : print(SrvSocked)

# =======================================================================
#  MAIN
# =======================================================================
def main():
    global SrvSocked, Activate
    if Activate :
       print("====================================") 
       print("To shut down the server, type : END ")
       print("====================================")
       print("The server is waiting for client connections")
       # Ожидать подключений клиентов и для каждого подключения
       # создавать новый поток агента клиента
       newConnectionsThread = threading.Thread(target = newConnections, args = (SrvSocked,))
       newConnectionsThread.start()
       wStr = ' '
       while not (wStr == 'END'): 
          wStr = input("") 
          if (wStr == 'END'):
              print("====================================")
              print ("SysOp type END-Server command")
              print("====================================")
# =======================================================================
# =======================================================================
ActivateServer()
main()
DisConnectAll()
DeactivateServer()
print("====================================")
print ("Server shut down")
input("Press any key ... ")
sys.exit(0)
