import socket
from   tkinter import *
import time
import sys

# =======================================================================
#  ГЛОБАЛЬНЫЕ КОНСТАНТЫ
# =======================================================================
# --------------------------------------
# Поля команд и квитанций
cFldSep   = ';';             #  Разделитель полей в командах и квитанциях
cRepYES   = 'YES\r\n';       #  Код позитивной квитанции от сервера
cRepNOT   = 'NOT\r\n';       #  Код негативной квитанции от сервера
cCmdEND   = 'END\r\n';       #  Код команды отключения клиента

# --------------------------------------
# Запрос отладочной печати
Debug = False            # Отладочный вывод на консоль операторами print

# --------------------------------------
# Параметры тайм-аута     
cTimeout  = 1.0           # Время одной попытки при операции чтения (сек.)

# =======================================================================
#  ГЛОБАЛЬНЫЕ ПЕРЕМЕННЫЕ
# =======================================================================
ClSocket = None          # Основной Socked клиента 
Connected  = False       # Флаг - клиент connected

# --------------------------------------
# Ожидание поступления данных с сервера
# .decode используется для преобразования сообщения в байтах в строку
def RecvFromServer():
    global Connected, ClSocket
    if not Connected : return 
    try:        
        txt = ClSocket.recv(1024).decode("utf-8")
        return txt
    except:
        disconnect()
        AddToReport("Ошибка чтения с сервера")
# --------------------------------------
# Выполнить запись данных для текущего клиента
def SendToServer(txt):
    global Connected, ClSocket
    if (not Connected) : return 
    try:
       # str.encode используется для преобразования строкового сообщения
       #  в массив байт, чтобы его можно было отправлять по сети
       ClSocket.sendall(str.encode(txt))
       return True                                  # Успешное завершение записи
    except : return False                           # Аварийное завершение операции
# --------------------------------------
# Отключение от сервера
def disconnect() :
   global Connected, ClSocket
   if Connected :
      SendToServer(cCmdEND)
      time.sleep(4 * cTimeout)
   # Отключить клиент 
   try :      
      ClSocket.close()
      Connected = False
      message1(entr_stat, "blue", " DISCONNECTED")
      ClearReport()
      AddToReport("Текущий сеанс клиента закончен")
   except :
      message1(entr_stat, "red",  " ERROR") 
   if Debug : print(ClSocket)   
# --------------------------------------        
# Подключение к серверу
def connect() :
   global Connected, ClSocket
   if Connected : return
   try:       
       host  = EntriesGet(entssv, 0)        # "127.0.0.1"
       port  = int(EntriesGet(entssv, 1))   # 9099
       NAME  = EntriesGet(entssv, 2)        # User Name
       PSW   = EntriesGet(entssv, 3)        # Password
       ClSocket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
       ClSocket.connect((host, port))
       Connected = True
       message1(entr_stat, "green", " CONNECTED")
   except:
       Connected = False 
       disconnect() 
       AddToReport("Не удалось установить соединение с сервером")
       return
   # Авторизация на сервере
   txt = PSW + cFldSep + NAME
   if not SendToServer(txt) :
       Connected = False 
       disconnect() 
       AddToReport("Связь с сервером прервалась")
       return
   # Подтверждение авторизации
   try: 
      ClSocket.settimeout(4 * cTimeout) 
      txt = ClSocket.recv(1024).decode("utf-8") 
      if txt == cRepYES:
         # Получена позитивная квитанция 
         Connected = True
         ClSocket.settimeout(None)
         ClearReport()
         AddToReport("Связь с сервером успешно установлена")
      else:
         Connected = False 
         disconnect()  
         AddToReport("Сервер отказал в обслуживании") 
   except: 
      Connected = False 
      disconnect()   
      AddToReport("Сервер разорвал соединение")
# --------------------------------------   
def run() :
    global Connected, ClSocket
    if not Connected : return
    RQ = entr_RQ.get()
    if RQ == "" : return
    # Отправить данные на сервер
    if not SendToServer(RQ) :
       Connected = False 
       disconnect() 
       AddToReport("Связь с сервером прервалась")
    if Connected: 
       #  Ожидание поступления данных с сервера
       # .decode используется для преобразования сообщения в байтах в строку
       try:          
          txt = RecvFromServer()
          AddToReport("SERVER : " + txt)
          if (txt == cCmdEND):
             Connected = False
             disconnect() 
             AddToReport("Сервер разорвал соединение")
       except:
          Connected = False
          disconnect() 
          AddToReport("Связь с сервером прервалась")

# =======================================================================
#  GUI SERVICE
# ======================================================================= 
# --------------------------------------
# Заполнение группы entries из списка lst
def lsttoent (lst, entries) :
    entclear (0, entries)
    if lst == [] : return
    for ind in range (0, len(lst)) :
        entr = entries[ind]
        entr.insert(0, str(lst[ind]))
# --------------------------------------
# Очистка группы entries начиная с индекса start
def entclear (start, entries) :
    for ind in range (0, len(entries)) :
        entr = entries[ind]
        entr.delete(0, END)        
# --------------------------------------
# Выборка в группе entries значения из Entry с индексом ind
def EntriesGet(entries, ind) :
    entr = entries[ind]
    return entr.get()
    
# --------------------------------------
srvparm =[['HOST :','PORT :','NAME :','PSW : '],
          ['127.0.0.1','9099','User','psw']]
# --------------------------------------
# Создать группу entries 
def makeform(frm, titles) :  
    entries = []
    for ic in range(0,len(titles[0])) :
        row = Frame(frm)                           
        # add label, entry
        Label(row, width=8, text=titles[0][ic]).pack(side=LEFT) 
        entr = Entry(row)
        entr.insert(0, str(titles[1][ic]))
        entr.pack(side=LEFT, expand=NO, fill=X)     
        # pack row on top
        row.pack(side=TOP, fill=X)                  
        entries.append(entr)     
    return entries
# --------------------------------------
# Очистить журнал операций
def ClearReport() :
    text1.delete (0.0 , END)   # Удалить все    
# --------------------------------------
# Вставить текст в конец журнала операций
def AddToReport (txt, fontcolor="black") :
    lines = txt.splitlines()
    if Debug : print(txt)
    if len(lines) > 0 :
       # text1.insert(END, lines[0] +'\n')       # Запись в конец журнала
       text1.insert(0.0, lines[0] +'\n')         # Запись в начало журнала   
# --------------------------------------
# Сообщение в поле Entry
def message1(entr, fontcolor, txt) :
    entr["fg"]=fontcolor
    entr.delete(0,END)
    entr.insert(0, str(txt))
    
# =======================================================================
#  GUI
# =======================================================================   
if __name__ == '__main__':
    root = Tk()
    root.title ('Echo CLIENT. ver.1.1.')
    root.geometry ('630x260' )
    root.resizable (False, False)
    # ==========================
    frame_main1 = Frame (root)
    # ==========================
    # --------------------------
    frame_mL = Frame (frame_main1)
    # --------------------------
    # ---
    frame_parm =Frame (frame_mL)
    Label(frame_parm, width=20, text='Параметры клиента').pack(side=TOP, pady=4)
    entssv = makeform(frame_parm, srvparm)
    frame_parm.pack(side=TOP, padx=5, pady=5)
    # --- 
    frame_btn =Frame (frame_mL)
    Button(frame_btn, width=16, text=' Connect ', command= (lambda: connect())).pack(side=TOP, pady=3)
    Button(frame_btn, width=16, text=' DisConnect ', command= (lambda: disconnect())).pack(side=TOP, pady=3)
    frame_btn.pack(side=TOP, padx=5, pady=5)
    # ---
    frame_stat =Frame (frame_mL)
    Label(frame_stat, width=6, text='STAT :').pack(side=LEFT, pady=4)
    entr_stat = Entry(frame_stat)                # Entry для индикации состояния
    entr_stat.config(width=17, bg='gray90', font=('tahoma', 10))
    entr_stat.pack(side=TOP, fill=X, expand=YES, padx=5, pady=4)
    frame_stat.pack(side=TOP, padx=5, pady=5)
    # ---
    # ---------------------------
    frame_mL.pack(side=LEFT, padx=5)
    frame_mR = Frame (frame_main1)
    # ---------------------------
    # ---
    frame_rep = Frame(frame_mR)
    Label(frame_rep, width=20, text='Журнал операций').pack(side=TOP, padx=4, pady=5)
    text1 =Text(frame_rep, height = 12, width = 65, bg='gray90', font='tahoma 8', wrap=WORD)
    text1.pack(side=LEFT, padx=4, pady=2)
    scrollbar = Scrollbar(frame_rep)
    scrollbar .pack(side=LEFT, fill=Y)
    scrollbar ['command' ] = text1.yview      # первая привязка
    text1['yscrollcommand' ] = scrollbar.set  # вторая привязка
    frame_rep.pack(side=TOP)
    # ---
    # --------------------------
    frame_mR.pack(side=RIGHT, padx=5)
    # --------------------------
    # ==========================
    frame_main1.pack(side=TOP)
    frame_main2 = Frame (root)
    # ==========================
    # ---
    frame_RQ = Frame(frame_main2)
    Button(frame_RQ, width=8, text=' Run   ', command= (lambda: run())).pack(side=LEFT, padx=4, pady=4) 
    entr_RQ = Entry(frame_RQ)                 # Entry для сообщений
    entr_RQ.config(width=72, bg='gray90', font=('tahoma', 8)) # font=('tahoma', 9, 'bold')
    entr_RQ.pack(side=TOP, fill=X, expand=YES, padx=5, pady=5)
    entr_RQ.insert(0, " текст для отправки на сервер")
    frame_RQ.pack(side=TOP)
    # ---
    # ==========================
    frame_main2.pack(side=TOP)
    # ==========================
    
message1(entr_stat, "blue", " DISCONNECTED")
root.mainloop()
if Connected : SendToServer(cCmdEND)
   

