unit Main;

// ====================================================================
(*
           TCP/IP 
                 

    TCP/IP      
   ,         .
        
        ()  .
    ,       
     .   
            Ecxel,
          
    .    ()  
       .
   // -----------------------------------------------------
    2.01. ()  , , , , 2018.
                () Source code  ..
     08.01.2018
*)
// ====================================================================

// ====================================================================
//     INDY
// ====================================================================

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, MMSystem, EncdDecd, StrUtils, StdCtrls, ExtCtrls, ComCtrls,
  //
   IdGlobal, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient;


type
  TClientForm = class(TForm)
    TCPClient: TIdTCPClient;
    Timer2: TTimer;
    Panel1: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    edIP: TEdit;
    edPort: TEdit;
    Button1: TButton;
    Button2: TButton;
    stxtConnect: TStaticText;
    edName: TEdit;
    edPSW: TEdit;
    Label1: TLabel;
    MemoReport: TMemo;
    Panel2: TPanel;
    Label7: TLabel;
    Label8: TLabel;
    StatusBar1: TStatusBar;
    Label12: TLabel;
    StaticText1: TStaticText;
    edSend: TEdit;
    edRead: TEdit;
    btnSend: TButton;
    Label13: TLabel;
    procedure TCPClientConnected(Sender: TObject);
    procedure TCPClientDisconnected(Sender: TObject);
    procedure TCPClientStatus(ASender: TObject;
      const AStatus: TIdStatus; const AStatusText: String);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button4Click(Sender: TObject);
    procedure btnSendClick(Sender: TObject);

  private
    { Private declarations }
    //     
    function TryWriteLn(Msg : string) : boolean;
    //     
    function TryReadLn(var Msg : string) : boolean;
    //   
    function DoDisConnect(Msg : string) : boolean;
    //     
    procedure RunRequest(RqCmdInd : integer);

  public
    { Public declarations }
  end;

var
  ClientForm: TClientForm;

// ==========================================================================
// ==========================================================================

implementation
{$R *.dfm}

// ==========================================================================
// ==========================================================================

// ==========================================================================
//   
// ==========================================================================
// 08.02.2019
// ------------------------------
//     
const cRepTimeOut = 20;         //      
      cFieldSep   = ';';        //      
      cRepYES     = 'YES';      //     
      cRepNOT     = 'NOT';      //     
      cCmdEND     = 'END';      //    
// -----------------------------
//   
const cCmdConnect    = 'CNN';   //     
      cCmdDisConnect = 'DCN';   //     
      cCmdService    = 'SRV';   //      
// -----------------------------
//   
const cCmdGET       = 'GET';    //    
      cCmdSET       = 'SET';    //      

// -----------------------------
//     
// -----------------------------
//      ( 1 msec)
//    unit MMSystem.pas
type TTimeStampsMM = record
  MMErr  : word;             //      
  BTime  : LongInt;          //    msec
  ETime  : LongInt;          //    msec
end;

// ==========================================================================
//   
// ==========================================================================
// -------------------------------------------------------------------------
//    
function GetApplicationDirectory() : string;
begin
   Result := Application.ExeName;
   Result := ExtractFileDir(Result);
end;
// --------------------------------------------------------------------------
//  Login-  
function GetCurrentUserName() : string;
const cnMaxUserNameLen = 254;
var   sUserName     : string;
      dwUserNameLen : DWord;
begin
  dwUserNameLen := cnMaxUserNameLen-1;
  SetLength( sUserName, cnMaxUserNameLen );
  GetUserName(PChar(sUserName), dwUserNameLen);
  SetLength(sUserName, dwUserNameLen-1);
  Result := sUserName;
end;
// --------------------------------------------------------------------------
//  RqEdit.Text     
function TryEditToInt(RqEdit : TEdit; var Value : integer) : boolean;
begin
   Result := False;
   try
       if Trim(RqEdit.Text) = ''
       then Value := 0
       else begin
           Value := StrToInt(Trim(RqEdit.Text));
           RqEdit.Color := clWindow;
       end;
       Result := True;
   except
       RqEdit.Color := RGB(255,240,240);
       ShowMessage('       ');
   end;
end;
// --------------------------------------------------------------------------
// 24.11.2016
//      
//  1
//   Cmd = 'field1;field2;field3'
//   Result = 'field1', Cmd = 'field2;field3'
//  2
//   Cmd = 'field3'
//   Result = 'field3', Cmd = ''
function CutNextCmdField(var Cmd : string) : string;
var wPos : integer;
    wStr : string;
begin
   wStr   := Trim(Cmd);
   Result := wStr;
   wPos   := pos(cFieldSep, wStr);
   if wPos > 0
   then begin
        Result := copy(wStr, 1, wPos - 1);
        if (Length(wStr) > wPos)
        then Cmd := copy(wStr, wPos + 1, Length(wStr))
   end
   else Cmd := '';
end;
// =========================================================================
//       
// =========================================================================
// 10.03.2013
//    
procedure StartMMTimeStamp (var RqStamp  : TTimeStampsMM);
begin
   try
       RqStamp.BTime := timeGetTime;
       RqStamp.MMErr := 0;
   except
       RqStamp.MMErr := 1;          //   
   end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//       
function StopMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   if RqStamp.MMErr = 0
   then begin
      with RqStamp
      do begin
          try
            ETime := timeGetTime;
            if (ETime - BTime) >= 0
            then Result := IntToStr(ETime - BTime);
          except
            MMErr := 1;
            Result := '-1';
          end;
      end;
   end
   else Result := '-1';
end;
// ==========================================================================
//   TRY-     
// ==========================================================================
// --------------------------------------------------------------------------
// 24.11.2016
//     
function TClientForm.TryWriteLn(Msg : string) : boolean;
begin
   try
     TCPClient.WriteLn(Msg);
     Result := True;
   except
     Result := False;
   end;
end;
// --------------------------------------------------------------------------
// 24.11.2016
//     
function TClientForm.TryReadLn(var Msg : string) : boolean;
var RepeatCount : integer;
begin
   RepeatCount := 10;  //  
   Msg := '';
   try
     repeat
        Msg := TCPClient.ReadLn(EOL, cRepTimeOut);
        Dec(RepeatCount);
     until ((Msg <> '') or (RepeatCount < 0));
     //  Msg <> ''    //    
     //  Msg  = ''    //   
     Result := True;
   except
     //      
     Result := False;
   end;
end;

// ==========================================================================
//   
// ==========================================================================
// --------------------------------------------------------------------------
// 07.01.2017
//   
function TClientForm.DoDisConnect(Msg : string) : boolean;
begin
   Result := False;
   //  Disconnect
   if TCPClient.Connected
   then begin
      //     - " "
      TryWriteLn(cCmdEND);
   end;
   //   (  TCPClient.Connected )
   try
     TCPClient.Disconnect();
     StatusBar1.Panels[1].Text := Msg;
     Result := True;
   except
     StatusBar1.Panels[1].Text := 'ERROR :   '
                                + ' ';
   end;
end;
// --------------------------------------------------------------------------
// 07.01.2017
//   - " Disconnect"
procedure TClientForm.TCPClientDisconnected(Sender: TObject);
begin
  //   Online
  stxtConnect.Color := clBtnFace;
  //   
  MemoReport.Clear;
  MemoReport.Lines.Add(' ');
end;
// --------------------------------------------------------------------------
// 07.01.2017
//   DisConnect   
procedure TClientForm.Button2Click(Sender: TObject);
begin
  //  
  DoDisConnect('   ');
end;
// ==========================================================================
//   
// ==========================================================================
// --------------------------------------------------------------------------
//   - " Connect"
procedure TClientForm.TCPClientConnected(Sender: TObject);
var   wStr   : string;
begin
   MemoReport.Clear;
   //  
   wStr := edPSW.Text + cFieldSep + edName.Text + cFieldSep;
   //     Python
   wStr := AnsiToUtf8(wStr);
   //   
   if not TryWriteLn(wStr)
   then begin
      StatusBar1.Panels[1].Text := '    ';
      Exit;
   end;
   //    
   if TryReadLn(wStr)
   then begin
      //     Python
      wStr := Utf8ToAnsi(wStr);
      //  
      if wStr = cRepYES
      then begin
         stxtConnect.Color := clLime;
         MemoReport.Lines.Add(' ');
      end
      else DoDisConnect('   ');
   end
   else begin
      DoDisConnect('ERROR :       ');
   end;
end;
// --------------------------------------------------------------------------
//   -   
procedure TClientForm.Button1Click(Sender: TObject);
begin
  if (edIP.Text   = '') or
     (edPort.Text = '') or
     (edName.Text = '') or
     (edPSW.Text  = '')
  then begin
     StatusBar1.Panels[1].Text := '     ';
     Exit;
  end;
  TCPClient.Host := edIP.Text;
  TCPClient.Port := StrToInt(edPort.Text);
  try
    TCPClient.Connect();
  except
    StatusBar1.Panels[1].Text := '    : Connect';
  end;
end;
// --------------------------------------------------------------------------
// 07.01.2017
//   -    
procedure TClientForm.TCPClientStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: String);
begin
  StatusBar1.Panels[0].Text := AStatusText;
end;

// ==========================================================================
//    
// ==========================================================================
// --------------------------------------------------------------------------
// 08.02.2019
//     
procedure TClientForm.RunRequest(RqCmdInd : integer);
var  wCmd     : string;    //    
     wRep     : string;    //   
begin
    // ----------------------------
    //  
    if not TCPClient.Connected
    then begin
       StatusBar1.Panels[1].Text := '     ';
       Exit;
    end;

    wCmd := edSend.Text;
    wCmd := AnsiToUtf8(wCmd);
    if not TryWriteLn(wCmd)
    then begin
      StatusBar1.Panels[1].Text := '     : '
                                    + wCmd;
      Exit;
    end;

    wRep := '';
    if TryReadLn(wRep)
    then begin
      wRep := Utf8ToAnsi(wRep);
      edRead.Text := wRep;
    end;

end;
procedure TClientForm.btnSendClick(Sender: TObject);
begin
   RunRequest(0);
end;
// ==========================================================================
//   
// ==========================================================================
// --------------------------------------------------------------------------



// ==========================================================================
//   / 
// ==========================================================================
// --------------------------------------------------------------------------
// 
procedure TClientForm.FormCreate(Sender: TObject);
begin
  //  INDY
  StaticText1.Caption := ' ' + TCPClient.Version;

  //    
  edName.Text := GetCurrentUserName();
end;

// --------------------------------------------------------------------------
//     
procedure TClientForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if TCPClient.Connected
  then begin
    Action := caNone;
    MessageDlg('    '
    + #13#10 + '  ( Online )...',
               mtInformation, [mbOk], 0);
  end;
end;

// --------------------------------------------------------------------------
//    (  )
procedure TClientForm.Button4Click(Sender: TObject);
begin
(*
   case cbBoxCMD.ItemIndex of
     0 : UserApp01Form.Show;
   end;
*)
end;

// ==========================================================================
// 
// ==========================================================================


end.
