import socket
import threading
from   tkinter import *
import time
import sys
import os

# WINDOS ONLY

# =======================================================================
#  ГЛОБАЛЬНЫЕ КОНСТАНТЫ
# =======================================================================
SHUT_RD   = 0  # Stop receiving data for this socket. If further data arrives, reject it.
SHUT_WR   = 1  # Stop trying to transmit data from this socket. Discard any data waiting
               # to be sent. Stop looking for acknowledgement of data already sent; don’t
               # retransmit it if it is lost.
SHUT_RDWR = 2  # Stop both reception and transmission.
# --------------------------------------
# Поля команд и квитанций
cFldSep   = ';';         #  Разделитель полей в командах и квитанциях
cRepYES   = 'YES';       #  Код позитивной квитанции от сервера
cRepNOT   = 'NOT';       #  Код негативной квитанции от сервера
cCmdEND   = 'END';       #  Код команды отключения клиента

# --------------------------------------
# Запрос отладочной печати
Debug = True             # Отладочный вывод на консоль операторами print
# --------------------------------------
# Параметры тайм-аута
MAX_TIME_OUT = 30.0      # Максимальное время ожидания на операциях чтения (сек.)       
ONE_TIMEOUT     = 1.0       # Время одной попытки при операции чтения (сек.)

# =======================================================================
#  ГЛОБАЛЬНЫЕ ПЕРЕМЕННЫЕ
# =======================================================================
# Переменные для хранения информации о соединениях
SrvSocked = None         # Основной Socked сервера
Password  = ""           # Пароль для подключения клиентов
Activate  = False        # Флаг - сервер активирован
connections = []         # Список подключенных агентов клиента на сервере
total_connections = 0    # Число  подключенных агентов клиента на сервере

# =======================================================================
#  АГЕНТ КЛИЕНТА НА СЕРВЕРЕ
# =======================================================================
# --------------------------------------
# Класс потока для агента клиента, каждый новый экземпляр создается для
# каждого подключенного клиента и имеет свой сокет и адрес
class Client(threading.Thread):
    def __init__(self, socket, address, psw, id, name, signal):
        threading.Thread.__init__(self)
        self.socket = socket
        self.address = address   # IP -адрес клиента
        self.psw = psw           # Пароль
        self.id = id             # Цифровой идентификатор пользователя
        self.name = name         # Имя пользователя
        self.signal = signal
        self.rcount = 0          # Счетчик попыток чтения клиекта
        self._stop_event = threading.Event()
    # --------------------------------------    
    # Остановить и ликвидировать текущего агента клиента    
    def stop(self):
        self._stop_event.set()
    # --------------------------------------    
    # Проверить запрос на остановку и ликвидацию текущего агента клиента 
    def stopped(self):
        return self._stop_event.is_set()
    # --------------------------------------
    # Получить строку идентификации клиента
    def __GetIdClient(self):
        return "ID : " + str(self.address) + " : "
    # --------------------------------------
    # Выполнить чтение данных текущего клиента
    def __ReadClient(self):
        try:
           data = [] 
           data = self.socket.recv(1024)
           return [0, data]                            # Успешное завершение чтения
        except :                         
           if self.socket.timeout : return [1, data]   # Выход по тайм-ауту
           else : return [2, data]                     # Аварийное завершение операции
    # --------------------------------------       
    # Выполнить запись данных для текущего клиента
    def __SendToClient(self, data):
        try:
           self.socket.sendall(data)
           return True                                  # Успешное завершение записи
        except : return False                           # Аварийное завершение операции
    # --------------------------------------
    # Остановка и ликвидация текущего агента клиента и его сокета       
    def __RemoveClient(self, txt):
        msg = self.__GetIdClient() + txt
        self.__SendToClient(str.encode(cCmdEND))
        self.signal = False
        time.sleep(1)
        connections.remove(self)
        # Очет
        AddToReport(msg)
    # --------------------------------------
    # Основной цикл потока по взаимодействию с клиентом.
    # Если чтение или запись клиенту выполнить не удается, выполняется
    # остановка и ликвидация текущего агента клиента и его сокета
    # .decode используется для преобразования байтовых данных в печатную строку
    def run(self):
        count = 0                                      # Счетчик попыток чтение
        self._stop_event.clear()
        self.socket.settimeout(ONE_TIMEOUT)
        while self.signal :    
            if (self._stop_event.is_set()) :
                txt = "SERVER : client force disconnect"
                self.__RemoveClient(txt)
                break
            buf = []
            buf = self.__ReadClient()
            if buf[0] == 1 :
               global MAX_TIME_OUT 
               if self.rcount < MAX_TIME_OUT :
                  self.rcount += 1
                  continue
               else :
                  txt = "SERVER : client long inactive disconnect"
                  self.__RemoveClient(txt)                  
                  break
            if buf[0] == 2 :
               txt = "SERVER : client I/O Error disconnect"
               self.__RemoveClient(txt)
               break
            data = buf[1]
            self.rcount = 0
            if ((str(data.decode("utf-8")) == cCmdEND) ):
               txt = "SERVER : client logged out"
               self.__RemoveClient(txt)
               break            
            # ===========================
            # Заглушка обработки запроса
            # ===========================


            # ===========================
            # Реплика сервера
            if self.__SendToClient(data) :
               txt = self.__GetIdClient() + "CLIENT : " + str(data.decode("utf-8"))                              
               AddToReport(txt,0)
            else :
               self._stop_event.set()
            
# =======================================================================
#  Основные функции сервера
# =======================================================================
# Принудительно отключить всех клиентов               
def DisConnectAll():    
    if Debug : print("DisConnectAll")
    if len(connections) <= 0 :
        if Debug : print(" Клиенты :", connections)
        return
    # Ликвидировать активных агентов
    for ind in range(0,len(connections)) :     
       CL =  connections[ind]
       CL.stop()
       txt = " ID : " + str(CL.address) + " : SERVER : Запрос отключения"
       if Debug : print(txt)       
    time.sleep(4 * ONE_TIMEOUT)       
    if Debug : print(" Клиенты : ", connections)
# -------------------------------------- 
# Прочитать пароль из строки подключения клиента
def GetClientPSW(RqSock) :
    RqSock.settimeout(ONE_TIMEOUT)
    try :       
       txt = RqSock.recv(1024).decode("utf-8")
       print(txt)       
       RqSock.settimeout(None)
       lst = txt.split(cFldSep)

       if len(lst) > 0 : return lst[0]
       else : return ""     
    except :
        RqSocket.settimeout(None)
        return ""     
# -------------------------------------- 
# Ждем новых подключений
def newConnections(RqSocket):
    global Activate, Password, total_connections
    # print("connect Request")
    if not Activate : return
    while  Activate:
        try: 
           # Попытка подключить клиента  
           sock, address = RqSocket.accept()
           print("connect accept")
           # Авторизация клиента
           ClientPSW = GetClientPSW(sock)
           print(Password, ClientPSW)
           if Password == ClientPSW:
              # Позитивная квитанция 
              sock.sendall(str.encode(cRepYES))
              OkFlag = True
           else:
              # Негативная квитанция
              txt = " SERVER : client " + str(address) + " : disabled"  
              sock.sendall(str.encode(cRepNOT))
              sock.close()
              OkFlag = False
              AddToReport(txt)
        except:
           OkFlag = False
        # Создание агента клиента на сервере   
        if OkFlag:                      
           connections.append(Client(sock, address, ClientPSW, total_connections, "Name", True))
           connections[len(connections) - 1].start()
           total_connections += 1
           # Отчет
           txt = "ID : " + str(address) + " : SERVER : New client connection"
           AddToReport(txt)
# --------------------------------------                     
# Активировать сервер    
def ActivateServer():
    global SrvSocked, Password, Activate 
    try :
       # Прочитать значения host, port, listen
       host = EntriesGet(entssv, 0)             # "127.0.0.1"
       port = int(EntriesGet(entssv, 1))        # 9099
       Password = EntriesGet(entssv, 2)         # Password
       AddToReport ("host: "  + host)
       AddToReport ("port: "  + str(port))
       AddToReport ("PSW: "   + Password)
       # Создать новый socket для сервера       
       SrvSocked = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
       SrvSocked.bind((host, port))
       SrvSocked.listen(5)
       # Успешная активация
       Activate = True 
       # Ожидать подключений клиентов и для каждого подключения
       # создавать новый поток агента клиента
       newConnectionsThread = threading.Thread(target = newConnections, args = (SrvSocked,))
       newConnectionsThread.start()
       # Вывод отчета
       message1(entr_msg, "green", " Сервер успешно активирован")
    except :
       message1(entr_msg, "red", " Ошибка активации. Проверьте (HOST, PORT), закройте работающие дубликаты сервера.") 
    if Debug : print(SrvSocked)   
# --------------------------------------
# ДеАктивировать сервер    
def DeactivateServer() :
    global SrvSocked, Activate 
    if not SrvSocked : return 0
    # Отключить всех клиентов
    DisConnectAll()
    # Деактивировать сервер
    try :
       SrvSocked.close()
       Activate = False
       message1(entr_msg, "blue", " Сервер НЕ Активирован")
    except :
       if Debug : print(SrvSocked)
       message1(entr_msg, "red", " Ошибка деактивации сервера") 
    time.sleep(2 * ONE_TIMEOUT)
    if Debug : print(SrvSocked)

# =======================================================================
#  SERVICE
# =======================================================================
# --------------------------------------
# Выборка по индексу поля из текста разделенного сепараторами
def getinsplit (txt, sep, indx) :
   lst = txt.split(sep)
   if abs(indx) < len(lst) : return lst[indx]
   else : return ""

# =======================================================================
#  GUI SERVICE
# =======================================================================
# --------------------------------------
# Заполнение группы entries из списка lst
def lsttoent (lst, entries) :
    entclear (0, entries)
    if lst == [] : return
    for ind in range (0, len(lst)) :
        entr = entries[ind]
        entr.insert(0, str(lst[ind]))
# --------------------------------------
# Очистка группы entries начиная с индекса start
def entclear (start, entries) :
    for ind in range (0, len(entries)) :
        entr = entries[ind]
        entr.delete(0, END)        
# --------------------------------------
# Выборка в группе entries значения из Entry с индексом ind
def EntriesGet(entries, ind) :
    entr = entries[ind]
    return entr.get()
    
# --------------------------------------
srvparm =[['HOST :','PORT :','PSW  :'],
          ['127.0.0.1','9099','psw']]
# --------------------------------------
# Создать группу entries 
def makeform(frm, titles) :  
    entries = []
    for ic in range(0,len(titles[0])) :
        row = Frame(frm)                           # make a new row
        # add label, entry
        Label(row, width=8, text=titles[0][ic]).pack(side=LEFT) 
        entr = Entry(row)
        entr.insert(0, str(titles[1][ic]))
        entr.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # pack row on top
        row.pack(side=TOP, fill=X)                  
        entries.append(entr)     
    return entries
# --------------------------------------
# Очистить журнал операций
def ClearReport() :
    text1.delete (0.0 , END)   # Удалить все    
# --------------------------------------
# Вставить текст в конец журнала операций
def AddToReport(txt, level=1) :
    if Debug : print(txt)
    if level > 0 : 
       # text1.insert(END, txt +'\n')       # Запись в конец журнала
       text1.insert(0.0, txt +'\n')         # Запись в начало журнала   
# --------------------------------------
# Сообщение в поле Entry
def message1(entr, fontcolor, txt) :
    entr["fg"]=fontcolor
    entr.delete(0,END)
    entr.insert(0, str(txt))

# =======================================================================
#  GUI
# =======================================================================        
if __name__ == '__main__':
    root = Tk()
    root.title ('Echo SERVER. ver.1.1.')
    root.geometry ('630x250' )
    root.resizable (False, False)
    # ==========================
    frame_main1 = Frame (root)
    # ==========================
    # --------------------------
    frame_mL = Frame (frame_main1)
    # --------------------------
    # ---
    frame_parm =Frame (frame_mL)
    Label(frame_parm, width=20, text='Параметры сервера').pack(side=TOP, padx=5, pady=5)
    entssv = makeform(frame_parm, srvparm)
    frame_parm.pack(side=TOP, padx=5, pady=5)
    # --- 
    frame_btn =Frame (frame_mL)
    Button(frame_btn, width=16, text=' DisConnectAll ', command= (lambda: DisConnectAll())).pack(side=TOP, pady=5)
    Button(frame_btn, width=16, text='    Activate   ', command= (lambda: ActivateServer())).pack(side=TOP, pady=5)
    Button(frame_btn, width=16, text='  DeActivate   ', command= (lambda: DeactivateServer())).pack(side=TOP, pady=5)
    frame_btn.pack(side=TOP, padx=5, pady=5)
    # ---
    # ---------------------------
    frame_mL.pack(side=LEFT, padx=5)
    frame_mR = Frame (frame_main1)
    # ---------------------------
    # ---
    frame_rep = Frame(frame_mR)
    Label(frame_rep, width=20, text='Журнал операций').pack(side=TOP, padx=5, pady=5)
    text1 =Text(frame_rep, height = 12, width = 65, bg='gray90', font='Arial 8', wrap=WORD)
    text1.pack(side=LEFT, padx=8, pady=5)
    scrollbar = Scrollbar(frame_rep)
    scrollbar .pack(side=LEFT, fill=Y)
    scrollbar ['command' ] = text1.yview      # первая привязка
    text1['yscrollcommand' ] = scrollbar.set  # вторая привязка
    frame_rep.pack(side=TOP)
    # ---
    # --------------------------
    frame_mR.pack(side=RIGHT, padx=5)
    # --------------------------
    # ==========================
    frame_main1.pack(side=TOP)
    frame_main2 = Frame (root)
    # ==========================
    # ---
    frame_msg = Frame(frame_main2)
    Label(frame_msg, width=8, text="STATUS :").pack(side=LEFT, pady=5) 
    entr_msg = Entry(frame_msg)                # Entry для сообщений
    entr_msg.config(width=76, bg='gray90', font=('tahoma', 9)) # font=('tahoma', 10, 'bold')
    entr_msg.pack(side=TOP, fill=X, expand=YES, pady=5)
    frame_msg.pack(side=TOP)
    # ---
    # ==========================
    frame_main2.pack(side=TOP)
    # ==========================
    
    message1(entr_msg, "blue", " Сервер НЕ Активирован")
    root.mainloop()

    DisConnectAll()
    
    print ("Сервер завершил работу")
    sys.exit(0)

