"""
use Entry widgets directly
lay out by rows with fixed-width labels: this and grid are best for forms
"""

from tkinter   import *
from math      import pow
from Tools.slse_gauss import slse_gauss

# Запрос на отладочный вывод с помощью print
debugf = False

# Подписи к полям Entry
lbxy =[['x0','x1','x2','x3','x4','x5','x6','x7',
        'x8','x9','x10','x11','x12','x13','x14','x15',
        'x16','x17','x18','x19','x20','x21','x22','x23'],
       ['y0','y1','y2','y3','y4','y5','y6','y7','y8',
        'y9','y10','y11','y12','y13','y14','y15',
        'y16','y17','y18','y19','y20','y21','y22','y23']]

lbap =[['a0','a1','a2','a3','a4','a5','a6'],
       ['p0','p1','p2','p3','p4','p5','p6']]

# Тестовый пример для заполнения ents1
tst1 = [-1,-11.41,
        -0.8,-10.5317376,
        -0.6,-10.1136544,
        -0.4,-9.9512704,
        -0.2,-9.9322656,
         0,-10,
         0.2,-10.1239456,
         0.4,-10.2770304,
         0.6,-10.4198944,
         0.8,-10.4920576,
         1,-10.41,
         1.2,-10.0721536,
         1.4,-9.3708064,
         1.6,-8.2109184,
         1.8,-6.5358496,
         2,-4.36,
         2.2,-1.8083616,
         2.4,0.8370176,
         2.6,3.0836576,
         2.8,4.1683584,
         3,2.99,
         3.2,-1.9645696,
         3.4,-12.7015584]


lstx  = []
lsty  = []

# =========== GUI ======================
# Создать группу entries для ввода X и Y
def makeform1(root, titles) :  
    entries1 = []
    for ic in range(0,len(titles[0])) :
        row = Frame(root)                           # make a new row
        # add label, entry
        Label(row, width=5, text=titles[0][ic]).pack(side=LEFT) 
        ent1 = Entry(row)
        ent1.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # add label, entry
        Label(row, width=5, text=titles[1][ic]).pack(side=LEFT)
        ent2 = Entry(row)
        ent2.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # pack row on top
        row.pack(side=TOP, fill=X)                   
        entries1.append(ent1)
        entries1.append(ent2)
    return entries1
# --------------------------------------
# Создать группу entries для вывода коэффициентов
# интерполяции [a0,a1, ... an]
def makeform2(root, titles) :  
    entries2 = []
    for ic in range(0,len(titles[0])) :
        row = Frame(root)                           # make a new row
        # add label, entry
        Label(row, width=5, text=titles[0][ic]).pack(side=LEFT) 
        ent3 = Entry(row)
        ent3.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # pack row on top
        row.pack(side=TOP, fill=X)                  
        entries2.append(ent3)     
    return entries2

# =========== APPROXIMATION ================
# Сообщение в поле Entry
def message1(entr, mess) :
    entr.delete(0,END)
    entr.insert(0, str(mess))
    
# --------------------------------------
# Проверить и получить степень последнего члена аппроксимирующего ряда
def getian(entr) :
    try :
       ian = int(entr.get())
       if ian > 6 : ian = 6
       if ian < 1 : ian = 1
    except :
       ian = 1
    entr.delete(0,END)
    entr.insert(0, str(ian))
    return ian

# --------------------------------------
# Выборка в группе entries значения из Entry с индексом ind
def getdat(entries, ind) :
    entr = entries[ind]
    try  :
       if str(entr.get()) == '' :
          return [1, None]    
       else :       
          return [0,float(str(entr.get()))]
    except :
       entr.delete(0, END)    
       entr.insert(0, 'error')
       return [2, None]

# --------------------------------------
# Очистка группы entries начиная с индекса start
def entclear (start, entries) :
    for ind in range (0, len(entries)) :
        entr = entries[ind]
        entr.delete(0, END)

# --------------------------------------
# Заполнение группы entries из списка lst
def lsttoent (lst, entries) :
    entclear (0, entries)
    if lst == [] : return
    for ind in range (0, len(lst)) :
        entr = entries[ind]
        entr.insert(0, str(lst[ind]))

# --------------------------------------            
# Создать матрицу формата
# [x0,x1, ... xn]            
def makex(entries) :
    lstx.clear()
    for ind in range (0, len(entries)) :
        dat = getdat(entries, ind)
        if (dat[0] == 0) : 
           if (ind % 2) == 0 :
              lstx.append(dat[1])     
        else  :  break
    if debugf :
       print('makex. Матрица формата [x0,x1, ... xn] : ')
       print(lstx)
    return lstx

# --------------------------------------    
# Создать матрицу формата
# [y0,y1, ... yn]            
def makey(entries) :
    lsty.clear()
    for ind in range (0, len(entries)) :
        dat = getdat(entries, ind)   
        if (dat[0] == 0) : 
           if (ind % 2) != 0 :
               lsty.append(dat[1])
        else  :  break
    if debugf :
           print('makey. Матрица формата [y0,y1, ... yn] : ')
           print(lsty)
    return lsty

# --------------------------------------    
# Создать систему линейных уравнений для
# аппроксимации степенным многочленом
def makeslse_ap(entsxy, ian) :
    # ian - индекс коэффициента ian
    # k   - индекс указывает на конкретную строку в системе уравнений
    # n   - индекс перечисляет базисные функции v(x) или колонки системы уравнений 
    # m   – индекс перечисляет точки аргумента(x).
    slse = []
    lstx = makex(entsxy)
    lsty = makey(entsxy)
    # Контроль выполнимости
    if len(lstx) != len(lsty) :
       message1(entr_msg, ' Длины таблиц xn и yn не совпадают')
       return  []
    if len(lstx) < (ian + 1) :
       message1(entr_msg, ' Необходимо уменьшить значение n (которое сейчас = ' + str(ian)
                + ') или длина таблиц должа быть >= ' + str(ian+1))
       return  []
    # Создание матрицы системы линейных уравнений
    for k in range(0, ian + 1) :
        slse_k = []
        bk     = 0
        for m in range(0, len(lstx)) :
            bk  += lsty[m]*pow(lstx[m],k)
        for n in range(0, ian + 1) :
            ckn = 0
            for m in range(0, len(lstx)) :
                ckn += pow(lstx[m],k)*pow(lstx[m], n)                
            slse_k.append(ckn)
        slse_k.append(bk)
        slse.append(list(slse_k))
    if debugf :
           print('makeslse_ap. Матрица системы линейных уравнений : ')
           print(slse)       
    return slse

# --------------------------------------
# Вычислить по коэффициентам an степенной многочлен в точке x
def ppoly(an, x) :
   s = 0
   for n in range(0, len(an)) : s+=an[n]*pow(x, n)
   return s

# --------------------------------------
# Отобразить абсолютные ошибки по результатам аппроксимации
def showdelta (an) :
    dymax = 0
    text1 .delete (1.0 , END)   # Удалить все
    for m in range(0, len(lstx)) : 
        dy = lsty[m] - ppoly(an, lstx[m])
        if abs(dy) > dymax : dymax = abs(dy)
        # Вставить текст строки в конец списка строк
        text1.insert(END, 'x = ' + str(lstx[m]) + '   dy = ' + str(dy)+'\n')
    text1.insert(END, 'Абс.макс.ошибка = ' + str(dymax)+'\n')

# --------------------------------------          
# Выполнить аппроксимацию путем решения
# системы линейных уравнений
def run(entsxy, entsroots) :
    ian = getian(ent_p)
    entclear (0, entsroots)
    message1(entr_msg, ' ')
    sls = makeslse_ap(entsxy, ian)   
    if sls == [] : return []
    roots = slse_gauss(sls, debugf)
    lsttoent (roots, entsroots)
    showdelta(roots)
    if debugf :
       print('run. Список корней системы линейных уравнений : ')
       print(roots)
    if roots == [] :
       message1(entr_msg, ' Аппроксимация невозможна. Матрица системы уравнений плохо обусловлена')   
       return  []
    paint(canvas, roots)
    return roots

# =========== ГРАФИКА ==================
# Набор данных для построения графика
GWdW = 600  #  Ширина виджета Canvas
GWdH = 320  #  Высота виджета Canvas
brX = 50    #  Горизонтальные бордюры для графика
brY = 20    #  Вертикальные бордюры для графика
grW = GWdW - 2 * brX     #  Ширина графика
grH = GWdH - 2 * brY     #  Высота графика
titenum = 10;            #  Число подписей на оси Y и X
scx = []    #  мин., макс. и масштаб лля Аргументов
scy = []    #  мин., макс. и масштаб для Значений

# --------------------------------------
# Вычислить по коэффициентам an степенной многочлен в точке x
def ppoly(an, x) :
   s = 0
   for n in range(0, len(an)) : s+=an[n]*pow(x, n)
   return s
# --------------------------------------
#  Вычислить мин., макс. и масштаб : [min, max, scale]
def scl(glen, sc, lst) :
    sc.clear() 
    sc.append(min(lst))
    sc.append(max(lst))
    try :
       sc.append(glen /(sc[1]-sc[0]))
    except :
       sc.append(0)   
# --------------------------------------
#  Получить аргумент в масштабе графика
def xtopix(sc, x) :
    return brX + sc[2]*(x-sc[0])
# --------------------------------------
#  Получить значение в масштабе графика
def ytopix(sc, y) :
    return brY + grH - sc[2]*(y-sc[0])
# --------------------------------------
# Очистить график
def clear(canvas) :
    canvas.delete('all')    
# --------------------------------------
# Прорисовать графики
def paint(canvas, an) :
   clear(canvas)
   # -------- ОСИ  
   scl(grW, scx, lstx)   # Мин., макс. и масштаб для Аргументов
   scl(grH, scy, lsty)   # Мин., макс. и масштаб для Значений
   # Опорные точки осей
   xb = xtopix(scx,scx[0])
   xe = xtopix(scx,scx[1])
   yb = ytopix(scy,scy[0])
   ye = ytopix(scy,scy[1])
   # Прорисовать оси X и Y
   canvas.create_line(xb, yb, xe, yb, width=2) # Ось X
   canvas.create_line(xb, ye, xb, yb, width=2) # Ось Y
   # Прорисовать подписи на оси X
   yb = ytopix(scy,scy[0])
   i, xr, xstep = 0, scx[0], (scx[1]-scx[0])/(titenum -1)
   while i < titenum :
      x = xtopix(scx,xr)
      canvas.create_line(x, yb, x, yb - 5, width=2)
      canvas.create_text(x, yb + 4, text='%3.1f'% (xr), anchor=N)
      xr+=xstep
      i+=1
   # Прорисовать подписи на оси Y
   i, yr, ystep = 0, scy[0], (scy[1]-scy[0])/(titenum -1)
   while i < titenum :
      y = ytopix(scy,yr) 
      canvas.create_line(xb, y, xb + 5, y, width=2)
      canvas.create_text(xb - 6, y, text='%5.1f'% (yr), anchor=E)
      yr+=ystep
      i+=1
   # -------- ГРАФИКИ
   # ---- График исходных данных
   # Вычислить X и Y в масштабе графика
   scaled = []
   for i in range(0, len(lstx)) :
     x = xtopix(scx, lstx[i])
     y = ytopix(scy, lsty[i])
     scaled.append((x, y)) 
   # Прорисовать график исходных данных  
   # При smooth=1 применяется сглаживание на изломах линии     
   canvas.create_line(scaled, fill='black', smooth=0)  
   if debugf :
      print('paint. Масштабированная матрица для визуализации : ')
      print(scaled)
   # Прорисовать точки на графике исходных данных   
   for x,y in scaled : 
      canvas.create_oval(x - 3, y - 3, x + 3, y + 3, width=1,
                         outline='black', fill='SkyBlue2')
   # ---- График полином(X)
   # Вычислить X и полином(X) в масштабе графика
   scaled.clear()
   xnum = 50
   xstep = (scx[1]-scx[0])/xnum
   for i in range(0, xnum + 1) :
     x = scx[0] + xstep * i 
     y = ppoly(an, x)
     x = xtopix(scx, x)
     y = ytopix(scy, y)
     scaled.append((x, y))
   # Прорисовать график полинома     
   # При smooth=1 применяется сглаживание на изломах линии     
   canvas.create_line(scaled, fill='red', smooth=0)   


# =========== GUI ======================    
if __name__ == '__main__':
    root = Tk()
    root.title ('Аппроксимация табличной функции степенным многочленом')
    root.geometry ('940x640' )
    root.resizable (False, False)
    # ===== frame_m1 ==========
    frame_m1 = Frame (root)
    # --- frame_xy
    frame_xy = Frame (frame_m1, bd=1)
    Label(frame_xy, width=50, text='Введите аргумент и значение функции').pack(side=TOP)
    Label(frame_xy, width=50, text='Минимальное число отсчетов (xn, yn) >= 2').pack(side=TOP)
    ents1 = makeform1(frame_xy, lbxy)
    frame_xy.pack(side=TOP)
    # ---- Frame_tst
    frame_tst = Frame (frame_m1, bd=1)
    Button(frame_tst, text=' Подготовить тест ', command= (lambda: lsttoent(tst1, ents1))).pack(side=LEFT)
    frame_tst.pack(side=TOP, padx=5, pady=5)
    # ----
    frame_m1.pack(side=LEFT)
    # ==========================
    # ======= frame_m2 =========
    frame_m2 = Frame (root)
    frame_m2up = Frame (frame_m2)
    # ======= frame_m21
    frame_m21 = Frame (frame_m2up) 
    # --- frame_an
    frame_an =Frame (frame_m21)
    Label(frame_an, width=20, text='an : ( n <= 6 или n >= 1)').pack(side=TOP, padx=5, pady=5)
    ent_p = Entry(frame_an, width=10)
    ent_p.insert(0, '2')
    ent_p.pack(side=LEFT, padx=5, pady=5)
    Button(frame_an, text=' Старт ', command= (lambda: run(ents1,ents2 ))).pack(side=LEFT)
    frame_an.pack(side=TOP)
    # --- frame_coef
    frame_coef =Frame (frame_m21)
    Label(frame_coef, width=20, text='Коэффициенты ряда').pack(side=TOP)
    ents2 = makeform2(frame_coef, lbap)
    frame_coef.pack(side=LEFT) 
    # -------
    frame_m21.pack(side=LEFT)
    # ======= frame_m22
    frame_m22 = Frame (frame_m2up) 
    # --- frame_rep
    frame_rep = Frame(frame_m22)
    Label(frame_rep, width=20, text='Журнал операций').pack(side=TOP, padx=5, pady=5)
    text1 =Text(frame_rep, height = 12, width = 65, font='Arial 8', wrap=WORD)
    text1.pack(side=LEFT, padx=8, pady=5)
    scrollbar = Scrollbar(frame_rep)
    scrollbar .pack(side=LEFT, fill=Y)
    scrollbar ['command' ] = text1.yview      # первая привязка
    text1['yscrollcommand' ] = scrollbar.set  # вторая привязка
    frame_rep.pack(side=TOP)
    frame_m22.pack(side=RIGHT)
    # -------
    frame_m2up.pack(side=TOP)
    # =======
    # ======= frame_m2dn
    frame_m2dn = Frame (frame_m2)
    frm_gr = Frame(frame_m2dn, bd=0)
    # -------
    entr_msg = Entry(frame_m2dn)                    # Entry для сообщений
    entr_msg.config(width=40, bg='silver', font=('times', 10, 'bold'))
    entr_msg.pack(side=TOP, fill=X, expand=YES, padx=5, pady=5)
    # -------
    canvas = Canvas(frm_gr, width=GWdW, height=GWdH, bg = 'gray90')
    canvas.pack(side=TOP)
    frm_gr.pack(side=TOP, padx=5, pady=5)
    frame_m2dn.pack(side=TOP)
    # =======
    frame_m2.pack(side=RIGHT)
    # ==========================
    
    
    root.mainloop()
