"""
use Entry widgets directly
lay out by rows with fixed-width labels: this and grid are best for forms
"""

from tkinter   import *
from math      import pow
from Tools.slse_gauss import slse_gauss

# Запрос на отладочный вывод с помощью print
debugf = False

# Подписи к полям Entry
lbxy =[['x0','x1','x2','x3','x4','x5','x6','x7','x8','x9','x10','x11','x12','x13','x14','x15'],
       ['y0','y1','y2','y3','y4','y5','y6','y7','y8','y9','y10','y11','y12','y13','y14','y15']]

lbap =[['a0','a1','a2','a3','a4'],
       ['p0','p1','p2','p3','p4']]

# Тестовый пример для заполнения ents1
tst1 = [1, 1, 2, 4, 3, 9, 4, 16, 5, 25, 6, 36, 7, 49, 8, 64]

global lstx
global lsty
lstx  = []
lsty  = []

# =========== GUI ======================
# Создать группу entries для ввода X и Y
def makeform1(root, titles) :  
    entries1 = []
    for ic in range(0,len(titles[0])) :
        row = Frame(root)                           # make a new row
        # add label, entry
        Label(row, width=5, text=titles[0][ic]).pack(side=LEFT) 
        ent1 = Entry(row)
        ent1.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # add label, entry
        Label(row, width=5, text=titles[1][ic]).pack(side=LEFT)
        ent2 = Entry(row)
        ent2.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # pack row on top
        row.pack(side=TOP, fill=X)                   
        entries1.append(ent1)
        entries1.append(ent2)
    return entries1
# --------------------------------------
# Создать группу entries для вывода коэффициентов
# интерполяции [a0,a1, ... an]
def makeform2(root, titles) :  
    entries2 = []
    for ic in range(0,len(titles[0])) :
        row = Frame(root)                           # make a new row
        # add label, entry
        Label(row, width=5, text=titles[0][ic]).pack(side=LEFT) 
        ent3 = Entry(row)
        ent3.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # pack row on top
        row.pack(side=TOP, fill=X)                  
        entries2.append(ent3)     
    return entries2

# =========== APPROXIMATION ================
# Сообщение в поле Entry
def message1(entr, mess) :
    entr.delete(0,END)
    entr.insert(0, str(mess))
    
# --------------------------------------
# Проверить и получить степень последнего члена аппроксимирующего ряда
def getian(entr) :
    try :
       ian = int(entr.get())
       if ian > 4 : ian = 4
       if ian < 1 : ian = 1
    except :
       ian = 1
    entr.delete(0,END)
    entr.insert(0, str(ian))
    return ian

# --------------------------------------
# Выборка в группе entries значения из Entry с индексом ind
def getdat(entries, ind) :
    entr = entries[ind]
    try  :
       if str(entr.get()) == '' :
          return [1, None]    
       else :       
          return [0,float(str(entr.get()))]
    except :
       entr.delete(0, END)    
       entr.insert(0, 'error')
       return [2, None]

# --------------------------------------
# Очистка группы entries начиная с индекса start
def entclear (start, entries) :
    for ind in range (0, len(entries)) :
        entr = entries[ind]
        entr.delete(0, END)

# --------------------------------------
# Заполнение группы entries из списка lst
def lsttoent (lst, entries) :
    entclear (0, entries)
    if lst == [] : return
    for ind in range (0, len(lst)) :
        entr = entries[ind]
        entr.insert(0, str(lst[ind]))

# --------------------------------------            
# Создать матрицу формата
# [x0,x1, ... xn]            
def makex(entries) :
    lstx.clear()
    for ind in range (0, len(entries)) :
        dat = getdat(entries, ind)
        if (dat[0] == 0) : 
           if (ind % 2) == 0 :
              lstx.append(dat[1])     
        else  :  break
    if debugf :
       print('makex. Матрица формата [x0,x1, ... xn] : ')
       print(lstx)
    return lstx

# --------------------------------------    
# Создать матрицу формата
# [y0,y1, ... yn]            
def makey(entries) :
    lsty.clear()
    for ind in range (0, len(entries)) :
        dat = getdat(entries, ind)   
        if (dat[0] == 0) : 
           if (ind % 2) != 0 :
               lsty.append(dat[1])
        else  :  break
    if debugf :
           print('makey. Матрица формата [y0,y1, ... yn] : ')
           print(lsty)
    return lsty

# --------------------------------------    
# Создать систему линейных уравнений для
# аппроксимации степенным многочленом
def makeslse_ap(entsxy, ian) :
    # ian - индекс коэффициента ian
    # k   - индекс указывает на конкретную строку в системе уравнений
    # n   - индекс перечисляет базисные функции v(x) или колонки системы уравнений 
    # m   – индекс перечисляет точки аргумента(x).
    slse = []
    lstx = makex(entsxy)
    lsty = makey(entsxy)
    # Контроль выполнимости
    if len(lstx) != len(lsty) :
       message1(entr_msg, ' Длины таблиц xn и yn не совпадают')
       return  []
    if len(lstx) < (ian + 1) :
       message1(entr_msg, ' Необходимо уменьшить значение n (которое сейчас = ' + str(ian)
                + ') или длина таблиц должа быть >= ' + str(ian+1))
       return  []
    # Создание матрицы системы линейных уравнений
    for k in range(0, ian + 1) :
        slse_k = []
        bk     = 0
        for m in range(0, len(lstx)) :
            bk  += lsty[m]*pow(lstx[m],k)
        for n in range(0, ian + 1) :
            ckn = 0
            for m in range(0, len(lstx)) :
                ckn += pow(lstx[m],k)*pow(lstx[m], n)                
            slse_k.append(ckn)
        slse_k.append(bk)
        slse.append(list(slse_k))
    if debugf :
           print('makeslse_ap. Матрица системы линейных уравнений : ')
           print(slse)       
    return slse

# --------------------------------------
# Вычислить по коэффициентам an степенной многочлен в точке x
def ppoly(an, x) :
   s = 0
   for n in range(0, len(an)) : s+=an[n]*pow(x, n)
   return s

# --------------------------------------
# Отобразить абсолютные ошибки по результатам аппроксимации
def showdelta (an) :
    dymax = 0
    text1 .delete (1.0 , END)   # Удалить все
    for m in range(0, len(lstx)) : 
        dy = lsty[m] - ppoly(an, lstx[m])
        if abs(dy) > dymax : dymax = abs(dy)
        # Вставить текст строки в конец списка строк
        text1.insert(END, 'x = ' + str(lstx[m]) + '   dy = ' + str(dy)+'\n')
    text1.insert(END, 'Абс.макс.ошибка = ' + str(dymax)+'\n')

# --------------------------------------          
# Выполнить аппроксимацию путем решения
# системы линейных уравнений
def run(entsxy, entsroots) :
    ian = getian(ent_p)
    entclear (0, entsroots)
    message1(entr_msg, ' ')
    sls = makeslse_ap(entsxy, ian)   
    if sls == [] : return []
    roots = slse_gauss(sls, debugf)
    lsttoent (roots, entsroots)
    showdelta(roots)
    if debugf :
       print('run. Список корней системы линейных уравнений : ')
       print(roots)
    if roots == [] :
       message1(entr_msg, ' Аппроксимация невозможна. Матрица системы уравнений плохо обусловлена')   
       return  []   
    return roots



# =========== GUI ======================    
if __name__ == '__main__':
    root = Tk()
    root.title ('Аппроксимация табличной функции степенным многочленом')
    root.geometry ('610x450' )
    root.resizable (False, False)
    # --- frame_m1 ------
    frame_m1 = Frame (root)
    # --- frame_xy
    frame_xy = Frame (frame_m1, bd=1)
    Label(frame_xy, width=50, text='Введите аргумент и значение функции').pack(side=TOP)
    Label(frame_xy, width=50, text='Минимальное число отсчетов (xn, yn) >= 2').pack(side=TOP)
    ents1 = makeform1(frame_xy, lbxy)
    Label(frame_xy, width=1, text=' ').pack(side=TOP)
    Label(frame_xy, width=1, text=' ').pack(side=LEFT)
    Button(frame_xy, text=' Подготовить тест ', command= (lambda: lsttoent(tst1, ents1))).pack(side=LEFT)
    Label(frame_xy, width=20, text=' - тестовый пример         ').pack(side=LEFT)
    frame_xy.pack(side=LEFT)
    # --- frame_a
    frame_a =Frame (frame_m1)
    Label(frame_a, width=20, text='an : ( n <= 4 или n >= 1)').pack(side=TOP)
    ent_p = Entry(frame_a)
    ent_p.insert(0, '2')
    ent_p.pack(side=TOP)
    Label(frame_a, width=20, text='Коэффициенты ряда').pack(side=TOP)
    ents2 = makeform2(frame_a, lbap)
    # --- frame_run
    frame_run = Frame(frame_a)
    Label(frame_run, width=1, text=' ').pack(side=TOP)
    Label(frame_run, width=1, text=' ').pack(side=LEFT)
    Button(frame_run, text=' Старт ', command= (lambda: run(ents1,ents2 ))).pack(side=LEFT)
    Label(frame_run, width=25, text=' - выполнить аппроксимацию    ').pack(side=LEFT)
    frame_run.pack(side=TOP)
    # --- frame_a
    Label(frame_a, width=1, text=' ').pack(side=TOP)
    Label(frame_a, width=20, text='Журнал операций').pack(side=TOP)
    Label(frame_a, width=1, text=' ').pack(side=LEFT)
    text1 =Text(frame_a, height = 12, width = 40, font='Arial 8', wrap=WORD)
    text1.pack(side=LEFT)
    scrollbar = Scrollbar(frame_a)
    scrollbar .pack(side=LEFT, fill=Y)
    scrollbar ['command' ] = text1.yview      # первая привязка
    text1['yscrollcommand' ] = scrollbar.set  # вторая привязка
    frame_a.pack(side=RIGHT)
    frame_m1.pack(side=TOP)
    # --- root ------
    Label(root, width=1, text=' ').pack(side=TOP)
    entr_msg = Entry(root)                    # Entry для сообщений
    entr_msg.config(width=40, bg='silver', font=('times', 10, 'bold'))
    # entr_msg.config(width=40, bg='silver', font=('times', 10, 'bold', 'italic'))
    entr_msg.pack(side=TOP, fill=X, expand=YES)
    # message1(entr_msg, ' Старт приложения ')
    root.mainloop()
