﻿# Solving Linear Systems of Equations (GAUSS) 
# РЕШЕНИЕ СИСТЕМЫ ЛИНЕЙНЫХ УРАВНЕНИЙ МЕТОДОМ ГАУССА
#
#  slse_gauss(rq_tab, fdebug : bool = False)
#
#  Параметры:
#
#   fdebug - Запрос на печать отладочной инфармации : True
#
#   rq_tab - Исходная матрица системы линейных уравнений вида:
#
#      [[a01, a02, a03, a04, ...., a0n, b0],
#       [a11, a12, a13, a14, ...., a1n, b1],
#        ...........................
#       [an1, an2, an3, an4, ...., ann, bn]]
# 
#   return - Пустой список [] или список корней вида:
#
#       [x0, x1, x2, x3, ...., xn]
# 
def slse_gauss(rq_tab, fdebug : bool = False) :
   # Граничный допуск на плохо обусловленную матрицу
   tol = 1.0E-18;
   # Полная копия исходной матрицы rq_tab
   tab=[]
   for ir in range(0, len(rq_tab)) :
       tab.append(list(rq_tab[ir]))
   if fdebug :
      print('slse_gauss. Исходная матрица :')
      print(tab)    
   # ==========================
   # Входной контроль
   if tab is None :
       print('slse_gauss. Матрица системы уравнений не задана');
       return
   # Число строк в матрице
   max_row = len(tab);
   # Число коэффициентов в строке матрицы
   max_col = len(tab[1]);
   if (max_col < 2) | (max_col != max_row+1) :
      print('slse_gauss. Размеры матрицы системы уравнений заданы неправильно');
      return [] 
   # ==========================
   # Постороение Гауссовой матрицы
   # i   - Рабочий индекс
   # ir  - Рабочий индекс строки
   # ic  - Рабочий индекс столбца
   # tmp - Рабочая переменная
   for i in range(0, max_row) :
      imr = i;                    # Индекс строки  ведущего (master) элемента
      imc = i;                    # Индекс столбца ведущего (master) элемента 
      # --------------------
      # Найти максимальный ведущий (master) элемент в субматрице
      tmp = abs(tab[imr][imc]);
      icr = imr;                  
      for ir in range(imr, max_row) :
         if tmp < abs(tab[ir][imc]) : 
            tmp = abs(tab[ir][imc]);
            icr = ir;
      # icr - Индекс строки с максимальным ведущим элементом                 
      # --------------------
      # Установить строку с максимальным ведущим элементом
      # как первую строку субматрицы.
      if imr != icr : 
         for ic in range(0, max_col) :
            tmp = tab[imr][ic];
            tab[imr][ic] = tab[icr][ic];
            tab[icr][ic] = tmp;              
      # --------------------
      # Отнормировать к единице ведущий элемент ()
      tmp = tab[imr][imc];
      if abs(tmp) > tol :
         for ic in range(0,max_col) :
            tab[imr][ic] = tab[imr][ic] / tmp;
            # for ic
         ok = True;
      else :
         ok = False;
         print('slse_gauss. Матрица плохо обусловлена');
         return []   
      # --------------------
      # Построить субматрицу для ведущего элемента tab[imr][imc]
      if imr < max_row :
         # субматрица существует
         for ir in range(imr + 1, max_row) :
            # Для всех строк субматрицы
            tmp = tab[ir][imc];
            for ic in range(0, max_col) : 
               # Для всех столбцов
               tab[ir][ic] = tab[ir][ic] - tab[imr][ic] * tmp;            
   # end of for im
   # ==========================
   if fdebug :
      print('slse_gauss. Гауссова форма исходной матрицы :')
      print(tab)                    
   # ==========================
   if ok :
     roots =[0]*max_row;
     ire  = len(tab)-1     # Индекс последней строки
     ice  = ire+1;         # Индекс колонки B
     icxe = ice-1;         # Мндекс колонки Xn
     # print(ire, ice, icxe)
     roots[icxe] = tab[ire][ice]
     wr = ire - 1
     while wr >= 0 :
        wx =tab[wr][ice];
        wc = wr;
        while wc <= icxe :
           wx-=tab[wr][wc]*roots[wc]
           wc+=1
           roots[wr] = wx  
        wr-=1
     # end of while wr
     if fdebug :
        print('slse_gauss. Корни системы уравнений в формате [x0, x1, ...xn] :')
        print(roots)
     return roots[:]
   # end of if ok  
# ==========================                 
# end of slse_gauss

def test_slse() :
   # корни : 1, 2, 3. 4
   tab1 = [[ 1, 2, 3, 4, 30],
           [ 2, 7, 1, 8, 51],
           [-1,-2,-3,-6,-38],
           [ 1,-5, 8, 3,27]];
   print('testSLS :')
   print(slse_gauss(tab1))
# ==========================                 
# end of testSLS
   

