"""
use Entry widgets directly
lay out by rows with fixed-width labels: this and grid are best for forms
"""

from tkinter   import *
from math      import pow
from Tools.slse_gauss import slse_gauss

# Запрос на отладочный вывод с помощью print
debugf = False

# Подписи к полям Entry
lbxy =[['x0','x1','x2','x3','x4','x5','x6','x7','x8','x9'],
       ['y0','y1','y2','y3','y4','y5','y6','y7','y8','y9']]

lbap =[['a0','a1','a2','a3','a4','a5','a6','a7','a8','a9'],
       ['p0','p1','p2','p3','p4','p5','p6','p7','p8','p9']]

# Набор тестовых данных
tst1 = [1, 2, 2, 5, 3, 10, 4, 17, 5, 10, 6, 8, 7, 3, 8, -5]

lstx  = []  #  Аргументы 
lsty  = []  #  Значения
lstxy = []  #  Аргументы и значения в формате список списков

# =========== СЕРВИС ===================
# Сообщение в поле Entry
def message1(entr, mess) :
    entr.delete(0,END)
    entr.insert(0, str(mess))
    
# =========== GUI ======================
# Создать группу entries для ввода X и Y
def makeform1(root, titles) :  
    entries1 = []
    for ic in range(0,len(titles[0])) :
        row = Frame(root)                           # make a new row
        # add label, entry
        Label(row, width=5, text=titles[0][ic]).pack(side=LEFT) 
        ent1 = Entry(row)
        ent1.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # add label, entry
        Label(row, width=5, text=titles[1][ic]).pack(side=LEFT)
        ent2 = Entry(row)
        ent2.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # pack row on top
        row.pack(side=TOP, fill=X)                   
        entries1.append(ent1)
        entries1.append(ent2)
    return entries1
# --------------------------------------
# Создать группу entries для вывода коэффициентов
# интерполяции [a0,a1, ... an]
def makeform2(root, titles) :  
    entries2 = []
    for ic in range(0,len(titles[0])) :
        row = Frame(root)                           # make a new row
        # add label, entry
        Label(row, width=5, text=titles[0][ic]).pack(side=LEFT) 
        ent3 = Entry(row)
        ent3.pack(side=LEFT, expand=NO, fill=X)     # grow horizontal
        # pack row on top
        row.pack(side=TOP, fill=X)                  
        entries2.append(ent3)     
    return entries2

# =========== INTERPOLATION ================
# Выборка в группе entries значения из Entry с индексом ind
def getdat(entries, ind) :
    entr = entries[ind]
    try  :
       if str(entr.get()) == '' :
          return [1, None]    
       else :       
          return [0,float(str(entr.get()))]
    except :
       entr.delete(0, END)    
       entr.insert(0, 'error')
       return [2, None]
# --------------------------------------
# Очистка группы entries начиная с индекса start
def entclear (start, entries) :
    for ind in range (0, len(entries)) :
        entr = entries[ind]
        entr.delete(0, END)
# --------------------------------------
# Заполнение группы entries из списка lst
def lsttoentr (lst, entries) :
    entclear (0, entries)
    if lst == [] : return
    # if len(lst) != len(entries) :  return
    for ind in range (0, len(lst)) :
        entr = entries[ind]
        entr.insert(0, str(lst[ind]))    
# --------------------------------------        
# Создать матрицу формата
# [[x0,x1, ... xn],[y0,y1, ... yn]]            
def makexy(entries) :
    lstx.clear()
    lsty.clear()
    lstxy.clear()
    for ind in range (0, len(entries)) :
        dat = getdat(entries, ind)   
        if (dat[0] == 0) : 
           if (ind % 2) : lsty.append(dat[1])
           else : lstx.append(dat[1])
        else  :  break
    if (len(lstx) == len(lsty)) & (len(lstx) > 1) :
        lstxy.append(list(lstx))
        lstxy.append(list(lsty))
        if debugf :
           print('makexy. Матрица формата [[x0,x1, ... xn],[y0,y1, ... yn]] : ')
           print(lstxy)
        return lstxy
    else :
        # Контроль выполнимости
        if len(lstx) < 2 :
           message1(entr_msg, ' Длина таблицы Xn меньше двух точек')
           return  [] 
        if len(lstx) > len(lsty) :
           message1(entr_msg, ' Длина таблицы Yn меньше длины таблицы Xn')
           return  []    
# --------------------------------------
# Создать систему линейных уравнений для
# интерполяции степенным многочленом
def makesls(entries) :
     xy = makexy(entries)
     if xy == [] : return []
     else : 
        sls = []
        for ir in range(0, len(xy[1])) :
            pwx = []   
            for ic in range(0, len(xy[0])) :
                pwx.append(pow(xy[0][ir],ic))
            pwx.append(xy[1][ir])                
            sls.append(list(pwx))
     if debugf :
           print('makesls. Матрица системы линейных уравнений : ')
           print (sls)                   
     return sls
   
# =========== RUN ======================
# Выполнить интерполяцию путем решения
# системы линейных уравнений
def run(entsxy, entsroots) :
    entclear (0, entsroots)
    message1(entr_msg, ' ')
    sls = makesls(entsxy)
    if sls == [] : return []
    roots = slse_gauss(sls, debugf)
    if debugf :
       print('run. Список корней системы линейных уравнений : ')
       print(roots)
    if len(roots) > 0 :
       lsttoentr(roots, entsroots) 
       message1(entr_msg, ' Успешное завершение')
    else :
       message1(entr_msg, ' Не могу найти коэффициенты полинома')
       return []
    return roots

# =========== GUI ======================    
if __name__ == '__main__':  
    root = Tk()
    root.title ('Интерполяция табличной функции')
    root.geometry ('530x290' )
    root.resizable (False, False)
    # ------------------------
    frame1 = Frame(root, bd=0)
    # ---
    frame1L = Frame(frame1, bd=0)
    Label(frame1L, width=45, text='Введите аргументы и значения функции').pack(side=TOP)
    ents1 = makeform1(frame1L, lbxy)
    frame1L.pack(side=LEFT, padx=5, pady=5)
    # ---
    frame1R = Frame(frame1, bd=0)
    Label(frame1R, width=45, text='Коэффициент степенного ряда').pack(side=TOP)
    ents2 = makeform2(frame1R, lbap)
    frame1R.pack(side=RIGHT, padx=5, pady=5)
    # ---
    frame1.pack(side=TOP)
    # ------------------------
    frame3 = Frame(root, bd=0)
    Button(frame3, text=' Загрузить тестовый пример ',
           command= (lambda: lsttoentr(tst1, ents1))).pack(side=LEFT, padx=5)
    Button(frame3, text=' Выполнить интерполяцию ',
           command= (lambda: run(ents1, ents2 ))).pack(side=LEFT, padx=5)
    frame3.pack(side=TOP, padx=5, pady=5)
    # ------------------------
    frmMsg = Frame(root, bd=0)
    Label(frmMsg, width=12, text='Сообщение :').pack(side=LEFT, padx=5)
    entr_msg = Entry(frmMsg)           # Entry для сообщений
    entr_msg.config(width=50, bg='silver', font=('times', 10, 'bold'))
    entr_msg.pack(side=TOP, fill=X, expand=YES)
    frmMsg.pack(side=TOP, padx=5, pady=5)
    # ------------------------
    root.mainloop()
