import sys
from tkinter import *
from slse_gauss import *    # test_slse, slse_gauss

Debug = False

# --------------------
# корни : 1, 2, 3. 4
test1 = [[ 1, 2, 3, 4,  30],
         [ 2, 7, 1, 8,  51],
         [-1,-2,-3,-6, -38],
         [ 1,-5, 8, 3,  27]]
# --------------------
# корни : -5, -0.5, -0.7, 0.5
test2 = [[1, -1,  1, -1, -5.7],
         [1,  0,  0,  0,   -5],
         [1,  1,  1,  1, -5.7],
         [1,  2,  4,  8, -4.8]]
# --------------------
# Размеры матрицы системы линейных уравнений
tabrow, tabcol   = 4, 5
# Рабочий индекс строк в сетке
row_indx = 0
# Рабочая матрица системы линейных уравнений
tab = []
# ====================
# --------------------
# Очистить сетку коэффициентов
# системы уравнений tab_ent
def clear_tab_ent(tab_ent):
   for r in tab_ent:
      for c in r:
         c.delete('0', END)
         c.insert(END, '0.0')
# --------------------
# Загрузить сетку коэффициентов
# системы уравнений tab_ent
# из тестового набора tab_test
def load_tab_ent(tab_test, tab_ent):
    ir = 0
    for r in tab_ent :
        ic = 0
        for c in r:
            c.delete('0', END)
            c.insert(END, str(tab_test[ir][ic]))
            ic += 1
        ir += 1
# --------------------
# Распечатать коэффициенты системы уравнений
# из сетки коэффициентов tab_ent
def print_tab(tab_ent):
   for r in tab_ent:
        for c in r:
            print(c.get(), end=' ')
        print()
   print()
# --------------------   
# Загрузить матрицу tab системы уравнений
# из сетки коэффициентов tab_ent
def load_tab(tab_ent, tab) :
    tab.clear()
    for r in tab_ent :
        v = []
        for c in r :
           v.append(float(c.get()))   
        tab.append(v)
    if Debug : print(tab)
# --------------------
# Очистить сетку корней xi_ent
def clear_xi_ent(xi_ent):
    i = 0
    for c in xi_ent : 
      c.delete(0,END)
      c.insert(0,' ')
      i += 1    
# --------------------
# Сохранить корни xi системы уравнений
# в сетку корней xi_ent
def save_xi(xi, xi_ent):
    i = 0
    for c in xi_ent : 
      c.delete(0,END)
      if xi == [] : c.insert(0,' NaN ')
      else : c.insert(0,str(xi[i]))
      i += 1
# ====================
# --------------------
def onTest1():
    clear_xi_ent(xi_ent)
    load_tab_ent(test1, tab_ent)
# --------------------
def onTest2():
    clear_xi_ent(xi_ent)
    load_tab_ent(test2, tab_ent)
# --------------------
def onPrint():
    print_tab(tab_ent)
# --------------------    
def onClear():
    clear_xi_ent(xi_ent)
    clear_tab_ent(tab_ent)   
# --------------------
def onRun () :
    load_tab(tab_ent, tab)
    xi = slse_gauss(tab, Debug)
    save_xi(xi, xi_ent)
      
# ====================
if __name__ == '__main__':  
   root = Tk()
   root.title ('Решение систем линейных уравнений')
   root.geometry ('620x210' )
   root.resizable (False, False)
# --------------------    
# Добавить в сетку Label для подписей
# к матрице коэффициентов системы уравнений
ai = []
for c in range(tabcol):
    if c < tabcol - 1 : lb = Label(text='a' + str(c), relief=RIDGE)
    else :  lb = Label(text='b', relief=RIDGE)
    lb.grid(row=row_indx, column=c, sticky=NSEW)
    ai.append(lb)
row_indx += 1
# --------------------
# Добавить в сетку Entry для значений
# в матрице коэффициентов системы уравнений
tab_ent = []
for r in range(tabrow):
    v = []
    for c in range(tabcol):
        ent = Entry(relief=RIDGE)
        ent.grid(row=row_indx + r, column=c, sticky=NSEW)
        ent.insert(END, str(0))
        v.append(ent)
    tab_ent.append(v)
row_indx += tabrow
# --------------------
# Добавить в сетку Label для подписей
# к матрице корней
xi_lb = []
for c in range(tabcol-1):
    lb = Label(text='x' + str(c), relief=RIDGE)
    lb.grid(row=row_indx, column=c, sticky=NSEW)
    xi_lb.append(lb)
row_indx += 1
# --------------------
# Добавить в сетку Entry для значений
# в матрице корней
xi_ent = []
for c in range(tabcol-1):
    ent = Entry(relief=RIDGE)
    ent.grid(row=row_indx, column=c, sticky=NSEW)
    ent.insert(END, ' ')
    xi_ent.append(ent)
bttrun = Button(text='Выполнить',  command=onRun)
bttrun.grid(row=row_indx, column=tabcol-1)
row_indx += 1    
# --------------------

# Создать сетку для управляющих кнопок
Button(text='Test1', command=onTest1).grid(row=row_indx,  column=0, pady=4)
Button(text='Test2', command=onTest2).grid(row=row_indx,  column=1, pady=4)
Button(text='Print', command=onPrint).grid(row=row_indx,  column=2, pady=4)
Button(text='Clear', command=onClear).grid(row=row_indx,  column=3, pady=4)
Button(text='Quit',  command=sys.exit).grid(row=row_indx, column=4, pady=4)

mainloop()
