from tkinter   import *
from math import * 

debugf = False

# =====================
eps = 1.e-10;         # Абсолютная ошибка завершения поиска решения
MaxStepNum = 128      # Мкасимальное число шагов поиска решения
FlagInit = False      # Флаг исходные данные загружены и можно выполнять шаги поиска
SrcDat  = []          # Список исходных данных [xL, xR, FunStr]
# --------------------
FlagOneStep = False   # Флаг пошагового режима
StepNum = 0           # Номер шага поиска решения

# =====================
# 2D - График табличной функции
numpoint = 200  # Число точек для графика
listx    = []   # Список Аргументов графика
listy    = []   # Список Значений графика

# ============ СЕРВИС ==================
# Сообщение в поле Entry
def msg(entr, txt) :
    entr.delete(0,END)
    entr.insert(0, ' ' + str(txt))
# --------------------------------------
# Выборка значения из Entry
def GetDat(entr) :
    try  :
       if str(entr.get()) == '' :
          return [False, None]    
       else :       
          return [True,float(str(entr.get()))]
    except :
       entr.delete(0, END)    
       entr.insert(0, 'error')
       return [False, None]  
      
# =========== ГРАФИКА ==================
# Набор данных для построения графика
GWdW = 850  #  Ширина виджета Canvas
GWdH = 420  #  Высота виджета Canvas
brX = 50    #  Горизонтальные бордюры для графика
brY = 20    #  Вертикальные бордюры для графика
grW = GWdW - 2 * brX     #  Ширина графика
grH = GWdH - 2 * brY     #  Высота графика
titenum = 10;            #  Число подписей на оси Y и X
scx = []    #  мин., макс. и масштаб лля Аргументов
scy = []    #  мин., макс. и масштаб для Значений

# --------------------------------------
# Очистить график
def clear(canvas) :
    canvas.delete('all')
# --------------------------------------
#  Вычислить мин., макс. и масштаб : [min, max, scale]
def scl(glen, sc, lst) :
    sc.clear() 
    sc.append(min(lst))
    sc.append(max(lst))
    try : sc.append(glen /(sc[1]-sc[0]))
    except : sc.append(0)   
# --------------------------------------
#  Получить аргумент в масштабе графика
def xtopix(sc, x) :
    return brX + sc[2]*(x-sc[0])
# --------------------------------------
#  Получить значение в масштабе графика
def ytopix(sc, y) :
    return brY + grH - sc[2]*(y-sc[0])
# --------------------------------------
# Вычислить масштабы и прорисовать оси
def ScaleAndAxes(canvas, lstx, lsty) :
   clear(canvas)
   # -------- МАСШТАБЫ  
   scl(grW, scx, lstx)   # Мин., макс. и масштаб для Аргументов
   scl(grH, scy, lsty)   # Мин., макс. и масштаб для Значений
   # -------- ОСИ  
   # Опорные точки осей
   xb = xtopix(scx,scx[0])
   xe = xtopix(scx,scx[1])
   yb = ytopix(scy,scy[0])
   ye = ytopix(scy,scy[1])
   # Прорисовать оси X и Y
   canvas.create_line(xb, yb, xe, yb, width=2) # Ось X
   canvas.create_line(xb, ye, xb, yb, width=2) # Ось Y
   # Прорисовать подписи на оси X
   yb = ytopix(scy,scy[0])
   i, xr, xstep = 0, scx[0], (scx[1]-scx[0])/(titenum -1)
   while i < titenum :
      x = xtopix(scx,xr)
      canvas.create_line(x, yb, x, yb - 5, width=2)
      canvas.create_text(x, yb + 4, text='%3.1f'% (xr), anchor=N)
      xr+=xstep
      i+=1
   # Прорисовать подписи на оси Y
   i, yr, ystep = 0, scy[0], (scy[1]-scy[0])/(titenum -1)
   while i < titenum :
      y = ytopix(scy,yr) 
      canvas.create_line(xb, y, xb + 5, y, width=2)
      canvas.create_text(xb - 6, y, text='%5.1f'% (yr), anchor=E)
      yr+=ystep
      i+=1  
# --------------------------------------
# Прорисовать график функции
def ShowFunc(canvas, lstx, lsty) :
   ScaleAndAxes(canvas, lstx, lsty)      
   # ---- График исходных данных
   # Вычислить X и Y в масштабе графика
   scaled = []
   for i in range(0, len(lstx)) :
     x = xtopix(scx, lstx[i])
     y = ytopix(scy, lsty[i])
     scaled.append((x, y)) 
   # Прорисовать график исходных данных  
   # При smooth=1 применяется сглаживание на изломах линии     
   canvas.create_line(scaled, fill='black', smooth=0)  
   if debugf :
      print('paint. Масштабированная матрица для визуализации : ')
      print(scaled)
   ShowHorizontLine(canvas, 0)   
# --------------------------------------
# Прорисовать точку на графике
def ShowOnePoint(canvas, x, y) :
    if (scx[2] == 0) | (scy[2] == 0) : return
    px = xtopix(scx, x)
    py = ytopix(scy, y)
    # Прорисовать одну точку на графике исходных данных   
    canvas.create_oval(px - 2, py - 2, px + 2, py + 2, width=1,
                       outline='black', fill='SkyBlue2')
# --------------------------------------
# Прорисовать горизонтальную линию на графике исходных данных 
def ShowHorizontLine(canvas, y) :
    if (scy[2] == 0) : return
    py = ytopix(scy, 0)
    # Прорисовать одну точку на графике исходных данных   
    canvas.create_line(brX, py, GWdW - brX, py, width=1, fill='blue')    

# ========== ПОИСК РЕШЕНИЯ =============
# --------------------------------------
# Выборка и контроль исходных данных
def GetAllDat(entr_xb, entr_xe, entr_fun) :
   SrcDat.clear()
   lxb=GetDat(entr_xb)
   lxe=GetDat(entr_xe)
   if (lxb[0] & lxe[0] & (entr_fun.get() != '')) :
      SrcDat.append(lxb[1])
      SrcDat.append(lxe[1])
      SrcDat.append(entr_fun.get())      
# --------------------------------------
# Вычислить табличную функцию
def CalcFunc(entr_xb, entr_xe, entr_fun) :
   listx.clear()
   listy.clear()
   if SrcDat == [] : return 
   try :  stepx = (SrcDat[1]- SrcDat[0]) / (numpoint - 1)      
   except : return
   x = SrcDat[0]
   for n in range(0, numpoint) :
      try :
         y = eval(SrcDat[2])
         listx.append(x)
         listy.append(y)
      except :
         listx.clear()
         listy.clear()
         break
      x += stepx      
# --------------------------------------
# Инициировать исходные данные и прорисовать график
def InitAndShowFunc() :
    global FlagInit, StepNum
    FlagRun = False
    StepNum = 0
    msg(entr_num, ' ')
    msg(entr_x, ' ')
    SrcDat = GetAllDat(entr_xb, entr_xe, entr_fun)   
    CalcFunc(entr_xb, entr_xe, entr_fun)
    if (len(listx) > 0) & (len(listy) > 0) :
       ShowFunc(canvas1, listx, listy)
       msg(entr_msg, ' Ок! Можно начать искать решение')
       FlagInit = True

# --------------------------------------
# Шаг поиска решения
def FindOneStep() :
    global xL, xR, FunStr
    # Ловушка выхода по условию невыполнимости алгоритма
    x = xL
    yL = eval(FunStr)
    x = xR
    yR = eval(FunStr)
    if ((yL>0)&(yR>0))|((yL<0)&(yR<0))|(yL==yR) :
       msg(entr_msg, ' Поиск корня невозможен, f(xL) и f(xR) имеют одинаковый знак либо равны') 
       return 2
    x=(xR+xL)/2;
    y=eval(FunStr);
    ShowOnePoint(canvas1, x, y)
    if abs(y)<=eps :
       msg(entr_msg, ' Корень найден')
       msg(entr_x, x)
       return 1
    if (yR > yL) : 
       # Возрастающая функция
       if y > 0 : xR = x
       else : xL = x;
    else :
       # Убывающая функция
       if y < 0 : xR = x
       else : xL = x
    return 0
# --------------------------------------
# Автоматическое выполнение всех шагов поиска решения
def RunAuto() :
   global FlagInit, FlagOneStep, xL, xR, FunStr
   if not FlagInit :
      msg(entr_msg, ' Вначале нажмите кнопку: Подготовить') 
      return
   xL = SrcDat[0]       
   xR = SrcDat[1]       
   FunStr = SrcDat[2]   
   for n in range(1, MaxStepNum) : 
     codend = FindOneStep()
     if (n > MaxStepNum) | (codend > 0) : break
   msg(entr_num, n)  
   FlagInit = False
   
# --------------------------------------
# Пошаговое выполнение поиска решения
def RunOneStep() :
   global FlagInit, FlagOneStep, StepNum, xL, xR, FunStr
   if not FlagInit :
      msg(entr_msg, ' Вначале нажмите кнопку: Подготовить')
      return
   if not FlagOneStep :
      # Загрузка начальных границ и выполнение первого шага 
      xL = SrcDat[0]      
      xR = SrcDat[1]       
      FunStr = SrcDat[2]   
      StepNum = 1
      FlagOneStep = True
      codend = FindOneStep()
   else :
      # Выполнение очередного шага  
      codend = FindOneStep()  
      StepNum += 1
   msg(entr_num, StepNum)   
   if (StepNum > MaxStepNum) | (codend > 0) :
      FlagOneStep = False
      FlagInit = False     
          
# =========== GUI ======================    
if __name__ == '__main__':
    root = Tk()
    root.title ('Нахождение действительного корня трансцендентного уравнения методом бисекции')
    root.geometry ('880x550' )
    root.resizable (False, False)
    # ===== frame_m1 ==========
    frame_m1 = Frame (root)
    Label(frame_m1, width=60, text='Левая часть F(x) уравнения F(x) = 0').pack(side=TOP, padx=5, pady=2)
    entr_fun = Entry(frame_m1)                    
    entr_fun.config(width=120, bg='silver', font=('tahoma', 10))
    entr_fun.pack(side=TOP, fill=X, expand=YES, padx=5, pady=2)
    frame_m1.pack(side=TOP)
    entr_fun.insert(0, ' log10(12*x)+sin(4*x)+x-2.8')
    # ==========================
    # ======= frame_m2 =========
    frame_m2 = Frame (root)
    # -------
    Label(frame_m2, width=6, text='x_Left').pack(side=LEFT, padx=5, pady=10)
    entr_xb = Entry(frame_m2, width=8)                    
    entr_xb.config(bg='silver', font=('tahoma', 10))
    entr_xb.pack(side=LEFT, fill=X, padx=2, pady=10)
    entr_xb.insert(0, '0.1')
    # -------
    Label(frame_m2, width=6, text='x_Right').pack(side=LEFT, padx=5, pady=10)
    entr_xe = Entry(frame_m2, width=8)                    
    entr_xe.config(bg='silver', font=('tahoma', 10))
    entr_xe.pack(side=LEFT, fill=X, padx=2, pady=10)
    entr_xe.insert(0, '3.2')
    # -------
    Button(frame_m2, text=' Подготовить ',  command= (lambda: InitAndShowFunc())).pack(side=LEFT , padx=20)
    Button(frame_m2, text=' Очередной шаг ', command= (lambda: RunOneStep())).pack(side=LEFT, padx=5)
    Button(frame_m2, text=' Автоматически ', command= (lambda: RunAuto())).pack(side=LEFT, padx=5)
    frame_m2.pack(side=TOP)
    # -------
    Label(frame_m2, width=10, text='Номер шага').pack(side=LEFT, padx=5, pady=10)
    entr_num = Entry(frame_m2, width=4)                    
    entr_num.config(bg='silver', font=('tahoma', 10))
    entr_num.pack(side=LEFT, fill=X, padx=5, pady=10)
    entr_num.insert(0, ' ')
    # -------
    Label(frame_m2, width=2, text=' X').pack(side=LEFT, padx=5, pady=10)
    entr_x = Entry(frame_m2)                    
    entr_x.config(bg='silver', font=('tahoma', 10))
    entr_x.pack(side=LEFT, fill=X, padx=5, pady=10)
    entr_x.insert(0, ' ')
    # ==========================
    # ======= frame_m3 =========
    frame_m3 = Frame (root)
    canvas1 = Canvas(frame_m3, width=GWdW, height=GWdH, bg = 'gray90')
    canvas1.pack(side=TOP)
    frame_m3.pack(side=TOP)
    clear(canvas1)
    # ==========================
    # ======= frame_m4 =========
    frame_m4 = Frame (root)
    entr_msg = Entry(frame_m4)                    # Entry для сообщений
    entr_msg.config(width=106, bg='silver', font=('tahoma', 10, 'bold'))
    entr_msg.pack(side=TOP, fill=X, expand=YES, padx=5, pady=5)
    frame_m4.pack(side=TOP)
    # ==========================
    # ==========================
    root.mainloop()
    
