from tkinter   import *
from random import *

Debug = False
maxind = 100;
list1 = []

# =========== ГРАФИКА ==================
# Набор данных для построения графика
GWdW = 600  #  Ширина виджета Canvas
GWdH = 200  #  Высота виджета Canvas
brX = 15    #  Горизонтальные бордюры для графика
brY = 30    #  Вертикальные бордюры для графика
grW = GWdW - 2 * brX     #  Ширина графика
grH = GWdH - 2 * brY     #  Высота графика
titenum = 6;            #  Число подписей на оси Y и X
scx = []    #  мин., макс. и масштаб лля Аргументов
scy = []    #  мин., макс. и масштаб для Значений

# --------------------------------------
# Очистить график
def clear(canvas) :
    canvas.delete('all')
# --------------------------------------
# Вычислить мин., макс. и масштаб : [min, max, scale] для Аргументов
def sclx(sc, minx, maxx) :
    sc.clear() 
    sc.append(minx)
    sc.append(maxx)
    try : sc.append(grW/(sc[1]-sc[0]))
    except : sc.append(0)
# --------------------------------------
# Вычислить мин., макс. и масштаб : [min, max, scale] для Значений
def scly(sc, lst) :
    sc.clear() 
    sc.append(min(lst))
    sc.append(max(lst))
    try : sc.append(grH/(sc[1]-sc[0]))
    except : sc.append(0)       
# --------------------------------------
#  Получить Аргумент в масштабе графика
def xtopix(sc, x) :
    return brX + sc[2]*(x-sc[0])
# --------------------------------------
#  Получить Значение в масштабе графика
def ytopix(sc, y) :
    return brY + grH - sc[2]*(y-sc[0])
# --------------------------------------
# Прорисовать график
def paint(canvas, tit, lst) :
   clear(canvas)
   
   # -------- ОСИ  
   sclx(scx, 0, maxind)     # Мин., макс. и масштаб для Аргументов
   scly(scy, lst)           # Мин., макс. и масштаб для Значений
   # Опорные точки осей
   xb = xtopix(scx,scx[0])
   xe = xtopix(scx,scx[1])
   yb = ytopix(scy,scy[0])
   ye = ytopix(scy,scy[1])
   # Заголовок графика
   # anchor position must be : N, NE, E, SE, S, SW, W, NW, or CENTER
   canvas.create_text(brX, brY - 20, text=tit, justify=RIGHT, anchor=NW)
   # Прорисовать оси X
   canvas.create_line(xb, yb, xe, yb, width=2, fill='red') # Ось X
   # Прорисовать подписи на оси X
   yb = ytopix(scy,scy[0])
   i, xr, xstep = 0, scx[0], (scx[1]-scx[0])/(titenum -1)
   while i < titenum :
      x = xtopix(scx,xr)
      canvas.create_line(x, yb, x, yb + 5, width=2, fill='red')
      canvas.create_text(x, yb + 8, text='%3.0f'% (xr), anchor=N)
      xr+=xstep
      i+=1
   # -------- ГРАФИК
   # Вычислить X и Y в масштабе графика
   for i in range(0, len(lst)) :
     x = xtopix(scx, i)
     y = ytopix(scy, lst[i])
     canvas.create_line(x, yb, x, y, width=2)   

# =====================================
# ------------------------------------- 
#  процедура пузырьковой сортировки
def MySort(wList) :
   n=len(wList)
   while n >= 0 :
      for k in range(0,(n-1)) :
          if wList[k] > wList[k+1] :
             buf = wList[k+1]
             wList[k+1]=wList[k]
             wList[k]=buf      
      n=n-1
   if Debug : print(wList);   
   paint(canvas2, 'Отсортированный случайный список', wList)   
# -------------------------------------    
def MakeRandomList(wList) : 
   #  Подготовить два списка с общим случайным наполнением
   wList.clear()
   for Ind in range(0, maxind) :
      wList.append(random())   
   if Debug : print(wList);
   paint(canvas1, 'Исходный случайный список', wList)
# -------------------------------------   
def RunSort (wList) :
   # Подготовить два списка с общим случайным наполнением
   MakeRandomList(wList)
   # Отсортировать список функцией MySort
   MySort(wList);
      
# =========== GUI ======================    
if __name__ == '__main__':
    root = Tk()
    root.title ('Сортировка списка методом пузырьковой сортировки')
    root.geometry ('620x460' )
    root.resizable (False, False)
    # ===== frame_m1 ==========
    frame_m1 = Frame (root)
    # ----
    canvas1 = Canvas(frame_m1, width=GWdW, height=GWdH, bg = 'gray90')
    canvas1.pack(side=TOP, pady=6)
    canvas2 = Canvas(frame_m1, width=GWdW, height=GWdH, bg = 'gray90')
    canvas2.pack(side=TOP, pady=6)
    # ----
    frame_m1.pack(side=TOP)
    # ======= frame_m2 =========
    frame_m2 = Frame (root)
    Button(frame_m2, text=' Выполнить ', command= (lambda: RunSort(list1))).pack(side=LEFT)
    # ----
    frame_m2.pack(side=TOP)
    # ==========================
    root.mainloop()
