﻿# Вычисление функции SIN(angl) рядом Маклорена, где angl задан в радианах
# 1. Оптимизация алгоритма с ограничением длины ряда по достижению ошибки delta
# 2. Перенос угла alpha диапазон -2*pi 2*pi
# 3. Оптимизация алгоритма по значениям производных для ряда произвольной длины
# eps - точность вычисляемой функции
# Например:
#     x=pi/2;
#     y=McSin(angl,1e-16);
#
onepi=3.141592653589793;         # Угол pi
def McSin(angl,eps) :
   twopi = 6.283185307179586;    # Угол 2*pi
   # Перенос угла angl диапазон -2*pi 2*pi
   x=angl-twopi*(angl // twopi);
   y=0;     # Предустановка результата
   p=1;     # x - в очередной степени
   f=1;     # Очередное значение факториала
   # d-derivatives (Повторяющаяся группа производных функции вычисленная в нуле)
   d=[0, 1, 0, -1];
   m=0;
   ys=y;
   for k in range(0,128) : 
      if d[m]!= 0 :          
         y += p*d[m]/f;
         if abs(ys-y)<eps :
            print('sin(x)=', y, 'Длина ряда k=', k, ', макс. длина =', 128);    
            return y;
      ys=y; 
      m += 1;
      if m > len(d)-1 : m=0;   
      f *= k+1;   
      p=p*x;
      
# Цикл упрощенного диалога
print('Вычисление функции sin(x)')
choice = 'R';
while choice == 'R' :
  replay=input('Введите угол в градусах >>> ');
  # Перевод угла в радианы
  x=float(replay)*onepi/180;
  print('Значение sin(x)=', McSin(x,1e-16))
  # Остановка
  choice = input("Введите R для продолжения или просто Enter для выхода ...")      
