#!/usr/bin/python3
from tkinter import *
from tkinter import ttk
from tkinter.scrolledtext import ScrolledText
from Tools.LibSamples import *

root=Tk()
winW = 1024  # Ширина окна
winH = 600   # Высота окна
root.geometry(str(winW)+'x'+str(winH))
root.title('МНОЖЕСТВА (методы структуры данных типа set)')
root.resizable(width=False, height=False)

# ------------------------------------------------
# Отступы внутри всех фреймов
# ------------------------------------------------
pdX = 8     # Отступы внутри фрейма по X
pdY = 6     # Отступы внутри фрейма по Y

frameL=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=5 * winW//16, height=winH)
frameR=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=11* winW//16, height=winH)
frameL.pack(side='left', fill='none', expand='no')
frameR.pack(side='left', fill='none', expand='no')
# Запрет изменения размеров фреймов встроенными виджетами
frameL.pack_propagate(0)
frameR.pack_propagate(0)

winW = winW - 2 * pdX
winH = winH - 2 * pdY
frameLT=ttk.Frame(frameL, padding=[pdX, pdY], relief=SUNKEN, width=5 * winW//16, height= 9 * winH//16)
frameLB=ttk.Frame(frameL, padding=[pdX, pdY], relief=SUNKEN, width=5 * winW//16, height= 7 * winH//16)
frameLT.pack(side='top', fill='none', expand='no')
frameLB.pack(side='top', fill='none', expand='no')
frameLT.pack_propagate(0)
frameLB.pack_propagate(0)
frameRT=ttk.Frame(frameR, padding=[pdX, pdY], relief=SUNKEN, width=11 * winW//16, height= 9 * winH//16)
frameRB=ttk.Frame(frameR, padding=[pdX, pdY], relief=SUNKEN, width=11 * winW//16, height= 7 * winH//16)
frameRT.pack(side='top', fill='none', expand='no')
frameRB.pack(side='top', fill='none', expand='no')
frameRT.pack_propagate(0)
frameRB.pack_propagate(0)

stdfont  = 'Calibri 11'   # Фонт для Python  3, Windows 10
#stdfont = 'Calibri 8'    # Фонт для Pydroid 3, Android 11

# ------------------------------------------------
# Сегмент для прикладной части
# ------------------------------------------------
SampleList = [{'tit' : ' Конструкторы множеств',               'img' : '',          'pgm' : Sample01},
              {'tit' : ' Доступ к элементам множеств',         'img' : 'img02.png', 'pgm' : Sample02},
              {'tit' : ' Методы .add() и .discard()',          'img' : '',          'pgm' : Sample03},
              {'tit' : ' Методы .clear() и .remove()',         'img' : '',          'pgm' : Sample04},
              {'tit' : ' Метод  .difference(); ',              'img' : 'img05.png', 'pgm' : Sample05},
              {'tit' : ' Метод  .difference_update()',         'img' : 'img06.png', 'pgm' : Sample06},
              {'tit' : ' Метод  .intersection()',              'img' : 'img07.png', 'pgm' : Sample07},
              {'tit' : ' Метод  .intersection_update()',       'img' : 'img08.png', 'pgm' : Sample08},
              {'tit' : ' Метод  .union()',                     'img' : 'img09.png', 'pgm' : Sample09},
              {'tit' : ' Метод  .update()',                    'img' : 'img10.png', 'pgm' : Sample10},
              {'tit' : ' Методы .issubset() и issuperset()',   'img' : '',          'pgm' : Sample11},
              {'tit' : ' Метод  .isdisjoint()',                'img' : '',          'pgm' : Sample12},
              {'tit' : ' Метод  .symmetric_difference',        'img' : 'img13.png', 'pgm' : Sample13},
              {'tit' : ' Метод  .symmetric_difference_update', 'img' : 'img14.png', 'pgm' : Sample14},
              {'tit' : ' Метод  .pop()',                       'img' : '',          'pgm' : Sample15},
              {'tit' : ' Метод  .copy()',                      'img' : '',          'pgm' : Sample16}]

DocMsg = '''
 ДОКУМЕНТАЦИЯ

 1. Множества Python
    https://www.w3schools.com/python/python_sets.asp
   
 2. Методы множеств Python
    https://www.w3schools.com/python/python_ref_set.asp

 3. Операции (выражения) с множествами
    https://docs.python.org/3.10/tutorial/datastructures.html#sets
'''

def showselect(event):
    global func
    indexs = LBox01.curselection() # Кортеж индексов
    if len(indexs) == 1:           # Если отмечена только одна строка
       i = indexs[0]       
    if (i >= 0) and (i < len(SampleList)):
       RunSample(SampleList[i], ImgLab, TextCode, TextResult) 


# ---------------------------------
# Создать Listbox 
LBox01 = Listbox(frameLT, height = 4, width = 36, font = stdfont) 
LBox01.pack(side = 'left', fill='both', padx=4, pady=4)
# Прокрутка Listbox
scrollbar = ttk.Scrollbar(frameLT, orient="vertical", command=LBox01.yview)
scrollbar.pack(side='right', fill=Y)
LBox01["yscrollcommand"]=scrollbar.set
# Заполнение Listbox
for ind in range(len(SampleList)):
    LBox01.insert(ind, SampleList[ind]['tit'])
# Подключить обработчик для реакции на кнопку мышки
LBox01.bind("<<ListboxSelect>>", showselect)
# ---------------------------------
# Метка для размещения изображения
ImgLab = ttk.Label(frameLB, font = stdfont, justify=LEFT, text='Комментарии к примерам')
ImgLab.pack(side = 'top')
# ---------------------------------
# Скролтексты для примера и результата выполнения
TextCode= ScrolledText(frameRT, font = stdfont, padx = 10, pady = 0, wrap = WORD)
TextCode.pack(side='top', fill='both',  expand='yes')
TextCode.insert('1.0',DocMsg)
TextResult = ScrolledText(frameRB, font = stdfont, padx = 10, pady = 0, wrap = WORD)
TextResult.pack(side='top', fill='both',  expand='yes')
TextResult.insert('1.0','Результаты выполнения примеров')
# ------------------------------------------------
# Цикл ожидания событий
# ------------------------------------------------
root.mainloop ()
