#!/usr/bin/python3
from tkinter import *
from tkinter import ttk

root=Tk()
winW = 460  # Ширина окна
winH = 260  # Высота окна
root.geometry(str(winW)+'x'+str(winH))
root.title('Переключение картинок с помощью ListBox')
root.resizable(width=False, height=False)

# ------------------------------------------------
# Отступы внутри всех фреймов
# ------------------------------------------------
pdX = 8     # Отступы внутри фрейма по X
pdY = 6     # Отступы внутри фрейма по Y

frameL=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=1* winW//3, height=winH)
frameR=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=2* winW//3, height=winH)
frameL.pack(side='left', fill='none', expand='no')
frameR.pack(side='left', fill='none', expand='no')
# Запрет изменения размеров фреймов встроенными виджетами
frameL.pack_propagate(0)
frameR.pack_propagate(0)

# ------------------------------------------------
# Сегмент для прикладной части
# ------------------------------------------------
stdfont  = 'Calibri 11'   # Фонт для Python  3, Windows 10
#stdfont = 'Calibri 8'    # Фонт для Pydroid 3, Android 11

# Подготовить переменную для заполнения Listbox 
images = ["img01", "img02", "img03", "img04", "img05", "img06"]
images_var = Variable(value=images)

def ShowImg(index):
    global pic01
    if pic01 != None : del pic01
    if   index == 0: pic01 = PhotoImage(file="./pictures/img01.gif")
    elif index == 1: pic01 = PhotoImage(file="./pictures/img02.png")    
    elif index == 2: pic01 = PhotoImage(file="./pictures/img03.png")
    elif index == 3: pic01 = PhotoImage(file="./pictures/img04.png")
    elif index == 4: pic01 = PhotoImage(file="./pictures/img05.png")
    elif index == 5: pic01 = PhotoImage(file="./pictures/img06.png")
    else: pic01 = None
    print(index, LBox01.get(index))
    if pic01 != None : lab["image"] = pic01

def showselect(event):
    indexs = LBox01.curselection() # Кортеж индексов
    if len(indexs) == 1:           # Если отмечена только одна строка
       i = indexs[0]
       ShowImg(i)

pic01 = None
# Создать и заполнить Listbox 
LBox01 = Listbox(frameL, listvariable=images_var) 
LBox01.pack(side = 'top', fill=X, padx=5, pady=5)
# Подключить обработчик для реакции на кнопку мышки
LBox01.bind("<<ListboxSelect>>", showselect)
# Метка для размещения изображения
lab = ttk.Label(frameR)
lab.pack(side = 'top')
# ------------------------------------------------
# Цикл ожидания событий
# ------------------------------------------------
root.mainloop ()
