#!/usr/bin/python3
from tkinter import *
from tkinter import ttk
from tkinter.scrolledtext import ScrolledText
from Tools.LibSamples import *

root=Tk()
winW = 800  # Ширина окна
winH = 610  # Высота окна
root.geometry(str(winW)+'x'+str(winH))
root.title('Методы структуры данных типа list')
root.resizable(width=False, height=False)

# ------------------------------------------------
# Отступы внутри всех фреймов
# ------------------------------------------------
pdX = 8     # Отступы внутри фрейма по X
pdY = 6     # Отступы внутри фрейма по Y

# ------------------------------------------------
# Подготовим три фрейма первого уровня
# ------------------------------------------------
frameT=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=winW, height= 3 * winH//12)
frameM=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=winW, height= 5 * winH//12)
frameB=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=winW, height= 4 * winH//12)
frameT.pack(side='top', fill='none', expand='no')
frameM.pack(side='top', fill='none', expand='no')
frameB.pack(side='top', fill='none', expand='no')
# Запрет изменения размеров фреймов встроенными виджетами
frameT.pack_propagate(0)
frameM.pack_propagate(0)
frameB.pack_propagate(0)

# ------------------------------------------------
# Подготовим фреймы второго уровня
# ------------------------------------------------
winWp2 = winW - 2 * pdX  # Ширина уменьшилась за счет уже использованых отступов
winHp6 = winH - 6 * pdY  # Высота уменьшилась за счет уже использованых отступов

# Внутри frameT
frameT1=ttk.Frame(frameT, padding=[pdX, pdY], relief=SUNKEN, width=winWp2//4, height= 3 * winHp6//12)
frameT2=ttk.Frame(frameT, padding=[pdX, pdY], relief=SUNKEN, width=winWp2//4, height= 3 * winHp6//12)
frameT3=ttk.Frame(frameT, padding=[pdX, pdY], relief=SUNKEN, width=winWp2//4, height= 3 * winHp6//12)
frameT4=ttk.Frame(frameT, padding=[pdX, pdY], relief=SUNKEN, width=winWp2//4, height= 3 * winHp6//12)
frameT1.pack(side='left', fill='none', expand='no')
frameT2.pack(side='left', fill='none', expand='no')
frameT3.pack(side='left', fill='none', expand='no')
frameT4.pack(side='left', fill='none', expand='no')
# Запрет изменения размеров фреймов встроенными виджетами
frameT1.pack_propagate(0)
frameT2.pack_propagate(0)
frameT3.pack_propagate(0)
frameT4.pack_propagate(0)

# ------------------------------------------------
# Сегмент для прикладной части
# ------------------------------------------------
stdfont  = 'Calibri 11'   # Фонт для Python  3, Windows 10
#stdfont = 'Calibri 8'    # Фонт для Pydroid 3, Android 11
# ---------------------------
# ПРИМЕР: Подготовим TextCode
# ---------------------------
TextCode= ScrolledText(frameM, font = stdfont, padx = 10, pady = 8, wrap = WORD)
TextCode.pack(side='top', fill='both',  expand='yes')

wstr = ''' 1. Примеры методов для структуры данных типа list:

   append();  copy();  clear();   count();  extend();
   index();   insert();  pop();   remove(); reverse();
   sort();    min();     max();   len()

 2. Примеры работы со списками регулярными и нерегулярными по типу элементов

 3. В этом окне будет отображаться исходный текст, а в окне ниже результат
    его выполнения
'''
TextCode.insert(END, wstr)

# ---------------------------
#  Подготовим TextResult
# ---------------------------
TextResult = ScrolledText(frameB, font = stdfont, padx = 10, pady = 8, wrap = WORD)
TextResult.pack(side='top', fill='both',  expand='yes')

# ---------------------------
# Подготовим кнопки
# ---------------------------
but1 = Button(frameT1, text='Адресация элементов', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample01(x,y))
but1.pack(side='top', fill='x', expand='no')
but2 = Button(frameT1, text='.append()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample02(x,y))
but2.pack(side='top', fill='x', expand='no')
but3 = Button(frameT1, text='Копирование ссылки', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample03(x,y))
but3.pack(side='top', fill='x', expand='no')
but4 = Button(frameT1, text='.copy()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample04(x,y))
but4.pack(side='top', fill='x', expand='no')
#
but5 = Button(frameT2, text='.sort()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample05(x,y))
but5.pack(side='top', fill='x', expand='no')
but6 = Button(frameT2, text='.min();  .max()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample06(x,y))
but6.pack(side='top', fill='x', expand='no')
but7 = Button(frameT2, text='.index();  .count()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample07(x,y))
but7.pack(side='top', fill='x', expand='no')
but8 = Button(frameT2, text='.insert();  .pop()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample08(x,y))
but8.pack(side='top', fill='x', expand='no')
#
but9 = Button(frameT3, text='.remove();  .clear()', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample09(x,y))
but9.pack(side='top', fill='x', expand='no')
but10 = Button(frameT3, text=' .reverse() ', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample10(x,y))
but10.pack(side='top', fill='x', expand='no')
but11 = Button(frameT3, text=' Длина списка len() ', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample11(x,y))
but11.pack(side='top', fill='x', expand='no')
but12 = Button(frameT3, text=' .extend() ', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample12(x,y))
but12.pack(side='top', fill='x', expand='no')
#
but13 = Button(frameT4, text='Нерегулярный список 1', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample13(x,y))
but13.pack(side='top', fill='x', expand='no')
but14 = Button(frameT4, text='Нерегулярный список 2', font = stdfont, command = lambda x=TextCode, y=TextResult : Sample14(x,y))
but14.pack(side='top', fill='x', expand='no')
but15 = Button(frameT4, text='Нерегулярный список 3', font = stdfont, command = lambda x=TextCode, y=TextResult, z= frameT4: Sample15(x,y,z))
but15.pack(side='top', fill='x', expand='no')
# ------------------------------------------------
# Цикл ожидания событий
# ------------------------------------------------
root.mainloop ()
