#!/usr/bin/python3
from tkinter import *
from tkinter import ttk
from tkinter.scrolledtext import ScrolledText
from Tools.LibSamples import *

root=Tk()
winW = 1024  # Ширина окна
winH = 640   # Высота окна
root.geometry(str(winW)+'x'+str(winH))
root.title('СЛОВАРИ (методы структуры данных типа dict)')
root.resizable(width=False, height=False)

# ------------------------------------------------
# Отступы внутри всех фреймов
# ------------------------------------------------
pdX = 8     # Отступы внутри фрейма по X
pdY = 6     # Отступы внутри фрейма по Y

frameL=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=5 * winW//16, height=winH)
frameR=ttk.Frame(root, padding=[pdX, pdY], relief=SUNKEN, width=11* winW//16, height=winH)
frameL.pack(side='left', fill='none', expand='no')
frameR.pack(side='left', fill='none', expand='no')
# Запрет изменения размеров фреймов встроенными виджетами
frameL.pack_propagate(0)
frameR.pack_propagate(0)

winW = winW - 2 * pdX
winH = winH - 2 * pdY
frameLT=ttk.Frame(frameL, padding=[pdX, pdY], relief=SUNKEN, width=5 * winW//16, height= 9 * winH//16)
frameLB=ttk.Frame(frameL, padding=[pdX, pdY], relief=SUNKEN, width=5 * winW//16, height= 7 * winH//16)
frameLT.pack(side='top', fill='none', expand='no')
frameLB.pack(side='top', fill='none', expand='no')
frameLT.pack_propagate(0)
frameLB.pack_propagate(0)
frameRT=ttk.Frame(frameR, padding=[pdX, pdY], relief=SUNKEN, width=11 * winW//16, height= 9 * winH//16)
frameRB=ttk.Frame(frameR, padding=[pdX, pdY], relief=SUNKEN, width=11 * winW//16, height= 7 * winH//16)
frameRT.pack(side='top', fill='none', expand='no')
frameRB.pack(side='top', fill='none', expand='no')
frameRT.pack_propagate(0)
frameRB.pack_propagate(0)

stdfont  = 'Calibri 11'   # Фонт для Python  3, Windows 10
#stdfont = 'Calibri 8'    # Фонт для Pydroid 3, Android 11

# ------------------------------------------------
# Сегмент для прикладной части
# ------------------------------------------------
SampleList = [{'tit' : ' Конструкторы словарей',               'img' : '',          'pgm' : Sample01},
              {'tit' : ' Доступ к элементам словарей',         'img' : '',          'pgm' : Sample02},
              {'tit' : ' Метод .fromkeys()',                   'img' : '',          'pgm' : Sample03},
              {'tit' : ' Методы .clear() и .copy',             'img' : '',          'pgm' : Sample04},
              {'tit' : ' Метод  .update(); ',                  'img' : '',          'pgm' : Sample05},
              {'tit' : ' Метод  .get()',                       'img' : '',          'pgm' : Sample06},
              {'tit' : ' Методы .pop() и .popitem()',          'img' : '',          'pgm' : Sample07},
              {'tit' : ' Метод  .setdefault',                  'img' : '',          'pgm' : Sample08},
              {'tit' : ' Методы .keys() и .values()',          'img' : '',          'pgm' : Sample09},
              {'tit' : ' Метод  .items()',                     'img' : '',          'pgm' : Sample10}]

DocMsg = '''
 ДОКУМЕНТАЦИЯ (СЛОВАРИ)
 
Словари используются для хранения значений данных в парах ключ:значение.
Словарь представляет собой упорядоченный* набор, изменяемый и не
допускающий дублирования. Начиная с Python версии 3.7, словари упорядочены .
В Python 3.6 и более ранних версиях словари неупорядочены 

 1. Словари Python
    https://www.w3schools.com/python/python_dictionaries.asp
   
 2. Методы словарей Python
    https://www.w3schools.com/python/python_ref_dictionary.asp

 3. https://docs.python.org/3.10/library/stdtypes.html#typesmapping
'''

def showselect(event):
    global func
    indexs = LBox01.curselection() # Кортеж индексов
    if len(indexs) == 1:           # Если отмечена только одна строка
       i = indexs[0]       
    if (i >= 0) and (i < len(SampleList)):
       RunSample(SampleList[i], ImgLab, TextCode, TextResult) 


# ---------------------------------
# Создать Listbox 
LBox01 = Listbox(frameLT, height = 4, width = 36, font = stdfont) 
LBox01.pack(side = 'left', fill='both', padx=4, pady=4)
# Прокрутка Listbox
scrollbar = ttk.Scrollbar(frameLT, orient="vertical", command=LBox01.yview)
scrollbar.pack(side='right', fill=Y)
LBox01["yscrollcommand"]=scrollbar.set
# Заполнение Listbox
for ind in range(len(SampleList)):
    LBox01.insert(ind, SampleList[ind]['tit'])
# Подключить обработчик для реакции на кнопку мышки
LBox01.bind("<<ListboxSelect>>", showselect)
# ---------------------------------
# Метка для размещения изображения
ImgLab = ttk.Label(frameLB, font = stdfont, justify=LEFT, text='Комментарии к методам')
ImgLab.pack(side = 'top')
# ---------------------------------
# Скролтексты для примера и результата выполнения
TextCode= ScrolledText(frameRT, font = stdfont, padx = 10, pady = 0, wrap = WORD)
TextCode.pack(side='top', fill='both',  expand='yes')
TextCode.insert('1.0',DocMsg)
TextResult = ScrolledText(frameRB, font = stdfont, padx = 10, pady = 0, wrap = WORD)
TextResult.pack(side='top', fill='both',  expand='yes')
TextResult.insert('1.0','Результаты выполнения примеров')
# ------------------------------------------------
# Цикл ожидания событий
# ------------------------------------------------
root.mainloop ()
