unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    btn1: TButton;
    btn2: TButton;
    btn3: TButton;
    cbb1: TComboBox;
    cbb2: TComboBox;
    cbb3: TComboBox;
    cbb4: TComboBox;
    lbl1: TLabel;
    pnl1: TPanel;
    lbl2: TLabel;
    lbl3: TLabel;
    lbl4: TLabel;
    lbl5: TLabel;
    lbl6: TLabel;
    lbl7: TLabel;
    lbl8: TLabel;
    edt1: TEdit;
    shp1: TShape;
    shp2: TShape;
    lbl9: TLabel;
    lbl10: TLabel;
    lbl11: TLabel;
    lbl12: TLabel;
    procedure btn1Click(Sender: TObject);
    procedure btn2Click(Sender: TObject);
    procedure btn3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// ====================================================================
//     
// ====================================================================
//       
const MaxNumR = 4;  //    
const MaxNumC = 4;  //     

//  
type TXValue = integer;

//   -   
type TXAr = array[1..MaxNumC] of TXValue;

//     
type TYProc  = procedure (pAData : Pointer);

//    ,   
type TATab   = array[1..MaxNumR, 1..MaxNumC] of
      record
       NS  : integer;    //     
       YP  : TYProc;     //     
     end;
// --------------------------------------------------------------------
//       
type TAData = record
     XAr : TXAr;         //   
     IX     : integer;   //  ,   
     CS     : integer;   //   
     ATab   : TATab;     //  
end;

// ====================================================================
//
// ====================================================================
//  1   
procedure YPR1(pAData : Pointer);
var wStr   : string;
begin
   with TAData(pAData^)do
   begin
      wStr := '   ';
      ShowMessage(wStr);
   end;
end;

// --------------------------------------------------------------------
//  2   
procedure YPR2(pAData : Pointer);
var wStr   : string;
begin
   with TAData(pAData^)do
   begin
      wStr := '  : ' + IntToStr(CS) + #13#10;
      wStr := wStr + '  X' + IntToStr(IX);
      wStr := wStr + '  : ' + IntToStr(XAr[IX]);
      ShowMessage(wStr);
   end;
end;

// ====================================================================
//    , ,  
// ====================================================================
// NS -    ,  0,     ()
// YP -    ,  nil,     

const DefATab : TATab =
(
 ((NS:2; YP:YPR2), (NS:0; YP:nil),  (NS:0; YP:nil),  (NS:0; YP:nil) ),  // S1
 ((NS:0; YP:nil),  (NS:0; YP:nil),  (NS:3; YP:YPR2), (NS:0; YP:nil) ),  // S2
 ((NS:0; YP:nil),  (NS:2; YP:YPR2), (NS:0; YP:nil),  (NS:4; YP:YPR2)),  // S3
 ((NS:0; YP:nil),  (NS:1; YP:YPR1), (NS:0; YP:nil),  (NS:0; YP:nil) )   // S4
);

// ====================================================================
//    TAutomat
// ====================================================================

type TAutomat = class(TObject)
private
  //   
  AData : TAData;
public
  //  
  constructor Create(RqATab : TATab);
  //  
  procedure RunAutomat (RqXAr : TXAr);
  //    
  property GetCurrStat : Integer read AData.CS;
end;

// --------------------------------------------------------------------
//   .
//      .
//    , ,    .

constructor TAutomat.Create(RqATab : TATab);
var wR, wC : Integer;
begin
  inherited Create();
  with AData do
  begin
      CS := Low(ATab);
      for wC := Low(XAr) to High(XAr) do
      begin
         XAr[wC] := 0;
         for wR := Low(ATab) to High(ATab) do ATab[wR,wC] := RqATab[wR,wC];
       end;
  end;
end;

// --------------------------------------------------------------------
//      .
//      
//    .
//           .
//   ,   .

procedure TAutomat.RunAutomat(RqXAr : TXAr);
var wInd   : Integer;
    wFound : Boolean;
    wPR    : TYProc;
    wP     : Pointer;
begin
  with AData do
  begin
      for wInd := Low(XAr) to High(XAr) do XAr[wInd] := RqXAr[wInd];
      wFound := False;
      //   
      for wInd := Low(XAr) to High(XAr) do
      begin
        if (AData.XAr[wInd] > 0) and (AData.ATab[CS,wInd].NS > 0)
        then begin
          IX := wInd;
          wFound := True;
          Break;
        end;
      end;
      if wFound
      then begin
        //     
        wPR := ATab[CS,IX].YP;
        CS := ATab[CS,IX].NS;
        if Assigned(wPR)
        then begin
          //   ,   
          wP  := Addr(AData);
          wPR(wP);
        end;
      end;
  end;
end;

// ====================================================================
//     TAutomat
// ====================================================================


// ====================================================================
//         
// ====================================================================

//   
var XArr    : TXAr;
//    
var AUTOMAT : TAutomat;

//   
procedure TForm1.btn1Click(Sender: TObject);
begin
   if not Assigned(AUTOMAT)
   then begin
      AUTOMAT := TAutomat.Create(DefATab);
      edt1.Text := 'S' + IntToStr(AUTOMAT.GetCurrStat);
   end;
end;

//       
procedure TForm1.btn2Click(Sender: TObject);
begin
   XArr[1] := StrToInt(cbb1.Text);
   XArr[2] := StrToInt(cbb2.Text);
   XArr[3] := StrToInt(cbb3.Text);
   XArr[4] := StrToInt(cbb4.Text);
   if Assigned(AUTOMAT)
   then begin
     AUTOMAT.RunAutomat(XArr);
     edt1.Text := 'S' + IntToStr(AUTOMAT.GetCurrStat);
   end
   else begin
     ShowMessage('   ');
   end;
end;

//    
procedure TForm1.btn3Click(Sender: TObject);
begin
   if Assigned(AUTOMAT) then
   begin
       AUTOMAT.Free;
       AUTOMAT := nil;
       edt1.Text := '';
   end;
end;

end.
