unit LineScope03;
// ====================================================================
(*
                  
                        ( TLineScope)

          TCustomScope
       (. unit CustomScope03).
   
    TLineScope     
   ( Value)      
    .   
      Value "   "  ,
     "   "  .
           
      ,     
    ( ,     ).
           
     TImage ( -  Image).

      // -----------------------------------------------------
      // ,    
      // -----------------------------------------------------
      MinScope    -    (   0)
      MaxScope    -   (   0)
      // -----------------------------------------------------
      //    
      // -----------------------------------------------------
      ScopeName   -   ()
      Measure     -    
      // -----------
      //     
      P2Wall      -       ( 0)
      P1Wall      -      ( 0)
      N1Wall      -      ( 0)
      N2Wall      -       ( 0)
      WallStyle   -      
      // -----------
      NumLPF      -     ( 0)
      // -----------
      XBeg        - X- ( )    Image
      YBeg        - Y- ( )    Image
      ScopeWidth  - X-    
      // -----------
      Compact     -   
      Transparent -  
      // -----------------------------------------------------
      MinScopeWidth -   
      // -----------------------------------------------------
      //     
      // -----------------------------------------------------
      Visible     -  
      Value       -    

           unit CustomScope03
    type TCustomScope = class(TObject)

   // -----------------------------------------------------
   //   :
   Scope := TLineScope.Create(Image1, RqXB, RqYB);
   // -----------------------------------------------------
   //     :
   if Assigned(Scope) then Scope.Value := ...;   //  
   // :  NumLPF = 0,    
   //             .  NumLPF >= 2,   
   //                 (NumLPF)   
   //              .
   // -----------------------------------------------------
    3.01. ()  , , , 2018.
                () Source code  ..
     14.07.2018
*)
// ====================================================================

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls,
  CustomScope03;

type TLineScope = class(TCustomScope)
private
  // ------------------------
  fImg         : TImage;    //  Image
  // ------------------------
  //    
  fMinWidth    : integer;
  //    
  fCGW         : integer;   //    
  fCGH         : integer;   //    
  // ------------------------
  //    
  fIRect       : TRect;     //   
  fVRect       : TRect;     //   
  fGRect       : TRect;     //   
  fTRect       : TRect;     //   
  fFRect       : TRect;     //   
  // ------------------------
  fX0          : integer;   //    fGRect
  fScale       : extended;  // 
  // ------------------------
  //     
   procedure CalcScale();
  // ------------------------
  //     
  procedure ShowMarks(RqBmp : TBitMap);
  //      
  function  GetGW(Value : extended) : integer;
  //    
  procedure SetMinWidth(RqWidth : integer);
  // ------------------------
protected
  //      
  procedure ReSizeScope(); override;
  //       
  procedure ReRangeScope(); override;
  // ------------------------
  //     Bmp
  procedure PaintToBmp(Bmp : TBitMap); override;

public
  // ------------------------
  //  / 
  constructor  Create(RqImage : TImage; RqXB, RqYB : integer);
  procedure Free();
  //   
  property MinScopeWidth : integer read fMinWidth write SetMinWidth;
  // ------------------------
end;

implementation

// -------------------------------------------------------------------------
const cLScopeWidth  = 150;      //    
      cLScopeHeight = 40;       //    
      cWDelim   = 4;            //     
      cHDelim   = 1;            //     
      cWIcon    = 14;           //   
      cHIcon    = 14;           //   
      cHGrSc    = 8;            //    
      cHMark    = 6;            //   
      cWBound   = 8;            //     
      cHBound   = 4;            //     
      cValuePic = ' 123,123 ';  //   
      cOutPic = '%6.3f';        //     

// -------------------------------------------------------------------------
//  
constructor TLineScope.Create(RqImage : TImage; RqXB, RqYB : integer);
begin
   inherited Create(RqImage, RqXB, RqYB, cLScopeWidth, cLScopeHeight);
   // -------------------------------
   //  fImg
   fImg   := RqImage;
   // --------------------
   ScopeName := 'K ';
   fMinWidth := cLScopeWidth;
   fCGW      := cLScopeWidth - 2 * cWBound;  //   
   fCGH      := cHGrSc;                      //   
   // --------------------
   Compact     := False;
   Transparent := False;
   // --------------------
   //  
   Measure := ' . ';
   MinScope   := -100;
   MaxScope   :=  100;
   Value := MinScope + (MaxScope - MinScope) / 2;
   ReSizeScope();
   // --------------------
   //  
   Visible := True;
end;
// -------------------------------------------------------------------------
//  
procedure TLineScope.Free();
begin
   // --------------------
   //  
   Visible :=False;
   // --------------------
   inherited Free();
end;

// -------------------------------------------------------------------------
//     
procedure TLineScope.ShowMarks(RqBmp : TBitMap);
var   wVRange  : extended;     //   
      wGRange  : integer;      //   
      wMarkNum : extended;     //    
      wVStep   : extended;     //    
      wVValue  : extended;     //  
      wGStep   : extended;     //    
      wGValue  : extended;     //  
      wColor   : TColor;       //  
begin
    if not ((MaxScope - MinScope) > 0) then Exit;
    //    
    wVRange := MaxScope - MinScope;
    wGRange := fGRect.Right - fGRect.Left;
    wMarkNum := wGRange / 6;
    //      
    wVStep  := wVRange / wMarkNum;
    wGStep  := wGRange / wMarkNum;
    //  
    with RqBmp.Canvas
    do begin
      Pen.Width   := 2;
      Pen.Style   := psSolid;
      Brush.Style := bsClear;
      wVValue := MinScope;
      wGValue := 0;
      while (wVValue <= MaxScope)
      do begin
          //   
          wColor := GetColorByValue(csDark, wVValue);
          Pen.Color   := wColor;
          Rectangle(fGRect.Left   + Round(wGValue),
                    fGRect.Bottom + cHMark - 2,
                    fGRect.Left   + Round(wGValue) + 2,
                    fGRect.Bottom + cHMark);
          wVValue := wVValue + wVStep;
          wGValue := wGValue + wGStep;
      end;
    end;
end;
// -------------------------------------------------------------------------
//      
procedure TLineScope.ReSizeScope();
var wBmp    : TBitMap;
    wFW, wFH, wMaxW, wMaxH : integer;
begin
  wBmp := Bmp;
  with wBmp
  do begin
     // -----------------------------
     //     (,  + )
     wMaxH := (2 * cHBound) + cHIcon;
     wFH   := (2 * cHBound) + Canvas.TextHeight('0');
     if wFH > wMaxH then wMaxH := wFH;
     // -----------------------------
     //     (,  + )
     wMaxW := 2 * cWBound + cWDelim  + cWIcon
            + Canvas.TextWidth(cValuePic + ' ' + Measure);
     // -----------------------------
     //    
     fIRect.Top    := cHBound;
     fIRect.Left   := cWBound;
     fIRect.Bottom := fIRect.Top  + cHIcon;
     fIRect.Right  := fIRect.Left + cWIcon;
     //    -  ( + )
     fVRect.Top    := cHBound;
     fVRect.Left   := fIRect.Right + cWDelim;
     fVRect.Bottom := fVRect.Top  + Canvas.TextHeight('0');
     fVRect.Right  := fVRect.Left
                   + Canvas.TextWidth(cValuePic + ' ' + Measure);
     // -----------------------------
     if not Compact
     then begin
       // -----------------------------
       //     ScopeName
       wFW := 2 * cWBound + Canvas.TextWidth(ScopeName);
       if wFW > wMaxW then wMaxW := wFW;
       // -----------------------------
       //    not Compact 
       //        
       wFW := 2 * cWBound + cLScopeWidth;
       if wFW > wMaxW then wMaxW := wFW;
       if fMinWidth > wMaxW then wMaxW := fMinWidth;
       // -----------------------------
       wFH := wMaxH + cHDelim;
       //    
       fCGW := wMaxW - 2 * cWBound;
       fGRect.Left   := cWBound;
       fGRect.Top    := wFH;
       fGRect.Right  := wMaxW - cWBound;
       fGRect.Bottom := fGRect.Top + cHGrSc;
       // -----------------------------
       wFH := wFH + cHGrSc + cHMark + cWDelim;
       //   
       fTRect.Left   := cWBound;
       fTRect.Top    := wFH;
       fTRect.Right  := wMaxW - cWBound;
       fTRect.Bottom := fTRect.Top  + Canvas.TextHeight('0');
       // -----------------------------
       //    
       wMaxH := wFH + + Canvas.TextHeight('0') + cHBound;
     end;
     //    Bmp
     fFRect := Rect(0, 0, wMaxW, wMaxH);
     //    
     ScopeSize(wMaxW, wMaxH);
     //     
     CalcScale();
     //   
     fX0 := fGRect.Left + Abs(GetGW(MinScope));
  end;
end;
// -------------------------------------------------------------------------
//     
procedure TLineScope.CalcScale();
begin
  fScale := 0;
  if MaxScope <= MinScope then Exit;
  if (MaxScope - MinScope) = 0 then Exit;
  fScale := (fGRect.Right - fGRect.Left) / (MaxScope - MinScope);
end;
// -------------------------------------------------------------------------
//        
function TLineScope.GetGW(Value : extended) : integer;
begin
   Result := 0;
   if fScale > 0
   then begin
      if Value > MaxScope
      then begin
         Result := Round(fScale * Abs(MaxScope));
         Exit;
      end;
      if Value < MinScope
      then begin
         Result := Round(fScale * Abs(MinScope));
         Exit;
      end;
      Result := Round(fScale * Abs(Value));
   end;
end;
// -------------------------------------------------------------------------
//    
procedure TLineScope.SetMinWidth(RqWidth : integer);
begin
   if Abs(RqWidth) <  fMinWidth
   then fMinWidth := cLScopeWidth
   else fMinWidth := Abs(RqWidth);
   ReSizeScope;
end;

// -------------------------------------------------------------------------
//       
procedure TLineScope.ReRangeScope();
begin
  CalcScale();
  fX0 := fGRect.Left + Abs(GetGW(MinScope));
end;
// -------------------------------------------------------------------------
//     Bmp
procedure TLineScope.PaintToBmp(Bmp : TBitMap);
const clTransp = clTeal;
var wX      : integer;
    CFields : TColor;
    CValue  : TColor;
begin
   if not Visible then Exit;
   //   
   CValue := GetColorByValue(csBright,   Value);
   CFields := RGB(200,220,240);
   //  
   with Bmp.Canvas
   do begin
      Pen.Color := clBlack;
      Pen.Style := psSolid;
      Pen.Width := 1;
      // -----------------------------
      if not Transparent
      then  begin
         //      
         Pen.Color := clWhite;
         Brush.Color := CFields;
         Brush.Style := bsSolid;
         Rectangle(fFRect);
         //   
         Pen.Color := clBlack;
         MoveTo(fFRect.Left,    fFRect.Bottom-1);
         LineTo(fFRect.Right-1, fFRect.Bottom-1);
         MoveTo(fFRect.Right-1, fFRect.Top);
         LineTo(fFRect.Right-1, fFRect.Bottom);
      end;
      // -----------------------------
      //  
      Brush.Color := CValue;
      Brush.Style := bsSolid;
      Ellipse(fIRect);
      // -----------------------------
      //  
      Brush.Style := bsClear;
      TextOut(fVRect.Left, fVRect.Top,
               ' ' + Format(cOutPic, [Value])
             + ' ' + Measure + ' ' );
      // -----------------------------
      if not Compact
      then begin
        // ---------------------------
        //   
        Brush.Color := CFields;
        Brush.Style := bsSolid;
        Rectangle(fGRect);
        // ---------------------------
        //   
        Pen.Style := psClear;
        Brush.Style := bsSolid;
        Brush.Color := CValue;
        if Value >= 0
        then begin
           wX := fX0 + GetGW(Value);
           Rectangle(fX0, fGRect.Top + 1, wX, fGRect.Bottom);
           Pen.Style := psSolid;
           MoveTo(wX, fGRect.Top);
           LineTo(wX, fGRect.Bottom);
        end else begin
           wX := fX0 - GetGW(Value);
           Rectangle(wX, fGRect.Top + 1, fX0, fGRect.Bottom);
           Pen.Style := psSolid;
           MoveTo(wX, fGRect.Top);
           LineTo(wX, fGRect.Bottom);
        end;
        // ---------------------------
        Pen.Width := 2;
        MoveTo(fX0, fGRect.Top);
        LineTo(fX0, fGRect.Bottom - 1);
        // ---------------------------
        //  
        if ScopeName <> ''
        then begin
            Brush.Color := CFields;
            Brush.Style := bsClear;
            TextOut(fTRect.Left, fTRect.Top, ScopeName);
        end;
        ShowMarks(Bmp);
      end;
   end;
end;
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

// ================================================================
//   TLineScope. 
// ================================================================

end.
