unit DnConsole03;
// ====================================================================
(*
                 

         ,
          .
         :

       TLineScope   -  ;
       TRingScope   -  ;
       TSwitchScope -     ;
       TDigitsScope -        .

          
     LoadBaseImg(FileName : string),  
     *.jpg .

         (
   DescScopeArr),      TDescScope.
        ,   ,
         ,  
        .   
           , 
           LoadAllScopes.
   :  LoadAllScopes(High(DescScopeArr), Addr(DescScopeArr))

   // -----------------------------------------------------
   //    :
   const DescScopeArr : array[0..MaxIndxDescSope] of TDescScope =
   ( ........... );
   var   DnConsole : TDnConsole;  //  
         wDir      : string;      //   
   procedure TForm1.Button1Click(Sender: TObject);
   begin
      if Assigned(DnConsole) then Exit;
      DnConsole := TDnConsole.Create(1200,800);
      DnConsole.LoadBaseImg(wDir + '\PICTUREs\Default.jpg');
      DnConsole.LoadAllScopes(High(DescScopeArr), Addr(DescScopeArr));
      DnConsole.DnFRM.Show;
   end;
   // -----------------------------------------------------

         'L', 'R' ,'S'  
   :
   procedure SetValueToScope(RqIndx : integer; RqValue : extended);
   : RqIndx -   ,    
                      ;
        RqValue -   .

         'D' ,  
       ,      
     . :

    // -----------------------------------------------------
    //  Word -    'D'   
    //  RqRadix  .
    // (.  TRadix    TDigitsScope)
    procedure ShowDScope(RqIndx : integer; RqRadix : TRadix; Value : Word);
    var wScope  : TCustomScope;
    begin
       if not Assigned(DnConsole) then Exit;
       wScope := DnConsole.Scope[RqIndx];
       if Assigned(wScope)
       then begin
          if (wScope is TDigitsScope)
          then TDigitsScope(wScope).ShowWordValue(RqRadix, Value);
       end;
    end;
    // -----------------------------------------------------

           

    // -----------------------------------------------------
     3.00. ()  , , , 2018.
                 () Source code  ..
      04.07.2018
*)
// ====================================================================

interface

uses Windows, Messages, Classes, Controls, Forms, SysUtils, Graphics,
     Dialogs, ComCtrls, StdCtrls, ExtCtrls, Menus, MMSystem,
     //  
     ImgLoadSave03,
     CustomScope03, LineScope03, RingScope03, SwitchScope03, DigitsScope03,
     DnGridEd03, DnAlarm03, DTF03, SpectrScopes03, Oscillograph03;

// =========================================================================
//       
// =========================================================================
//      ( 1 msec)
//    unit MMSystem.pas
type TTimeStampsMM = record
  MMErr  : word;             //      
  BTime  : LongInt;          //    msec
  ETime  : LongInt;          //    msec
end;

// ================================================================
//       
// ================================================================
//   
type TDescScope = record
     // --------------------
     LastScope   : boolean;     //  -    
     // --------------------
     ScopeType   : char;        //  
                                // 'L'-,
                                // 'R'-,
                                // 'S'-,
                                // 'D'- 
     // --------------------
     ScopeName   : string;      //  
     Measure     : string;      //   
     // --------------------
     MinScope    : extended;    //   (. )
     MaxScope    : extended;    //    (. )
     P2Wall      : extended;    //      
     P1Wall      : extended;    //     
     N2Wall      : extended;    //      
     N1Wall      : extended;    //     
     WallStyle   : TWallStyle;  //     
     // --------------------
     NumLPF      : byte;        //      ( 0)
     // --------------------
     XBeg, YBeg  : integer;     //     
     ScopeWidth  : integer;     //   (  L-)
     // --------------------
     Compact     : boolean;     //  ( S  L-)
     ScopeStyle  : TScopeStyle; //   ( R -)
     Transparent : boolean;     // 
     // --------------------
     //  
     // --------------------
     GrmNum      : integer;     //      ( 0)
     Grm1P       : extended;    //     (msec) ( 0)
     // --------------------
     //   
     Radix       : TRadix;      //     
     DFrame      : TDFrame;     //   
end;

// ================================================================
//       (DTF)
//   .
// ================================================================
type TSpectrData = record
    ScopeIndx : integer;           //   
    YMaxNum   : integer;           //     
    YIndx     : integer;           //     
    ArrY      : array of extended; //    
    GrmMax    : extended;          // .    
    GrmIndx : integer;             //   
    ArrS      : TArrSpectr;        //   
end;

// ================================================================
//  TDnConsole   
// ================================================================
const TimeReSizeOut = 300;        //     ReSize

type TDnConsole = class(TObject)
private
   // -----------
   fDnFRM        : TForm;         //  
   // -----------
   fTimer        : TTimer;        //    ReSize
   // -----------
   fPanCTRL1     : TPanel;        //   1
   fLbX          : TLabel;        // : MouseX
   fLbY          : TLabel;        // : MouseY
   fStxtX        : TStaticText;   // MouseX
   fStxtY        : TStaticText;   // MouseY
   fLbSel        : TLabel;        // :  
   fCbBoxSel     : TComboBox;     //  
   fLbShow       : TLabel;        // :  
   fBttShow      : TButton;       //  
   fChBoxOs1     : TCheckBox;     // . 
   fChBoxGrd     : TCheckBox;     // . GRID - 
   fChBoxAlrm    : TCheckBox;     // . ALARM - 
   // -----------
   fLbDTF        : TLabel;        // : DTF (msec)
   fStxtDTF      : TStaticText;   // DTF (msec)
   fLbGrm1       : TLabel;        // : GRM1 (msec)
   fStxtGrm1     : TStaticText;   // GRM1 (msec)
   // -----------
   fPageCTRL     : TPageControl;  //   TPageControl
   fScrollBox    : TScrollBox;    // fScrollBox  fImg
   fImg          : TImage;        //  Image
   // -----------
   fPanSPEC      : TPanel;        //   
   // -----------
   fPanCTRL2     : TPanel;
   fLbSamp       : TLabel;        // :   (   )
   fStxtSamp     : TStaticText;   //   (   )
   fPrgsBar      : TProgressBar;
   fLbGrmSel     : TLabel;        // :   
   fStxtGrmSel   : TStaticText;   //   
   fLbPerSel     : TLabel;        // :    (msec)
   fStxtPerSel   : TStaticText;   //    (msec)
   fLbFrqSel     : TLabel;        // :    (Hz)
   fStxtFrqSel   : TStaticText;   //    (Hz)
   fLbAmpSel     : TLabel;        // :   
   fStxtAmpSel   : TStaticText;   //   
   fChBoxHandGrm : TCheckBox;     //    
   fLbOscGrmPrm  : TLabel;        // :  
   fCmbBoxGrmPrm : TComboBox;     //  
   fLbOscGrmPA   : TLabel;        // :   
   fEdOscGrmPA   : TEdit;         //   
   fBttOscGrmPA  : TButton;       // 
   // -----------
   fPanCTRL3     : TPanel;
   // ========================================
   //     
   fScopeIndx  : integer;
   //    
   fScopeArr     : array of TCustomScope;
   // ========================================
   fOsScope      : TOscillograph; //   
   // -----------
   fGRID         : TDnGridEd;     //  GRID - 
   // -----------
   fALARM        : TDnAlarm;      //  ALARM - 
   // ========================================
   fSpectrData   : TSpectrData;   //   DTF   
   fDTF          : TDTF03;        //    
   fDFTStamps    : TTimeStampsMM; //     DTF
   // -----------
   fSpectrScope  : TSpectrScope;  //  
   fOscCTRL3     : TOscillograph; //    
   // ========================================
   fXMove        : integer;       // X -   
   fYMove        : integer;       // Y -   
   fFlgXOR       : boolean;       //    
   // ========================================
   //   onClose   fFRM
   procedure OnFRMClose(Sender: TObject; var Action: TCloseAction);
   //   onReSize   fFRM
   procedure OnFRMResize(Sender: TObject);
   //    onReSize   fFRM
   procedure OnReSizeTimer(Sender: TObject);
   //  ReSize   fFRM
   procedure FRMResize();
   // ========================================
   //  CREATE / FREE
   // ========================================
   //      fPanCTRL1
   procedure CreateAllInPanCTRL1();
   //      fPanCTRL2
   procedure CreateAllInPanCTRL2();
   //     PopupMenu
   procedure  GreateAndConnecPoUpMenu();
   //      
   procedure CreateAllInfPageCTRL();
   //      
   procedure CreateAllTools();
   // ----------------------
   //      fPanCTRL1   
   procedure FreeAllInPanCTRL1();
   //      fPanCTRL2   
   procedure FreeAllInPanCTRL2();
   // ========================================
   //    (fScopeArr)
   // ========================================
   //     
   procedure InitScope(RqScope : TCustomScope; RqDescScope : TDescScope);
   //      
   procedure FreeScopes();
   // ========================================
   //    ( fScopeIndx)
   // ========================================
   //       
   procedure HidenShowSectrTab();
   //    
   //    
   procedure InitAdditionalScopes();
   // -----------
   //      fCbBoxSel
   procedure CbBoxSelClick(Sender : TObject);
   //       Img
   function ClickIndByImgXY(X,Y : integer): integer;
   // -----------
   //       fImg
   // -----------
   //     (ssAlt)   
   procedure MouseDown(Sender: TObject; Button: TMouseButton;
                       Shift: TShiftState; X, Y: Integer);
   //  
   procedure MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
   //   
   procedure MouseUp(Sender: TObject; Button: TMouseButton;
                     Shift: TShiftState; X, Y: Integer);
   // -----------
   //    
   // -----------
   //       
   procedure SelectScopeToAdditionalScope();
   // -----------
   //  
   // -----------
   //    
   procedure MenuClick(Sender : TObject);
   //      
   procedure ShowAllScope(Sender : TObject);
   // -----------
   //      
   function GetScope(RqIndx : integer) : TCustomScope;
   // ========================================
   //       
   // ========================================
   //    GRID - 
   procedure SetGRIDParam (RqGRID : TDnGridEd; RqIndx : integer);
   // /  GRID - 
   procedure onGRIDClick(Sender: TObject);
   // -----------
   //    ALARM - 
   procedure SetALARMParam (RqALARM : TDnAlarm; RqIndx : integer);
   // / ALARM - 
   procedure onALARMClick(Sender: TObject);
   // -----------
   //       
   procedure InitOsScope(RqOs : TOscillograph; RqIndx : integer);
   //  /   
   procedure ChBoxOs1Click(Sender: TObject);
   // ========================================
   //   
   // ========================================
   //   "  "
   procedure onSelectGrm (Sender: TObject;
                          Num : integer; ArrGrm : TArrSpectr);
   //    SpectrScope   
   procedure ShowSpectrScope();
   //     
   procedure CalcAndShowDTF();
   //         
   procedure AddValueToSampleArr(RqValue : extended);
   //    DTF
   procedure InitSpectrData(RqIndx : integer);
   // -----------
    //     
   procedure CmbBoxGrmPrmShow();
   //   -     
   procedure CmbBoxGrmPrmClick(Sender : TObject);
   //       
   procedure AutoScaleToOscGrm(AmpGrm : extended);
   //     
   procedure InitOscGrm(RqScopeIndx, RqGrmIndx : integer);
   //   -     
   procedure ChBoxHandGrmClick(Sender : TObject);
   //   -     
   procedure BttOsGrmPAClick(Sender : TObject);

public
   // -----------
   //  
   constructor Create(RqFrmW, RqFrmH : integer);
   //  
   procedure Free;
   // ========================================
   //    
   procedure LoadBaseImg(RqFileName : string);
   //   c   
   procedure LoadAllScopes(RqHighIndxArr    : integer;
                           RqPtDescScopeArr : pointer);
   //      
   procedure SetValueToScope(RqIndx : integer; RqValue : extended);

   // ========================================
   //     
   property Scope[RqIndx : integer] : TCustomScope read GetScope;
   // ========================================
   //       
   property DnFRM : TForm read fDnFRM;

end;

// =========================================================================
// =========================================================================

implementation

// =========================================================================
// =========================================================================

//    
const
      cDFRM_MinW    = 860;    // .   
      cDFRM_MinH    = 640;    // .   

//    fPageCTRL
const
      cTabTitles : array[0..1] of ShortString = ('', '');

//   
const
      cPanCTRL1_H   = 60;    //    fPanCTRL1
      cPanSPEC_H    = 300;   //    fPanSPEC

//     
const cScopeMaxCount = 500;

// =========================================================================
//       
// =========================================================================
// -------------------------------------------------------------------------
// 02.01.2017
//    
function StartMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   Result := '';
   try
       RqStamp.BTime := timeGetTime;
       RqStamp.MMErr := 0;
   except
       RqStamp.MMErr := 1;          //   
       Result := '.';
   end;
end;
// -------------------------------------------------------------------------
// 02.01.2017
//       
function StopMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   if RqStamp.MMErr = 0
   then begin
      with RqStamp
      do begin
          try
            ETime := timeGetTime;
            if (ETime - BTime) >= 0
            then Result := IntToStr(ETime - BTime)
            else Result := '';
          except
            MMErr := 1;
            Result := '.';
          end;
      end;
   end;
end;
// ================================================================
//    fFRM     
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//   fFRM   Close   
procedure TDnConsole.OnFRMClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caHide;  // TCloseAction = (caNone, caHide, caFree, caMinimize);
end;
// ================================================================
//  ReSize   fFRM
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//   onReSize   fFRM
procedure TDnConsole.OnFRMResize(Sender: TObject);
begin
    FRMResize();
    fTimer.Enabled  := True;
    fTimer.Interval := TimeReSizeOut;
end;
// ----------------------------------------------------------------
// 04.07.2018
//    onReSize
procedure TDnConsole.OnReSizeTimer(Sender: TObject);
begin
   fTimer.Enabled  := False;
   fDnFRM.Realign;
end;
// ----------------------------------------------------------------
// 04.07.2018
//  ReSize   fFRM
//     ""
//     
procedure  TDnConsole.FRMResize;
begin
  if Assigned(fPanSPEC) and Assigned(fPageCTRL)
  then begin
    if Assigned(fPageCTRL.Pages[High(cTabTitles)])
    then fPanSPEC.Height := fPageCTRL.Pages[High(cTabTitles)].Height div 2;
  end;
end;
// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//   fPanCTRL1      
procedure TDnConsole.CreateAllInPanCTRL1();
const //------------
      cYLv1   = 10;          //    
      cYLv2   = 30;          //    
      //------------
      cXGr1   = 10;          // X - c    1
      cXGr2   = 54;          // X - c    2
      cXGr3   = 120;         // X - c    3
      cXGr4   = 340;         // X - c    4
      cXGr5   = 420;         // X - c    5
      cXGr6   = 550;         // X - c    6
      cXGr7   = 690;         // X - c    7
      cXGr8   = 770;         // X - c    8
begin
   // -----------------------
   //    1
   fLbX := TLabel.Create(fPanCTRL1);
   with fLbX do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr1,cYLv1, 40,16);
      AutoSize := False;
      Caption  := 'MouseX';
   end;
   fLbY := TLabel.Create(fPanCTRL1);
   with fLbY do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr1,cYLv2, 40,16);
      AutoSize := False;
      Caption  := 'MouseY';
   end;
   // -----------------------
   //    2
   fStxtX := TStaticText.Create(fPanCTRL1);
   with fStxtX do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr2,cYLv1, 50,16);
      AutoSize    := False;
      BorderStyle := sbsSunken;
   end;
   fStxtY := TStaticText.Create(fPanCTRL1);
   with fStxtY do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr2,cYLv2, 50,16);
      AutoSize    := False;
      BorderStyle := sbsSunken;
   end;
   // -----------------------
   //    3
   fLbSel := TLabel.Create(fPanCTRL1);
   with fLbSel do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr3,cYLv1, 200,16);
      AutoSize := False;
      Caption  := ' ';
   end;
   fCbBoxSel  := TComboBox.Create(fPanCTRL1);
   with fCbBoxSel do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr3,cYLv2-4, 200,16);
      OnClick := CbBoxSelClick;
   end;
   // -----------------------
   //    4
   fLbShow  := TLabel.Create(fPanCTRL1);
   with fLbShow do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr4,cYLv1, 60,16);
      AutoSize := False;
      Caption  := '';
   end;
   fBttShow := TButton.Create(fPanCTRL1);;
   with fBttShow do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr4 -1,cYLv2 - 4, 64,20);
      Caption   := '    ';
      fBttShow.OnClick := ShowAllScope;
   end;
   // -----------------------
   //    5
   fChBoxOs1 := TCheckBox.Create(fPanCTRL1);
   with fChBoxOs1 do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr5,cYLv1, 140,16);
      Caption  := '. ';
      fChBoxOs1.OnClick := ChBoxOs1Click;
   end;
   fChBoxGrd := TCheckBox.Create(fPanCTRL1);
   with fChBoxGrd do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr5,cYLv2, 140,16);
      Caption  := '. GRID - ';
      fChBoxGrd.OnClick := onGRIDClick;
   end;
   // -----------------------
   //    6
   fChBoxAlrm := TCheckBox.Create(fPanCTRL1);
   with fChBoxAlrm do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr6,cYLv2, 140,16);
      Caption  := '. ALARM - ';
      fChBoxAlrm.OnClick := onALARMClick;
   end;
   // -----------------------
   //    7
   fLbDTF := TLabel.Create(fPanCTRL1);
   with fLbDTF do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr7,cYLv1, 70,16);
      AutoSize := False;
      Caption  := 'DTF (msec)';
   end;
   fStxtDTF := TStaticText.Create(fPanCTRL1);
   with fStxtDTF do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr7,cYLv2, 70,16);
      AutoSize    := False;
      BorderStyle := sbsSunken;
   end;
   // -----------------------
   //    8
   fLbGrm1 := TLabel.Create(fPanCTRL1);
   with fLbGrm1 do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr8,cYLv1, 70,16);
      AutoSize := False;
      Caption  := 'GRM1 (msec)';
   end;
   fStxtGrm1 := TStaticText.Create(fPanCTRL1);
   with fStxtGrm1 do
   begin
      Parent := fPanCTRL1;
      SetBounds(cXGr8,cYLv2, 70,16);
      AutoSize    := False;
      BorderStyle := sbsSunken;
   end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//      fPanCTRL2
procedure TDnConsole.CreateAllInPanCTRL2();
const cXGrF1  = 10;
      cF1W    = 220;
      cXGrF2  = 230;
      cF2W    = 100;
      StepY   = 26;
      //------------
      cYGr1   = 10;               // Y - c   1
      cYGr2   = cYGr1 + StepY;    // Y - c   2
      cYGr3   = cYGr2 + StepY;    // Y - c   3
      cYGr4   = cYGr3 + StepY;    // Y - c   4
      cYGr5   = cYGr4 + StepY;    // Y - c   5
      cYGr6   = cYGr5 + StepY;    // Y - c   6
      cYGr7   = cYGr6 + StepY;    // Y - c   7
      cYGr8   = cYGr7 + StepY;    // Y - c   8
      cYGr9   = cYGr8 + StepY;    // Y - c   9
      cYGr10  = cYGr9 + StepY;    // Y - c   10
begin
   // -----------------------
   //    1
   fLbSamp := TLabel.Create(fPanCTRL2);
   with fLbSamp do
   begin
      Parent := fPanCTRL2;
      SetBounds(10,cYGr1, cF1W,16);
      AutoSize := False;
      Caption  := '  (   )';
   end;
   fStxtSamp := TStaticText.Create(fPanCTRL2);
   with fStxtSamp do
   begin
      Parent := fPanCTRL2;
      SetBounds(cXGrF2,cYGr1, cF2W,16);
      AutoSize    := False;
      BorderStyle := sbsSunken;
   end;
   // -----------------------
   //    2
   fPrgsBar := TProgressBar.Create(fPanCTRL2);
   with fPrgsBar do
   begin
      Parent := fPanCTRL2;
      SetBounds(10, cYGr2, fPanCTRL2.Width - 20, 16);
      Min := 0;
      Max := 100;
      Position := 50;
   end;
   // -----------------------
   //    3
   fLbGrmSel := TLabel.Create(fPanCTRL2);
   with fLbGrmSel do
   begin
      Parent := fPanCTRL2;
      SetBounds(10,cYGr3, cF1W,16);
      AutoSize := False;
      Caption  := '  ';
   end;
   fStxtGrmSel := TStaticText.Create(fPanCTRL2);
   with fStxtGrmSel do
   begin
      Parent := fPanCTRL2;
      SetBounds(cXGrF2,cYGr3, cF2W,16);
      AutoSize    := False;
      BorderStyle := sbsSunken;
   end;
   // -----------------------
   //    4
   fLbPerSel := TLabel.Create(fPanCTRL2);
   with fLbPerSel do
   begin
      Parent := fPanCTRL2;
      SetBounds(10,cYGr4, cF1W,16);
      AutoSize := False;
      Caption  := '   (msec)';
   end;
   fStxtPerSel := TStaticText.Create(fPanCTRL2);
   with fStxtPerSel do
   begin
      Parent := fPanCTRL2;
      SetBounds(cXGrF2,cYGr4, cF2W,16);
      AutoSize    := False;
      BorderStyle := sbsSunken;
   end;
   // -----------------------
   //    5
   fLbFrqSel := TLabel.Create(fPanCTRL2);
   with fLbFrqSel do
   begin
      Parent := fPanCTRL2;
      SetBounds(10,cYGr5, cF1W,16);
      AutoSize := False;
      Caption  := '   (Hz)';
   end;
   fStxtFrqSel := TStaticText.Create(fPanCTRL2);
   with fStxtFrqSel do
   begin
      Parent := fPanCTRL2;
      SetBounds(cXGrF2,cYGr5, cF2W,16);
      AutoSize    := False;
      BorderStyle := sbsSunken;
   end;
   // -----------------------
   //    6
   fLbAmpSel := TLabel.Create(fPanCTRL2);
   with fLbAmpSel do
   begin
      Parent := fPanCTRL2;
      SetBounds(10,cYGr6, cF1W,16);
      AutoSize := False;
      Caption  := '  ';
   end;
   fStxtAmpSel := TStaticText.Create(fPanCTRL2);
   with fStxtAmpSel do
   begin
      Parent := fPanCTRL2;
      SetBounds(cXGrF2,cYGr6, cF2W,16);
      AutoSize    := False;
      BorderStyle := sbsSunken;
   end;
   // -----------------------
   //    7
   fChBoxHandGrm := TCheckBox.Create(fPanCTRL2);
   with fChBoxHandGrm do
   begin
      Parent := fPanCTRL2;
      SetBounds(10,cYGr7, 300,16);
      Checked  := False;
      Caption  := '   ';
      fChBoxHandGrm.OnClick := ChBoxHandGrmClick;
   end;
   // -----------------------
   //    8
   fLbOscGrmPrm := TLabel.Create(fPanCTRL2);
   with fLbOscGrmPrm do
   begin
      Parent := fPanCTRL2;
      SetBounds(10,cYGr8, cF1W,16);
      AutoSize := True;
      Caption  := ' ';
   end;
   fCmbBoxGrmPrm := TComboBox.Create(fPanCTRL2);
   with fCmbBoxGrmPrm do
   begin
      Parent := fPanCTRL2;
      SetBounds(cXGrF2 - 120,cYGr8 - 4, cF2W + 120,16);
      with fCmbBoxGrmPrm.Items do
      begin
         Add('   ');
         Add('     ');
         Add('     ');
      end;
      ItemIndex := 0;
      OnClick := CmbBoxGrmPrmClick;
   end;
   // -----------------------
   //    9
   fLbOscGrmPA := TLabel.Create(fPanCTRL2);
   with fLbOscGrmPA do
   begin
      Parent := fPanCTRL2;
      SetBounds(10,cYGr9, cF1W,16);
      AutoSize := False;
      Caption  := '  ';
   end;
   fEdOscGrmPA := TEdit.Create(fPanCTRL2);
   with fEdOscGrmPA do
   begin
      Parent := fPanCTRL2;
      SetBounds(cXGrF2,cYGr9, cF2W,20);
      AutoSize := False;
      Enabled  := False;
      Text := '0';
   end;
   // -----------------------
   //    10
   fBttOscGrmPA := TButton.Create(fPanCTRL2);
   with fBttOscGrmPA do
   begin
      Parent := fPanCTRL2;
      SetBounds(cXGrF2,cYGr10 + 4, cF2W,20);
      Caption  := '';
      OnClick := BttOsGrmPAClick;
   end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//    fImg  PopupMenu
procedure  TDnConsole.GreateAndConnecPoUpMenu();
var MenuItems : array of TMenuItem;
begin
   SetLength(MenuItems, 3);
   // =================================
   MenuItems[0]:= NewItem('/', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_Visible');
   MenuItems[0].Tag := 1;
   // --------------------
   MenuItems[1]:= NewItem('  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_Style');
   MenuItems[1].Tag := 2;
   // --------------------
   MenuItems[2]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_Tranparent');
   MenuItems[2].Tag := 3;
   // =================================
   //    (PopupMenu)
   fImg.PopupMenu := NewPopupMenu(fImg, 'Menu',paLeft, True, MenuItems);
   // =================================
   SetLength(MenuItems,0);
end;
// ----------------------------------------------------------------
// 04.07.2018
//      
procedure TDnConsole.CreateAllInfPageCTRL();
const cCTRL2_W  = 340;
var   Ind : integer;
      wHeight  : integer;
      wWidth   : integer;
      wHalfH   : integer;
begin
   // ----------------------
   //  
   // ----------------------
   //   TPageControl
   fPageCTRL := TPageControl.Create(fDnFRM);
   fPageCTRL.Parent := fDnFRM;
   with fPageCTRL do
   begin
      SetBounds(0, cPanCTRL1_H, fDnFRM.ClientWidth, fDnFRM.ClientHeight);
      Align := alClient;
   end;
   //     TPageControl
   for Ind := Low(cTabTitles) to High(cTabTitles) do
   with TTabSheet.Create(fPageCTRL) do
   begin
      PageControl := fPageCTRL;
      Name := 'ts' + IntToStr(Ind);
      Caption := cTabTitles[Ind];
   end;
   fPageCTRL.TabIndex := Low(cTabTitles);
   fPageCTRL.Visible  := True;
   // ----------------------
   //    fPageCTRL ( Pages[Low(cTabTitles)])
   // ----------------------
   //  fScrollBox     Low(cTabTitles)
   fScrollBox  := TScrollBox.Create(fPageCTRL.Pages[Low(cTabTitles)]);
   with fScrollBox do
   begin
      Parent := fPageCTRL.Pages[Low(cTabTitles)];
      Align := alClient;
   end;
   // ----------------------
   //  fImg  fScrollBox
   fImg := TImage.Create(fScrollBox);
   with fImg do
   begin
      Parent := fScrollBox;
      SetBounds(0,0,10,10);
      AutoSize := False;
      OnMouseDown := MouseDown;
      OnMouseMove := nil;  // MouseMove -    
      OnMouseUp   := nil;  // MouseUp  -    
      //     PopupMenu
      GreateAndConnecPoUpMenu();
   end;
   // ----------------------
   // ======================
   wHeight := fPageCTRL.Pages[High(cTabTitles)].Height;
   wWidth  := fPageCTRL.Pages[High(cTabTitles)].Width;
   wHalfH  := wHeight div 2;
   fPanSPEC := TPanel.Create(fPageCTRL.Pages[High(cTabTitles)]);
   with fPanSPEC do
   begin
      Parent := fPageCTRL.Pages[High(cTabTitles)];
      SetBounds(0, 0, wWidth, wHalfH - 1);
      Align    := alTop;
   end;
   // ----------------------
   //   fPanCTRL2
   fPanCTRL2 := TPanel.Create(fPageCTRL.Pages[High(cTabTitles)]);
   with fPanCTRL2 do
   begin
      Parent := fPageCTRL.Pages[High(cTabTitles)];
      SetBounds(0, wHalfH + 1, cCTRL2_W, wHalfH);
      Align    := alLeft;
   end;
   //      fPanCTRL2
   CreateAllInPanCTRL2();
   // ----------------------
   fPanCTRL3 := TPanel.Create(fPageCTRL.Pages[High(cTabTitles)]);
   with fPanCTRL3 do
   begin
      Parent := fPageCTRL.Pages[High(cTabTitles)];
      SetBounds(fPanCTRL2.Width + 1, wHalfH + 1, wWidth - cCTRL2_W - 1, wHalfH);
      Align    := alClient;
   end;
end;
// ================================================================
//   
// ================================================================
// 04.07.2018
//      
procedure TDnConsole.CreateAllTools();
begin
   // ----------------------
   //    
   fDTF         := TDTF03.Create;
   // ----------------------
   //  
   fSpectrScope := TSpectrScope.Create(fPanSPEC);
   //     SpectrScope   
   fSpectrScope.DialogLoadSpectrOnOff(False);
   //    "   "
   fSpectrScope.OnGrmSelect := onSelectGrm;
   // ----------------------
   //    
   fOscCTRL3 := TOscillograph.Create(fPanCTRL3);
   // ----------------------
end;
// ================================================================
//   ( )
// ================================================================
// ----------------------------------------------------------------
//   ( Public)
constructor TDnConsole.Create(RqFrmW, RqFrmH : integer);
begin
   inherited Create;
   // -----------------------
   //   
   fDnFRM := TForm.Create(nil);
   with fDnFRM do
   begin
      BorderIcons := [biSystemMenu,biMinimize,biMaximize];
      Caption   := '   ';
      Position  := poDesktopCenter;
      FormStyle := fsNormal;
      AutoSize  := False;
      if RqFrmW < cDFRM_MinW
      then ClientWidth := cDFRM_MinW
      else ClientWidth := RqFrmW;
      if RqFrmH < cDFRM_MinH
      then ClientHeight := cDFRM_MinH
      else ClientHeight := RqFrmH;
      Constraints.MinHeight := cDFRM_MinH;
      Constraints.MinWidth  := cDFRM_MinW;
      OnClose  := OnFRMClose;
   end;
   // ----------------------
   //    fPanCTRL1
   fPanCTRL1 := TPanel.Create(fDnFRM);
   fPanCTRL1.Parent := fDnFRM;
   with fPanCTRL1 do
   begin
      SetBounds(0, 0, fDnFRM.ClientWidth, cPanCTRL1_H);
      Align := alTop;
   end;
   //      fPanCTRL1
   CreateAllInPanCTRL1();
   // ----------------------
   //      
   CreateAllInfPageCTRL();
   // ----------------------
   //      
   CreateAllTools();
   // ----------------------
   //    onReSize
   fTimer := TTimer.Create(nil);
   fTimer.Enabled  := False;
   fTimer.Interval := TimeReSizeOut;
   fTimer.OnTimer  := OnReSizeTimer;
   // ----------------------
   //  ,   ReSize
   fDnFRM.onResize := OnFRMResize;
   // ----------------------
end;
// ================================================================
//  
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//      fPanCTRL1   
procedure TDnConsole.FreeAllInPanCTRL1();
begin
   // --------
   if Assigned(fChBoxAlrm)   then fChBoxAlrm.Free;
   if Assigned(fChBoxGrd)    then fChBoxGrd.Free;
   if Assigned(fChBoxOs1)    then fChBoxOs1.Free;
   // --------
   if Assigned(fBttShow)     then fBttShow.Free;
   if Assigned(fLbShow)      then fLbShow.Free;
   // --------
   if Assigned(fCbBoxSel)    then fCbBoxSel.Free;
   if Assigned(fLbSel)       then fLbSel.Free;
   // --------
   if Assigned(fStxtY)       then fStxtY.Free;
   if Assigned(fStxtX)       then fStxtX.Free;
   // --------
   if Assigned(fLbY)         then fLbY.Free;
   if Assigned(fLbX)         then fLbX.Free;
   // --------
   if Assigned(fLbDTF)       then fLbDTF.Free;
   if Assigned(fStxtDTF)     then fStxtDTF.Free;
   // --------
   if Assigned(fLbGrm1)      then fLbGrm1.Free;
   if Assigned(fStxtGrm1)    then fStxtGrm1.Free;
   // ========
   if Assigned(fPanCTRL1)     then fPanCTRL1.Free;
end;
// --------------------------------------------------------------------
// 04.07.2018
//      fPanCTRL2   
procedure TDnConsole.FreeAllInPanCTRL2();
begin
   // --------
   if Assigned(fBttOscGrmPA)  then fBttOscGrmPA.Free;
   // --------
   if Assigned(fEdOscGrmPA)   then fEdOscGrmPA.Free;
   if Assigned(fLbOscGrmPA)   then fLbOscGrmPA.Free;
   // --------
   if Assigned(fCmbBoxGrmPrm) then fCmbBoxGrmPrm.Free;
   if Assigned(fLbOscGrmPrm)  then fLbOscGrmPrm.Free;

   // --------
   if Assigned(fChBoxHandGrm) then fChBoxHandGrm.Free;
   // --------
   if Assigned(fStxtAmpSel)  then fStxtAmpSel.Free;
   if Assigned(fLbAmpSel)    then fLbAmpSel.Free;
    // --------
   if Assigned(fStxtFrqSel)  then fStxtFrqSel.Free;
   if Assigned(fLbFrqSel)    then fLbFrqSel.Free;
   // --------
   if Assigned(fStxtPerSel)  then fStxtPerSel.Free;
   if Assigned(fLbPerSel)    then fLbPerSel.Free;
   // --------
   if Assigned(fStxtGrmSel)  then fStxtGrmSel.Free;
   if Assigned(fLbGrmSel)    then fLbGrmSel.Free;
   // --------
   if Assigned(fPrgsBar)     then fPrgsBar.Free;
   // --------
   if Assigned(fStxtSamp)    then fStxtSamp.Free;
   if Assigned(fLbSamp)      then fLbSamp.Free;
   // ========
   if Assigned(fPanCTRL2)    then fPanCTRL2.Free;
end;
// ================================================================
//   ( )
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//    ( Public)
procedure TDnConsole.Free;
begin
   // ===========================================
   //  ReSize
   fDnFRM.onResize := nil;
   if Assigned(fTimer) then fTimer.Free;
   // ===========================================
   //   
   // ===========================================
   if Assigned(fOscCTRL3)    then fOscCTRL3.Free;
   // if Assigned(fSignalScope) then fSignalScope.Free;
   //----------------------
   //      DTF
   SetLength(fSpectrData.ArrY,0);
   SetLength(fSpectrData.ArrS,0);
   if Assigned(fDTF)         then fDTF.Free;
   //----------------------
   if Assigned(fSpectrScope) then fSpectrScope.Free;
   //----------------------
   if Assigned(fALARM) then fALARM.Free;
   if Assigned(fGRID)  then fGRID.Free;
   if Assigned(fOsScope) then fOsScope.Free;
   //----------------------
   //      
   FreeScopes();
   // ===========================================
   //    
   // ===========================================
   //      
   // -------------------------------------------
   if Assigned(fPanCTRL3)    then fPanCTRL3.Free;
   //----------------------
   //      fPanCTRL2   
   FreeAllInPanCTRL2();
   //----------------------
   if Assigned(fImg)         then fImg.Free;
   if Assigned(fPanSPEC)     then fPanSPEC.Free;
   if Assigned(fScrollBox)   then fScrollBox.Free;
   // ---------------------
   //     fPageCTRL
   if Assigned(fPageCTRL)    then fPageCTRL.Free;
   // -------------------------------------------
   //      fPanCTRL1   
   FreeAllInPanCTRL1();
   // ===========================================
   //   
   if Assigned(fDnFRM) then fDnFRM.Free;
   // ===========================================
   //  
   inherited Free;
end;
// ================================================================
//  
// ================================================================
// --------------------------------------------------------------------
// 04.07.2018
//      ( Public)
procedure TDnConsole.LoadBaseImg(RqFileName : string);
var wImgLS : TLoadSaveImage;   //     Image
begin
    if not Assigned(fImg) then Exit;
    wImgLS := TLoadSaveImage.Create(nil,nil);
    try
       if wImgLS.LoadImgFromFile(RqFileName, fImg)
       then begin
         fImg.Height := fImg.Picture.Height;
         fImg.Width  := fImg.Picture.Width;
       end;
    finally
       wImgLS.Free;
    end;
end;
// ================================================================
//    
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//     
procedure TDnConsole.InitScope(RqScope : TCustomScope;
                               RqDescScope : TDescScope);
begin
  // -----------------
  RqScope.Visible     := False;
  // =================
  RqScope.ScopeName   := RqDescScope.ScopeName;
  RqScope.Measure     := RqDescScope.Measure;
  // -----------------
  RqScope.MinScope    := RqDescScope.MinScope;
  RqScope.MaxScope    := RqDescScope.MaxScope;
  RqScope.P2Wall      := RqDescScope.P2Wall;
  RqScope.P1Wall      := RqDescScope.P1Wall;
  RqScope.N2Wall      := RqDescScope.N2Wall;
  RqScope.N1Wall      := RqDescScope.N1Wall;
  RqScope.WallStyle   := RqDescScope.WallStyle;
  // -----------------
  RqScope.NumLPF      := RqDescScope.NumLPF;
  // -----------------
  RqScope.XBeg        := RqDescScope.XBeg;
  RqScope.YBeg        := RqDescScope.YBeg;
  // -----------------
  RqScope.Compact     := RqDescScope.Compact;
  RqScope.ScopeStyle  := RqDescScope.ScopeStyle;
  RqScope.Transparent := RqDescScope.Transparent;
  // -----------------
  RqScope.ScopeWidth  := RqDescScope.ScopeWidth;
  if (RqScope is TLineScope)
  then begin
     TLineScope(RqScope).MinScopeWidth := RqDescScope.ScopeWidth;
  end;
  // -----------------
  RqScope.GrmNum      := RqDescScope.GrmNum;
  RqScope.Grm1        := RqDescScope.Grm1P;
  // -----------------
  if (RqScope is TDigitsScope)
  then begin
     with (RqScope as TDigitsScope)
     do begin
       Radix     := RqDescScope.Radix;
       DFrame    := RqDescScope.DFrame;
       TxtColor  := clBlue;
       FonColor  := clSilver;
     end;
  end;
  // -----------------
  RqScope.Visible     := True;
  // =================
  fCbBoxSel.Items.Add(RqDescScope.ScopeName);

end;
// ----------------------------------------------------------------
// 04.07.2018
// ( Public)
//   c     
procedure TDnConsole.LoadAllScopes(RqHighIndxArr    : integer;
                                   RqPtDescScopeArr : pointer);
type TModel = array[0..cScopeMaxCount - 1] of TDescScope;
var  wURep, Ind : integer;
begin
   //    
   if Length(fScopeArr) > 0
   then begin
       wURep := MessageDlg('   ! ' + #13#10 +
                           '    ?',
                            mtInformation,[mbYes,mbNo],0);
       if wURep = mrYes
       then  FreeScopes()  //    
       else Exit;
   end;
   // -------------------------------------------
   //      
   fCbBoxSel.Clear;
   fScopeIndx := -1;
   if (RqPtDescScopeArr = nil) or (RqHighIndxArr  < 0) then Exit;
   SetLength(fScopeArr, RqHighIndxArr  + 1);
   Ind := 0;
   while Ind <= RqHighIndxArr
   do begin
     with TModel(RqPtDescScopeArr^)[Ind] do
     begin
        //  
        case ScopeType of
          'L' : fScopeArr[Ind] := TLineScope.Create(fImg,   XBeg, YBeg);
          'R' : fScopeArr[Ind] := TRingScope.Create(fImg,   XBeg, YBeg);
          'S' : fScopeArr[Ind] := TSwitchScope.Create(fImg, XBeg, YBeg);
          'D' : fScopeArr[Ind] := TDigitsScope.Create(fImg, XBeg, YBeg);
           else fScopeArr[Ind] := nil;
        end;
        //  
        if Assigned(fScopeArr[Ind]) then
        InitScope(fScopeArr[Ind], TModel(RqPtDescScopeArr^)[Ind]);
        //    
        if LastScope
        then begin
          //     ,   
          if (Ind < RqHighIndxArr ) then SetLength(fScopeArr, Ind + 1);
          Break;
        end;
     end;
     Ind := Ind + 1;
   end;
   // -------------------------
   //     
   fScopeIndx := Low(fScopeArr);
   fCbBoxSel.ItemIndex := fScopeIndx;
   //     
   HidenShowSectrTab();
   //       
   InitAdditionalScopes();
end;
// ----------------------------------------------------------------
// 04.07.2018
//      
procedure TDnConsole.FreeScopes();
var Ind : integer;
begin
  for Ind := Low(fScopeArr) to High(fScopeArr)
  do begin
    if Assigned(fScopeArr[Ind])
    then begin
       if fScopeArr[Ind] is TLineScope
       then begin
           TLineScope(fScopeArr[Ind]).Free;
           Continue;
       end;
       if fScopeArr[Ind] is TRingScope
       then begin
           TRingScope(fScopeArr[Ind]).Free;
           Continue;
       end;
       if fScopeArr[Ind] is TSwitchScope
       then begin
          TSwitchScope(fScopeArr[Ind]).Free;
          Continue;
       end;
       if fScopeArr[Ind] is TDigitsScope
       then begin
          TDigitsScope(fScopeArr[Ind]).Free;
          Continue;
       end;
       fScopeArr[Ind] := nil;
    end;
  end;
  SetLength(fScopeArr,0);
end;
// ================================================================
//    ( fScopeIndx)
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//     
procedure TDnConsole.HidenShowSectrTab();
var wIndx : integer;
begin
  if fScopeIndx < 0 then Exit;
  //    
  wIndx := fPageCTRL.PageCount - 1;
  if fScopeArr[fScopeIndx].GrmNum > 0
  then fPageCTRL.Pages[wIndx].TabVisible := True
  else fPageCTRL.Pages[wIndx].TabVisible := False;
end;
// ----------------------------------------------------------------
// 04.07.2018
//    
//    
procedure TDnConsole.InitAdditionalScopes();
begin
   if fScopeIndx < 0 then Exit;
   if (fScopeIndx < Low(fScopeArr)) or (fScopeIndx > High(fScopeArr))
   then Exit;
   if fScopeArr[fScopeIndx].Grm1 > 0
   then fStxtGrm1.Caption := ' ' + FloatToStr(fScopeArr[fScopeIndx].Grm1)
   else fStxtGrm1.Caption := ' .';
   fStxtDTF.Caption := '';
   // ------------------------------------
   //    ALARM - 
   if Assigned(fALARM) then SetALARMParam (fALARM, fScopeIndx);
   if Assigned(fGRID)  then SetGRIDParam  (fGRID,  fScopeIndx);
   if Assigned(fOsScope) then InitOsScope (fOsScope, fScopeIndx);
   // ------------------------------------
   //    DTF
   if Assigned(fSpectrScope) then InitSpectrData(fScopeIndx);
   //     
   if Assigned(fOscCTRL3) then InitOscGrm(fScopeIndx,0);

end;
// ----------------------------------------------------------------
// 04.07.2018
//      fCbBoxSel
procedure TDnConsole.CbBoxSelClick(Sender : TObject);
begin
   if fCbBoxSel.ItemIndex >= 0
   then begin
       fScopeIndx := fCbBoxSel.ItemIndex;
       HidenShowSectrTab();
       //       
       InitAdditionalScopes();
   end
end;
// ----------------------------------------------------------------
//        fImg
// ----------------------------------------------------------------
// 04.07.2018
//    RqX,RqY  RqRect
function IsXYInRect(const RqRect : TRect; RqX, RqY : integer): boolean;
begin
  Result := (RqX >= RqRect.Left) and (RqX <= RqRect.Right) and
            (RqY >= RqRect.Top)  and (RqY <= RqRect.Bottom);
end;
// ----------------------------------------------------------------
// 04.07.2018
//       Img
function TDnConsole.ClickIndByImgXY(X,Y : integer): integer;
var  Ind    : integer;
begin
   Result := -1;
   for Ind := Low(fScopeArr) to High(fScopeArr)
   do begin
     if IsXYInRect(fScopeArr[Ind].ScopeRect, X, Y)
     then begin
        Result := Ind;
        fScopeIndx := Result;
        fCbBoxSel.ItemIndex := fScopeIndx;
        HidenShowSectrTab();
        //       
        InitAdditionalScopes();
        Exit;
     end;
   end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//   
procedure TDnConsole.MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var wIndx : integer;              //     
begin
  fStxtX.Caption := IntToStr(X);
  fStxtY.Caption := IntToStr(Y);
  //   fScopeIndx ( -1  X,Y    )
  wIndx := ClickIndByImgXY(X,Y);
  // -------------------------------------------
  //      
  if (Shift * [ssAlt] <> []) and (wIndx >= 0)
  then begin
      //  ,   MouseMove  MouseUp
      fImg.OnMouseMove := MouseMove;
      fImg.OnMouseUp   := MouseUp;
  end
  else begin
      //  ,   MouseMove  MouseUp
      fImg.OnMouseMove := nil;
      fImg.OnMouseUp   := nil;
      Exit;
  end;
  // -------------------------------------------
  //     
  fFlgXOR := False;               //    
  fXMove  := X;                   // X -   
  fYMove  := Y;                   // Y -   
  //  
  fScopeArr[fScopeIndx].Visible := False;
  //   
  with fImg.Canvas
  do begin
    Pen.Style   := psDot;
    Pen.Mode    := pmNotXor;
    Brush.Style := bsClear;
  end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//  
procedure TDnConsole.MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var wSW, wSH : integer;
begin
   fStxtX.Caption := IntToStr(X);
   fStxtY.Caption := IntToStr(Y);
   wSW := fScopeArr[fScopeIndx].ScopeWidth;
   wSH := fScopeArr[fScopeIndx].ScopeHeight;
   with fImg.Canvas
   do begin
      //      
      if fFlgXOR then Rectangle(fXMove, fYMove, fXMove + wSW, fYMove + wSH);
      //       
      fXMove := X;
      fYMove := Y;
      Rectangle(fXMove, fYMove, fXMove + wSW, fYMove + wSH);
   end;
   fFlgXOR := True;
end;
// ----------------------------------------------------------------
// 04.07.2018
//   
procedure TDnConsole.MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var wSW, wSH : integer;
begin
   //   fImg.OnMouseMove
   fImg.OnMouseMove := nil;
   wSW := fScopeArr[fScopeIndx].ScopeWidth;
   wSH := fScopeArr[fScopeIndx].ScopeHeight;
   with fImg.Canvas
   do begin
      //   
      if fFlgXOR then Rectangle(fXMove, fYMove, fXMove + wSW, fYMove + wSH);
      //  Pen  Brush
      Pen.Style := psSolid;
      Pen.Mode  := pmCopy;
      Brush.Style := bsSolid;
   end;
   //     
   fScopeArr[fScopeIndx].ScopePosition(fXMove, fYMove);
   fScopeArr[fScopeIndx].Visible := True;
   //   fImg.OnMouseUp
   fImg.OnMouseUp   := nil;
end;
// ================================================================
//    
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//  Public
//        
procedure TDnConsole.SetValueToScope(RqIndx : integer; RqValue : extended);
begin
   if (RqIndx < Low(fScopeArr)) or (RqIndx > High(fScopeArr)) then Exit;
   fScopeArr[RqIndx].Value := RqValue;
   if RqIndx = fScopeIndx then SelectScopeToAdditionalScope();
end;
// ----------------------------------------------------------------
// 04.07.2018
//      () 
//      
procedure TDnConsole.SelectScopeToAdditionalScope();
var wValue : extended;
begin
   if fScopeIndx < 0 then Exit;
   if (fScopeIndx < Low(fScopeArr)) or (fScopeIndx > High(fScopeArr))
   then Exit;
   wValue := fScopeArr[fScopeIndx].Value;
      // ------------------------------------
   if Assigned(fALARM)   then fALARM.Value := wValue;
   if Assigned(fGRID)    then fGRID.CellsStr[1,6] := FloatToStr(wValue);
   if Assigned(fOsScope) then fOsScope.AddNewData(wValue);
   // ------------------------------------
   //         
   if Assigned(fSpectrScope) then AddValueToSampleArr(wValue);
end;
// ================================================================
//   ()  ( fScopeIndx)
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//    
procedure TDnConsole.MenuClick(Sender : TObject);
var wItem  : TMenuItem;
    Ind    : integer;
begin
   Ind := fScopeIndx;
   if not ((Ind >= Low(fScopeArr)) and (Ind <= High(fScopeArr))) then Exit;
   wItem :=  TMenuItem(Sender);
   case wItem.Tag of
   1 : begin      //   
          fScopeArr[Ind].Visible := not fScopeArr[Ind].Visible;
       end;
   2 : begin      //   
          if (fScopeArr[Ind] is TRingScope)
          then begin
             if fScopeArr[Ind].ScopeStyle = ssARC
             then fScopeArr[Ind].ScopeStyle := ssPIE
             else fScopeArr[Ind].ScopeStyle := ssARC;
          end
          else fScopeArr[Ind].Compact := not fScopeArr[Ind].Compact;
       end;
   3 : begin     //   
         fScopeArr[Ind].Transparent := not fScopeArr[Ind].Transparent;
       end;
   end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//      
procedure TDnConsole.ShowAllScope(Sender : TObject);
var Ind : integer;
begin
    for Ind := Low(fScopeArr) to High(fScopeArr)
    do if not fScopeArr[Ind].Visible then fScopeArr[Ind].Visible := True;
end;
// ----------------------------------------------------------------
// 04.07.2018
//  Public
//      
function TDnConsole.GetScope(RqIndx : integer) : TCustomScope;
begin
   Result := nil;
   if (RqIndx < Low(fScopeArr)) or (RqIndx > High(fScopeArr)) then Exit;
   Result := fScopeArr[RqIndx];
end;
// ================================================================
//  GRID-
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//    GRID - 
procedure TDnConsole.SetGRIDParam (RqGRID : TDnGridEd; RqIndx : integer);
var wM : string;
begin
  if not Assigned(RqGRID) then Exit;
  if (RqIndx < Low(fScopeArr)) or (RqIndx > High(fScopeArr)) then Exit;
  wM  := fScopeArr[RqIndx].Measure;
  if not (fScopeArr[RqIndx] is TSwitchScope)
  then wM  := ' (' + wM + ')' else wM  := '';
  with RqGRID
  do begin
    GridTitle := ' ' + fScopeArr[RqIndx].ScopeName;
    CellsStr[1,1] := IntToStr(fScopeArr[RqIndx].XBeg);
    CellsStr[1,2] := IntToStr(fScopeArr[RqIndx].YBeg);
    CellsStr[1,3] := FloatToStr(fScopeArr[RqIndx].MaxScope) + wM;
    CellsStr[1,4] := FloatToStr(fScopeArr[RqIndx].P2Wall) + wM;
    CellsStr[1,5] := FloatToStr(fScopeArr[RqIndx].P1Wall) + wM;
    CellsStr[1,6] := '';  //  
    CellsStr[1,7] := FloatToStr(fScopeArr[RqIndx].N1Wall) + wM;
    CellsStr[1,8] := FloatToStr(fScopeArr[RqIndx].N2Wall) + wM;
    CellsStr[1,9] := FloatToStr(fScopeArr[RqIndx].MinScope) + wM;
    if fScopeArr[RqIndx].NumLPF > 0
    then CellsStr[1,10] := IntToStr(fScopeArr[RqIndx].NumLPF)
    else CellsStr[1,10] := ' ';
    if fScopeArr[RqIndx].Grm1 > 0
    then CellsStr[1,11] := FloatToStr(fScopeArr[RqIndx].Grm1)
    else CellsStr[1,11] := ' ';
  end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//  ()/ () GRID - 
procedure TDnConsole.onGRIDClick(Sender: TObject);
begin
   if fChBoxGrd.Checked
   then begin
          if Assigned(fGRID) then Exit;
          //   GRID - 
          fGRID := TDnGridEd.Create(300, 250, True);
          // 
          with fGRID do
          begin
             RowMaxInd    := 11;
             RowTitle[1]  := ' Xb (pix)';
             RowTitle[2]  := ' Yb (pix)';
             RowTitle[3]  := ' Max. ';
             RowTitle[4]  := ' Max. 2 ';
             RowTitle[5]  := ' Max. 1 ';
             RowTitle[6]  := '  ';
             RowTitle[7]  := ' Min. 1 ';
             RowTitle[8]  := ' Min. 2 ';
             RowTitle[9]  := ' Min. ';
             RowTitle[10] := '    ';
             RowTitle[11] := '  1(msec) ';
          end;
          //    GRID -    
          SetGRIDParam (fGRID, fScopeIndx);
   end
   else begin
          if Assigned(fGRID)
          then begin
             fGRID.Free;
             fGRID := nil;
          end;
    end;
end;
// ================================================================
//  ALARM-
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//    ALARM - 
procedure TDnConsole.SetALARMParam (RqALARM : TDnAlarm; RqIndx : integer);
begin
   //  
   if not Assigned(fALARM) then Exit;
   if (RqIndx < Low(fScopeArr)) or (RqIndx > High(fScopeArr)) then Exit;
   // 
   with fScopeArr[RqIndx]
   do begin
      fALARM.Title  := ScopeName;
      fALARM.YMes   := Measure;
      fALARM.P2Wall := P2Wall;
      fALARM.P1Wall := P1Wall;
      fALARM.N2Wall := N2Wall;
      fALARM.N1Wall := N1Wall;
      case WallStyle of
         //  
         wsNotUse : fALARM.AlarmMode := alrmNotUse;
         //    
         wsDam    : fALARM.AlarmMode := alrmDam;
         //    
         wsLimit  : fALARM.AlarmMode := alrmLimit;
      end;
   end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//  ()/ () GRID - 
procedure TDnConsole.onALARMClick(Sender: TObject);
begin
   if fChBoxAlrm.Checked
   then begin
          if Assigned(fALARM) then Exit;
          //   ALARM - 
          fALARM := TDnAlarm.Create(380, 250);
          //    ALARM -    
          SetALARMParam (fALARM, fScopeIndx);
   end
   else begin
          if Assigned(fALARM)
          then begin
             fALARM.Free;
             fALARM := nil;
          end;
    end;
end;
// ================================================================
//   
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//       
procedure TDnConsole.InitOsScope(RqOs : TOscillograph; RqIndx : integer);
begin
  if not Assigned(RqOs) then Exit;
  if (RqIndx < Low(fScopeArr)) or (RqIndx > High(fScopeArr)) then Exit;
  RqOs.Clear;
  with fScopeArr[RqIndx]
  do begin
    RqOs.Title := ScopeName;
    RqOs.YMes  := Measure;
    if Abs(MaxScope) >= Abs(MinScope)
    then RqOs.YMax  := Abs(MaxScope)
    else RqOs.YMax  := Abs(MinScope);
    RqOs.P2Wall     := P2Wall;
    RqOs.P1Wall     := P1Wall;
    RqOs.N2Wall     := N2Wall;
    RqOs.N1Wall     := N1Wall;
  end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//  ()/ ()   
procedure TDnConsole.ChBoxOs1Click(Sender: TObject);
begin
   if fChBoxOs1.Checked
   then begin
          if Assigned(fOsScope) then Exit;
          //    
          fOsScope := TOscillograph.Create(300, 200);
          //       
          InitOsScope(fOsScope, fScopeIndx);
   end
   else begin
          if Assigned(fOsScope)
          then begin
             fOsScope.Free;
             fOsScope := nil;
          end;
    end;
end;
// ================================================================
//   ( )
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//   "  "
procedure TDnConsole.onSelectGrm (Sender: TObject;
                                  Num : integer; ArrGrm : TArrSpectr);
var wPeriod, wFreq : extended;
begin
   //   
   fStxtGrmSel.Caption := ' ' + IntToStr(Num);
   fStxtGrmSel.Caption := '';
   fStxtFrqSel.Caption := '';
   fStxtPerSel.Caption := '';
   fStxtAmpSel.Caption := '';
   //     fSpectrData
   fSpectrData.GrmIndx := Num;
   fSpectrData.GrmMax  := 0;
   //       
   wPeriod := fScopeArr[fScopeIndx].Grm1;
   if Num > 0
   then begin
      fStxtPerSel.Caption := Format('%8.3f', [wPeriod / Num]);
      if wPeriod > 0
      then begin
         //   ( msec)   (Hz)
         wFreq := 1000 *  Num / wPeriod;
         fStxtFrqSel.Caption := Format('%8.3f', [wFreq]);
      end;
   end
   else begin
       fStxtPerSel.Caption := ' ~';
       fStxtFrqSel.Caption := ' 0';
   end;
   if Assigned(fOscCTRL3)
   then begin
      //     
      InitOscGrm(fScopeIndx, Num);
      //       
      if fChBoxHandGrm.Checked
      then AutoScaleToOscGrm(ArrGrm[Num].Amp);
   end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//      SpectrScope   
procedure TDnConsole.ShowSpectrScope();
var Ind : integer;
begin
   //  
   if not Assigned(fSpectrScope) then Exit;
   if not Assigned(fDTF) then Exit;
   //       SpectrScope
   if fDTF.MaxIndGgm < 0 then Exit;
   SetLength(fSpectrData.ArrS, fDTF.MaxIndGgm + 1);
   for Ind := 0 to fDTF.MaxIndGgm
   do begin
      //    SpectrScope
      fSpectrData.ArrS[Ind].Amp := fDTF.Cn[Ind];
      fSpectrData.ArrS[Ind].Phs := fDTF.Pn[Ind];
   end;
   //      
   fSpectrScope.ArrSpectr := fSpectrData.ArrS;
   //    
   fSpectrScope.Show;
end;
// ----------------------------------------------------------------
// 04.07.2018
//     
procedure TDnConsole.CalcAndShowDTF();
var AmpGrm : extended;  //    
begin
   if not Assigned(fDTF) then Exit;
  // ----------------------------
  //    
  fStxtDTF.Caption := StartMMTimeStamp (fDFTStamps);
  // ----------------------------
  //  
  fDTF.CodMet := 0;                   //   
  fDTF.RqDegree := False;             //    
  fDTF.XB := 0;                       //    
  if fScopeArr[fScopeIndx].Grm1 > 0
  then fDTF.XE := fScopeArr[fScopeIndx].Grm1
  else fDTF.XE := 1;                  //     ( msec)
  fDTF.RunDTF03(fSpectrData.ArrY);    //   
  // ----------------------------
  //       
  fStxtDTF.Caption := ' ' + StopMMTimeStamp (fDFTStamps);
  // ----------------------------
  //  
  if Assigned (fSpectrScope)
  then begin
      ShowSpectrScope();
      //    
      if (not fSpectrData.GrmIndx) < 0
      then begin
         AmpGrm := fDTF.Cn[fSpectrData.GrmIndx];
         if AmpGrm > fSpectrData.GrmMax
         then fSpectrData.GrmMax := AmpGrm;
         //      
         fStxtAmpSel.Caption := Format('%8.3f', [fSpectrData.GrmMax]);
         //     
         if Assigned(fOscCTRL3)
         then begin
             if not fChBoxHandGrm.Checked
             //       
             then AutoScaleToOscGrm(AmpGrm);
             //      
             fOscCTRL3.AddNewData(AmpGrm);
          end;
      end
      else begin
         fStxtGrmSel.Caption := ' ';
         fStxtFrqSel.Caption := '';
         fStxtPerSel.Caption := '';
         fStxtAmpSel.Caption := '';
      end;
  end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//         
procedure TDnConsole.AddValueToSampleArr(RqValue : extended);
begin
  if not Assigned(fDTF) then Exit;
  with fSpectrData
  do begin
    if (ScopeIndx < 0) or (YMaxNum  < 5) then Exit;
    //   ,  
    Inc(YIndx);
    if YIndx > High(ArrY)
    then begin
          //     
          CalcAndShowDTF();
          //   
          fSpectrData.YIndx := 0;
    end;
    //     
    ArrY[YIndx] := RqValue;
    //   
    if Assigned(fPrgsBar) then fPrgsBar.Position := YIndx;
  end; // with
end;

// ----------------------------------------------------------------
// 04.07.2018
//    DTF
procedure  TDnConsole.InitSpectrData(RqIndx : integer);
begin
   //  
   if not Assigned(fSpectrScope) then Exit;
   fSpectrScope.ClearShow;
   if (RqIndx < Low(fScopeArr)) or (RqIndx > High(fScopeArr)) then Exit;
   with fSpectrData
   do begin
      if fScopeArr[RqIndx].GrmNum > 0
      then begin
          ScopeIndx := RqIndx;
          //    
          YMaxNum := 4 * fScopeArr[RqIndx].GrmNum + 1;
          fStxtSamp.Caption := ' ' + IntToStr(YMaxNum);
          //    
          if (Length(ArrY)<> YMaxNum) or (Length(ArrY) = 0)
          then SetLength(ArrY, YMaxNum);
          GrmIndx := 0;
      end
      else begin
         //  
         ScopeIndx := -1;
         YMaxNum   := 0;
         fStxtSamp.Caption := IntToStr(YMaxNum);
      end;
      //     
      YIndx := 0;
      if not Assigned(fPrgsBar) then Exit;
      fPrgsBar.Min := 0;
      fPrgsBar.Max := YMaxNum;
      fPrgsBar.Position := fPrgsBar.Min;
   end;
end;
// ================================================================
//    
// ================================================================
// ----------------------------------------------------------------
// 04.07.2018
//    Edit  extended  Rez
function TryToExt(edt : TEdit; var Rez : extended) : boolean;
begin
    Result := False;
    try
      edt.Color := clWindow;
      Rez := StrToFloat(edt.Text);
      Result := True;
    except
      edt.Color := RGB(255, 200,200);
      ShowMessage('    ');
    end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//     
procedure TDnConsole.CmbBoxGrmPrmShow();
begin
   case fCmbBoxGrmPrm.ItemIndex of
       0 : fEdOscGrmPA.Text := Format('%8.3f', [fOscCTRL3.YMax]);
       1 : fEdOscGrmPA.Text := Format('%8.3f', [fOscCTRL3.P2Wall]);
       2 : fEdOscGrmPA.Text := Format('%8.3f', [fOscCTRL3.P1Wall]);
   else fEdOscGrmPA.Text := '';
   end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//   -     
procedure TDnConsole.CmbBoxGrmPrmClick(Sender : TObject);
begin
   CmbBoxGrmPrmShow();
end;
// ----------------------------------------------------------------
//       
procedure TDnConsole.AutoScaleToOscGrm(AmpGrm : extended);
const
    cLCoeff = 0.8;   //       fOscCTRL3
    cHCoeff = 2;     //       fOscCTRL3
    cCoeff  = 1.5;   //    fOscCTRL3
begin
    if not Assigned(fOscCTRL3) then Exit;
    if (AmpGrm > fSpectrData.GrmMax * cLCoeff) or
       (fOscCTRL3.YMax > fSpectrData.GrmMax * cHCoeff)
    then begin
      fOscCTRL3.YMax := fSpectrData.GrmMax * cCoeff;
      //     
      CmbBoxGrmPrmShow();
    end;
end;
// ----------------------------------------------------------------
//     
procedure TDnConsole.InitOscGrm(RqScopeIndx, RqGrmIndx : integer);
begin
   if not Assigned(fOscCTRL3) then Exit;
   if (RqScopeIndx < Low(fScopeArr)) or (RqScopeIndx > High(fScopeArr))
   then Exit;
   // ------------------------
   fSpectrData.ScopeIndx := RqScopeIndx;
   fSpectrData.YMaxNum   := 4 * fScopeArr[RqScopeIndx].GrmNum + 1;
   fSpectrData.YIndx     := 0;
   fSpectrData.GrmMax    := 0;
   fSpectrData.GrmIndx   := RqGrmIndx;
   fStxtGrmSel.Caption := ' ' + IntToStr(RqGrmIndx);
   // ------------------------
   if RqGrmIndx = 0
   then begin
       fOscCTRL3.YMax      := 0;
       // ------------------------
       fStxtGrmSel.Caption := ' 0';
       fStxtPerSel.Caption := ' ~';
       fStxtFrqSel.Caption := ' 0';
   end;
   fStxtAmpSel.Caption := '';
   fEdOscGrmPA.Text := '';
   fChBoxHandGrm.Checked := False;
   // ------------------------
   fOscCTRL3.WallStyle   := oswsNotUse;
   fOscCTRL3.YMes   := fScopeArr[RqScopeIndx].Measure;
   fOscCTRL3.P2Wall := 0;
   fOscCTRL3.P1Wall := 0;
   fOscCTRL3.Clear;
   fOscCTRL3.Title :=  fScopeArr[RqScopeIndx].ScopeName
                       + ' :     '
                       + IntToStr(fSpectrData.GrmIndx);
end;
// ----------------------------------------------------------------
// 04.07.2018
//   -     
procedure TDnConsole.ChBoxHandGrmClick(Sender : TObject);
// var wExt : extended;
begin
    if not Assigned(fOscCTRL3) then Exit;
    if fChBoxHandGrm.Checked
    //    
    then begin
       //     
       CmbBoxGrmPrmShow();
       //    
       fOscCTRL3.WallStyle := oswsDam;
       //  
       fEdOscGrmPA.Enabled := True;
    end
    //    
    else begin
       // wExt := fSpectrData.GrmMax;
       fCmbBoxGrmPrm.ItemIndex := 0;
       fOscCTRL3.WallStyle := oswsNotUse;
       //  
       fEdOscGrmPA.Enabled := False;
       fEdOscGrmPA.Text := '';
    end;
end;
// ----------------------------------------------------------------
// 04.07.2018
//   -     
procedure TDnConsole.BttOsGrmPAClick(Sender : TObject);
var wExt : extended;
begin
   if not Assigned(fOscCTRL3) then Exit;
   if TryToExt(fEdOscGrmPA, wExt)
   then begin
       wExt := Abs(wExt);
       case fCmbBoxGrmPrm.ItemIndex of
       0 : begin
              fOscCTRL3.YMax := wExt;
              fOscCTRL3.P2Wall := 0.9 * wExt;
              fOscCTRL3.P1Wall := 0.8 * wExt;
           end;
       1 : if wExt < fOscCTRL3.YMax   then fOscCTRL3.P2Wall := wExt;
       2 : if wExt < fOscCTRL3.P2Wall then fOscCTRL3.P1Wall := wExt;
       end;
       //     
       CmbBoxGrmPrmShow();
       //  
       fOscCTRL3.ReShow;
   end;
end;
// ================================================================
// END
// ================================================================

end.

