unit DigitsScope03;
// ====================================================================
(*

               
                
                    (  TDigitsScope )

           
    TImage        
     .     TCustomScope,
         :

       ScopeRect - Rectangle      TImage
       XBeg, YBeg -     TImage
       Visible -  
       Transparent -  
       Compact -  
       ScopeName -  

          :

       ScopePosition -  XBeg  YBeg  
       ShowScope -  

         :

       Radix -     
       DFrame -    ()
       FonColor -  
       FontName -  
       FontSize  -  
       FontStyle -  
       TxtColor -   
       TextValue -   

             
     :

       Clear -  
       ShowTextValue -    
       ShowByteValue -     Byte
       ShowWordValue -     Word
       ShowLongWordValue -     LongWord
       ShowIntegerValue -     Integer
       ShowInt64Value -     Int64
       ShowExtendedValue -    Extended

           TImage
      Create. :

       Scope := TDigitsScope.Create(Image1, XBeg, YBeg);

        ,     
     . :

       if Assigned(Scope) then Scope.ShowWordValue(RqRadix, RqValue);

    // -----------------------------------------------------
         3.02 ()  , , , 2018.
                     () Source code  ..
          20.07.2018
*)
// ====================================================================

interface

uses Windows, Messages, Classes, Controls, SysUtils, Graphics, Dialogs,
     Forms, StdCtrls, ExtCtrls, Menus, CustomScope03;

//     
type TRadix  = (rdxDecimal, //   
                rdxHex,     //   
                rdxBit);    //   

//   
type TDFrame = (dfrmNone,   //  
                dfrmUp,     //  
                dfrmDown);  //  

// --------------------------------------------------------------------
//       
type TSCode = (scdClear,
               scdText,
               scdBit,
               scdWord,
               scdLongWord,
               scdInteger,
               scdInt64,
               scdExtended);

// ====================================================================
//                TDigitsScope
// ====================================================================

type TDigitsScope = class(TCustomScope)
private
   // --------------------------
   fBmp         : TBitMap;      //   
   // --------------------------
   // --------------------------
   fTxtH        : integer;      //    
   fTxtW        : integer;      //    
   fCharW       : integer;      //    
   // --------------------------
   fText        : string;       //   
   // --------------------------
   //  
   fRadix       : TRadix;       //     
   fDFrame      : TDFrame;      //   
   fFontName    : string;       //   
   fFontSize    : integer;      //  
   fFontStyle   : TFontStyles;  //  
   fFonColor    : TColor;       //   
   fTxtColor    : TColor;       //    
   // -----------------------------
   fSCode       : TSCode;       //     
   // --------------------------
   //   
   procedure InitDScope();
   // --------------------------
   //     
   function GetCharWidth(RqChar : char) : integer;
   //     
   procedure SetDsplWH(RqW, RqH : integer);
   //        
   procedure ResizeDSPL(RqStr : string); overload;
   procedure ResizeDSPL(RqW, RqH : integer); overload;
   // --------------------------
   //      
   // --------------------------
   //  fBMP
   procedure ClearBMP(RqColor : TColor);
   //     fBMP
   procedure PaintScopeToBMP();
   // --------------------------
   //    (  )   Image
   procedure ReShowDScope();
   //      
   procedure ResizeAndShowDScope(RqText : string; RqValue : extended);
   // --------------------------
   //  property
   // --------------------------
   //      
   procedure SetRadix (RqRadix : TRadix);
   //     
   procedure SetDFrame (RqDFrame : TDFrame);
   //      
   procedure SetFonColor(RqColor : TColor);
   //      
   procedure SetTxtColor(RqColor : TColor);
   //    
   procedure SetFontSize(RqSize  : integer);
   //    
   procedure SetFontStyle(RqStyle  : TFontStyles);
   //    
   procedure SetFontName(RqName  : string);
   // --------------------------
protected
   //        
   procedure ReSizeScope();  override;
   // ------------------------
   //     fBmp
   procedure PaintToBmp(Bmp : TBitMap); override;
public
   //      Image
   constructor Create(RqImg : TImage; RqXBeg, RqYBeg : integer); overload;
   //   
   procedure   Free;
   // -----------------------------
   //  
   procedure Clear();
   //        DIGITs - 
   function ShowTextValue(RqValue : string) : string;
   //     Byte   
   function  ShowByteValue(RqRadix : TRadix; RqValue : Int64) : string;
   //     Word   
   function  ShowWordValue(RqRadix : TRadix; RqValue : Int64) : string;
   //     LongWord   
   function ShowLongWordValue(RqRadix : TRadix; RqValue : Int64) : string;
   //     Integer   
   function ShowIntegerValue(RqRadix : TRadix; RqValue : Int64) : string;
   //     Int64   
   function ShowInt64Value(RqRadix : TRadix; RqValue : Int64) : string;
   //    Extended   
   function ShowExtendedValue(RqValue : extended) : string;
   // --------------------------
   //     
   property Radix    : TRadix read fRadix    write SetRadix;
   //    ()
   property DFrame   : TDFrame read fDFrame  write SetDFrame;
   //  
   property FonColor : TColor read fFonColor write SetFonColor;
   //  
   property FontName : string read fFontName write SetFontName;
   //  
   property FontSize : integer read fFontSize write SetFontSize;
   //    
   property FontStyle : TFontStyles read fFontStyle write SetFontStyle;
   //   
   property TxtColor : TColor read fTxtColor write SetTxtColor;
   // --------------------------
   //   
   property TextValue : string    read fText;
end;

// ====================================================================
// ====================================================================
implementation
// ====================================================================
// ====================================================================

// ====================================================================
//                TDigitsScope
//                
// ====================================================================
const Scope_MinW  = 80;         // .   
      Scope_MinH  = 14;         // .   
const cBorderW    = 8;          //   
      cBorderH    = 4;          //   
// --------------------------------------------------------------------
//   
const prefDEC     = 'dec:';
      prefHEX     = 'hex:';
      prefBIT     = 'bit:';

// ====================================================================
//   / 
// ====================================================================
// --------------------------------------------------------------------
//      Image (OVERLOAD)
constructor TDigitsScope.Create(RqImg : TImage; RqXBeg, RqYBeg : integer);
begin
   inherited Create(RqImg, RqXBeg, RqYBeg, Scope_MinW, Scope_MinH);
   // -----------------------------
   //     
   fBMP := Bmp;
   // -----------------------------
   //    
   InitDScope();
end;
// -----------------------------------------------------------------
//    
procedure TDigitsScope.InitDScope();
begin
   // -----------------------------
   //   
   fFontSize := 12;
   fBMP.Canvas.Font.Name := 'Courier New';
   fBMP.Canvas.Font.Size := fFontSize;
   fFontStyle := [fsBold];
   fBMP.Canvas.Font.Style := fFontStyle;
   fCharW := GetCharWidth('0');
   // -----------------------------
   //    
   fDFrame     := dfrmDown;
   //    
   fFonColor   := RGB(90,120,150);
   fTxtColor   := clAqua;
   // -----------------------------
   //   
   ScopeName := ' ';
   // -----------------------------
   //        DIGITs - 
   fText := ShowTextValue('DigitsScope');
   // -----------------------------
   //  
   Visible := True;
end;
// =================================================================
//    
// =================================================================
// -----------------------------------------------------------------
//     
function TDigitsScope.GetCharWidth(RqChar : char) : integer;
begin
   Result := fBMP.Canvas.TextWidth(RqChar);
end;
// -----------------------------------------------------------------
//      
procedure TDigitsScope.SetDsplWH(RqW, RqH : integer);
var wH, wW : integer;
begin
   if RqH < Scope_MinH then wH := Scope_MinH else wH := RqH;
   if RqW < Scope_MinW then wW := Scope_MinW else wW := RqW;
   // ---------------------------------------
   //   
   ScopeSize(wW + 2 * cBorderW, wH + 2 * cBorderH);
end;
// -----------------------------------------------------------------
//      
procedure TDigitsScope.ResizeDSPL(RqStr : string);
var wTxtH, wTxtW : integer;
begin
   with fBMP
   do begin
      fCharW := GetCharWidth('0');
      wTxtH := Canvas.TextHeight(RqStr);
      wTxtW := Canvas.TextWidth (RqStr);
      if (wTxtH > fTxtH) or (wTxtW > fTxtW)
      then begin
         if (wTxtH > fTxtH) then fTxtH := wTxtH;
         if (wTxtW > fTxtW) then fTxtW := wTxtW + fCharW;
         //     
         SetDsplWH(fTxtW, fTxtH);
      end;
   end;
end;
// -----------------------------------------------------------------
//      
procedure TDigitsScope.ResizeDSPL(RqW, RqH : integer);
begin
   with fBMP
   do begin
      fCharW := GetCharWidth('0');
      if (RqH <> fTxtH) or (RqW <> fTxtW)
      then begin
         fTxtH := RqH;
         if (fTxtH < Scope_MinH) then fTxtH := Scope_MinH;
         fTxtW := RqW + fCharW;
         if (fTxtW < Scope_MinW) then fTxtW := Scope_MinW;
         //     
         SetDsplWH(fTxtW, fTxtH);
      end;
   end;
end;
// --------------------------------------------------------------------
//  
procedure TDigitsScope.Free;
begin
   // ---------------------------------

   // ---------------------------------
   inherited Free;
end;

// ====================================================================
//     
// ====================================================================
// -------------------------------------------------------------------------
//        
procedure TDigitsScope.ReSizeScope();
begin
//    ResizeDSPL(fText);
end;
// -------------------------------------------------------------------------
//       Bmp
//     ShowScope();
procedure TDigitsScope.PaintToBmp(Bmp : TBitMap);
begin
   fBMP := Bmp;
   if not Assigned(fBMP) then Exit;
   //     fBMP
   PaintScopeToBMP();
end;
// ====================================================================
//       
// ====================================================================
// --------------------------------------------------------------------
//     
procedure TDigitsScope.ClearBMP(RqColor : TColor);
begin
  if not Assigned(fBMP) then Exit;
  with fBMP.Canvas do
  begin
    Brush.Color := RqColor;
    Brush.Style := bsSolid;
    FillRect(Rect(0, 0, fBMP.Width, fBMP.Height));
  end;
end;

// --------------------------------------------------------------------
//     
procedure DFrameToBMP(RqBMP : TBitMap; RqDFrame : TDFrame; dHW : byte);
begin
   if not Assigned(RqBMP) then Exit;
   if RqDFrame = dfrmNone then Exit;
   with RqBMP.Canvas do
   begin
      Pen.Width := 2;
      if RqDFrame = dfrmUp   then Pen.Color := clBlack;
      if RqDFrame = dfrmDown then Pen.Color := clWhite;
      Rectangle(0,0, RqBMP.Width-dHW, RqBMP.Height-dHW);
      Pen.Width := 1;
      if RqDFrame = dfrmUp   then Pen.Color := clWhite;
      if RqDFrame = dfrmDown then Pen.Color := clBlack;
      MoveTo(0, RqBMP.Height);
      LineTo(0, 0);
      LineTo(RqBMP.Width, 0);
      MoveTo(1, RqBMP.Height-2-dHW);
      LineTo(1, 1);
      LineTo(RqBMP.Width-1-dHW, 1);
   end;
end;
// --------------------------------------------------------------------
//     fBMP
procedure TDigitsScope.PaintScopeToBMP();
begin
   //   
   if not Transparent then ClearBMP(fFonColor);
   //     fBMP
   with fBMP.Canvas do
   begin
      Brush.Style := bsClear;
      Font.Color  := fTxtColor;
      TextOut(cBorderW + 2, cBorderH, fText);
      // 
      if not Transparent then DFrameToBMP(fBMP, fDFrame, 1);
   end;
end;
// ====================================================================
//        Image
// ====================================================================
//    (  )   Image
procedure TDigitsScope.ReShowDScope();
begin
   //      Image.
   //    PaintScopeToBMP();
   ShowScope();
end;
// --------------------------------------------------------------------
//      
procedure TDigitsScope.ResizeAndShowDScope(RqText : string; RqValue : extended);
begin
    fText := RqText;
    if Measure <> '' then fText := fText + ' ' +  Measure;
    // -------------------------------------------------
    //    fBMP   ,
    //    fBMP    fText
    ResizeDSPL(fText);
    // -------------------------------------------------
    //  Value      
    // Image.    PaintScopeToBMP();
    Value := RqValue;
end;
// ====================================================================
//  PROPERTY
// ====================================================================
//    
procedure TDigitsScope.SetFontName(RqName  : string);
begin
   if not Assigned(fBmp) then Exit;
   fFontName := RqName;
   fBmp.Canvas.Font.Name := RqName;
   //   
   ResizeDSPL(fText);
   //      Image
   ReShowDScope();
end;
// --------------------------------------------------------------------
//    
procedure TDigitsScope.SetFontStyle(RqStyle  : TFontStyles);
begin
   if not Assigned(fBmp) then Exit;
   fFontStyle := RqStyle;
   fBmp.Canvas.Font.Style := fFontStyle;
   //   
   ResizeDSPL(fText);
   //      Image
   ReShowDScope();
end;
// --------------------------------------------------------------------
//    
procedure TDigitsScope.SetFontSize(RqSize  : integer);
begin
   if not Assigned(fBmp) then Exit;
   if (RqSize < 7) or (RqSize > 24) then Exit;
   fFontSize := RqSize;
   fBmp.Canvas.Font.Size := fFontSize;
   //   
   ResizeDSPL(fText);
   //      Image
   ReShowDScope();
end;
// --------------------------------------------------------------------
//      
procedure TDigitsScope.SetRadix (RqRadix : TRadix);
begin
   fRadix := RqRadix;
   //      Image
   ReShowDScope();
end;
// --------------------------------------------------------------------
//     
procedure TDigitsScope.SetDFrame (RqDFrame : TDFrame);
begin
   fDFrame := RqDFrame;
   //      Image
   ReShowDScope();
end;
// --------------------------------------------------------------------
//      
procedure TDigitsScope.SetFonColor(RqColor : TColor);
begin
   fFonColor := RqColor;
   //      Image
   ReShowDScope();
end;
// --------------------------------------------------------------------
//      
procedure TDigitsScope.SetTxtColor(RqColor : TColor);
begin
   fTxtColor := RqColor;
   //      Image
   ReShowDScope();
end;
// ====================================================================
//
// ====================================================================
// --------------------------------------------------------------------
//        
function HexToBitStr(RqHexStr : string): string;
const cSep = ' ';
var Indx : integer;
begin
   Result := '';
   if Trim(RqHexStr) = '' then Exit;
   for  Indx := 1 to Length(RqHexStr)
   do case RqHexStr[Indx] of
       // ----------
       '0' : Result := Result + '0000' + cSep;
       '1' : Result := Result + '0001' + cSep;
       '2' : Result := Result + '0010' + cSep;
       '3' : Result := Result + '0011' + cSep;
       '4' : Result := Result + '0100' + cSep;
       '5' : Result := Result + '0101' + cSep;
       '6' : Result := Result + '0110' + cSep;
       '7' : Result := Result + '0111' + cSep;
       // ----------
       '8' : Result := Result + '1000' + cSep;
       '9' : Result := Result + '1001' + cSep;
       'A' : Result := Result + '1010' + cSep;
       'B' : Result := Result + '1011' + cSep;
       'C' : Result := Result + '1100' + cSep;
       'D' : Result := Result + '1101' + cSep;
       'E' : Result := Result + '1110' + cSep;
       'F' : Result := Result + '1111' + cSep;
    end;
end;
// ====================================================================
//   
// ====================================================================
// --------------------------------------------------------------------
//  
procedure TDigitsScope.Clear();
begin
   //   
   ResizeDSPL(Scope_MinW, Scope_MinH);
   //      
   ResizeAndShowDScope(' ',0);
   fSCode := scdClear;
end;
// --------------------------------------------------------------------
//        DIGITs - 
function TDigitsScope.ShowTextValue(RqValue : string) : string;
begin
    if (fSCode <> scdClear) then Clear();
    Result := RqValue;
    //      
    ResizeAndShowDScope(Result,0);
    fSCode := scdText;
end;
// --------------------------------------------------------------------
//     Byte   
function TDigitsScope.ShowByteValue(RqRadix : TRadix; RqValue : Int64) : string;
var wByte : word;
begin
   wByte := 0;
   if (fSCode <> scdClear) and (fSCode <> scdBit) then Clear();
   if (RqValue >= 0) and (RqValue <= 255)
   then begin
      try
         wByte := Byte(RqValue);
         case RqRadix of
            rdxDecimal : Result := prefDEC + IntToStr(RqValue);
            rdxHex     : Result := prefHEX + IntToHex(wByte, SizeOF(Byte) * 2);
            rdxBit     : begin
                           Result := IntToHex(wByte, SizeOF(Byte) * 2);
                           Result := prefBIT + HexToBitStr(Result);
                         end;
         end;
      except Result := 'error'; end;
   end else Result  := 'out range';
   //  (  ShowScope)  .
   HidenSetValue(RqValue);
   //      
   ResizeAndShowDScope(Result, wByte);
   fSCode := scdBit;
end;
// --------------------------------------------------------------------
//     Word   
function TDigitsScope.ShowWordValue(RqRadix : TRadix; RqValue : Int64) : string;
var wWord : word;
begin
   wWord := 0;
   if fSCode <> scdWord then Clear();
   if (RqValue >= 0) and (RqValue <= 65535)
   then begin
      try
         wWord := Word(RqValue);
         case RqRadix of
            rdxDecimal : Result := prefDEC + IntToStr(RqValue);
            rdxHex     : Result := prefHEX + IntToHex(wWord, SizeOF(Word) * 2);
            rdxBit     : begin
                           Result := IntToHex(wWord, SizeOF(Word) * 2);
                           Result := prefBIT + HexToBitStr(Result);
                         end;
         end;
      except Result := 'error'; end;
   end else Result  := 'out range';
   //      
   ResizeAndShowDScope(Result, wWord);
   fSCode := scdWord;
end;
// --------------------------------------------------------------------
//     LongWord   
function TDigitsScope.ShowLongWordValue(RqRadix : TRadix; RqValue : Int64) : string;
var wLongWord : LongWord;
begin
   wLongWord := 0;
   if fSCode <> scdLongWord then Clear();
   if (RqValue >= 0) and (RqValue <= 4294967295)
   then begin
      try
         wLongWord := LongWord(RqValue);
         case RqRadix of
            rdxDecimal : Result := prefDEC + IntToStr(RqValue);
            rdxHex     : Result := prefHEX +
                                   IntToHex(wLongWord, SizeOF(LongWord) * 2);
            rdxBit     : begin
                           Result := IntToHex(wLongWord, SizeOF(LongWord) * 2);
                           Result := prefBIT + HexToBitStr(Result);
                         end;
         end;
      except Result := 'error'; end;
   end else Result  := 'out range';
   //      
   ResizeAndShowDScope(Result, wLongWord);
   fSCode := scdLongWord;
end;
// --------------------------------------------------------------------
//     Integer   
function TDigitsScope.ShowIntegerValue(RqRadix : TRadix; RqValue : Int64) : string;
var wInteger : Integer;
begin
   wInteger := 0; 
   if fSCode <> scdInteger then Clear();
   if (RqValue >= -2147483647) and (RqValue <= 2147483647)
   then begin
      try
         wInteger := Integer(RqValue);
         case RqRadix of
            rdxDecimal : Result := prefDEC + IntToStr(RqValue);
            rdxHex     : Result := prefHEX +
                                   IntToHex(wInteger, SizeOF(Integer) * 2);
            rdxBit     : begin
                           Result := IntToHex(wInteger, SizeOF(Integer) * 2);
                           Result := prefBIT + HexToBitStr(Result);
                         end;
         end;
      except Result := 'error'; end;
   end else Result  := 'out range';
   //      
   ResizeAndShowDScope(Result, wInteger);
   fSCode := scdInteger;
end;
// --------------------------------------------------------------------
//     Int64   
function TDigitsScope.ShowInt64Value(RqRadix : TRadix; RqValue : Int64) : string;
begin
   if fSCode <> scdInt64 then Clear();
   try
      case RqRadix of
        rdxDecimal : Result := prefDEC + IntToStr(RqValue);
        rdxHex     : Result := prefHEX + IntToHex(RqValue, SizeOF(Int64) * 2);
        rdxBit     : begin
                       Result := IntToHex(RqValue, SizeOF(Int64) * 2);
                       Result := prefBIT + HexToBitStr(Result);
                     end;
       end;
   except Result := 'error'; end;
   //      
   ResizeAndShowDScope(Result, RqValue);
   fSCode := scdInt64;
end;
// --------------------------------------------------------------------
//    Extended   
function TDigitsScope.ShowExtendedValue(RqValue : extended) : string;
begin
   if fSCode <> scdExtended then Clear();
   Result := prefDEC + FloatToStr(RqValue);
   //      
   ResizeAndShowDScope(Result, RqValue);
   fSCode := scdExtended;
end;
// ====================================================================
// 
// ====================================================================

end.
