unit CustomScope03;
(*
                    TCustomScope
                 
                    

         
    ,    
    TImage.  TCustomScope   
        -  TBitMap.
         Visible, Transparent,
      ScopePosition  ScopeSize,   
      ( )   ,
     ,      
      TImage ( ).  , 
   TCustomScope      
        .

      ( Value)   ,
       ,  
   TCustomScope   ,   
     :

       //      
       //     .   
       //      .
       procedure ReRangeScope(); virtual;
       // ----------------------
       //       
       //       .
       //         .
       procedure ReSizeScope();  virtual;
       // ----------------------
       //      .
       //       
       //      
       //     .
       procedure PaintToBmp(Bmp : TBitMap); virtual; abstract;

          
      ShowScope.     
         ,  
         .
     ShowScope   :

       1.    Transparent.   
               ;
       2.    PaintToBmp 
           ;
       3.      
          .

     ShowScope,  ,    
      TCustomScope,     
    ,     .

            
     type TCustomScope = class(TObject)

   // -----------------------------------------------------
    3.03. ()  , , , 2018.
                () Source code  ..
     14.07.2018
*)

interface

uses Windows, Classes, Graphics, Dialogs, ExtCtrls;

// =========================================================================
// =========================================================================
//   
type TScopeStyle = (ssNotUse,     //  
                    ssArc,        //  
                    ssPie);       //  

//       
type TWallStyle  = (wsNotUse,     //  
                    wsDam,        //    
                    wsLimit);     //    

//         
type TColorStyle  = (csDark,      //   
                     csLight,     //   
                     csBright);   //     

//   -    
type TOnYellowValue = procedure(Sender : TObject; Value : extended) of object;

//   -    
type TOnRedValue = procedure(Sender : TObject; Value : extended) of object;

type TCustomScope = class(TObject)
private
  // ------------------------
  fImg         : TImage;      //  Image
  // ------------------------
  //   
  fXBeg        : integer;     // X -    fImg
  fYBeg        : integer;     // Y -    fImg
  fWidth       : integer;     //  
  fHeight      : integer;     //  
  fScopeRect   : TRect;       //     fImg
  fBmpSave     : TBitMap;     //    
  fBmp         : TBitMap;     //   
  fBmpRect     : TRect;       //     fBmp
  // ------------------------
  //   
  fVisible     : boolean;     //  
  fTransparent : boolean;     //     
  fScopeStyle  : TScopeStyle; //   
  fCompact     : boolean;     //  
  // ------------------------
  fScopeName   : string;      //  
  fTag         : integer;     //  
  fUserObj     : TObject;     //   
  // ------------------------
  //      
  fMaxScope    : extended;    //   
  fMinScope    : extended;    //   
  fP2Wall      : extended;    //      
  fP1Wall      : extended;    //     
  fN1Wall      : extended;    //     
  fN2Wall      : extended;    //      
  fWallStyle   : TWallStyle;  //  
  //   -    
  fOnYellowValue  : TOnYellowValue;
  //   -    
  fOnRedValue     : TOnRedValue;
  // ------------------------
  //   
  fArrLPF      : array of extended;
  fIndLPF      : integer;     //    
  // ------------------------
  fMeasure     : string;      //  
  fValue       : extended;    //   
  // ------------------------
  //  
  fGrmNum      : integer;     //     
  fGrm1        : extended;    //   
  // ------------------------
  //     fImg
  procedure RestoreBkGround();
  procedure SaveBkGround();
  // ------------------------
  //   
  procedure SetXBeg(XBeg : integer);
  procedure SetYBeg(YBeg : integer);
  // ------------------------
  //   
  procedure SetWidth(RqWidth : integer);
  procedure SetHeight(RqHeight : integer);
  // ------------------------
  //   
  procedure SetVisible(RqVisible : boolean);
  //       
  procedure SetTransparent(RqTransparent : boolean);
  //       
  procedure SetCompact(RqCompact : boolean);
  //   
  procedure SetScopeStyle(RqScopeStyle : TScopeStyle);
  // ------------------------
  //  
  procedure SetScopeName (RqScopeName : string);
  // ------------------------
  //       
  procedure SetMaxScope(RqMaxScope : extended);
  //       
  procedure SetMinScope(RqMinScope : extended);
  //      
  procedure SetP2Wall (RqP2Wall  : extended);
  //     
  procedure SetP1Wall (RqP1Wall  : extended);
  //     
  procedure  SetN1Wall(RqN1Wall : extended);
  //      
  procedure  SetN2Wall(RqN2Wall : extended);
  //       
  procedure  SetWallStyle(RqWallStyle : TWallStyle);
  //      -    
  procedure  RunOnYellowValue(RqValue : extended);
  //       -    
  procedure  RunOnRedValue(RqValue : extended);
  // ------------------------
  //       
  procedure ShiftArrLPF();
  //      
  function CalcLPF(RqValue : extended) : extended;
  //     
  function  GetNumLPF (): integer;
  procedure SetNumLPF (RqNum : integer);
  //   
  procedure SetValue (RqValue : extended);
  //  
  procedure SetMeasure(RqMeasure : string);
  // ------------------------

protected
  //        
  procedure ReRangeScope(); virtual;
  //        
  procedure ReSizeScope();  virtual;
  //     fBmp
  procedure PaintToBmp(Bmp : TBitMap); virtual; abstract;
  // ------------------------
  //       
  function GetColorByValue (RqColorStyle : TColorStyle;
                            RqValue : extended) : TColor;
  //  (  ShowScope)  .
  procedure HidenSetValue (RqValue : extended);

public
  // ------------------------
  //  / 
  constructor  Create(RqImg : TImage; RqX, RqY, RqWidth, RqHeight : integer);
  procedure Free();
  // ------------------------
  //   
  procedure ScopeSize(RqWidth, RqHeight : integer);
  //  XBeg  YBeg  
  procedure ScopePosition(RqXBeg, RqYBeg : integer);
  //    fImg
  procedure ShowScope();
  // ------------------------
  //    fImg
  property ScopeRect : TRect  read fScopeRect;
  // ------------------------
  //    fImg
  property XBeg   : integer  read fXBeg  write SetXBeg;
  property YBeg   : integer  read fYBeg  write SetYBeg;
  // ------------------------
  //  
  property ScopeWidth  : integer  read fWidth   write SetWidth;
  property ScopeHeight : integer  read fHeight  write SetHeight;
  // ------------------------
  //  
  property Visible     : boolean     read fVisible     write SetVisible;
  //  
  property Transparent : boolean     read fTransparent write SetTransparent;
  //  
  property ScopeStyle  : TScopeStyle read fScopeStyle  write SetScopeStyle;
  //  
  property Compact     : boolean     read fCompact     write SetCompact;
  // ------------------------
  //  
  property ScopeName : string        read fScopeName   write SetScopeName;
  //  
  property Tag       : integer       read fTag         write fTag;
  //   
  property UserObj      : TObject    read fUserObj     write fUserObj;
  // ------------------------
  //  
  property Bmp       : TBitMap    read fBmp;
  // ------------------------
  //       
  property MaxScope  : extended    read fMaxScope  write SetMaxScope;
  //       
  property MinScope  : extended    read fMinScope  write SetMinScope;
  //      
  property P2Wall   : extended    read fP2Wall   write SetP2Wall;
  //     
  property P1Wall   : extended    read fP1Wall   write SetP1Wall;
  //     
  property N1Wall   : extended    read fN1Wall   write SetN1Wall;
  //      
  property N2Wall   : extended    read fN2Wall   write SetN2Wall;
  //      
  property WallStyle : TWallStyle  read fWallStyle write SetWallStyle;
  //   -    
  property OnYellowValue : TOnYellowValue read  fOnYellowValue
                                          write fOnYellowValue;
  //   -    
  property OnRedValue    : TOnRedValue    read  fOnRedValue
                                          write fOnRedValue;
  // ------------------------
  //       
  property NumLPF  : integer  read GetNumLPF write SetNumLPF;
  //   
  property Value   : extended read fValue    write SetValue;
  //  
  property Measure : string   read fMeasure  write SetMeasure;
  // ------------------------
  //  :
  // ------------------------
  //     
  property GrmNum  : integer  read fGrmNum   write fGrmNum;
  //   
  property Grm1    : extended read fGrm1     write fGrm1;
end;

// =========================================================================
// =========================================================================
implementation
// =========================================================================
// =========================================================================

//      
type TColorType  = (ctGreen,      //  
                    ctBlue,       //  
                    ctYellow,     //  
                    ctRed);       //  

// =========================================================================
//    / 
// =========================================================================
constructor TCustomScope.Create(RqImg : TImage;
                                RqX, RqY, RqWidth, RqHeight : integer);
begin
   inherited Create;
   // -------------------------------
   //  fImg
   fImg := RqImg;
   // -------------------------------
   if not Assigned(fImg.Picture) then fImg.Picture := TPicture.Create;
   with fImg.Picture.Bitmap
   do begin
      if Width  <> fImg.Width   then Width  := fImg.Width;
      if Height <> fImg.Height  then Height := fImg.Height;
      if PixelFormat <> pf24bit then PixelFormat := pf24bit;
   end;
   // -------------------------------
   fVisible := False;
   fTransparent := False;
   fCompact     := False;
   // -------------------------------
   //   
   fXBeg  := RqX;
   fYBeg  := RqY;
   fWidth     := Abs(RqWidth);
   fHeight    := Abs(RqHeight);
   fScopeRect := Rect(fXBeg, fYBeg, fXBeg + fWidth, fYBeg + fHeight);
   fBmpRect   := Rect(0, 0, fWidth, fHeight);
   // -------------------------------
   //   
   fBmpSave := TBitMap.Create;
   fBmpSave.PixelFormat := pf24bit;
   //   
   fBmp  := TBitMap.Create;
   fBmp.PixelFormat := pf24bit;
   fBmp.Canvas.Font.Name := 'Tahoma';
   fBmp.Canvas.Font.Size := 8;
   // -------------------------------
   SaveBkGround();        //    
   // -------------------------------
   //      
   fWallStyle := wsNotUse;
   //   
   P2Wall     := 0;
   P1Wall     := 0;
   N2Wall     := 0;
   P1Wall     := 0;
   //   -    
   fOnYellowValue  := nil;
   //   -    
   fOnRedValue     := nil;
   // -------------------------------
   SetNumLPF(0);
end;

// -------------------------------------------------------------------------
procedure TCustomScope.Free();
begin
   SetNumLPF(0);
   if Assigned(fBmpSave)
   then begin
       RestoreBkGround();
       fBmpSave.Free();
   end;
   if Assigned(fBmp) then fBmp.Free();
   // --------------------
   inherited Free();
end;
// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
//    
procedure TCustomScope.RestoreBkGround();
var wRect : TRect;
begin
   if fVisible
   then begin
      //  Rect 
      wRect := Rect(0,0, fBmpSave.Width, fBmpSave.Height);
      //     fImg
      fImg.Canvas.CopyRect(fScopeRect, fBmpSave.Canvas,wRect);
   end;
end;
// -------------------------------------------------------------------------
//    
procedure TCustomScope.SaveBkGround();
var wRect : TRect;
begin
   if (not Assigned(fImg)) or (not Assigned(fBmpSave)) then Exit;
   //    
   fBmpSave.Height := fScopeRect.Bottom - fScopeRect.Top  + 1;
   fBmpSave.Width  := fScopeRect.Right  - fScopeRect.Left + 1;
   //  Rect 
   wRect := Rect(0,0, fBmpSave.Width, fBmpSave.Height);
   //  
   fBmpSave.Canvas.CopyRect(wRect, fImg.Canvas, fScopeRect);
   //    
   fBmp.Height := fBmpSave.Height;
   fBmp.Width  := fBmpSave.Width;
end;
// -------------------------------------------------------------------------
//   
procedure TCustomScope.SetVisible(RqVisible : boolean);
begin
  if RqVisible = fVisible then Exit;
  if RqVisible //   
  then begin
      if not fVisible
      then begin
         SaveBkGround();
         //    fImg
         fVisible := RqVisible;
         ShowScope();
      end;
  end
  else begin   //    
      if fVisible
      then begin
          //    fImg
          RestoreBkGround();
          fVisible := RqVisible;
       end;
  end;
end;
// -------------------------------------------------------------------------
//       
procedure TCustomScope.SetTransparent(RqTransparent : boolean);
var wVisible : boolean;
begin
   if RqTransparent = fTransparent then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fTransparent := RqTransparent;
   Visible := wVisible;
end;
// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
//       
procedure TCustomScope.SetCompact(RqCompact : boolean);
var wVisible : boolean;
begin
   if RqCompact = fCompact then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fCompact := RqCompact;
   ReSizeScope();
   Visible := wVisible;
end;
// -------------------------------------------------------------------------
//   
procedure TCustomScope.SetScopeStyle(RqScopeStyle : TScopeStyle);
var wVisible : boolean;
begin
   if (RqScopeStyle = fScopeStyle) then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fScopeStyle := RqScopeStyle;
   ReSizeScope();
   Visible := wVisible;
end;
// -------------------------------------------------------------------------
//   
procedure TCustomScope.SetScopeName (RqScopeName : string);
var wVisible : boolean;
begin
   if (RqScopeName = fScopeName) then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fScopeName := RqScopeName;
   ReSizeScope();
   Visible := wVisible;
end;
// -------------------------------------------------------------------------
//  XBeg    fImg
procedure TCustomScope.SetXBeg(XBeg : integer);
var wVisible : boolean;
begin
   if (XBeg = fXBeg) or (XBeg < 0) or (XBeg > fImg.Width) then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fXBeg := XBeg;
   fScopeRect := Rect(fXBeg, fYBeg, fXBeg + fWidth, fYBeg + fHeight);
   Visible := wVisible;
end;
// -------------------------------------------------------------------------
//  YBeg    fImg
procedure TCustomScope.SetYBeg(YBeg : integer);
var wVisible : boolean;
begin
   if (YBeg = fYBeg) or (YBeg < 0) or (YBeg > fImg.Height) then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fYBeg := YBeg;
   fScopeRect := Rect(fXBeg, fYBeg, fXBeg + fWidth, fYBeg + fHeight);
   Visible := wVisible;
end;
// -------------------------------------------------------------------------
//    
procedure TCustomScope.SetWidth(RqWidth : integer);
begin
  if RqWidth < 1 then Exit;              //     
  if fWidth = RqWidth then Exit;         //    
  if fVisible then RestoreBkGround();
  // 
  fWidth := RqWidth;
  fScopeRect := Rect(fXBeg, fYBeg, fXBeg + fWidth, fYBeg + fHeight);
  SaveBkGround();
  //   
  ReSizeScope();
  if fVisible then ShowScope();
end;
// -------------------------------------------------------------------------
//    
procedure TCustomScope.SetHeight(RqHeight : integer);
begin
  if RqHeight < 1 then Exit;             //     
  if fHeight = RqHeight then Exit;       //    
  if fVisible then RestoreBkGround();
  // 
  fHeight := RqHeight;
  fScopeRect := Rect(fXBeg, fYBeg, fXBeg + fWidth, fYBeg + fHeight);
  SaveBkGround();
  //   
  ReSizeScope();
  if fVisible then ShowScope();
end;
// -------------------------------------------------------------------------
// 09.07.2018
//     
procedure TCustomScope.SetMaxScope(RqMaxScope : extended);
var wVisible : boolean;
    wMax     : extended;
begin
  if (RqMaxScope = fMaxScope) then Exit; //    
  wMax := RqMaxScope;
  if wMax < 0 then wMax := 0;            //    
  if (wMax = 0) and (fMinScope = 0)
  then begin
      MessageDlg('     .'
               + #13#10
               + ' MaxScope    ... ',
      mtInformation, [mbOk], 0);
      Exit;                             //    
  end;
  // 
  wVisible := fVisible;
  if fVisible then Visible := False;
  fMaxScope := wMax;
  if (fMaxScope = 0)
  then begin
     //   
      fP2Wall := 0;
      fP1Wall := 0;
  end
  else begin
      //  
      if (fP2Wall > fMaxScope)
      then begin
         fP2Wall:= fMaxScope;
         if (fP1Wall > fP2Wall) then fP1Wall := fP2Wall;
      end;
  end;
  ReRangeScope();
  Visible := wVisible;
end;
// -------------------------------------------------------------------------
// 09.07.2018
//     
procedure TCustomScope.SetMinScope(RqMinScope : extended);
var wVisible : boolean;
    wMin     : extended;
begin
  if (RqMinScope = fMinScope) then Exit; //    
  wMin := RqMinScope;
  if wMin > 0 then wMin := 0;            //    
  if (fMaxScope = 0) and (wMin = 0)
  then begin
      MessageDlg('     .'
               + #13#10
               + ' MinScope    ... ',
      mtInformation, [mbOk], 0);
      Exit;                             //    
  end;                             //    
  // 
  wVisible := fVisible;
  if fVisible then Visible := False;
  fMinScope := wMin;
  if (fMinScope = 0)
  then begin
     //   
      fN2Wall := 0;
      fN1Wall := 0;
  end
  else begin
      //  
      if (fN2Wall < fMinScope)
      then begin
         fN2Wall := fMinScope;
         if (fN1Wall < fN2Wall) then fN1Wall := fN2Wall;
      end;
  end;
  ReRangeScope();
  Visible := wVisible;
end;
// -------------------------------------------------------------------------
//     
// -------------------------------------------------------------------------
// 08.07.2018
//  ()    
procedure TCustomScope.SetP2Wall (RqP2Wall : extended);
var wVisible : boolean;
begin
  //    
  if (RqP2Wall = fP2Wall) then Exit;
  wVisible := fVisible;
  if fVisible then Visible := False;
  // 
  if (fMaxScope > 0)
  then begin
    //    
    if (RqP2Wall >= 0) and (RqP2Wall <= fMaxScope)
    then begin
       fP2Wall := RqP2Wall;  //  
       //  fP1Wall
       if fP1Wall > fP2Wall then fP1Wall := fP2Wall;
    end
    else begin
        //  
        if (RqP2Wall < 0)
        then begin
           //   
           fP2Wall := 0;
           fP1Wall := 0;
        end;
        if (RqP2Wall > fMaxScope) then fP2Wall := fMaxScope;
    end;
  end
  else begin
     //   
     fP2Wall := 0;
     fP1Wall := 0;
  end;
  ReRangeScope();
  Visible := wVisible;
end;
// -------------------------------------------------------------------------
// 08.07.2018
//  ()    
procedure TCustomScope.SetP1Wall (RqP1Wall : extended);
var wVisible : boolean;
begin
  //    
  if (RqP1Wall = fP1Wall) then Exit;
  wVisible := fVisible;
  if fVisible then Visible := False;
  // 
  if (fP2Wall > 0)
  then begin
    if (RqP1Wall >= 0) and (RqP1Wall <= fP2Wall)
    then fP1Wall := RqP1Wall  //     
    else begin
        //  ,     
        if (RqP1Wall < 0) then fP1Wall := 0;
        if (RqP1Wall > fP2Wall) then fP1Wall := fP2Wall;
    end;
  end
  else fP1Wall := 0;
  ReRangeScope();
  Visible := wVisible;
end;
// -------------------------------------------------------------------------
// 08.07.2018
//     
procedure TCustomScope.SetN1Wall(RqN1Wall : extended);
var wVisible : boolean;
begin
  //    
  if (RqN1Wall = fN1Wall) then Exit;
  wVisible := fVisible;
  if fVisible then Visible := False;
  //   
  if (RqN1Wall <= 0) and (RqN1Wall >= fN2Wall)
  then fN1Wall := RqN1Wall  //     
  else begin
        //  ,     
        if (RqN1Wall > 0) then fN1Wall := 0;
        if (RqN1Wall < fP2Wall) then fN1Wall := fN2Wall;
  end;
  ReRangeScope();
  Visible := wVisible;
end;
// -------------------------------------------------------------------------
// 08.07.2018
//      
procedure TCustomScope.SetN2Wall(RqN2Wall : extended);
var wVisible : boolean;
begin
  //    
  if (RqN2Wall = fN2Wall) then Exit;
  wVisible := fVisible;
  if fVisible then Visible := False;
  // 
  if (fMinScope < 0)
  then begin
    //    
    if (RqN2Wall <= 0) and (RqN2Wall >= fMinScope)
    then begin
        fN2Wall := RqN2Wall;  //  
        //  fN1Wall
        if fN1Wall < RqN2Wall then fN1Wall := RqN2Wall;
    end
    else begin
        //  
        if (RqN2Wall > 0)
        then begin
           //   
           fN2Wall := 0;
           fN1Wall := 0;
        end;
        if (RqN2Wall < fMinScope) then fN2Wall := fMinScope;
    end;
  end
  else begin
     //   
     fN2Wall := 0;
     fN1Wall := 0;
  end;
  ReRangeScope();
  Visible := wVisible;
end;
// -------------------------------------------------------------------------
//       
procedure  TCustomScope.SetWallStyle(RqWallStyle : TWallStyle);
var wVisible : boolean;
begin
  if (RqWallStyle = fWallStyle)
  then Exit; //    
  // 
  wVisible := fVisible;
  if fVisible then Visible := False;
  fWallStyle := RqWallStyle;
  Visible := wVisible;
end;
// -------------------------------------------------------------------------
//      -    
procedure  TCustomScope.RunOnYellowValue(RqValue : extended);
begin
   if not Assigned(fOnYellowValue) then Exit;
   try
      fOnYellowValue(Self, RqValue);
   except
   end;
end;
// -------------------------------------------------------------------------
//       -    
procedure  TCustomScope.RunOnRedValue(RqValue : extended);
begin
   if not Assigned(fOnRedValue) then Exit;
   try
      fOnRedValue(Self, RqValue);
   except
   end;
end;
// -------------------------------------------------------------------------
//          
// -------------------------------------------------------------------------
//      RqColorStyle
function GetColorByStyle (RqColorStyle : TColorStyle;
                          RqColorType  : TColorType) : TColor;
begin
    Result := clBlack;
    case RqColorStyle of
     //   
     csDark  :  case RqColorType of
                    ctGreen  : Result := clGreen;      //  
                    ctBlue   : Result := clBlue;       //  
                    ctYellow : Result := clYellow;     //  
                    ctRed    : Result := clRed;        //  
                end;
     //   
     csLight :  case RqColorType of
                    ctGreen  : Result := RGB(180,255,200);  //  
                    ctBlue   : Result := RGB(180,200,255);  //  
                    ctYellow : Result := RGB(255,255,180);  //  
                    ctRed    : Result := RGB(255,180,180);  //  
                end;
     //   
     csBright : case RqColorType of
                    ctGreen  : Result := RGB(100,255,100);  //  
                    ctBlue   : Result := RGB(100,100,255);  //  
                    ctYellow : Result := clYellow;          //  
                    ctRed    : Result := RGB(255,100,100);  //  
                end;
    end;
end;
// -------------------------------------------------------------------------
//        
function TCustomScope.GetColorByValue (RqColorStyle : TColorStyle;
                                       RqValue : extended) : TColor;
const EpsZ = 1e-14;
var AcN, AcP : boolean;
    NZ1, NZ2, NZ3, NZ4 : boolean;
    PZ1, PZ2, PZ3, PZ4 : boolean;
    wG : boolean;
begin
    Result := clBlack;  //   
    //   
    AcN := (N2Wall < -EpsZ) and (N2Wall <= N1Wall) and (fMinScope < -EpsZ);
    AcP := (P2Wall >  EpsZ) and (P2Wall >= P1Wall) and (fMaxScope >  EpsZ);
    //   RqValue   
    NZ1 := AcN and (RqValue <= 0)      and (RqValue > N1Wall);
    NZ2 := AcN and (RqValue <= N1Wall) and (RqValue > N2Wall);
    NZ3 := AcN and (RqValue <= N2Wall) and (RqValue >= fMinScope);
    NZ4 := (RqValue <  fMinScope);
    //   RqValue   
    PZ1 := AcP and (RqValue >= 0)      and (RqValue < P1Wall);
    PZ2 := AcP and (RqValue >= P1Wall) and (RqValue < P2Wall);
    PZ3 := AcP and (RqValue >= P2Wall) and (RqValue <= fMaxScope);
    PZ4 := (RqValue >  fMaxScope);
    //      (Out of Range)
    if (NZ4 or PZ4)
    then begin
       Result := RGB(160,0,0);  // clPurple;
       //   -    
       RunOnRedValue(RqValue);
       Exit;
    end;
    if not (AcN or AcP)
    then begin
        if RqValue >= 0
        then Result := GetColorByStyle(RqColorStyle, ctGreen)
        else Result := GetColorByStyle(RqColorStyle, ctBlue);
        Exit;
    end;
    //     
    case fWallStyle of
    //--------
    wsNotUse : begin  //   
                 if RqValue >= 0
                 then Result := GetColorByStyle(RqColorStyle, ctGreen)
                 else Result := GetColorByStyle(RqColorStyle, ctBlue);
                 Exit;
               end;
    //--------
    wsDam    : begin //   
                  if (NZ1 or PZ1)
                  then begin
                    if RqValue >= 0
                    then Result := GetColorByStyle(RqColorStyle, ctGreen)
                    else Result := GetColorByStyle(RqColorStyle, ctBlue);
                    Exit;
                  end;
                  if (NZ2 or PZ2)
                  then begin
                    Result := GetColorByStyle(RqColorStyle, ctYellow);
                    //   -    
                    RunOnYellowValue(RqValue);
                    Exit;
                  end;
                  if (NZ3 or PZ3)
                  then begin
                    Result := GetColorByStyle(RqColorStyle, ctRed);
                    //   -    
                    RunOnRedValue(RqValue);
                  end;
                end;
     wsLimit  : begin //   
                   wG := ((AcN and AcP) and (NZ1 or PZ1)) or  // -/+ 
                         ((AcN and (not AcP)) and NZ2)    or  // - 
                         (((not AcN) and AcP) and PZ2);       // + 
                   if wG
                   then begin
                      if (RqValue >= 0)
                      then Result := GetColorByStyle(RqColorStyle, ctGreen)
                      else Result := GetColorByStyle(RqColorStyle, ctBlue);
                   end
                   else begin
                      Result := GetColorByStyle(RqColorStyle, ctRed);
                      //   -    
                      RunOnRedValue(RqValue);
                   end;
                end;
     else       begin //   
                  if RqValue >= 0
                  then Result := GetColorByStyle(RqColorStyle, ctGreen)
                  else Result := GetColorByStyle(RqColorStyle, ctBlue);
                end;
     end;
end;
// -------------------------------------------------------------------------
//    LPF (Low-Pass Filter)
// -------------------------------------------------------------------------
//     
function  TCustomScope.GetNumLPF(): integer;
begin
   Result := Length(fArrLPF);
end;
// -------------------------------------------------------------------------
//     
procedure TCustomScope.SetNumLPF(RqNum : integer);
var Ind : integer;
begin
   if RqNum >= 0
   then begin
     SetLength(fArrLPF, RqNum);
     //  
     if RqNum >= 0
     then for Ind := Low(fArrLPF) to High(fArrLPF) do fArrLPF[Ind] := 0;
   end;
end;
// -------------------------------------------------------------------------
//       
procedure TCustomScope.ShiftArrLPF();
var Ind : integer;
begin
    for Ind := Low(fArrLPF) to High(fArrLPF) - 1
    do fArrLPF[Ind] := fArrLPF[Ind + 1];
    fIndLPF := High(fArrLPF);
end;
// -------------------------------------------------------------------------
//      
function TCustomScope.CalcLPF(RqValue : extended) : extended;
var Ind : integer;
begin
   Result := 0;
   // -------------------------
   if fIndLPF <= High(fArrLPF)
   then fArrLPF[fIndLPF] := RqValue
   else begin
      ShiftArrLPF();
      fArrLPF[fIndLPF] := RqValue;
   end;
   fIndLPF := fIndLPF + 1;
   // -------------------------
   //  
   for Ind := Low(fArrLPF) to High(fArrLPF)
   do Result := Result + fArrLPF[Ind];
   Result := Result / Length(fArrLPF);
end;
// -------------------------------------------------------------------------
// 18.07.2018
//   
procedure TCustomScope.SetValue (RqValue : extended);
var wValue : extended;
begin
   if Length(fArrLPF) > 1
   then wValue := CalcLPF(RqValue)
   else wValue := RqValue;
   fValue := wValue;
   ShowScope();
end;
// -------------------------------------------------------------------------
//  
procedure TCustomScope.SetMeasure(RqMeasure : string);
const MaxLen = 8;
begin
   if Length(RqMeasure) > MaxLen
   then fMeasure := copy(RqMeasure, 1, MaxLen)
   else fMeasure := RqMeasure;
   ShowScope();
end;
// =========================================================================
//   ,  
// =========================================================================
// -------------------------------------------------------------------------
//        
procedure TCustomScope.ReSizeScope();
begin
//  OVERRIDE
end;

// -------------------------------------------------------------------------
//        
procedure TCustomScope.ReRangeScope();
begin
//  OVERRIDE
end;
// -------------------------------------------------------------------------
// 14.07.2018
//  (  ShowScope)  .
procedure TCustomScope.HidenSetValue (RqValue : extended);
var wValue : extended;
begin
   if Length(fArrLPF) > 1
   then wValue := CalcLPF(RqValue)
   else wValue := RqValue;
   fValue := wValue;
end;
// =========================================================================
//    
// =========================================================================
// -------------------------------------------------------------------------
//  Width  Height  
procedure TCustomScope.ScopeSize(RqWidth, RqHeight : integer);
var wVisible : boolean;
begin
   if (Abs(RqWidth) < 1) or (Abs(RqHeight) < 1) then Exit;
   if (fWidth = Abs(RqWidth)) and (fHeight = Abs(RqHeight)) then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fWidth  := Abs(RqWidth);
   fHeight := Abs(RqHeight);
   fScopeRect := Rect(fXBeg, fYBeg, fXBeg + fWidth, fYBeg + fHeight);
   Visible := wVisible;
end;
// -------------------------------------------------------------------------
//  XBeg  YBeg  
procedure TCustomScope.ScopePosition(RqXBeg, RqYBeg : integer);
var wVisible : boolean;
begin
   if (RqXBeg < 0) or (RqXBeg > fImg.Width)  then Exit;
   if (RqYBeg < 0) or (RqYBeg > fImg.Height) then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fXBeg := RqXBeg;
   fYBeg := RqYBeg;
   fScopeRect := Rect(fXBeg, fYBeg, fXBeg + fWidth, fYBeg + fHeight);
   Visible := wVisible;
end;
// =========================================================================
//   ,   PaintToBmp  
// =========================================================================
//  
procedure TCustomScope.ShowScope();
var wRect : TRect;
begin
   if not fVisible then Exit;
   //   fBmp   
   fBmp.Assign(fBmpSave);
   // --------------
   //       fBmp
   PaintToBmp(fBmp);
   // --------------
   //  Rect 
   wRect := Rect(0,0, fBmp.Width, fBmp.Height);
   //     fImg
   fImg.Canvas.CopyRect(fScopeRect, fBmp.Canvas, wRect);
end;
// =========================================================================
// =========================================================================

end.