unit MAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Math,
  CustomScope03, DnConsole03, DigitsScope03;

type
  TForm1 = class(TForm)
    bttGreate: TButton;
    bttFree: TButton;
    stxtMemory: TStaticText;
    Timer1: TTimer;
    bttShow: TButton;
    bttHide: TButton;
    Label3: TLabel;
    Panel1: TPanel;
    rgrpMode: TRadioGroup;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Button5: TButton;
    stxtModeStep: TStaticText;
    stxtModeCicle: TStaticText;
    Panel2: TPanel;
    Label2: TLabel;
    Label7: TLabel;
    cbboxAFunc: TComboBox;
    cbboxDFunc: TComboBox;
    Panel3: TPanel;
    trbarUAmp: TTrackBar;
    trbarCAmp: TTrackBar;
    Label5: TLabel;
    Label4: TLabel;
    stxtUAmp: TStaticText;
    stxtCAmp: TStaticText;
    trbarCGrm: TTrackBar;
    trbarUGrm: TTrackBar;
    stxtUGrm: TStaticText;
    stxtCGrm: TStaticText;
    Label6: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    procedure bttGreateClick(Sender: TObject);
    procedure bttFreeClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bttShowClick(Sender: TObject);
    procedure bttHideClick(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);

    procedure ComboBox1Click(Sender: TObject);
    procedure rgrpModeClick(Sender: TObject);
    procedure trbarUAmpChange(Sender: TObject);
    procedure trbarCAmpChange(Sender: TObject);
    procedure trbarUGrmChange(Sender: TObject);
    procedure trbarCGrmChange(Sender: TObject);

  private
    { Private declarations }
     function GetAnalogFunc() : extended;
     //    
     function GetDigitFunc() : Integer;
     //     
     procedure RunOneStep();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// =============================================================
//   
// =============================================================
// =============================================================
//  
// =============================================================

const cMaxDacIndx   = 1023;                    //   10 
      cMaxGrmIndx   = cMaxDacIndx div 4;       //   
      cMaxPntIndx   = 4 * cMaxGrmIndx;         // .    
      cPhaseStep    = 2 * Pi / cMaxPntIndx;    //     



const cMaxAddres = cMaxPntIndx - 1;            //    

const cMaxUGrm = cMaxGrmIndx div 2;            // .   U
      cMaxCGrm = cMaxGrmIndx div 2;            // .   

//    
const cMaxIndxDescSope = 15;                   //   
      cBaseXS = 360;                           //    
      cBaseYS = 255;                           //    
      cStepXS = 46;                            //    
      cMaxUAmp  = 1000;                        // .  

const DescScopeArr : array[0..cMaxIndxDescSope] of TDescScope =
(
     // =====================================
     // 
     // =====================================
     // =====================================   0
   ( ScopeType   : 'S';
     ScopeName   : 'd9'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 0 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   1
   ( ScopeType   : 'S';
     ScopeName   : 'd8'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 1 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   2
   ( ScopeType   : 'S';
     ScopeName   : 'd7'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 2 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   3
   ( ScopeType : 'S';
     ScopeName : 'd6'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 3 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   4
   ( ScopeType : 'S';
     ScopeName : 'd5'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 4 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   5
   ( ScopeType : 'S';
     ScopeName : 'd4'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 5 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   6
   ( ScopeType : 'S';
     ScopeName : 'd3'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 6 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   7
   ( ScopeType : 'S';
     ScopeName : 'd2'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 7 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   8
   ( ScopeType : 'S';
     ScopeName : 'd1'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 8 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   9
   ( ScopeType : 'S';
     ScopeName : 'd0'; MinScope : 0; MaxScope : 1;
     XBeg : cBaseXS + 9 * cStepXS;  YBeg  : cBaseYS;
     Compact : True;  Transparent : True;),
     // =====================================
     // 
     // =====================================   10
   ( ScopeType : 'D';
     ScopeName : ' Bit'; Measure : '';
     MinScope : 0; MaxScope : cMaxAddres;
     XBeg : 260; YBeg : 388;
     Transparent : True; Radix : rdxBit; DFrame : dfrmDown),
     // =====================================   11
   ( ScopeType : 'D';
     ScopeName : ' Decimal;'; Measure : '';
     MinScope : 0; MaxScope : cMaxAddres;
     XBeg : 530; YBeg : 388;
     Transparent : True; Radix : rdxDecimal; DFrame : dfrmDown),
     // =====================================   12
   ( ScopeType : 'D';
     ScopeName : ' Decimal;'; Measure : '';
     MinScope : 0; MaxScope : cMaxAddres;
     XBeg : 540; YBeg : 572;
     Transparent : True; Radix  : rdxDecimal; DFrame : dfrmDown),
     // =====================================
     // 
     // =====================================   13
   ( ScopeType : 'L';
     ScopeName : ' ';
     Measure : 'mV';
     MinScope : -(cMaxUAmp + 60);  MaxScope : cMaxUAmp + 60;
     P2Wall   :  (cMaxUAmp + 30);  P1Wall :  (cMaxUAmp + 1);
     N2Wall   : -(cMaxUAmp + 30);  N1Wall : -(cMaxUAmp + 1);
     WallStyle : wsDam;  NumLPF : 0;
     XBeg : 150; YBeg : 20;  ScopeWidth : 360;
     Compact : False; ScopeStyle : ssNotUse; Transparent : True;
     GrmNum  : cMaxGrmIndx;  Grm1P : 1;),
     // =====================================   14
   ( ScopeType : 'R';
     ScopeName : ' '; Measure : 'mV';
     MinScope : -(cMaxUAmp + 60);  MaxScope : cMaxUAmp + 60;
     P2Wall :    (cMaxUAmp + 30);  P1Wall :  (cMaxUAmp + 1);
     N2Wall :   -(cMaxUAmp + 30);  N1Wall : -(cMaxUAmp + 1);
     WallStyle : wsDam;  NumLPF : 0;
     XBeg : 1000; YBeg : 50; ScopeWidth : 0;
     Compact : False; ScopeStyle : ssArc; Transparent : True;
     GrmNum : cMaxGrmIndx; Grm1P  : 1;),
     // =====================================   15
   ( ScopeType : 'D';
     ScopeName : 'DFunc'; Measure : '';
     MinScope : 0; MaxScope : 0;
     XBeg : 260; YBeg : 436;
     Transparent : True; DFrame : dfrmDown)
);

// -------------------------------------------------------------
var   // 
      DnConsole : TDnConsole;

// =============================================================
//       DnConsole
// =============================================================
// -------------------------------------------------------------
//    
procedure ShowDScope(RqIndx : integer; RqRadix : TRadix; RqValue : Word);
var wScope  : TCustomScope;
begin
    if not Assigned(DnConsole) then Exit;
    wScope := DnConsole.Scope[RqIndx];
    if Assigned(wScope)
    then begin
        if (wScope is TDigitsScope)
        then begin
            //   TDigitsScope
            TDigitsScope(wScope).ShowWordValue(RqRadix, RqValue);
        end;
        //    DnConsole    
        DnConsole.SetValueToScope(RqIndx, RqValue);
    end;
end;
// -------------------------------------------------------------
//     
procedure ShowTxtDScope(RqIndx : integer; Value : string);
var wScope  : TCustomScope;
begin
    if not Assigned(DnConsole) then Exit;
    wScope := DnConsole.Scope[RqIndx];
    if Assigned(wScope)
    then begin
        if (wScope is TDigitsScope)
        then begin
            //   TDigitsScope
            TDigitsScope(wScope).ShowTextValue(Value);
        end;
    end;
end;
// -------------------------------------------------------------
//      
procedure SetPropToDScope(RqIndx      : integer;
                          RqFontStyle : TFontStyles;
                          RqFontSize  : integer;
                          RqTxtColor  : TColor);
var wScope  : TCustomScope;
begin
    if not Assigned(DnConsole) then Exit;
    wScope := DnConsole.Scope[RqIndx];
    if Assigned(wScope)
    then begin
        if (wScope is TDigitsScope)
        then begin
            TDigitsScope(wScope).FontStyle := RqFontStyle;
            TDigitsScope(wScope).FontSize  := RqFontSize;
            TDigitsScope(wScope).TxtColor  := RqTxtColor;
        end;
    end;
end;

// =============================================================
//  
// =============================================================
//  
var   CurentAddres  : integer;
      AnalogFunc    : extended;
      Code          : integer;
      UAmp          : extended;
      UGrm          : integer;
      CAmp          : integer;
      CGrm          : integer;
// -------------------------------------------------------------
// -------------------------------------------------------------
//  ,       
procedure ShowDacInputCode(RqWord : word);
var wWord : word;
    Ind   : integer;
begin
   wWord := RqWord;
   //     
   ShowDScope(10, rdxBit, wWord);
   //      
   ShowDScope(11, rdxDecimal, wWord);
   //     
   for Ind := 9 downTo 0 do
   begin
      DnConsole.SetValueToScope(Ind, wWord and $00000001);
      wWord := wWord shr 1;
   end;
end;
// -------------------------------------------------------------
//    
procedure ShowTxtCodeFunc(RqCbBox : TComboBox);
var wStr : string;
begin
   case RqCbBox.ItemIndex of
   0 : wStr := 'CODE=CAmp';
   1 : wStr := 'CODE=CAmp*Addr/MaxAddr';
   2 : wStr := 'CODE=CAmp*(1+sin(N*(2*Pi/MaxAddr)*Addr)/2); N- ';
   end;
   ShowTxtDScope(15, wStr);
end;
// -------------------------------------------------------------
function TForm1.GetAnalogFunc() : extended;
begin
   Result := 0;
   if not Assigned(DnConsole) then Exit;
   case cbboxAFunc.ItemIndex of
   0  :  Result := UAmp;
   1  :  Result := UAmp * CurentAddres / (cMaxPntIndx - 1);
   2  :  Result  := UAmp * Sin(UGrm * cPhaseStep * CurentAddres);
   end;
   // ---------------------------------
   DnConsole.SetValueToScope(13, Result);
end;
// -------------------------------------------------------------
//    
function TForm1.GetDigitFunc() : Integer;
begin
   Result := 0;
   if not Assigned(DnConsole) then Exit;
   case cbboxDFunc.ItemIndex of
   0 : Result := CAmp;
   1 : Result := Round(CAmp * CurentAddres / (cMaxPntIndx - 1));
   2 : Result := Round(CAmp * (1 + Sin(CGrm * cPhaseStep * CurentAddres))/2);
   end;
   // ---------------------------------
   //  ,       
   ShowDacInputCode(Result);
   //    
   ShowTxtCodeFunc(cbboxDFunc);
end;
// -------------------------------------------------------------
//        
procedure SetMemoryAddr();
begin
   Inc(CurentAddres);
   //       
   //     .
   if (CurentAddres < 0) or (CurentAddres > (cMaxPntIndx - 1))
   then CurentAddres := 0;
end;
// -------------------------------------------------------------
//     
procedure TForm1.RunOneStep();
begin
  if not Assigned(DnConsole) then Exit;
  //      
  ShowDScope(12, rdxDecimal, word(CurentAddres));
  //    
  AnalogFunc := GetAnalogFunc();
  Code  := GetDigitFunc();
  //    cMaxDacIndx
  // DnConsole.SetValueToScope(14, DigitFunc * AnalogFunc / cMaxPntIndx);
  DnConsole.SetValueToScope(14, Code * AnalogFunc / cMaxDacIndx);
  // ------------------------
  SetMemoryAddr();
end;
// =============================================================
//   
// =============================================================
// -------------------------------------------------------------
//  
procedure TForm1.Button5Click(Sender: TObject);
begin
  RunOneStep();  //   
end;
// -------------------------------------------------------------
//   
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if (rgrpMode.ItemIndex = 0) then Exit;
  RunOneStep(); //   
end;
// -------------------------------------------------------------
//  
procedure TForm1.ComboBox1Click(Sender: TObject);
begin
    case  ComboBox1.ItemIndex of
    0 : Timer1.Interval := 20;
    1 : Timer1.Interval := 100;
    2 : Timer1.Interval := 500;
    3 : Timer1.Interval := 1000;
    4 : Timer1.Interval := 2000;
    end;
end;
// -------------------------------------------------------------
//   
procedure TForm1.rgrpModeClick(Sender: TObject);
begin
   if rgrpMode.ItemIndex = 0
   then begin
      Timer1.Enabled := False;
      stxtModeStep.Color := clLime;
      stxtModeCicle.Color := clBtnFace;
   end
   else begin
      Timer1.Enabled := True;
      stxtModeStep.Color := clBtnFace;
      stxtModeCicle.Color := clLime;
   end;
end;
// -------------------------------------------------------------
//     
procedure TForm1.trbarUAmpChange(Sender: TObject);
begin
   UAmp := trbarUAmp.Position;
   stxtUAmp.Caption := IntToStr(trbarUAmp.Position);
end;
// -------------------------------------------------------------
//   
procedure TForm1.trbarUGrmChange(Sender: TObject);
begin
   UGrm :=  trbarUGrm.Position;
   stxtUGrm.Caption := IntToStr(trbarUGrm.Position);
   //        
   if trbarCGrm.Position > trbarUGrm.Position
   then trbarCGrm.Position := trbarUGrm.Position;
end;
// -------------------------------------------------------------
//     
procedure TForm1.trbarCAmpChange(Sender: TObject);
begin
    CAmp := trbarCAmp.Position;
    stxtCAmp.Caption := IntToStr(trbarCAmp.Position);
end;
// -------------------------------------------------------------
//   
procedure TForm1.trbarCGrmChange(Sender: TObject);
begin
   CGrm :=  trbarCGrm.Position;
   stxtCGrm.Caption := IntToStr(trbarCGrm.Position);
   //        
   if trbarCGrm.Position > trbarUGrm.Position
   then trbarCGrm.Position := trbarUGrm.Position;
end;
// =============================================================
//   /  
// =============================================================
// -------------------------------------------------------------
//    
function GetApplicationDirectory() : string;
begin
   Result := Application.ExeName;
   Result := ExtractFileDir(Result);
end;
// -------------------------------------------------------------
//   DnConsole
procedure TForm1.bttGreateClick(Sender: TObject);
var wDir : string;
begin
   wDir := GetApplicationDirectory();
   if Assigned(DnConsole) then Exit;
   // ------------------------------------
   DnConsole := TDnConsole.Create(1200,800);
   DnConsole.LoadBaseImg(wDir + '\PICTUREs\Default.jpg');
   DnConsole.LoadAllScopes(High(DescScopeArr), Addr(DescScopeArr));
   // -----------------------------
   SetPropToDScope(15, [fsItalic], 12, clBlack);  // [fsBold, fsItalic]
   // -----------------------------
   stxtModeStep.Color  := clLime;
   stxtModeCicle.Color := clBtnFace;
   // -----------------------------
   stxtMemory.Caption := IntToStr(AllocMemSize);
   // -----------------------------
end;
// -------------------------------------------------------------
//   DnConsole
procedure TForm1.bttFreeClick(Sender: TObject);
begin
   if Assigned(DnConsole)
   then begin
      DnConsole.Free;
      DnConsole := nil;
   end;
   // -----------------------------
   stxtModeStep.Color  := clBtnFace;
   stxtModeCicle.Color := clBtnFace;
   // -----------------------------
   stxtMemory.Caption := IntToStr(AllocMemSize);
end;
// -------------------------------------------------------------
//   DnConsole
procedure TForm1.FormDestroy(Sender: TObject);
begin
   if Assigned(DnConsole)
   then begin
      DnConsole.Free;
      DnConsole := nil;
   end;
end;
// -------------------------------------------------------------
// 
procedure TForm1.bttShowClick(Sender: TObject);
begin
   if Assigned(DnConsole) then DnConsole.DnFRM.Show;
end;
// -------------------------------------------------------------
// 
procedure TForm1.bttHideClick(Sender: TObject);
begin
   if Assigned(DnConsole) then DnConsole.DnFRM.Hide;
end;

// -------------------------------------------------------------
//  
procedure TForm1.FormCreate(Sender: TObject);
begin
  CurentAddres := 0;
  Timer1.Enabled := False;
  // ---------------------
  trbarUAmp.Min := 0;
  trbarUAmp.Max := cMaxUAmp;
  trbarUAmp.Position := trbarUAmp.Max div 2;
  UAmp := trbarUAmp.Position;
  // ---------------------
  //
  trbarUGrm.Min := 1;
  trbarUGrm.Max := cMaxUGrm;
  trbarUGrm.Position := 64;
  UGrm := trbarUGrm.Position;
  // ---------------------
  //
  trbarCAmp.Min := 0;
  trbarCAmp.Max := cMaxAddres + 1;
  trbarCAmp.Position := trbarCAmp.Max div 2;
  CAmp := trbarCAmp.Position;
  // ---------------------
  trbarCGrm.Min := 1;
  trbarCGrm.Max := cMaxCGrm;
  trbarCGrm.Position := 36;
  CGrm := trbarCGrm.Position;
end;




end.
