unit MAIN;

//    Sigma-Delta ,
//    Sigma-Delta DAC ()  .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, Math,
  PFilter, DDisplayTools, DDisplayGUI, DDisplayQE;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Panel2: TPanel;
    ColorDialog1: TColorDialog;
    Panel4: TPanel;
    Panel1: TPanel;
    Label1: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    CBox1EnCapt: TCheckBox;
    Ed1DisplayLV: TEdit;
    CBox1EnCurrY: TCheckBox;
    CbBox1Sens: TComboBox;
    STxt1GridColor: TStaticText;
    STxt1BeamColor: TStaticText;
    STxt1DisplayColor: TStaticText;
    Panel3: TPanel;
    Image1: TImage;
    Panel5: TPanel;
    Panel6: TPanel;
    Label9: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    CBox2EnCapt: TCheckBox;
    Ed2DisplayLV: TEdit;
    CBox2EnCurrY: TCheckBox;
    CbBox2Sens: TComboBox;
    STxt2GridColor: TStaticText;
    STxt2BeamColor: TStaticText;
    STxt2DisplayColor: TStaticText;
    Panel7: TPanel;
    Image2: TImage;
    Panel8: TPanel;
    EdMera: TEdit;
    EdSignal: TEdit;
    Label2: TLabel;
    Label14: TLabel;
    BttReset: TButton;
    Panel9: TPanel;
    SBttStart: TSpeedButton;
    SBttStop: TSpeedButton;
    STxtBalans: TStaticText;
    Label3: TLabel;
    CbBoxInDisplay1: TComboBox;
    Label4: TLabel;
    Label15: TLabel;
    STxtOutDAC: TStaticText;
    CbBoxDisplay1Style: TComboBox;
    Label16: TLabel;
    CBox1Alert: TCheckBox;
    CBox2Alert: TCheckBox;
    Label5: TLabel;
    CbBoxDisplay2Style: TComboBox;
    BttResetAll: TButton;
    Label10: TLabel;
    CBoxTemp: TComboBox;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    CBoxMaxStep: TComboBox;
    Label20: TLabel;
    CbBoxLPF: TComboBox;
    StxtImpP: TStaticText;
    Label21: TLabel;
    Label22: TLabel;
    StxtNumN: TStaticText;
    Label23: TLabel;
    STxtNumP: TStaticText;
    Label24: TLabel;
    Label25: TLabel;
    StxtPsubN: TStaticText;
    StxtNumSteps: TStaticText;
    Label26: TLabel;
    StxtOutSDLPF: TStaticText;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    BitBtnParmFltR: TBitBtn;
    // -----------------------------------------
    //    Delphi
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SBttStartClick(Sender: TObject);
    procedure SBttStopClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure CBox1EnCurrYClick(Sender: TObject);
    procedure CbBox1SensClick(Sender: TObject);
    procedure STxt1GridColorClick(Sender: TObject);
    procedure STxt1BeamColorClick(Sender: TObject);
    procedure STxt1DisplayColorClick(Sender: TObject);
    procedure CBox1EnCaptClick(Sender: TObject);
    procedure EdMeraChange(Sender: TObject);
    procedure EdSignalChange(Sender: TObject);
    procedure BttResetClick(Sender: TObject);
    procedure CBox1AlertClick(Sender: TObject);
    procedure STxt2DisplayColorClick(Sender: TObject);
    procedure STxt2BeamColorClick(Sender: TObject);
    procedure STxt2GridColorClick(Sender: TObject);
    procedure CBox2EnCaptClick(Sender: TObject);
    procedure CBox2EnCurrYClick(Sender: TObject);
    procedure CBox2AlertClick(Sender: TObject);
    procedure CbBox2SensClick(Sender: TObject);
    procedure BttResetAllClick(Sender: TObject);
    procedure CBoxTempClick(Sender: TObject);
    procedure CBoxMaxStepClick(Sender: TObject);
    procedure CbBoxLPFClick(Sender: TObject);
    procedure BitBtnParmFltRClick(Sender: TObject);
  private
    // -----------------------------------------
    //      1
    procedure DDisplay1OnItemDraw  (Sender : TObject; X, Y : integer;
                                    Item   : TQItem);
    procedure DDisplay1OnAlertItem (Sender : TObject; X, Y : integer;
                                    Item : TQItem);
    // -----------------------------------------
    //      2
    procedure DDisplay2OnItemDraw  (Sender : TObject; X, Y : integer;
                                    Item   : TQItem);
    procedure DDisplay2OnAlertItem (Sender : TObject; X, Y : integer;
                                    Item : TQItem);
  public
    { Public declarations }
    //  DAC  ADC
    procedure InitDacAdc();
    //  SD-  SD-
    procedure ClearDacAdc();
    //  1 (     )
    procedure AddPointToOscillograph1(RqOutDAC : double);
    //  2 (     )
    procedure AddPointToOscillograph2(RqOutDAC : double);
  end;

// ===========================================================
var  Form1: TForm1;
// ===========================================================
implementation

{$R *.dfm}
// ===========================================================
//    
const MaxDisplayPoint = 40;
var DDisplay1  : TDDisplay;  //     1  ()
var DDisplay2  : TDDisplay;  //     2  ()
// ===========================================================
const DefMera   = 10;        //    
      DefSignal = 4;         //    

var //   SD-
    Mera   : double;         //   
    Signal : double;         //   
    Balans : double;         //  - 
    PNum   : integer;        //    
    NNum   : integer;        //    
    PMod   : boolean;        //  P- 
    //   SD-
    SDLpfOut : double;       //  SIGMA-DELTA 
    //   
    RqLPF    : integer;       //   
    LPF2Out  : double;        //   
    LPF3Buf  : double;        //   
    LPF3Out  : double;        //   
//   SD-
const SBalansMin = 0.0001;   //      Balans = 0
var OutDAC  : double;        //      2
    RunFlag : boolean;       //  -  / 
    MaxStep : integer;       //     
// ===========================================================
//  
// ===========================================================
// -----------------------------------------------------------
//  DAC  ADC
procedure TForm1.InitDacAdc();
begin
   // -------------------
   RunFlag := False;          //  
   CBoxMaxStepClick(nil);     //     
   //   
   BttResetAllClick(nil);
end;
// -----------------------------------------------------------
//  
procedure TForm1.FormCreate(Sender: TObject);
begin
   // -------------------
   //  SD-  
   Mera    := DefMera;
   EdMera.Text := FloatToStr(Mera);
   Signal  := DefSignal;
   EdSignal.Text := FloatToStr(Signal);
   // ----------------------------
   //   1
   DDisplayGreate(DDisplay1, Image1);
   if Assigned(DDisplay1)
   then begin
      DDisplay1.DMaxCount := MaxDisplayPoint;
      //    -    
      OnOffDDisplayItemDraw(DDisplay1, False,  DDisplay1OnItemDraw);
      //    -    
      OnOffDDisplayAlertItem(DDisplay1, True, DDisplay1OnAlertItem);
      //   
      CbBox1SensClick(nil);
      DDisplay1.EnCapt := CBox1EnCapt.Checked;
   end;
   // ----------------------------
   //   2
   DDisplayGreate(DDisplay2, Image2);
   if Assigned(DDisplay2)
   then begin
      DDisplay2.DMaxCount := MaxDisplayPoint;
      //    -    
      OnOffDDisplayItemDraw(DDisplay2, False,  DDisplay2OnItemDraw);
      //    -    
      OnOffDDisplayAlertItem(DDisplay2, True, DDisplay2OnAlertItem);
      CbBox2SensClick(nil);
      DDisplay2.EnCapt   := CBox2EnCapt.Checked;
      DDisplay2.MdAlert  := Abs(Signal);
      CBox2Alert.Checked := False;
   end;
   // ----------------------------
   //  DAC  ADC
   InitDacAdc();
end;
// -----------------------------------------------------------
//    
procedure TForm1.FormDestroy(Sender: TObject);
begin
  RunFlag := False;
  DDisplayDestroy(DDisplay1);
  DDisplayDestroy(DDisplay2);
end;

// -----------------------------------------------------------
//    1
// -----------------------------------------------------------
//   -   
procedure TForm1.DDisplay1OnItemDraw (Sender : TObject;
     X, Y : integer; Item : TQItem);
begin
  Ed1DisplayLV.Text := FormatFloat('#0.000000', Item.RData);
end;
//   -   
procedure TForm1.DDisplay1OnAlertItem (Sender : TObject;
     X, Y : integer; Item : TQItem);
begin
  //    (440 hz)   
  //  :  (hz),  (ms)
  if CBox1Alert.Checked then Windows.Beep(440,10);
end;
//   
procedure TForm1.STxt1BeamColorClick(Sender: TObject);
begin
  SetDDisplayColor(DDisplay1, ColorDialog1, 1);
  ShowCororIndicators(DDisplay1,
                      STxt1BeamColor, STxt1DisplayColor, STxt1GridColor);
end;
//   
procedure TForm1.STxt1DisplayColorClick(Sender: TObject);
begin
  SetDDisplayColor(DDisplay1, ColorDialog1, 2);
  ShowCororIndicators(DDisplay1,
                      STxt1BeamColor, STxt1DisplayColor, STxt1GridColor);
end;
//    
procedure TForm1.STxt1GridColorClick(Sender: TObject);
begin
  SetDDisplayColor(DDisplay1, ColorDialog1, 3);
  ShowCororIndicators(DDisplay1,
                      STxt1BeamColor, STxt1DisplayColor, STxt1GridColor);
end;
//  /    
procedure TForm1.CBox1EnCaptClick(Sender: TObject);
begin
   if Assigned(DDisplay1)then DDisplay1.EnCapt := CBox1EnCapt.Checked;
end;
//  /       TEdit
procedure TForm1.CBox1EnCurrYClick(Sender: TObject);
begin
 OnOffDDisplayItemDraw (DDisplay1, CBox1EnCurrY.Checked, DDisplay1OnItemDraw);
end;
//   Alert   
procedure TForm1.CBox1AlertClick(Sender: TObject);
begin
  if Assigned(DDisplay1)
  then begin
    if CBox1Alert.Checked
    then DDisplay1.MdAlert := Abs(2*Mera)
    else DDisplay1.MdAlert := -1;
  end;
end;
//   (   )
procedure TForm1.CbBox1SensClick(Sender: TObject);
begin
  if Assigned(DDisplay1)
  then begin
     case CbBox1Sens.ItemIndex of
     0 : DDisplay1.Sens := 1;
     1 : DDisplay1.Sens := 5;
     2 : DDisplay1.Sens := 10;
     3 : DDisplay1.Sens := 50;
     end;
  end;
end;
// -----------------------------------------------------------
//    2
// -----------------------------------------------------------
//   -   
procedure TForm1.DDisplay2OnItemDraw (Sender : TObject;
     X, Y : integer; Item : TQItem);
begin
  Ed2DisplayLV.Text := FormatFloat('#0.000000', Item.RData);
end;
//   -   
procedure TForm1.DDisplay2OnAlertItem (Sender : TObject;
     X, Y : integer; Item : TQItem);
begin
  //    (440 hz)   
  //  :  (hz),  (ms)
  if CBox2Alert.Checked then Windows.Beep(440,10);
end;

//   
procedure TForm1.STxt2BeamColorClick(Sender: TObject);
begin
  SetDDisplayColor(DDisplay2, ColorDialog1, 1);
  ShowCororIndicators(DDisplay2,
                      STxt2BeamColor, STxt2DisplayColor, STxt2GridColor);
end;
//   
procedure TForm1.STxt2DisplayColorClick(Sender: TObject);
begin
  SetDDisplayColor(DDisplay2, ColorDialog1, 2);
  ShowCororIndicators(DDisplay1,
                      STxt2BeamColor, STxt2DisplayColor, STxt2GridColor);
end;
//    
procedure TForm1.STxt2GridColorClick(Sender: TObject);
begin
  SetDDisplayColor(DDisplay2, ColorDialog1, 3);
  ShowCororIndicators(DDisplay1,
                      STxt2BeamColor, STxt2DisplayColor, STxt2GridColor);
end;
//  /    
procedure TForm1.CBox2EnCaptClick(Sender: TObject);
begin
  if Assigned(DDisplay2)then DDisplay2.EnCapt := CBox2EnCapt.Checked;
end;
//  /       TEdit
procedure TForm1.CBox2EnCurrYClick(Sender: TObject);
begin
  OnOffDDisplayItemDraw (DDisplay2, CBox2EnCurrY.Checked, DDisplay2OnItemDraw);
end;
//   Alert   
procedure TForm1.CBox2AlertClick(Sender: TObject);
begin
  if Assigned(DDisplay2)
  then begin
    if CBox2Alert.Checked
    then DDisplay2.MdAlert := Abs(Signal)
    else DDisplay2.MdAlert := -1;
  end;
end;
//   (   )
procedure TForm1.CbBox2SensClick(Sender: TObject);
begin
  if Assigned(DDisplay2)
  then begin
     case CbBox2Sens.ItemIndex of
     0 : DDisplay2.Sens := 1;
     1 : DDisplay2.Sens := 5;
     2 : DDisplay2.Sens := 10;
     3 : DDisplay2.Sens := 50;
     end;
  end;
end;
// ===========================================================
//   
// ===========================================================
//  1 (     )
procedure TForm1.AddPointToOscillograph1(RqOutDAC : double);
var Y : double;
begin
   Y := 0;
   if Assigned(DDisplay1)
   then begin
     //  
     case CbBoxInDisplay1.ItemIndex of
     0: if PMod then Y := 1 else Y := 0;       //  (P)
     1: Y := Balans;                           //  Balans
     2: Y := PNum;                             //  PNum
     3: Y := NNum;                             //  NNum
     4: Y := PNum -NNum;                       //  PNum - NNum
     5: Y := RqOutDAC;                         // . 
     end;
     //      
     AddPointToDDisplay(DDisplay1, CbBoxDisplay1Style.ItemIndex, Y);
   end;
end;
//  2 (     )
procedure TForm1.AddPointToOscillograph2(RqOutDAC : double);
begin
  //        
  AddPointToDDisplay(DDisplay2, CbBoxDisplay2Style.ItemIndex, RqOutDAC);
end;

// ===========================================================
//  
// ===========================================================
//  
procedure TForm1.CBoxTempClick(Sender: TObject);
begin
   case CBoxTemp.ItemIndex of
   0 : Timer1.Interval := 500;
   1 : Timer1.Interval := 400;
   2 : Timer1.Interval := 300;
   3 : Timer1.Interval := 200;
   4 : Timer1.Interval := 100;
   5 : Timer1.Interval := 50;
   6 : Timer1.Interval := 20;
   end;
end;
//  
procedure TForm1.SBttStartClick(Sender: TObject);
begin
   if Assigned(DDisplay1)
   then begin
       RunFlag := True;   //  
   end;
end;
//  
procedure TForm1.SBttStopClick(Sender: TObject);
begin
   RunFlag := False;     //  
end;
//    
procedure TForm1.BttResetAllClick(Sender: TObject);
begin
   SBttStop.Down := True;
   SBttStart.Down := False;
   RunFlag := False;
   ClearDacAdc();
   if Assigned(DDisplay1) then DDisplay1.DisplayClear;
   if Assigned(DDisplay2) then DDisplay2.DisplayClear;
end;

// ===========================================================
//   SD- (), SD-
// ===========================================================
//  SD-  SD-
procedure TForm1.ClearDacAdc();
var Ind : integer;
begin
   // ----------------------------
   //  SD-  SD-
   PMod    := False;
   Balans  := 0;                 //    
   PNum    := 0;                 //     
   NNum    := 0;                 //     
   //  
   STxtBalans.Caption := '';
   STxtNumP.Caption   := '';
   StxtNumN.Caption   := '';
   StxtImpP.Color := clBtnFace;
   // ----------------------------
   //  SD-
   SDLpfOut := 0;       //  SIGMA-DELTA 
   OutDAC   := 0;
   // ----------------------------
   //   
   // ----------------------------
   LPF2Out  := 0;       //   
   FormPFilter.ClearFilter();
   // ----------------------------
   LPF3Buf  := 0;       //   
   LPF3Out  := 0;       //   
   // ----------------------------
   //  
   StxtPsubN.Caption := '';
   StxtNumSteps.Caption := '';
   StxtOutSDLPF.Caption := '';
   STxtOutDAC.Caption := '';

   // ----------------------------
   //  1 (     )
   AddPointToOscillograph1(OutDAC);
   //  2 (     )
   AddPointToOscillograph2(OutDAC);
end;

// -----------------------------------------------------------
//   SD- ()
// (--)
procedure SDMOD();
begin
   if Balans > 0
   then begin
      //    
      //     
      Balans := Balans - (Mera + Signal);
      NNum := NNum + 1;
      PMod := False;
   end
   else begin
     //    
     //     
     Balans  := Balans + Mera - Signal;
     PNum := PNum + 1;
     PMod := True;
   end;
end;
//   SD-
// ( )
function SDDAC () : double;
begin
   // -----------------------------------------
   // SIGMA-DELTA   ()
   if PNum + NNum > 0
   then Result := Mera * (PNum - NNum) /( PNum + NNum)
   else Result := 0;
   // -----------------------------------------
   //    
   // -----------------------------------------
   //  
   if PMod
   then LPF2Out := FormPFilter.RunFilter(Mera)
   else LPF2Out := FormPFilter.RunFilter(-Mera);

   // -----------------------------------------
   //  
   if PNum + NNum > 0
   then begin
      if PMod
      then LPF3Buf := LPF3Buf + Mera
      else LPF3Buf := LPF3Buf - Mera;
      LPF3Out := LPF3Buf / (PNum + NNum);
   end;
end;

// ===========================================================
//   SD-  SD-
// ===========================================================
//  SD-  SD-
procedure TForm1.BttResetClick(Sender: TObject);
begin
  ClearDacAdc();
end;
//     SD-  SD-
procedure TForm1.EdMeraChange(Sender: TObject);
var SMera : double;
begin
  SMera := Mera;
  if EditTextToFloat(Mera, EdMera)
  then begin
      if Mera > 0
      then begin
          if (Mera > Signal)
          then begin
            //  !
            ClearDacAdc();
            if Assigned(DDisplay1) then DDisplay1.MdAlert := Abs(2*Mera);
          end
          else begin
            ShowMessage ('     ');
            Mera := SMera;
            ClearDacAdc();
            EdMera.Text := FloatToStr(Mera);
          end;
      end
      else begin
         ShowMessage ('      ');
         Mera := SMera;
         ClearDacAdc();
         EdMera.Text := FloatToStr(Mera);
      end;
   end;
end;
//     SD-
procedure TForm1.EdSignalChange(Sender: TObject);
var SSignal : double;
begin
   SSignal := Signal;
   if EditTextToFloat(Signal, EdSignal)
   then begin
      if (Signal >=0) and (Mera >Signal)
      then begin
        //  !
        ClearDacAdc();
        if Assigned(DDisplay2) then DDisplay2.MdAlert := Abs(Signal);
      end
      else begin
        ShowMessage ('      ');
        Signal := SSignal;
        ClearDacAdc();
        EdSignal.Text := FloatToStr(Signal);
      end;
   end;
end;
//    SD- (SD-)
procedure TForm1.CbBoxLPFClick(Sender: TObject);
begin
   RqLPF   := CbBoxLPF.ItemIndex;
   if RqLPF = 1
   then BitBtnParmFltR.Visible := True
   else BitBtnParmFltR.Visible := False;
end;
//     
procedure TForm1.BitBtnParmFltRClick(Sender: TObject);
begin
   FormPFilter.Show;
end;
//     
procedure TForm1.CBoxMaxStepClick(Sender: TObject);
begin
   case CBoxMaxStep.ItemIndex of
   0 : MaxStep := -1;       //   
   1 : MaxStep := 0;        //     
   2 : MaxStep := 1;        //  
   3 : MaxStep := 10;
   4 : MaxStep := 20;
   5 : MaxStep := 40;
   6 : MaxStep := 80;
   7 : MaxStep := 100;
   8 : MaxStep := 200;
   9 : MaxStep := 400;
  10 : MaxStep := 800;
  11 : MaxStep := 1000;
  12 : MaxStep := 2000;
  13 : MaxStep := 4000;
  14 : MaxStep := 8000;
  15 : MaxStep := 10000;
   end;
end;

// ===========================================================
//     
// ===========================================================
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if RunFlag
  then begin
     // -----------------------------------------
     if Balans > 0
     then StxtImpP.Color := clBtnFace
     else StxtImpP.Color := clLime;
     //    SD- ()
     SDMOD();           //    SD-
     //     
     STxtBalans.Caption := FormatFloat('#0.000000000000',Balans);
     STxtNumP.Caption   := FloatToStr(PNum);
     StxtNumN.Caption   := FloatToStr(NNum);
     // -----------------------------------------
     //    SD-
     SDLpfOut := SDDAC();          // . 
     StxtPsubN.Caption := FloatToStr(PNum - NNum);
     StxtNumSteps.Caption  := FloatToStr(PNum + NNum);
     //  SIGMA-DELTA 
     StxtOutSDLPF.Caption := FormatFloat('#0.00000',SDLpfOut);
     //  
     case CbBoxLPF.ItemIndex of
     0 : OutDAC := SDLpfOut; // SD-
     1 : OutDAC := LPF2Out;  //  
     2 : OutDAC := LPF3Out;  //  
     end;
     STxtOutDAC.Caption := FormatFloat('#0.00000',OutDAC);
     // -----------------------------------------
     //  1 (     )
     AddPointToOscillograph1(OutDAC);
     //  2 (     )
     AddPointToOscillograph2(OutDAC);
     // -----------------------------------------
     //  
     if (MaxStep = 0) and (PNum + NNum > 0) and (Abs(Balans) < SBalansMin)
     then begin
        //     (Balans = 0)
        SBttStop.Down := True;
        SBttStart.Down := False;
        RunFlag := False;
     end
     else begin
       // -----------------------------------------
       //     
       if (MaxStep > 0) and (MaxStep <= PNum + NNum)
       then begin
          //  
          SBttStop.Down := True;
          SBttStart.Down := False;
          RunFlag := False;
       end;
     end;

     // -----------------------------------------
  end;
end;
// ===========================================================
// ===========================================================
end.
