unit DDisplayQE;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

//     
type TQItem = class(TObject)
 private
   fPNext  : pointer;  //    
   fIData  : integer;  //   
   fRData  : double;   //   
   // 
   procedure SetPNext(RqPNext : pointer);
   procedure SetIData(RqIData  : integer);
   procedure SetRData(RqRData  : double);
 public
   // 
   property PNext : pointer read fPNext write SetPNext;
   property IData : integer read fIData write SetIData;
   property RData : double  read fRData write SetRData;
end;

//       
type TIQueue = class(TQItem)
 protected
   fMaxCount : integer;     //   
   fPHead    : TQItem;      //    
   fPTail    : TQItem;      //    
   fICount   : integer;     //    
   fPBuf     : TQItem;      //    
   fDisplay  : TComponent;  //    
 private
   procedure SetMaxCount(aMaxCount : integer);
   procedure DeleteItemFromHead();
 protected
   property MaxCount : integer read fMaxCount write SetMaxCount;
 public
   constructor Create(RqDisplay : TComponent);
   procedure Free();
   //   
   procedure ClearQueue();
   //      
   procedure AddItemToTail(RqIData : integer; RqRData : double);
   procedure ShowItemQueue(); virtual; abstract;
end;

implementation

// -----------------------------------------------------------------------
//   TQItem
// -----------------------------------------------------------------------
procedure TQItem.SetPNext(RqPNext : pointer);
begin fPNext := RqPNext; end;

procedure TQItem.SetIData(RqIData : integer);
begin fIData := RqIData; end;

procedure TQItem.SetRData(RqRData : double);
begin fRData := RqRData; end;

// -----------------------------------------------------------------------
//     TIQueue
// -----------------------------------------------------------------------
//   
procedure TIQueue.ClearQueue();
begin
  //    
  if (fICount > 0) and Assigned(fPHead) and Assigned(fPTail)
  then begin
     repeat
       fPBuf := fPHead;          //    
       fPHead := fPHead.PNext;   //   
       fPBuf.Free;               //  
     until not Assigned(fPHead);
     fICount := 0;               //    
     fPHead := nil;              //    
     fPTail := nil;              //    
  end;
end;

//   MaxCount
procedure TIQueue.SetMaxCount(aMaxCount : integer);
begin
  if aMaxCount < fICount
  then begin
     ClearQueue();              //   
     fMaxCount := aMaxCount;    //     
  end
  else fMaxCount := aMaxCount;  //     
  ShowItemQueue();              //     
end;

// 
constructor TIQueue.Create (RqDisplay : TComponent);
begin
   inherited Create;
   fMaxCount := 30;             //     
   fDisplay := RqDisplay;       //   
end;

// 
procedure TIQueue.Free();
begin
  ClearQueue();    //   
  inherited Free;  //   
end;

//         
procedure TIQueue.DeleteItemFromHead();
begin
 if (fICount > 0) and Assigned(fPHead)
 then begin
 //   
   fPBuf  := fPHead;               //     
   fPHead := fPBuf.PNext;          //     
   fPBuf.Free;                     //  
   fICount := fICount - 1;         //    
   if not Assigned(fPHead)
   then begin
      //     
      fICount := 0;               //    
      fPHead := nil;              //    
      fPTail := nil;              //    
   end;
 end;
end;

//      
procedure TIQueue.AddItemToTail(RqIData : integer; RqRData : double);
begin
   if Assigned(fPTail)             //    
   then begin
      //    (   )
      fPBuf  := fPTail;            //     
      fPTail := TQItem.Create;     //    
      fPBuf.PNext := fPTail;       //     
      fICount := fICount + 1;      //   
   end
   else begin
      //   (    )
      fPTail := TQItem.Create;     //    
      fPTail.PNext := nil;         //    
      fPHead  := fPTail;           //    
      fICount := 1;                //    
   end;
   fPTail.IData  := RqIData;       //    
   fPTail.fRData := RqRData;
   //          
   if (fICount > MaxCount)
   then DeleteItemFromHead();
end;


end.
