unit DDisplayGUI;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,
  DDisplayQE;

//    
const CtrlTextStr = '#0.000'; //     

type TIQNotify = procedure
                (Sender : TObject; X,Y : integer; Item : TQItem) of object;
type TDDisplay = class(TIQueue)
 private
   // ---------------------------------------
   // 
   fDDisplay   : TImage;     //     
   //  
   fDColor     : TColor;     // Display color.   
   fBColor     : TColor;     // Beam color.     
   fGColor     : TColor;     // Grid color.      
   fAColor     : Tcolor;     // Axes color.      
   //  
   fEnHGrid    : boolean;    //    
   fEnVGrid    : boolean;    //    
   fEnCapt     : boolean;    //     
   //  
   fZeroTop    : integer;    // Top -    ( X)
   fGNumX      : integer;    //    
   fGNumH      : integer;    //       X
   fSens       : integer;    //  (   )
   fScaleY     : double;     //   
   //  
   fMdAlert    : double;     //   
   //  
   fOnDrawItem  : TIQNotify;  //   -  
   fOnAlertItem : TIQNotify;  //   -   
   // 
   fXStep      : integer;    //       
   fCount      : integer;    //   
   // ---------------------------------------
   //   
   //        
   procedure ClearDisplay(RqFillColor, RqRenColor : TColor);
   //   
   procedure DrawGridLine();
   //      (  )
   procedure DrawZeroLine();
   //    Item    Image.Top
   function  ValueToTop(Item : TQItem) : integer;
   //        
   procedure DrawCurrentCaption(Item : TQItem);
   //     (  )
   procedure DrawCurrentLine(Item : TQItem);
   //         
   procedure DrawGoToNextLine(Item : TQItem);
   // ---------------------------------------
   //    
   //      ( )
   procedure SetDMaxCountProp (RqDMaxCount : integer);
   // ---------------------------------------
   //    
   //    boolean
   procedure SetBooleanProp(RqInd : integer; RqProp : boolean);
   //    boolean
   function GetBooleanProp(RqInd : integer) : boolean;
   // ---------------------------------------
   //    
   //    -   
   procedure RunOnDrawItem(X,Y : integer; Item : TQItem);
   //    -   
   procedure RunOnAlertItem(X,Y : integer; Item : TQItem);
   // ---------------------------------------
 public
   constructor Create (RqDisplay : TComponent);
   //        
   // (  )
   procedure ShowItemQueue(); override;
   //        
   // (  )
   procedure AnalogShowItemQueue(); virtual;
   //  
   procedure DisplayClear();
   // ---------------------------------------
   //  
   property DMaxCount : integer read fMaxCount write SetDMaxCountProp;
   //    
   property GColor : TColor read fGColor write fGColor;
   //   
   property BColor : TColor read fBColor write fBColor;
   //   
   property DColor : TColor read fDColor write fDColor;
   //  (   )
   property Sens : integer read fSens write fSens;
   //   
   property MdAlert : double read fMdAlert write fMdAlert;
   // ---------------------------------------
   //  
   //    
   property EnHGrid : boolean index 1 read GetBooleanProp write SetBooleanProp;
   //    
   property EnVGrid : boolean index 2 read GetBooleanProp write SetBooleanProp;
   //     
   property EnCapt : boolean  index 3 read GetBooleanProp write SetBooleanProp;
   // ---------------------------------------
   //     
   //   -  
   property OnDrawItem : TIQNotify read fOnDrawItem write fOnDrawItem;
   //   -   
   property OnAlertItem : TIQNotify read fOnAlertItem write fOnAlertItem;
   // ---------------------------------------
end;

implementation

// -----------------------------------------------------------------------
//     TDDisplay
// -----------------------------------------------------------------------
// 
constructor TDDisplay.Create (RqDisplay : TComponent);
begin
  if (RqDisplay is TImage)
  then begin
     inherited Create(RqDisplay);  //     TIQueue
     // 
     fDDisplay := (RqDisplay as TImage);
     //  
     fDColor   := clBackground;    // Display color.   
     fBColor   := clLime;          // Beam color.     
     fGColor   := clBtnShadow;     // Grid color.      
     fAColor   := clBtnHighlight;  // Axes color.      
     //  
     fEnHGrid  := True;            //    
     fEnVGrid  := True;            //    
     fEnCapt   := True;            //   
     //  
     fGNumX  := MaxCount;          //      
     fGNumH  := 5;                 //       X
     fSens   := 10;                //  (   )
     //  
     fMdAlert := -1;               //    ()
  end;
end;

// -----------------------------------------------------------------------
//   
// -----------------------------------------------------------------------
//    boolean
procedure TDDisplay.SetBooleanProp(RqInd : integer; RqProp : boolean);
begin
  case RqInd of
  1 : fEnHGrid  := RqProp;    //    
  2 : fEnVGrid  := RqProp;    //    
  3 : fEnCapt   := RqProp;    //   
  end;
end;
//    boolean
function TDDisplay.GetBooleanProp(RqInd : integer) : boolean;
begin
  Result := False;
  case RqInd of
  1 : Result := fEnHGrid;    //    
  2 : Result := fEnVGrid;    //    
  3 : Result := fEnCapt;     //   
  end;
end;

//      ( )
procedure TDDisplay.SetDMaxCountProp (RqDMaxCount : integer);
begin
   if RqDMaxCount > 2
   then begin
     MaxCount := RqDMaxCount;         //  
     fGNumX   := MaxCount;            //      
     ClearDisplay(fDColor, fBColor);  //  
   end;
end;

// -----------------------------------------------------------------------
//     
// -----------------------------------------------------------------------
//    -   
procedure TDDisplay.RunOnDrawItem(X,Y : integer; Item : TQItem);
begin
  if Assigned(fOnDrawItem)
  then begin
    fOnDrawItem(Self, X, Y, Item);
  end;
end;
// -----------------------------------------------------------------------
//    -   
procedure TDDisplay.RunOnAlertItem(X,Y : integer; Item : TQItem);
begin
  if Assigned(fOnAlertItem)
  then begin
    fOnAlertItem(Self, X, Y, Item);
  end;
end;

// -----------------------------------------------------------------------
//  
// -----------------------------------------------------------------------
//    Item    Image.Top
function TDDisplay.ValueToTop(Item : TQItem) : integer;
begin
  Result := fZeroTop;  // Top -    ( X)
  if Assigned(Item)
  then begin
    Result := fZeroTop - Trunc(fScaleY * Item.RData);
  end;
end;
// -----------------------------------------------------------------------
//        
procedure TDDisplay.ClearDisplay(RqFillColor, RqRenColor : TColor);
begin
  if (fDisplay is TImage)
  then begin
     with fDDisplay do
     begin
        // Top -    
        fZeroTop := Height div 2;
        //   
        fScaleY  := fZeroTop / (fSens * fGNumH);
        //     
        Canvas.Font.Size := 7;
        fXStep := (Width - Canvas.TextWidth(CtrlTextStr)) div fGNumX;
        fCount := 0;
        //    
        Canvas.Brush.Style := bsSolid;
        Canvas.Brush.Color := RqFillColor;
        //   
        Canvas.FillRect(Rect(0, 0, Width, Height));
        //     
        DrawGridLine();
        //   
        DrawZeroLine();
        //     
        Canvas.Pen.Color := RqRenColor;
     end;
  end;
end;
// -----------------------------------------------------------------------
//  
procedure TDDisplay.DisplayClear();
begin
  ClearQueue;
  ClearDisplay(fDColor, fBColor);
end;
// -----------------------------------------------------------------------
//   
procedure TDDisplay.DrawGridLine();
var Step, Count : integer;
begin
  with fDDisplay do
  begin
    //    
    if fEnHGrid
    then begin
       Step := fZeroTop div fGNumH;
       Canvas.Pen.Color := fGColor;
       for Count := 0 to fGNumH do
       begin
          //      
          Canvas.MoveTo ( 0,     fZeroTop - Count * Step);
          Canvas.LineTo ( Width, fZeroTop - Count * Step);
          //      
          Canvas.MoveTo ( 0,     fZeroTop + Count * Step);
          Canvas.LineTo ( Width, fZeroTop + Count * Step);
       end;
    end;
    //    
    if fEnVGrid
    then begin
       Canvas.Pen.Color := fGColor;
       for Count := 0 to fGNumX do
       begin
         Canvas.MoveTo ( Count * fXStep, 0);
         Canvas.LineTo ( Count * fXStep, Height);
       end;
    end;
  end; // of with fDDisplay
end;
// -----------------------------------------------------------------------
//      (  )
procedure TDDisplay.DrawZeroLine();
var Count : integer;
begin
  with fDDisplay do
  begin
    //   
    Canvas.Pen.Color := fAColor;
    Canvas.MoveTo(0, fZeroTop);
    Canvas.LineTo(Width, fZeroTop);
    //     
    //Step := Width div fGNumX;
    for Count := 0 to fGNumX do
    begin
      Canvas.MoveTo ( Count * fXStep, fZeroTop - 3);
      Canvas.LineTo ( Count * fXStep, fZeroTop + 3);
    end;
  end;
end;
// -----------------------------------------------------------------------
//        
procedure TDDisplay.DrawCurrentCaption(Item : TQItem);
begin
  with fDDisplay do
  begin
     //     
     if (fMdAlert > 0) and (fMdAlert < Abs(Item.RData))
     then Canvas.Font.Color := RGB(255,0,0)     //   
     else Canvas.Font.Color := fBColor;
     //    
     if fEnCapt
     then begin
        Canvas.TextOut ( fCount * fXStep + 1,
              ValueToTop(Item) - Canvas.TextHeight('Y'),
              FormatFloat('#0.', Item.RData) );
     end;
  end;
end;
// -----------------------------------------------------------------------
//    
procedure TDDisplay.DrawCurrentLine(Item : TQItem);
begin
  with fDDisplay do
  begin
    DrawCurrentCaption(Item);
    // fCount * fXStep     
    // fZeroTop  Y  
    // fZeroTop - RqValue     Y
    Canvas.MoveTo(fCount * fXStep, ValueToTop(Item));
    fCount := fCount + 1;
    Canvas.LineTo(fCount * fXStep, ValueToTop(Item));
    //    
    RunOnDrawItem(fCount * fXStep, ValueToTop(Item), Item);
  end;
end;
// -----------------------------------------------------------------------
//         
procedure TDDisplay.DrawGoToNextLine(Item : TQItem);
begin
  with fDDisplay do
  begin
    Canvas.LineTo(fCount * fXStep, ValueToTop(Item));
  end;
end;
// -----------------------------------------------------------------------
//        
procedure TDDisplay.ShowItemQueue();
begin
    with fDDisplay do
    begin
      //  
      ClearDisplay(fDColor, fBColor);
      //  
      if (fICount > 0) and Assigned(fPHead) and Assigned(fPTail)
      then begin
         fPBuf := fPHead;
         repeat
            //    
            DrawCurrentLine(fPBuf);
            //     
            fPBuf := fPBuf.PNext;
            if Assigned(fPBuf)
            then begin
              //      
              DrawGoToNextLine(fPBuf);
            end;
         //      
         until not Assigned(fPBuf);
         //      
         fPBuf := fPTail;
         if (fMdAlert > 0) and (fMdAlert < Abs(fPBuf.RData))
         then begin
             //     -   
             RunOnAlertItem((fGNumX -1) * fXStep,
                           ValueToTop(fPBuf), fPBuf);
             //     
             Canvas.Font.Color := RGB(255,0,0);
         end
         else Canvas.Font.Color := fBColor;
         Canvas.TextOut ( fCount * fXStep,
                          ValueToTop(fPBuf) - Canvas.TextHeight('Y') - 4,
                          FormatFloat(CtrlTextStr, fPBuf.RData));
      end;
    end;
end;
// -----------------------------------------------------------------------
//        
procedure TDDisplay.AnalogShowItemQueue();
begin
    with fDDisplay do
    begin
       //  
       ClearDisplay(fDColor, fBColor);
       //  
       if (fICount > 0) and Assigned(fPHead) and Assigned(fPTail)
       then begin
          fPBuf := fPHead;
          // fCount * fXStep     
          Canvas.MoveTo(fCount * fXStep, ValueToTop(fPBuf));
          fCount := fCount + 1;
          Canvas.LineTo(fCount * fXStep, ValueToTop(fPBuf));
          repeat
              fPBuf := fPBuf.PNext;
              if Assigned(fPBuf)
              then begin
                  fCount := fCount + 1;
                  Canvas.LineTo(fCount * fXStep, ValueToTop(fPBuf));
                  //    
                  RunOnDrawItem(fCount * fXStep, ValueToTop(fPBuf), fPBuf);
              end;
          //      
          until not Assigned(fPBuf);
          //    
          if fEnCapt
          then begin
             //      
             fPBuf := fPTail;
             if (fMdAlert > 0) and (fMdAlert < Abs(fPBuf.RData))
             then begin
                //     -   
                RunOnAlertItem((fGNumX -1) * fXStep,
                                ValueToTop(fPBuf), fPBuf);
                 //     
                 Canvas.Font.Color := RGB(255,0,0);
             end
             else Canvas.Font.Color := fBColor;
             Canvas.TextOut ( fCount * fXStep,
                              ValueToTop(fPBuf) - Canvas.TextHeight('Y') - 4,
                              FormatFloat(CtrlTextStr, fPBuf.RData));
          end;
       end;
    end;
end;

// -----------------------------------------------------------------------
end.

