unit DnGridEd03;
(*
          StringGrid    

         
      .   
  ,       
   TDnGridEd.

      TDnGridEd   
        
  .

         1.00. ()  , , , , 2018.
                     () Source code  ..
          22.04.2018
*)
interface

uses Windows, Messages, Classes, Controls, Forms, SysUtils, Graphics,
     Dialogs, StdCtrls, ExtCtrls, Grids, Menus;
     
// =================================================================
//  
const FrmGridVer = 'v.1.00';

//         Grid
//         Grid
type TD1StrArr = array of string;

// =================================================================
type TDnGridEd = class(TObject)
private
   // -----------------------------
   fDFRM        : TForm;           //  
   // -----------------------------
   fPanel       : TPanel;          //    
   fGrid        : TStringGrid;     // StringGrid  
   fLbID        : TLabel;          //  ID:
   fStID        : TStaticText;     //  ID
   // -----------------------------
   //     ""   
   procedure FormClose(Sender: TObject; var Action: TCloseAction);
   //     Show
   procedure FormShow(Sender: TObject);
   //     Hide
   procedure FormHide(Sender: TObject);
   //   biSystemMenu : biMaximize
   procedure FormActivate(Sender: TObject);
   //   biSystemMenu : biMinimize
   procedure FormDeactivate(Sender: TObject);
   // -----------------------------
   //    
   procedure CreateDynComponents();
   //    
   procedure FreeDynComponents();
   // -----------------------------
   //    
   procedure SetDefaultGrid();
   // =============================
   //   property
   // =============================
   //  ID  
   procedure SetGridTitle(RqTitle : string);
   //  ID  
   function GetGridTitle() : string;
   // -----------------------------
   //      
   procedure SetRowMaxInd(RqMaxInd : integer);
   //       
   function  GetRowMaxInd() : integer;
   //      
   function  GetRowMinInd() : integer;
   // -----------------------------
   //      
   procedure SetColMaxInd(RqMaxInd : integer);
   //      
   function  GetColMaxInd() : integer;
   //      
   function  GetColMinInd() : integer;
   // -----------------------------
   //   
   procedure SetRowTitle(RqInd : integer; RqTitle : string);
   //   
   function GetRowTitle(RqInd  : integer) : string;
   // -----------------------------
   //   
   procedure SetColTitle(RqInd : integer; RqTitle : string);
   //   
   function GetColTitle(RqInd : integer) : string;
   // -----------------------------
   //     
   procedure SetCells(RqColInd, RqRowInd : integer; RqValue : string);
   //     
   function GetCells(RqColInd, RqRowInd : integer) : string;

public
   // =============================
   //     
   constructor Create(RqFrmW, RqFrmH : integer; RqSysMenu : boolean);
   procedure   Free;
   // =============================
   //   
   procedure GridClear();
   // -----------------------------
   //   
   procedure LoadColTitle (RqStrArr : TD1StrArr);
   //   
   procedure LoadRowTitle (RqStrArr : TD1StrArr);
   // =============================
   // ID  
   property GridTitle : string read GetGridTitle write SetGridTitle;
   // -----------------------------
   //     
   property RowMaxInd : integer read GetRowMaxInd write SetRowMaxInd;
   //     
   property RowMinInd : integer read GetRowMinInd;
   // -----------------------------
   //     
   property ColMaxInd : integer read GetColMaxInd write SetColMaxInd;
   //      
   property ColMinInd : integer read GetColMinInd;
   // -----------------------------
   //     
   property RowTitle[RqInd : integer] : string
                     read GetRowTitle  write SetRowTitle;
   //     
   property ColTitle[RqInd : integer] : string
                     read GetColTitle  write SetColTitle;
   // -----------------------------
   //    
   property CellsStr [RqColInd, RqRowInd : integer] : string
                      read  GetCells  write SetCells;

end;

// =================================================================
implementation
// =================================================================
// -----------------------------------------------------------------

const DFRM_MinW = 200;             // .   
      DFRM_MinH = 200;             // .   
      Panel_H   = 30;              //   -  
// -----------------------------------------------------------------
//      
constructor TDnGridEd.Create(RqFrmW, RqFrmH : integer; RqSysMenu : boolean);
begin
   inherited Create;
   // -----------------------------------
   //    
   fDFRM := TForm.Create(nil);
   with fDFRM do
   begin
      if RqSysMenu
      then BorderIcons := [biSystemMenu,biMinimize,biMaximize]
      else BorderIcons := [];
      // -------------------
      onClose   := FormClose;
      onShow    := FormShow;
      onHide    := FormHide;
      onActivate := FormActivate;
      onDeactivate := FormDeActivate;
      // -------------------
      Caption   := ' GRID- ' + FrmGridVer;
      Position  := poDesktopCenter;
      FormStyle :=  fsStayOnTop;
      AutoSize  := False;
      if RqFrmW < DFRM_MinW
      then  ClientWidth := DFRM_MinW
      else  ClientWidth := RqFrmW;
      if RqFrmH < DFRM_MinH
      then  ClientHeight := DFRM_MinH
      else  ClientHeight := RqFrmH;
   end;
   // -----------------------------------
   //    
   CreateDynComponents();
   // -----------------------------------
   fDFRM.Show;
   // -----------------------------------
end;
// -----------------------------------------------------------------
//       
procedure TDnGridEd.FormClose(Sender: TObject; var Action: TCloseAction);
// TCloseAction = (caNone, caHide, caFree, caMinimize);
begin
   Action := caMinimize;
(*
   Action := caNone;
   MessageDlg ('   '
   +  #13#10 + ' ,   .',
   mtInformation, [mbOk], 0);
*)
end;
//     Show
procedure TDnGridEd.FormShow(Sender: TObject);
begin
//
end;
//     Hide
procedure TDnGridEd.FormHide(Sender: TObject);
begin
//
end;
//   biSystemMenu :biMaximize
procedure TDnGridEd.FormActivate(Sender: TObject);
begin
  //  
  fDFRM.FormStyle := fsStayOnTop;
end;
//   biSystemMenu : biMinimize
procedure TDnGridEd.FormDeactivate(Sender: TObject);
begin
//
end;

// -----------------------------------------------------------------
//      
procedure  TDnGridEd.Free;
begin
   // -----------------------------------
   //    
   FreeDynComponents();
   // -----------------------------------
   //   
   if Assigned(fDFRM) then fDFRM.Free;
   inherited Free();
end;
// =================================================================
//    
// =================================================================
// -----------------------------------------------------------------
// lass-reference.  ,    ,
//     TComponent

type TControlClass = class of TControl;

// -----------------------------------------------------------------
//   ,   TControl.
//  CreateControl    class ()
// ,      RqParent
// (,  Form1, Panel1  ..)

function CreateControl(ControlClass   : TControlClass;
                       RqParent       : TWinControl;
                 const ComponentName  : string;
                       X, Y, W, H     : Integer): TControl;
begin
    Result := ControlClass.Create(RqParent);
    with Result do
    begin
      Parent := RqParent;                  //    
      Name := ComponentName;               //   
      SetBounds(X, Y, W, H);               //   TWinControl
      Visible := True;                     //   
    end;
end;
// =================================================================
//     
// =================================================================
// -----------------------------------------------------------------
//    
procedure TDnGridEd.CreateDynComponents();
begin
   // -----------------------------------
   //    
   fPanel := TPanel(CreateControl(TPanel, fDFRM, '',
                    0, 0, fDFRM.ClientWidth, Panel_H));
   fPanel.Align := alTop;
   // -----------------------------------
   //  TStringGrid
   fGrid  := TStringGrid(CreateControl(TStringGrid, fDFRM, '',
                         0, Panel_H,
                         fDFRM.ClientWidth, fDFRM.ClientHeight - Panel_H));
   fGrid.Align := alClient;
   SetDefaultGrid();
   // -----------------------------------
   fLbID := TLabel(CreateControl(TLabel, fPanel, '', 10, 6, 30, 20));
   fLbID.Caption := 'ID:';
   // -----------------------------------
   fStID := TStaticText(CreateControl(TStaticText, fPanel, '', 30, 4, 150, 20));
   fStID.AutoSize    := False;
   fStID.BorderStyle := sbsSunken;
end;
// -----------------------------------------------------------------
//    
procedure TDnGridEd.FreeDynComponents();
begin
   if Assigned(fStID)  then fStID.Free;
   if Assigned(fLbID)  then fLbID.Free;
   if Assigned(fGrid)  then fGrid.Free;
   if Assigned(fPanel) then fPanel.Free;
end;
// -----------------------------------------------------------------
//    
procedure TDnGridEd.SetDefaultGrid();
const Scr_W    = 24;  //   
      Row_H    = 16;  //  
      RC_Count = 1;   //      
      Row_Title = '';
      Col_Title = '';
begin
   with fGrid do
   begin
       FixedRows := 1;
       FixedCols := 1;
       ColCount  := FixedCols + RC_Count;
       RowCount  := FixedRows + RC_Count;
       DefaultColWidth  := ((fDFRM.ClientWidth - Scr_W) div 2);
       DefaultRowHeight := Row_H;
       Cells[0, 0] := Row_Title;
       Cells[1, 0] := Col_Title;
       Options := [goFixedVertLine,goFixedHorzLine,
                   goVertLine,goHorzLine,goColSizing,goEditing];
   end;
   GridClear();  //   
end;

// =================================================================
//  
// =================================================================
// -----------------------------------------------------------------
//   
procedure TDnGridEd.GridClear();
var wCol, wRow : integer;
begin
  with fGrid do
  begin
  for wRow := FixedRows to RowCount - 1
  do for wCol := FixedCols to ColCount - 1
     do Cells[wCol, wRow] := '';
  end;
end;
// -----------------------------------------------------------------
//   
procedure TDnGridEd.LoadColTitle (RqStrArr : TD1StrArr);
var Ind : integer;
begin
   if Length(RqStrArr) < 2 then Exit;
   if not(fGrid.FixedRows = 1) then Exit;
   if not(fGrid.FixedCols = 1) then Exit;
   fGrid.ColCount := Length(RqStrArr);
   for Ind := Low(RqStrArr) to High(RqStrArr)
   do fGrid.Cells[Ind, 0] := RqStrArr[Ind];
end;
// -----------------------------------------------------------------
//   
procedure TDnGridEd.LoadRowTitle (RqStrArr : TD1StrArr);
var Ind : integer;
begin
   if Length(RqStrArr) < 2 then Exit;
   if not(fGrid.FixedRows = 1) then Exit;
   if not(fGrid.FixedCols = 1) then Exit;
   fGrid.RowCount := Length(RqStrArr) + fGrid.FixedRows;
   for Ind := Low(RqStrArr) to High(RqStrArr)
   do fGrid.Cells[0, Ind + fGrid.FixedRows] := RqStrArr[Ind];
end;
// =================================================================
// -----------------------------------------------------------------
//  ID  
procedure TDnGridEd.SetGridTitle(RqTitle : string);
begin
    fStID.Caption := RqTitle;
end;
//  ID  
function TDnGridEd.GetGridTitle() : string;
begin
   Result := fStID.Caption;
end;
// -----------------------------------------------------------------
//      
procedure TDnGridEd.SetRowMaxInd(RqMaxInd : integer);
begin
   if RqMaxInd < fGrid.FixedRows then Exit;
   fGrid.RowCount := RqMaxInd + fGrid.FixedRows;
end;
//        
function TDnGridEd.GetRowMaxInd() : integer;
begin
   Result := fGrid.RowCount - fGrid.FixedRows;
end;
//       
function  TDnGridEd.GetRowMinInd() : integer;
begin
   Result := fGrid.FixedRows;
end;
// -----------------------------------------------------------------
//      
procedure TDnGridEd.SetColMaxInd(RqMaxInd : integer);
begin
   if RqMaxInd < fGrid.FixedCols then Exit;
   fGrid.ColCount := RqMaxInd + fGrid.FixedCols;
end;
//      
function TDnGridEd.GetColMaxInd() : integer;
begin
   Result := fGrid.ColCount - fGrid.FixedCols;
end;
//      
function  TDnGridEd.GetColMinInd() : integer;
begin
   Result := fGrid.FixedCols;
end;
// -----------------------------------------------------------------
//   
procedure TDnGridEd.SetRowTitle(RqInd : integer; RqTitle : string);
begin
   if not(fGrid.FixedRows = 1) then Exit;
   if not(fGrid.FixedCols = 1) then Exit;
   if (RqInd >= GetRowMinInd()) and
      (RqInd <= GetRowMaxInd())
   then fGrid.Cells[0, RqInd] := RqTitle;
end;
//   
function TDnGridEd.GetRowTitle(RqInd : integer) : string;
begin
   Result := '';
   if not(fGrid.FixedRows = 1) then Exit;
   if not(fGrid.FixedCols = 1) then Exit;
   if (RqInd >= GetRowMinInd()) and
      (RqInd <= GetRowMaxInd())
   then Result := fGrid.Cells[0, RqInd];
end;
// -----------------------------------------------------------------
//   
procedure TDnGridEd.SetColTitle(RqInd : integer; RqTitle : string);
begin
   if not(fGrid.FixedRows = 1) then Exit;
   if not(fGrid.FixedCols = 1) then Exit;
   if (RqInd >= 0) and
      (RqInd <= GetColMaxInd())
   then fGrid.Cells[RqInd,0] := RqTitle;
end;
//   
function TDnGridEd.GetColTitle(RqInd : integer) : string;
begin
   Result := '';
   if not(fGrid.FixedRows = 1) then Exit;
   if not(fGrid.FixedCols = 1) then Exit;
   if (RqInd >= 0) and
      (RqInd <= GetColMaxInd())
   then Result := fGrid.Cells[RqInd, 0];
end;
// -----------------------------------------------------------------
//     
procedure TDnGridEd.SetCells(RqColInd, RqRowInd : integer; RqValue : string);
begin
   if not(fGrid.FixedRows = 1) then Exit;
   if not(fGrid.FixedCols = 1) then Exit;
   if (RqColInd >= GetColMinInd()) and
      (RqColInd <= GetColMaxInd()) and
      (RqRowInd >= GetRowMinInd()) and
      (RqRowInd <= GetRowMaxInd())
   then fGrid.Cells[RqColInd, RqRowInd] :=  RqValue;
end;
//     
function TDnGridEd.GetCells(RqColInd, RqRowInd : integer) : string;
begin
   Result := '';
   if not(fGrid.FixedRows = 1) then Exit;
   if not(fGrid.FixedCols = 1) then Exit;
   if (RqColInd >= GetColMinInd()) and
      (RqColInd <= GetColMaxInd()) and
      (RqRowInd >= GetRowMinInd()) and
      (RqRowInd <= GetRowMaxInd())
   then  Result := fGrid.Cells[RqColInd, RqRowInd];
end;
// =================================================================
// -----------------------------------------------------------------


end.
