unit DnAlarm03;
// ====================================================================
(*
         3.02 ()  , , , 2018.
                     () Source code  ..
          20.07.2018
*)
// ====================================================================

interface

uses Windows, Messages, Classes, Controls, SysUtils, Graphics, Dialogs,
     Forms, StdCtrls, ExtCtrls, Menus;

type TAlarmMode = (alrmNotUse, alrmDam, alrmLimit);

// ====================================================================
//                TAlarm
//
// ====================================================================

type TDnAlarm = class(TObject)
private
   // -----------------------------
   fDFRM        : TForm;        //  
   // -----------------------------
   fPanel       : TPanel;       //  
   fPanelCreate : boolean;      //  :    
   // --------------------------
   fImg         : TImage;       // Image  
   fBMP         : TBitMap;      //  
   fPM          : TPopupMenu;   // PopUpMenu  
   // --------------------------
   fLbT         : TLabel;       // Label  
   fLbV         : TLabel;       // Label  
   // --------------------------
   fTimer       : TTimer;       //     ReSize
   // --------------------------
   fTitle       : string;       //  
   // --------------------------
   //  
   fYMes        : string;       //   
   //  
   // --------------------------
   //  
   fValue       : extended;     //  
   fPrevValue   : extended;     //   
   fZone        : integer;      //   
   fPrevZone    : integer;      //   
   fAddParmIndx : integer;      //   
   // -----------
   fCurrYMax    : extended;     //   
   fP2WallCount : cardinal;     //    P2Wall
   fP1WallCount : cardinal;     //    P1Wall
   fOkCount     : cardinal;     //   
   fN1WallCount : cardinal;     //    N1Wall
   fN2WallCount : cardinal;     //    N2Wall
   fCurrYMin    : extended;     //   
   // --------------------------
   //  
   fFonColor    : TColor;        //   
   fTextColor   : TColor;        //   
   fInfoColor   : TColor;        //   
   fNormalColor : Tcolor;        //    
   fcAlarm1     : TColor;        //   
   fcAlarm2     : TColor;        //   
   // --------------------------
   //     
   fP2Wall      : extended;      //      
   fP1Wall      : extended;      //     
   fN1Wall      : extended;      //     
   fN2Wall      : extended;      //      
   fAlarmMode   : TAlarmMode;    //    
   // -----------------------------
   fLookMarker  : boolean;       //      
   // -----------------------------
   //     ""   
   procedure onDFRMClose(Sender: TObject; var Action: TCloseAction);
   //     Show
   procedure onDFRMShow(Sender: TObject);
   //     Hide
   procedure onDFRMHide(Sender: TObject);
   //   biSystemMenu : biMaximize
   procedure onDFRMActivate(Sender: TObject);
   //   biSystemMenu : biMinimize
   procedure onDFRMDeactivate(Sender: TObject);
   // --------------------------
   //    
   procedure CreateDynComponents();
   // --------------------------
   //  ReSize
   procedure onPanelReSize(Sender: TObject);
   //    ReSize
   procedure onReSizeTimer(Sender: TObject);
   //        
   procedure ReSize();
   // --------------------------
   //     PopupMenu
   procedure  GreateAndConnecPoUpMenu();
   //    PopupMenu
   procedure MenuClick(Sender : TObject);
   // --------------------------
   procedure SetValue (RqValue  : extended);
   //     
   function GetZoneByValue() : integer;
   //      
   procedure SetP2Wall (RqP2Wall  : extended);
   //     
   procedure SetP1Wall (RqP1Wall  : extended);
   //     
   procedure  SetN1Wall(RqN1Wall : extended);
   //      
   procedure  SetN2Wall(RqN2Wall : extended);
   //  
   procedure CounterClear();
   //       
   procedure SetAlarmMode(RqMode : TAlarmMode);
   // --------------------------
   //   
   procedure ShowAddParm();
   // --------------------------
   //    fBMP  fImg
   procedure BmpToImg ();
   //  fBMP
   procedure ImageClear(RqColor : TColor);
   //   -    
   procedure ShowSepLine(RqY : integer; RqColor : TColor);
   //      
   procedure ShowMarker(RqY, RqZone : integer; RqColor : TColor);
   //   
   procedure ShowReportStr(RqY : integer;
                           RqTxt, RqValue : string;
                           RqColor : TColor);
   // --------------------------
   //   
   procedure DamReport();
   // --------------------------
   //      
   procedure PLimitReport();
   //      
   procedure NLimitReport();
   //      
   procedure PNLimitReport();
   // --------------------------
   //     
   procedure WallReport(RqErr : boolean);
   //     fBMP     fImg
   procedure ShowReport();
   // --------------------------
   //  
   procedure ShowTitle();
   // --------------------------
   //  property
   procedure SetTitle(RqTitle : string);

public
   // -----------------------------
   //      
   constructor Create(RqWidth, RqHeight : integer); overload;
   //      
   constructor Create(RqPanel : TPanel); overload;
   //   
   procedure   Free;
   // -----------------------------
   // 
   procedure Clear();
   // -----------------------------
   //  
   property Title      : string    read fTitle     write SetTitle;
   // --------------------------
   //   
   property  YMes      : string    read fYMes      write fYMes;
   //   
   property Value    : extended    read fValue   write SetValue;
   //      
   property P2Wall   : extended    read fP2Wall   write SetP2Wall;
   //     
   property P1Wall   : extended    read fP1Wall   write SetP1Wall;
   //     
   property N1Wall   : extended    read fN1Wall   write SetN1Wall;
   //      
   property N2Wall   : extended    read fN2Wall   write SetN2Wall;
   // --------------------------
   //      
   property AlarmMode : TAlarmMode read fAlarmMode write SetAlarmMode;
   // --------------------------
   //  
   property FonColor    : TColor   read fFonColor  write fFonColor;
   //   
   property TextColor   : TColor   read fTextColor write fTextColor;
   //   
   property InfoColor   : TColor   read fInfoColor write fInfoColor;
   // --------------------------
   //    
   property NormalColor : TColor   read fNormalColor write fNormalColor;
   //    
   property Alarm1Color  : TColor read fcAlarm1   write fcAlarm1;
   //    
   property Alarm2Color  : TColor read fcAlarm2   write fcAlarm2;

end;

// ====================================================================
// ====================================================================
implementation
// ====================================================================
// ====================================================================
const TimeReSizeOut = 400;  //     ReSize


//       TList ( FIFO)
type Data  = extended;
type AData = ^Data;

// ====================================================================
//                TDnAlarm
//            
// ====================================================================
const DFRM_MinW   = 380;        // .   
      DFRM_MinH   = 250;        // .   
      MinPanelW   = DFRM_MinW;  // .   
      MinPanelH   = DFRM_MinH;  // .   
      TopAreaH    = 20;         //    fImg
      DownAreaH   = 20;         //    fImg
      ImgBordX    = 2;          //  fImg     

// ====================================================================
//   / 
// ====================================================================
// --------------------------------------------------------------------
//       (OVERLOAD)
constructor TDnAlarm.Create(RqWidth, RqHeight : integer);
begin
   inherited Create;
   // -----------------------------------
   //    
   fDFRM := TForm.Create(nil);
   with fDFRM do
   begin
      BorderIcons := [biSystemMenu,biMinimize,biMaximize];
      // -------------------
      onClose   := onDFRMClose;
      onShow    := onDFRMShow;
      onHide    := onDFRMHide;
      onActivate := onDFRMActivate;
      onDeactivate := onDFRMDeActivate;
      // -------------------
      Caption   := ' ALARM -   3.0. ';
      Position  := poDesktopCenter;
      FormStyle :=  fsStayOnTop;
      AutoSize  := False;
      if RqWidth < DFRM_MinW
      then  ClientWidth := DFRM_MinW
      else  ClientWidth := RqWidth;
      if RqHeight < DFRM_MinH
      then  ClientHeight := DFRM_MinH
      else  ClientHeight := RqHeight;
      Constraints.MinWidth  := DFRM_MinW;
      Constraints.MinHeight := DFRM_MinH;
      // Realign;
   end;
   // -----------------------------
   fPanel := TPanel.Create(fDFRM);
   fPanel.Parent := fDFRM;
   fPanel.SetBounds(0,0, fDFRM.ClientWidth, fDFRM.ClientHeight);
   fPanel.Align := alClient;
   //  :    
   fPanelCreate := True;
   // -----------------------------
   //    
   CreateDynComponents();
   // -----------------------------
   fDFRM.Show;
end;
// --------------------------------------------------------------------
//       (OVERLOAD)
constructor TDnAlarm.Create(RqPanel : TPanel);
begin
   inherited Create;
   // -----------------------------
   fPanelCreate := False;  //  :    
   fPanel := RqPanel;
   //    
   fPanel.Constraints.MinHeight  := MinPanelH;
   fPanel.Constraints.MinWidth   := MinPanelW;
   //    ReSize
   fPanel.Anchors := [akLeft,akTop,akRight,akBottom];
   // -----------------------------
   //    
   CreateDynComponents();
   // -----------------------------
end;
// =================================================================
//    
// =================================================================
// -----------------------------------------------------------------
//    
procedure TDnAlarm.CreateDynComponents();
begin
   // -----------------------------
   //  Image  
   fImg  := TImage.Create(fPanel);
   fImg.Parent := fPanel;
   fImg.SetBounds(ImgBordX,TopAreaH,
                  fPanel.Width - 2 * ImgBordX,
                  fPanel.Height - TopAreaH - DownAreaH);
   //     PopupMenu
   GreateAndConnecPoUpMenu();
   // -----------------------------
   //   
   fBMP := TBitMap.Create;
   fBMP.PixelFormat := pf24bit;
   fBMP.Height := fImg.Height;
   fBMP.Width  := fImg.Width;
   fBMP.Canvas.Font.Name := 'Tahoma';
   fBMP.Canvas.Font.Size := 8;
   // -----------------------------
   //  Label   
   fLbV := TLabel.Create(fPanel);
   fLbV.Parent := fPanel;
   fLbV.SetBounds(2,fPanel.Height-18,fPanel.Width-4,16);
   fLbV.AutoSize := False;
   // -----------------------------
   //  Label   
   fLbT := TLabel.Create(fPanel);
   fLbT.Parent := fPanel;
   fLbT.SetBounds(2,3,fPanel.Width-4,16);
   fLbT.AutoSize := False;
   fLbT.Alignment := taLeftJustify;
   // -----------------------------
   //     ReSize
   fTimer := TTimer.Create(nil);
   fTimer.Enabled := False;
   fTimer.onTimer := onReSizeTimer;
   //  OnResize   
   fPanel.OnResize := onPanelResize;
   // -----------------------------
   //  
   fP2Wall      := 0;              //    1
   fP1Wall      := 0;              //    2
   fN2Wall      := 0;              //    1
   fN1Wall      := 0;              //    2
   fcAlarm1     := clYellow;       //     
   fcAlarm2     := clRed;          //     
   fAlarmMode   := alrmDam;        //    
   // -----------------------------
   //    
   fFonColor    := clBlack;
   fTextColor   := clWhite;
   fInfoColor   := clAqua;
   fNormalColor := clLime;
   ImageClear(fFonColor);
   // -----------------------------
   fAddParmIndx := 0;
   // -----------------------------
   //  
   fTitle       := '   ';
   fLookMarker  := True;          //      
   Clear();
end;
// --------------------------------------------------------------------
//  
procedure TDnAlarm.Free;
begin
   // ---------------------------------
   if Assigned(fTimer) then fTimer.Free;
   // ---------------------------------
   if Assigned(fPM)      then fPM.Free;
   if Assigned(fLbV)     then fLbV.Free;
   if Assigned(fLbT)     then fLbT.Free;
   if Assigned(fBMP)
   then begin
      fBMP.Free;
      fBMP := nil;
   end;
   if Assigned(fImg)    then fImg.Free;
   //  :    
   if fPanelCreate and Assigned(fPanel)
   then fPanel.Free;
   // ---------------------------------
   if Assigned(fDFRM)   then  fDFRM.Free;
   // ---------------------------------
   inherited Free;
end;
// =================================================================
//      
// =================================================================
// -----------------------------------------------------------------
//    (   )   
procedure TDnAlarm.onDFRMClose(Sender: TObject; var Action: TCloseAction);
// TCloseAction = (caNone, caHide, caFree, caMinimize);
begin
   Action := caMinimize;
end;
//     Show
procedure TDnAlarm.onDFRMShow(Sender: TObject);
begin
end;
//     Hide
procedure TDnAlarm.onDFRMHide(Sender: TObject);
begin
end;
//   biSystemMenu :biMaximize
procedure TDnAlarm.onDFRMActivate(Sender: TObject);
begin
  //  
  fDFRM.FormStyle := fsStayOnTop;
end;
//   biSystemMenu : biMinimize
procedure TDnAlarm.onDFRMDeactivate(Sender: TObject);
begin
end;
// ====================================================================
//  ReSize
// ====================================================================
procedure TDnAlarm.onPanelResize(Sender: TObject);
begin
   if fImg.Visible
   then begin
       fLbT.Visible := False;
       fLbV.Visible := False;
       fImg.Visible := False;
       fTimer.Enabled := True;
   end;
   fTimer.Interval := TimeReSizeOut;
end;
// --------------------------------------------------------------------
procedure TDnAlarm.onReSizeTimer(Sender: TObject);
begin
   fTimer.Enabled := False;
   ReSize;
end;
// --------------------------------------------------------------------
//      
procedure TDnAlarm.ReSize();
begin
   with fImg do
   begin
      Picture.Bitmap.Width  := fPanel.Width  - 2 * ImgBordX;
      Picture.Bitmap.Height := fPanel.Height - TopAreaH - DownAreaH;
      fBMP.Width  :=  Picture.Bitmap.Width;
      fBMP.Height :=  Picture.Bitmap.Height;
      Width  :=  Picture.Bitmap.Width;
      Height :=  Picture.Bitmap.Height;
   end;
   fLbV.SetBounds(2,fPanel.Height-18,fPanel.Width-4,16);
   ShowReport();
   fImg.Visible := True;
   fLbV.Visible := True;
   fLbT.Visible := True;
end;
// ==================================================================
//    
// ==================================================================
// ------------------------------------------------------------------
//     PopupMenu
procedure  TDnAlarm.GreateAndConnecPoUpMenu();
var MenuItems : array of TMenuItem;
begin

   // =================================
   //    (PopupMenu)
   // =================================
   SetLength(MenuItems, 4);
   // --------------------
   MenuItems[0]:= NewItem(' ', TextToShortCut(''),
                          True, True, MenuClick, 0, 'M_VALUE');
   MenuItems[0].Tag := 1;
   MenuItems[0].RadioItem := True;
   // --------------------
   MenuItems[1]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_INCREMENT');
   MenuItems[1].Tag := 2;
   // --------------------
   MenuItems[2]:= NewItem('-', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_SEP');
   // --------------------
   MenuItems[3]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_CLEAR');
   MenuItems[3].Tag := 3;
   // =================================
   //    (PopupMenu)
   fPM := NewPopupMenu(fImg, 'Menu',
                       paLeft, True, MenuItems);
   fImg.PopupMenu := fPM;
   // =================================
   SetLength(MenuItems,0);
end;

// --------------------------------------------------------------------
procedure ResetRadioItem(RqMenu : TPopupMenu;  RqItem : TMenuItem);
var Ind : integer;
begin
   with RqMenu.Items do
   begin
     for Ind :=0 to Count - 1
     do begin
        Items[Ind].RadioItem := False;
        Items[Ind].Checked   := False;
     end;
     RqItem.RadioItem := True;
     RqItem.Checked   := True;
   end;
end;
// --------------------------------------------------------------------
//    
procedure TDnAlarm.MenuClick(Sender : TObject);
var Item  : TMenuItem;
begin
   Item :=  TMenuItem(Sender);
   case Item.Tag of
   1  :  begin //   
           ResetRadioItem(fPM, Item);
           Item.Checked := True;
           fAddParmIndx := 0;
         end;
   2  :  begin  //   
           ResetRadioItem(fPM, Item);
           Item.Checked := True;
           fAddParmIndx := 1;
         end;
   3  :  begin  //  
           Clear();
         end;
    end;
   //  
   ShowTitle();
end;

// ====================================================================
//      
// ====================================================================
//   
procedure TDnAlarm.SetValue (RqValue  : extended);
begin
   fValue := RqValue;
   fZone  := GetZoneByValue();
   case fZone of
    -2 : Inc(fN2WallCount);       //    N2Wall
    -1 : Inc(fN1WallCount);       //    N1Wall
     0 : Inc(fOkCount);           //   
     1 : Inc(fP1WallCount);       //    P1Wall
     2 : Inc(fP2WallCount);       //    P2Wall
   end;
   if fValue > fCurrYMax then fCurrYMax := fValue;
   if fValue < fCurrYMin then fCurrYMin := fValue;
   // -----------------
   //   
   ShowAddParm();
   //       
   fLookMarker  := False;
   //    
   ShowReport();
   // -----------------
   fPrevValue := fValue;
   //   -    
   if (fPrevZone <> fZone) then Windows.Beep(440,100);
   fPrevZone  := fZone;
end;
// --------------------------------------------------------------------
//     
function TDnAlarm.GetZoneByValue() : integer;
begin
   //    
   Result := 0;
   // -----------------------
   //   
   if (fP2Wall = 0) and (fN2Wall = 0)
   then Exit;
   // -----------------------
   if fAlarmMode = alrmDam
   then begin
      //    (  )
      if (fP2Wall > 0) or (fN2Wall < 0)
      then begin
         if fValue >= 0
         then begin
            if (fP1Wall > 0) and (fValue >= fP1Wall) and (fValue < fP2Wall)
            then Result := 1;
            if (fValue >= fP2Wall) then Result := 2;
         end else begin
            if (fN1Wall < 0) and (fValue <= fN1Wall) and (fValue > fN2Wall)
            then Result := -1;
            if (fValue <= fN2Wall) then Result := -2;
         end;
         Exit;
      end;
   end;
   // -----------------------
   if fAlarmMode = alrmLimit
   then begin
      //   fP2Wall, fN2Wall   fP2Wall, fN2Wall
      // (  0  2)
      if (fP2Wall > 0) and (fN2Wall < 0) and
         (fP1Wall = 0) and (fN1Wall = 0)
      then begin
         if fValue >= 0
         then begin
            if (fValue >= fP2Wall) then Result := 2;
         end else begin
            if (fValue <= fN2Wall) then Result := -2;
         end;
         Exit;
      end;
      // -----------------------
      //     (  0, 1  2)
      if (fP2Wall > 0) and (fN2Wall = 0)
      then begin
          if fValue >= 0
          then begin
             if (fValue >= fP1Wall) and (fValue < fP2Wall) then Result := 1;
             if (fValue >= fP2Wall) then Result := 2;
             Exit;
          end;
      end;
      // -----------------------
      //     (  0, -1  -2)
      if (fP2Wall = 0) and (fN2Wall < 0)
      then begin
          if fValue <= 0
          then begin
             if (fValue <= fN1Wall) and (fValue > fN2Wall) then Result := -1;
             if (fValue <= fN2Wall) then Result := -2;
             Exit;
          end;
      end;
   end;
end;
// --------------------------------------------------------------------
//      
procedure TDnAlarm.SetP2Wall (RqP2Wall : extended);
begin
  //    
  if (RqP2Wall = fP2Wall) then Exit;
  // 
  if (RqP2Wall <= 0)
  then begin
      //   
      fP2Wall := 0;
      fP1Wall := 0;
  end else fP2Wall := RqP2Wall;
  ShowReport();
end;
// --------------------------------------------------------------------
//     
procedure TDnAlarm.SetP1Wall (RqP1Wall : extended);
begin
  // 
  if fP2Wall > 0
  then begin
    if RqP1Wall < fP2Wall
    then fP1Wall := RqP1Wall
    else fP1Wall := 0;
  end
  else fP1Wall := 0;
  ShowReport();
end;
// --------------------------------------------------------------------
//     
procedure TDnAlarm.SetN1Wall(RqN1Wall : extended);
begin
  //   
  if (RqN1Wall <= 0) and (RqN1Wall > fN2Wall)
  then fN1Wall := RqN1Wall
  else fN1Wall := 0;
  ShowReport();
end;
// --------------------------------------------------------------------
//      
procedure TDnAlarm.SetN2Wall(RqN2Wall : extended);
begin
  //    
  if (RqN2Wall = fN2Wall) then Exit;
  //    
  if (RqN2Wall >= 0)
  then begin
     //     
     fN1Wall := 0;
     fN2Wall := 0;
  end else fN2Wall := RqN2Wall;
  ShowReport();
end;
// --------------------------------------------------------------------
//       
procedure  TDnAlarm.SetAlarmMode(RqMode : TAlarmMode);
begin
  if (RqMode = fAlarmMode) then Exit; //    
  fAlarmMode := RqMode;
  // 
  Clear();
  ShowAddParm();
end;
// --------------------------------------------------------------------
//  
procedure TDnAlarm.CounterClear();
begin
   fCurrYMax    := 0;      //   
   fP2WallCount := 0;      //    P2Wall
   fP1WallCount := 0;      //    P1Wall
   fOkCount     := 0;      //   
   fN1WallCount := 0;      //    N1Wall
   fN2WallCount := 0;      //    N2Wall
   fCurrYMin    := 0;      //   
   // --------------
   fValue       := 0;
   fZone        := 0;
   fPrevValue   := 0;
   fPrevZone    := 0;
   // --------------
   ShowAddParm();
end;
// --------------------------------------------------------------------
//   
procedure TDnAlarm.ShowAddParm();
begin
   if not Assigned(fLbV) then Exit;
   case fAddParmIndx of
   0 : fLbV.Caption := '  : '
                      + FloatToStr(fValue);
   1 : fLbV.Caption := '  : '
                      + FloatToStr(fValue - fPrevValue);
   end;
end;
// --------------------------------------------------------------------
//  
procedure TDnAlarm.ShowTitle();
begin
  if not Assigned(fLbT) then Exit;
  fLbT.Caption := fTitle;
end;
// ====================================================================
//         fBMP
// ====================================================================
// --------------------------------------------------------------------
//     fImg
procedure TDnAlarm.BmpToImg ();
var wImgRect : TRect;
begin
  if (not Assigned(fImg)) or (not Assigned(fBMP)) then Exit;
  //     fImg
  wImgRect := Rect(0, 0, fImg.Width, fImg.Height);
  fImg.Canvas.CopyRect(wImgRect,fBMP.Canvas,wImgRect);
end;
// --------------------------------------------------------------------
//    
procedure TDnAlarm.ImageClear(RqColor : TColor);
begin
  with fBMP.Canvas do
  begin
    Brush.Color := RqColor;
    Brush.Style := bsSolid;
    FillRect(Rect(0,0, fBMP.Width, fBMP.Height));
  end;
end;
// --------------------------------------------------------------------
//      fBMP
// --------------------------------------------------------------------
const
   cStepY      = 16;           //   
   cTextLeft   = cStepY + 4;   //   ( )
   cY1  = 4;                   // Y -   1
   cY2  = cY1  + cStepY;       // Y -   2
   cY3  = cY2  + cStepY;       // Y -   3
   cY4  = cY3  + cStepY;       // Y -   4
   cY5  = cY4  + cStepY;       // Y -   5
   cY6  = cY5  + cStepY;       // Y -   6
   cY7  = cY6  + cStepY;       // Y -   7
   cY8  = cY7  + cStepY;       // Y -   8
   cY9  = cY8  + cStepY;       // Y -   9
   cY10 = cY9  + cStepY;       // Y -   10
   cY11 = cY10 + cStepY;       // Y -   11
   cY12 = cY11 + cStepY;       // Y -   12
const
   // ----------
   txtLimit   = '  ';
   txtUpWall  = '   : ';
   txtDnWall  = '    : ';
   txtUpLimit = '    : ';
   txtDnLimit = '    : ';
   // ----------
   txtDam     = '   ';
   txtP2Wall  = '      : ';
   txtP1Wall  = '      : ';
   txtN1Wall  = '      : ';
   txtN2Wall  = '      : ';
   // ----------
   txtNormal  = '    : ';
   // ----------
   txtMAX     = '   : ';
   txtMIN     = '     : ';
   // ----------
   txtPUpWall = '   : ';
   txtPDnWall = '   : ';
   txtNUpWall = '   : ';
   txtNDnWall = '    : ';

// --------------------------------------------------------------------
//   -    
procedure TDnAlarm.ShowSepLine(RqY : integer; RqColor : TColor);
begin
   with fBMP.Canvas do
   begin
      Pen.Color := RqColor;
      MoveTo(0, RqY + (cStepY div 2));
      LineTo(fBMP.Width, RqY + (cStepY div 2));
      Pen.Color := fFonColor;
   end;
end;
// --------------------------------------------------------------------
//      
procedure TDnAlarm.ShowMarker(RqY, RqZone : integer; RqColor : TColor);
const cMarkW = cStepY - 4;
var   wColor : TColor;
begin

   if fLookMarker then Exit;  //      
   if fZone <> RqZone
   then wColor := fFonColor
   else wColor := RqColor;
   with fBMP.Canvas do
   begin
      Pen.Color   := wColor;
      Brush.Style := bsSolid;
      Brush.Color := wColor;
      Rectangle(4, RqY, 4 + cMarkW, RqY + cMarkW);
      Brush.Color := fFonColor;
      Brush.Style := bsClear;
   end;
end;
// --------------------------------------------------------------------
//   
procedure TDnAlarm.ShowReportStr(RqY : integer;
                               RqTxt, RqValue : string;
                               RqColor : TColor);
var   wTextW : integer;
begin
   with fBMP.Canvas do
   begin
      Font.Color := fTextColor;
      TextOut(cTextLeft, RqY, RqTxt);
      wTextW := TextWidth(RqTxt);
      Font.Color := RqColor;
      TextOut(cTextLeft + wTextW + 4, RqY, RqValue);
   end;
end;
// --------------------------------------------------------------------
//   
procedure TDnAlarm.DamReport();
begin
   // 
   ShowReportStr(cY1, txtDam, '',  fTextColor);
   // ---------
   // 
   ShowSepLine(cY2, fTextColor);
   // ---------
   //   
   if fP2Wall > 0
   then begin
      ShowReportStr(cY3, txtP2Wall, IntToStr(fP2WallCount), fcAlarm2);
      ShowMarker(cY3, 2, fcAlarm2);
      ShowReportStr(cY4, txtP1Wall, IntToStr(fP1WallCount), fcAlarm1);
      ShowMarker(cY4, 1, fcAlarm1);
   end
   else begin
      ShowReportStr(cY3, txtP2Wall, '', fInfoColor);
      ShowReportStr(cY4, txtP1Wall, '', fInfoColor);
   end;
   // ---------
   // 
   ShowSepLine(cY5, fTextColor);
   // ---------
   //  
   ShowReportStr(cY6, txtNormal, IntToStr(fOkCount), fNormalColor);
   ShowMarker(cY6, 0, fNormalColor);
   // ---------
   // 
   ShowSepLine(cY7, fTextColor);
   // ---------
   //   
   if fN2Wall < 0
   then begin
      ShowReportStr(cY8, txtN1Wall, IntToStr(fN1WallCount), fcAlarm1);
      ShowMarker(cY8, -1, fcAlarm1);
      ShowReportStr(cY9, txtN2Wall, IntToStr(fN2WallCount), fcAlarm2);
      ShowMarker(cY9, -2, fcAlarm2);
   end
   else begin
      ShowReportStr(cY8, txtN1Wall, '', fInfoColor);
      ShowReportStr(cY9, txtN2Wall, '', fInfoColor);
   end;
   // ---------
   // 
   ShowSepLine(cY10, fTextColor);
   // ---------
   //   
   ShowReportStr(cY11, txtMAX, FloatToStr(fCurrYMax), fInfoColor);
   ShowReportStr(cY12, txtMIN, FloatToStr(fCurrYMin), fInfoColor);
end;

// --------------------------------------------------------------------
//      
procedure TDnAlarm.PNLimitReport();
begin
   if not ((fP2Wall > 0) and (fN2Wall < 0) and
           (fP1Wall = 0) and (fN1Wall = 0))
   then Exit;
   // 
   ShowReportStr(cY1, txtLimit, '',  fTextColor);
   //  
   ShowReportStr(cY2, txtUpWall, FloatToStr(fP2Wall), fInfoColor);
   ShowReportStr(cY3, txtDnWall, FloatToStr(fN2Wall), fInfoColor);
   // 
   ShowSepLine(cY4, fTextColor);
   // ---------
   //  
   ShowReportStr(cY5, txtUpLimit, IntToStr(fP2WallCount), fcAlarm2);
   ShowMarker(cY5,  2, fcAlarm2);
   ShowReportStr(cY6, txtNormal, IntToStr(fOkCount), fNormalColor);
   ShowMarker(cY6,  0, fNormalColor);
   ShowReportStr(cY7, txtDnLimit, IntToStr(fN2WallCount), fcAlarm2);
   ShowMarker(cY7, -2, fcAlarm2);
   // ---------
   // 
   ShowSepLine(cY8, fTextColor);
   // ---------
   //   
   ShowReportStr(cY9, txtMAX, FloatToStr(fCurrYMax),  fInfoColor);
   ShowReportStr(cY10, txtMIN, FloatToStr(fCurrYMin), fInfoColor);
end;
// --------------------------------------------------------------------
//      
procedure TDnAlarm.PLimitReport();
begin
   if not ((fP2Wall > 0) and (fP1Wall >= 0)) then Exit;
   // 
   ShowReportStr(cY1, txtLimit, '',  fTextColor);
   //  
   ShowReportStr(cY2, txtUpWall, FloatToStr(fP2Wall), fInfoColor);
   ShowReportStr(cY3, txtDnWall, FloatToStr(fP1Wall), fInfoColor);
   // 
   ShowSepLine(cY4, fTextColor);
   // ---------
   //  
   ShowReportStr(cY5, txtUpLimit, IntToStr(fP2WallCount), fcAlarm2);
   ShowMarker(cY5, 2, fcAlarm2);
   ShowReportStr(cY6, txtNormal, IntToStr(fP1WallCount), fNormalColor);
   ShowMarker(cY6, 1, fNormalColor);
   ShowReportStr(cY7, txtDnLimit, IntToStr(fOkCount), fcAlarm2);
   ShowMarker(cY7, 0, fcAlarm2);
   // ---------
   // 
   ShowSepLine(cY8, fTextColor);
   // ---------
    //   
   ShowReportStr(cY9, txtMAX, FloatToStr(fCurrYMax),  fInfoColor);
   ShowReportStr(cY10, txtMIN, FloatToStr(fCurrYMin), fInfoColor);
end;
// --------------------------------------------------------------------
//      
procedure TDnAlarm.NLimitReport();
begin
   if not ((fN2Wall < 0) and (fN1Wall <= 0)) then Exit;
   // 
   ShowReportStr(cY1, txtLimit, '',  fTextColor);
   //  
   ShowReportStr(cY2, txtUpWall, FloatToStr(fN1Wall), fInfoColor);
   ShowReportStr(cY3, txtDnWall, FloatToStr(fN2Wall), fInfoColor);
   // ---------
   // 
   ShowSepLine(cY4, fTextColor);
   // ---------
   //  
   ShowReportStr(cY5, txtUpLimit, IntToStr(fOkCount), fcAlarm2);
   ShowMarker(cY5,  0, fcAlarm2);
   ShowReportStr(cY6, txtNormal, IntToStr(fN1WallCount), fNormalColor);
   ShowMarker(cY6, -1, fNormalColor);
   ShowReportStr(cY7, txtDnLimit, IntToStr(fN2WallCount), fcAlarm2);
   ShowMarker(cY7, -2, fcAlarm2);
   // ---------
   // 
   ShowSepLine(cY8, fTextColor);
   // ---------
    //   
   ShowReportStr(cY9, txtMAX, FloatToStr(fCurrYMax),  fInfoColor);
   ShowReportStr(cY10, txtMIN, FloatToStr(fCurrYMin), fInfoColor);
end;
// --------------------------------------------------------------------
//     
procedure TDnAlarm.WallReport(RqErr : boolean);
const txtLimitErr = '   ';
var   wColor : TColor;
begin
   // 
   if RqErr
   then begin
      wColor := fcAlarm2;
      ShowReportStr(cY1, txtLimitErr, '', fTextColor);
   end
   else begin
      wColor := fInfoColor;
      ShowReportStr(cY1, '  ', '',  fTextColor);
   end;
   // ---------
   // 
   ShowSepLine(cY2, fTextColor);
   // ---------
   ShowReportStr(cY3, txtPUpWall, FloatToStr(fP2Wall), wColor);
   ShowReportStr(cY4, txtPDnWall, FloatToStr(fP1Wall), wColor);
   ShowReportStr(cY5, txtNUpWall, FloatToStr(fN1Wall), wColor);
   ShowReportStr(cY6, txtNDnWall, FloatToStr(fN2Wall), wColor);
end;
// --------------------------------------------------------------------
//     fBMP     fImg
procedure TDnAlarm.ShowReport();
begin
  ShowTitle();
  ImageClear(fFonColor);

  // ----------------
  if fAlarmMode = alrmDam
  then begin
     //      
     if (fP2Wall >  0) or (fN2Wall <  0)
     then begin
         DamReport();
         //     fImg
         BmpToImg (); Exit;
     end;
  end;
  // ----------------
  if fAlarmMode = alrmLimit
  then begin
     if (fP2Wall > 0) and (fN2Wall < 0) and
       ((fP1Wall > 0)  or (fN1Wall < 0))
     then begin
        WallReport(True);
        //     fImg
        BmpToImg (); Exit;
     end;
     //      
     if (fP2Wall > 0) and (fN2Wall < 0) and
        (fP1Wall = 0) and (fN1Wall = 0)
     then begin
         PNLimitReport();
         //     fImg
         BmpToImg (); Exit;
     end;
     //      
     if (fP2Wall > 0) and (fP1Wall >= 0)
     then begin
          PLimitReport();
          //     fImg
          BmpToImg (); Exit;
     end;
     //      
     if (fN2Wall < 0) and (fN1Wall <= 0)
     then begin
         NLimitReport();
         //     fImg
         BmpToImg (); Exit;
     end;
  end;
  // -----------------
  WallReport(False);
  //     fImg
  BmpToImg ();
end;

// ====================================================================
//  PROPERTY
// ====================================================================
// --------------------------------------------------------------------
//  
procedure TDnAlarm.SetTitle(RqTitle : string);
begin
   if Assigned(fLbT)
   then begin
       fTitle := '  ' + RqTitle;
       fLbT.Caption := fTitle;
       ShowTitle(); //  
   end;
end;

// ====================================================================
//   
// ====================================================================
// --------------------------------------------------------------------
//  
procedure TDnAlarm.Clear();
begin
   CounterClear();  //  
   ShowTitle();     //  
   ShowReport();    //  
end;
// ====================================================================
// ====================================================================

end.
