unit MAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Math,
  CustomScope03, DnConsole03, DigitsScope03;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    stxtMemory: TStaticText;
    Timer1: TTimer;
    Button3: TButton;
    Button4: TButton;
    Label3: TLabel;
    Button5: TButton;
    Button6: TButton;
    RadioGroup1: TRadioGroup;
    Edit1: TEdit;
    stxtRun: TStaticText;
    Label4: TLabel;
    Label5: TLabel;
    ComboBox1: TComboBox;
    Label1: TLabel;
    stxtMode: TStaticText;
    Label6: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure ComboBox1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


const MaxIndxDescSope = 28;
const BaseXS = 93;
      BaseYS = 281;
      StepXS = 46;
      cUion  = 1000;
const DescScopeArr : array[0..MaxIndxDescSope] of TDescScope =
(
     // =====================================
     // 
     // =====================================
     // =====================================   0
   ( ScopeType   : 'S';
     ScopeName   : 'dF'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS;  YBeg : BaseYS;
     Compact  : True; Transparent : True; ),
     // =====================================   1
   ( ScopeType   : 'S';
     ScopeName   : 'dE'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 1 * StepXS; YBeg  : BaseYS;
     Compact : True; Transparent : True; ),
     // =====================================   2
   ( ScopeType   : 'S';
     ScopeName   : 'dD'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 2 * StepXS; YBeg  : BaseYS;
     Compact : True; Transparent : True; ),
     // =====================================   3
   ( ScopeType   : 'S';
     ScopeName   : 'dC'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 3 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   4
   ( ScopeType   : 'S';
     ScopeName   : 'dB'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 4 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   5
   ( ScopeType   : 'S';
     ScopeName   : 'dA'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 5 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   6
   ( ScopeType   : 'S';
     ScopeName   : 'd9'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 6 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   7
   ( ScopeType   : 'S';
     ScopeName   : 'd8'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 7 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   8
   ( ScopeType   : 'S';
     ScopeName   : 'd7'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 8 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   9
   ( ScopeType : 'S';
     ScopeName : 'd6'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 9 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   10
   ( ScopeType : 'S';
     ScopeName : 'd5'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 10 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   11
   ( ScopeType : 'S';
     ScopeName : 'd4'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 11 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   12
   ( ScopeType : 'S';
     ScopeName : 'd3'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 12 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   13
   ( ScopeType : 'S';
     ScopeName : 'd2'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 13 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   14
   ( ScopeType : 'S';
     ScopeName : 'd1'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 14 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================   15
   ( ScopeType : 'S';
     ScopeName : 'd0'; MinScope : 0; MaxScope : 1;
     XBeg : BaseXS + 15 * StepXS;  YBeg  : BaseYS;
     Compact : True;  Transparent : True;),
     // =====================================
     // 
     // =====================================
     // =====================================   16
   ( ScopeType : 'L';
     ScopeName : '  '; Measure : 'mV';
     MinScope : -(cUion + 60); MaxScope : 0;
     P2Wall : 0;  P1Wall : 0;  N2Wall : -(cUion + 10); N1Wall : -(cUion + 5);
     WallStyle : wsDam;  NumLPF : 0;
     XBeg : 270; YBeg : 60;  ScopeWidth  : 200;
     Compact : False; ScopeStyle  : ssNotUse;  Transparent : True;
     GrmNum  : 100;  Grm1P : 1;),
     // =====================================   17
   ( ScopeType : 'L';
     ScopeName : ' '; Measure : 'mV';
     MinScope : 0; MaxScope : 2 * (cUion + 100);
     P2Wall : 2 * cUion + 10;   P1Wall :  2 * cUion;
     N2Wall : 0; N1Wall : 0;
     WallStyle : wsDam;  NumLPF : 0;
     XBeg : 950; YBeg : 60; ScopeWidth  : 200;
     Compact : False; ScopeStyle : ssNotUse; Transparent : True;
     GrmNum : 100; Grm1P  : 1;),
     // =====================================   18
   ( ScopeType : 'L';
     ScopeName : ' '; Measure : 'mV';
     MinScope : 0; MaxScope : 2 * (cUion + 50);
     P2Wall :  0;  P1Wall : 0;  N2Wall : 0;  N1Wall : 0;
     WallStyle : wsDam;  NumLPF : 0;
     XBeg : 950; YBeg : 270; ScopeWidth  : 200;
     Compact : False; ScopeStyle : ssNotUse; Transparent : True;
     GrmNum : 100;  Grm1P  : 50;),
     // =====================================   19
   ( ScopeType : 'S';
     ScopeName : ''; MinScope : 0; MaxScope : 1;
     XBeg : 820; YBeg  : 630;
     Compact : True;  Transparent : True;),
     // =====================================   20
   ( LastScope : False;
     ScopeType : 'S';
     ScopeName : 'Bit'; MinScope : 0; MaxScope : 1;
     XBeg : 398; YBeg  : 572;
     Compact : True;  Transparent : True;),
     // =====================================   21
   ( ScopeType : 'S';
     ScopeName : ''; MinScope : 0; MaxScope : 16;
     XBeg : 292; YBeg : 572;
     Compact : True;  Transparent : True;),
     // =====================================   22
   ( ScopeType : 'S';
     ScopeName : ' '; MinScope : 0; MaxScope : 1;
     XBeg : 415; YBeg  : 674;
     Compact : True;  Transparent : True;),
     // =====================================   23
   ( ScopeType : 'S';
     ScopeName : ''; MinScope : 0; MaxScope : 2;
     XBeg : 236; YBeg : 640;
     Compact : True;  Transparent : True;),
     // =====================================   24
   ( ScopeType : 'S';
     ScopeName : ''; MinScope : 0; MaxScope : 1;
     XBeg : 548; YBeg : 674;
     Compact : True; Transparent : True;),
     // =====================================   25
   ( LastScope : False;
     ScopeType : 'S';
     ScopeName : ''; MinScope : 0; MaxScope : 1;
     XBeg : 665; YBeg : 674;
     Compact : True;  Transparent : True;),
     // =====================================   26
   ( ScopeType : 'R';
     ScopeName : ''; Measure : 'mV';
     MinScope : 0; MaxScope : 2 * (cUion + 50);
     P2Wall : 2 * cUion + 10; P1Wall : 2 * cUion;
     N2Wall : 0; N1Wall : 0;
     WallStyle : wsDam;  NumLPF : 0;
     XBeg : 1000; YBeg : 420; ScopeWidth  : 200;
     Compact : False; ScopeStyle : ssArc;  Transparent : True;
     GrmNum : 100; Grm1P  : 1;),
     // =====================================   27
   ( ScopeType : 'D';
     ScopeName : ''; Measure : '';
     XBeg : 238; YBeg : 416;
     Transparent : True; Radix : rdxBit; DFrame : dfrmDown),
     // =====================================   28
   ( LastScope : True;
     ScopeType : 'D';
     ScopeName : ' '; Measure : '';
     XBeg : 580; YBeg : 416;
     Transparent : True; Radix  : rdxBit; DFrame : dfrmDown)
);

// -------------------------------------------------------------
var   // 
      DnConsole : TDnConsole;

// =============================================================
//   
// =============================================================

const //    
      MaxOrder = 15;

var   // 
      // ------------------------
      EMP      : extended;       //   
      // ------------------------
      StateADC : integer;        // 
                                 // 0 - 
                                 // 1 - 
                                 // 2 - 
      // ------------------------
      Start    : boolean;

      UION     : extended;       //  
      UIN      : extended;       //   
      UDAC     : extended;       //   
      // ------------------------
      UOUT     : extended;       //   
      RG2      : integer;        //  
      // -----------------------------------
      RG1      : integer;        //  
      StepADC  : byte;
      CurrentOrder : integer;   //    
      //    ( 0   )
      OrderArr : array[0..MaxOrder] of byte;

// =============================================================
//       DnConsole
// =============================================================
// -------------------------------------------------------------
//    
procedure ShowDScope(RqIndx : integer; RqRadix : TRadix; Value : Word);
var wScope  : TCustomScope;
begin
    if not Assigned(DnConsole) then Exit;
    wScope := DnConsole.Scope[RqIndx];
    if Assigned(wScope)
    then begin
        if (wScope is TDigitsScope)
        then TDigitsScope(wScope).ShowWordValue(RqRadix, Value);  // rdxBit
    end;
end;
// =============================================================
//  
// =============================================================
// -------------------------------------------------------------
//   ADC
procedure InitADC();
var Ind : integer;
begin
    Start := False;
    UION         := cUion;
    UDAC         := 0;
    StepADC      := 0;
    CurrentOrder := 0;
    //        
    FillChar(OrderArr, SizeOf(OrderArr), #0);
    for Ind := Low(OrderArr) to  High(OrderArr)
    do DnConsole.SetValueToScope(Ind, OrderArr[Ind]);
    // --------------------------------
    //    
    // --------------------------------
    //  
    DnConsole.SetValueToScope(16, -UION);   // 
    DnConsole.SetValueToScope(17,  UIN);    //  
    // --------------------------------
    DnConsole.SetValueToScope(18,  UDAC);   // UDAC
    // --------------------------------
    //   
    DnConsole.SetValueToScope(19,  1);      // 
    DnConsole.SetValueToScope(20,  0);      // Bit
    DnConsole.SetValueToScope(21,  0);      // 
    // ------
    DnConsole.SetValueToScope(23,  0);      // 
    DnConsole.SetValueToScope(24,  0);      // 
    DnConsole.SetValueToScope(25,  0);      // 
    // --------------------------------
    DnConsole.SetValueToScope(26,  UOUT);   //   
    // --------------------------------
    //  
    RG1  := 0;                              //  
    ShowDScope(27, rdxBit, 0);              // RG1
    ShowDScope(28, rdxBit, RG2);            // RG2
    // --------------------------------
end;
// -------------------------------------------------------------
//   ( )
procedure InitUION();
begin
    // 
    UION := cUion;
    //    
    EMP := Abs(UION)/(IntPower(2, High(OrderArr))-1);
    //  
    UIN  := 0;            //  
    RG1  := 0;            //  
    RG2  := 0;            //  
    UOUT := 0;            //   
    StateADC := 0;        //   ""

end;
// -------------------------------------------------------------
//    
procedure SetUIN(RqU : extended);
begin
    UIN := RqU;
    StateADC := 0;         //   ""
end;
// -------------------------------------------------------------
//   RG1
procedure CalcRG1();
var Ind : integer;
    Pw  : integer;
begin
    RG1 := 0;
    Pw  := 1;
    for Ind := High(OrderArr) downto Low(OrderArr)
    do begin
        if OrderArr[Ind] > 0 then RG1 := RG1 + Pw;
        Pw := Pw * 2;
    end;
end;
// -------------------------------------------------------------
//    
function CalcDAC() : extended;
begin
   Result := EMP * RG1;
   //  
   UDAC := Result;
   DnConsole.SetValueToScope(18, UDAC);
   // 
   if UDAC > UIN
   then begin
        DnConsole.SetValueToScope(19, 0);   // 
        DnConsole.SetValueToScope(20, 0);   // Bit
   end
   else begin
       DnConsole.SetValueToScope(19, 1);
       DnConsole.SetValueToScope(20, 1);
   end;
end;
// -------------------------------------------------------------
//  
procedure NextOrder();
begin
    Inc(CurrentOrder);
    if CurrentOrder > MaxOrder
    then begin
        // ----------------------------
        //   
        RG2 := RG1;
        ShowDScope(28, rdxBit, RG2);          // RG2
        UOUT := UDAC;
        DnConsole.SetValueToScope(26, UOUT);  //   
        // ----------------------------
        DnConsole.SetValueToScope(18, UDAC);  // UDAC
        StateADC := 2;                        //   ""
    end;
end;
// -------------------------------------------------------------
//    
procedure Phase1CurrentOrder();
begin
   //  
   OrderArr[CurrentOrder] := 1;
   CalcRG1();
   ShowDScope(27, rdxBit, RG1);               // RG1
   //    
   UDAC := CalcDAC();
   //  
   DnConsole.SetValueToScope(CurrentOrder, 1);
   //   
   DnConsole.SetValueToScope(21, (MaxOrder - CurrentOrder));
   // 
   DnConsole.SetValueToScope(23, 1);
end;
// -------------------------------------------------------------
//    
procedure Phase2CurrentOrder();
begin
   if UDAC > UIN
   then begin
      //  
      OrderArr[CurrentOrder] := 0;
      CalcRG1();
      ShowDScope(27, rdxBit, RG1);            // RG1
      //    
      UDAC := CalcDAC();
      //  
      DnConsole.SetValueToScope(CurrentOrder, 0);
   end;
   // 
   DnConsole.SetValueToScope(23, 2);
end;
// -------------------------------------------------------------
//     
procedure AutomatOneStep();
begin
   case Abs(StateADC) of
   0 : begin  //  ""
          InitADC();               //   ADC
          DnConsole.SetValueToScope(24, 0);  //  ""
          DnConsole.SetValueToScope(25, 0);  //  ""
          StateADC := 1;           //   ""
       end;
   1 : begin  //  ""
          if not Start
          then begin
             Start := True;
             DnConsole.SetValueToScope(24, 1);  //  ""
          end;
          //   
          if StepADC = 0
          then begin
             Phase1CurrentOrder();
             StepADC := 1;
          end
          else begin
             Phase2CurrentOrder();
             StepADC := 0;
             NextOrder();                    //   ""
          end;
       end;
   2 : begin //   ""
          DnConsole.SetValueToScope(24, 0);  //  ""
          DnConsole.SetValueToScope(25, 1);  //  ""
          StateADC := 0;                     //   ""
       end;
   else StateADC := 0;                       //   ""
   end;
end;

// =============================================================
//   
// =============================================================
// -------------------------------------------------------------
//   
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if not Assigned(DnConsole) then Exit;
  if not (RadioGroup1.ItemIndex = 0) then Exit;
  //     
  AutomatOneStep();
end;
// -------------------------------------------------------------
//  
procedure TForm1.Button5Click(Sender: TObject);
begin
  if not Assigned(DnConsole) then Exit;
  if not (RadioGroup1.ItemIndex = 1) then Exit;
  //     
  AutomatOneStep();
end;
// -------------------------------------------------------------
//    
procedure TForm1.Button6Click(Sender: TObject);
var wValue : extended;
begin
    if TryStrToFloat(Edit1.Text, wValue)
    then begin
       //   
     SetUIN(wValue);
     StateADC := 0;  //   ""
    end;
end;
// -------------------------------------------------------------
//  
procedure TForm1.ComboBox1Click(Sender: TObject);
begin
    case  ComboBox1.ItemIndex of
    0 : Timer1.Interval := 1000;
    1 : Timer1.Interval := 500;
    2 : Timer1.Interval := 100;
    3 : Timer1.Interval := 50;
    4 : Timer1.Interval := 20;
    end;
end;
// -------------------------------------------------------------
//   
procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
   if not Assigned(DnConsole) then Exit;
   if RadioGroup1.ItemIndex = 0
   then begin
       stxtMode.Color := clLime;
       DnConsole.SetValueToScope(22, 1);   //   
   end
   else begin
       stxtMode.Color := clBtnFace;
       DnConsole.SetValueToScope(22, 0);  //   
   end;
end;

// =============================================================
//   /  
// =============================================================
// -------------------------------------------------------------
//    
function GetApplicationDirectory() : string;
begin
   Result := Application.ExeName;
   Result := ExtractFileDir(Result);
end;
// -------------------------------------------------------------
//   DnConsole
procedure TForm1.Button1Click(Sender: TObject);
var wDir : string;
begin
   wDir := GetApplicationDirectory();
   if Assigned(DnConsole) then Exit;

   DnConsole := TDnConsole.Create(1200,800);
   DnConsole.LoadBaseImg(wDir + '\PICTUREs\Default.jpg');
   DnConsole.LoadAllScopes(High(DescScopeArr), Addr(DescScopeArr));
   stxtMemory.Caption := IntToStr(AllocMemSize);
   // -----------------------------
   //   ( )
   InitUION();
   stxtRun.Color := clLime;
end;
// -------------------------------------------------------------
//   DnConsole
procedure TForm1.Button2Click(Sender: TObject);
begin
   if Assigned(DnConsole)
   then begin
      DnConsole.Free;
      DnConsole := nil;
   end;
   stxtMemory.Caption := IntToStr(AllocMemSize);
   stxtRun.Color := clBtnFace;
end;
// -------------------------------------------------------------
//   DnConsole
procedure TForm1.FormDestroy(Sender: TObject);
begin
   if Assigned(DnConsole)
   then begin
      DnConsole.Free;
      DnConsole := nil;
   end;
end;
// -------------------------------------------------------------
// 
procedure TForm1.Button3Click(Sender: TObject);
begin
   if Assigned(DnConsole) then DnConsole.DnFRM.Show;
end;
// -------------------------------------------------------------
// 
procedure TForm1.Button4Click(Sender: TObject);
begin
   if Assigned(DnConsole) then DnConsole.DnFRM.Hide;
end;

// -------------------------------------------------------------
//  
procedure TForm1.FormCreate(Sender: TObject);
begin
//
end;

end.
