% Solving Linear Systems of Equations (GAUSS) 
%      
%  :
%             [x]=fgauss01(ab)
%
% ab -      :
%
%   a11 a12 a13 a14 .... a1N b1
%   a21 a22 a23 a24 .... a2N b2
%   ...........................
%   aN1 aN2 aN3 aN4 .... aNN bN
% 
% x -    
% 
function [x]=fgauss01(ab)
if isempty(ab)
    disp('     ');
    x=NaN;
    return
end;
nb = size(ab,2);
nx = size(ab,1);
if (nb < 2) || (nb ~= (nx+1))
    disp('      ');
    x=NaN;
    return
end;    
%   
for nM=1:(nx-1)
    %         ab(nM,nM)
    [v,n]=max(abs(ab(:,nM)));
    if (n > nM)
        s=ab(n,:);
        ab(n,:) = ab(nM,:);
        ab(nM,:)=s;
    end;
    %   
    if ab(nM,nM) == 0
       disp('  ');
       x=NaN;
       return;
    end;
    %     
    for row =(nM + 1):nx 
       koef =ab(row,nM)/ab(nM,nM);
       for n=1:nb
          if n == nM
             ab(row,n)=0;
         else   
             ab(row,n)=ab(row,n)-ab(nM,n)*koef;;
         end;    
      end;    
   end;
end;
%  
%   
if ab(nx,nx) == 0
   disp('  ');
   x=NaN;
   return;
end;
x=zeros(nx,1);
row = nx;
x(nx)=ab(row,nb)/ab(row,nx);  %  
while row > 1
    row=row-1;
    s=0;
    for n=1:nx
        if ab(row,n) ~= 0
           s=s+ab(row,n)*x(n);
       end;   
    end;
    x(row)=(ab(row,nb)-s)/ab(row,row);  %     
end;

