%     GAUSS  KRAMER
function ftest02_Gauss_Kramer(nm)
if (nm < 100) || (nm > 300)
   nm=200;
   disp(strcat('    :', num2str(nm)));
end;
disp('    GAUSS (blue)  KRAMER (red)');
disp(strcat('    : ', num2str(2*nm), '  '));
disp('   ');
pproc=0;
nproc=0;
for n = 1:nm
    A = rand(n,n);
    b = rand(n,1);
    AB = cat(2,A,b);
    x(n)=n;
    tic
       y2 = fgauss02(AB);
    t1(n) = toc;
    tic   
       y2 = fkramer01(A,b);
    t2(n) = toc;
    %  
    nproc=100*(n/10-rem(n,10))/(nm/10-rem(nm,10));
    if nproc > pproc
       disp(strcat(' :', num2str(nproc), '%'));
       pproc=nproc;
   end;   
end;
clf;              %  
disp('!   ...');
hold on;
plot(x,t1);       % GAUSS
plot(x,t2,'-r');  % KRAMER
grid on;