% Solving Linear Systems of Equations (KRAMER) 
%      
%  :
%             [x]=fkramer01(a,b)
%
% a -       :
%
%   a11 a12 a13 a14 .... a1N
%   a21 a22 a23 a24 .... a2N
%   ........................
%   aN1 aN2 aN3 aN4 .... aNN
%
% b -        :
%
%    b1
%    b2
%   ........................
%    bN
% 
% x -    
%
function [x]=fkramer01(a,b)
if isempty(a) || isempty(b)
    disp('    ');
    x=NaN;
    return
end;
if (size(a,1) ~= size(a,2)) || (size(a,1) ~= size(b,1))
    disp('      ');
    x=NaN;
    return
end;
d=det(a);
if d ~= 0    
   for n=1:size(a,2)
      buf=a(:,n);
      a(:,n)=b;
      x(n,1)=det(a)/d;
      a(:,n)=buf;
   end;
else
   x=NaN; 
   if (sum(abs(b))==0) && (d == 0)
      x=zeros(size(a,2),1);
      disp('   '); 
   else
      disp('  '); 
   end;    
end;
