%       
% function [vt, vmax]=vcontact02(s0,v0,a0)
%   
% s0 -      ()
% v0 -       (/.)
% a0 -       (/^2.)
% 
% vt - 2D-,  vt(1,n) -   vt(2,n) -  
% vmax -     
function [vt,vmax]=vcontact02(s0,v0,a0)
[t1,t2,ok]=contact02(s0,v0,a0);
if ~ok
  disp('     ');
  return;
end;    
dt=0.5;       %   
tsum =t1+t2;  %   
t=0;
n=1;
vmax=abs(v0)+abs(a0)*t1;
while t < tsum
  if t <=t1
    %  
    v=abs(v0)+abs(a0)*t;
  else
    %   
    v=vmax-abs(a0)*(t-t1);  
  end;  
  vt(1,n)=t;
  vt(2,n)=v;
  t=t+dt;
  n=n+1;
end; 
close all;   %    
plot(vt(1,:),vt(2,:));
xlabel(' (.)');
ylabel('  (./.)');
title('      ');
grid on;