%       
% function [st]=scontact02(s0,v0,a0)
%   
% s0 -      ()
% v0 -       (/.)
% a0 -       (/^2.)
% 
% st - 2D-,  st(1,n) -   st(2,n) -  
function [st]=scontact02(s0,v0,a0)
[t1,t2,ok]=contact02(s0,v0,a0);
if ~ok
  disp('     ');
  return;
end;    
dt=0.1;        %   
tsum=t1+t2;    %   
t=0;
n=1;
vmax=abs(v0)+abs(a0)*t1;
while t < tsum
  if t <=t1
    %    
    s=s0-(abs(v0)*t+(abs(a0)*t^2)/2);
    s1=s;
  else
    %    
    s=s1-vmax*(t-t1)+(abs(a0)*(t-t1)^2)/2;  
  end;  
  st(1,n)=t;
  st(2,n)=s;
  t=t+dt;
  n=n+1;
end;
close all;   %    
plot(st(1,:),st(2,:));
xlabel(' (.)');
ylabel('     (.)');
title('     ');
grid on;