% 3D-        
% function sa3contact01(s0,v0)
%   
% s0 -      ()
% v0 -       (/.)
% 
% 3D-        
%    3*g  0.1*g,  g=9.780327 (./.^2)
function sa3contact(s0,v0)
%   
countmax = 500;   %   
count = 0;        %  
%     
g=9.780327;       %     
amin = 0.1*g;
amax = 3*g;
da=0.5;           %       
a=amax;
% 
close all;     %    
disp(',     ');
hold on;
while (a >= amin) && (count <= countmax)
  x=[];
  y=[];
  z=[];  
  [t1,t2,ok]=contact02(s0,v0,a);
  if ~ok
   txt1='!   <= ';
   txt2=num2str(a);
   txt3='(./.^2)   ';
   disp(strcat(txt1,txt2,txt3));
   return;
  end;    
  dt=0.1;        %   
  tsum=t1+t2;    %   
  t=0;
  n=1;
  vmax=abs(v0)+abs(a)*t1;
  while t < tsum
    if t <=t1
      %    
      s=s0-(abs(v0)*t+(abs(a)*t^2)/2);
      s1=s;
    else
      %    
      s=s1-vmax*(t-t1)+(abs(a)*(t-t1)^2)/2;  
    end;  
    x(n)=t;
    y(n)=a;
    z(n)=s;
    t=t+dt;
    n=n+1;
  end;
  plot3(x,y,z);
  %   
  a=a-da;
  count = count+1;
end;  
xlabel(' (.)');
ylabel('    (./:2)');
zlabel('     (.)');
title('        ');
grid on;
hold off;
if (count <= countmax)
  disp('!  3D-   ');
else
  disp('   !');  
end;